<?php

class plFileHandler_file {
	public $url=false;
	public $path=false;
	public $filename = "";
	public $imagesize=false;
	public $is_folder = false;
	public $ext=false;
	public $size=false;
	public $size_wformat=false;
	public $deletelink = false;
	public $modified = false;
	public $owner = false;
	public $pic = false;
	public $onclick = false;
	public $permissions = false;

	public function __construct($filepath, $fileurl=false, $is_folder=false, $info=array()){
		if(!file_exists($filepath))	return false;
		$this->url = $fileurl;
		$this->path = $filepath;
		$this->is_folder = $is_folder;
		$this->filename = basename($filepath);
		foreach($info as $key=>$val)	$this->$key = $val;
	}

	public function __toString(){
		return $this->GetIcon().' '.$this->filename;
	}
	
	public function limitName(){
		$string = $this->filename;
		global $filename_limit;
		if(!isset($filename_limit))	$filename_limit = 15;
		if (strlen($string) > $filename_limit) {
			return substr($string,0,$filename_limit-1).'...';
		}else{
			return $string;
		}
	}
	
	public function GetPic($fulltag=true){
		if($this->is_folder){
			global $gCms;
			$url = $gCms->config['root_url'].'/modules/plFileHandler/images/dir.png';
			return $fulltag?'<img border=0 src="'.$url.'" alt=""/>':$url;
		}
		$extension = strtolower(substr(strrchr($this->filename, "."), 1));
		if(!in_array($extension, array('png','gif','jpg','jpeg'))){
			global $module;
			$url = $module->GetFileIcon($this->path);
			return $fulltag?'<img border=0 src="'.$url.'" alt=""/>':$url;
		}
		$thumbpath = str_replace($this->filename, 'thumb_'.$this->filename, $this->path);
		if(file_exists($thumbpath)){
			$thumburl = str_replace($this->filename, 'thumb_'.$this->filename, $this->url);
		}else{
			global $module;
			if($module->GetPreference('create_thumbnails',true)){
				$res = $module->plResize($this->path, $thumbpath, 96, 96, true, false);
				if(!$res){
					$url = $module->GetFileIcon($this->path);
					return $fulltag?'<img border=0 src="'.$url.'" alt=""/>':$url;					
				}
				$thumburl = str_replace($this->filename, 'thumb_'.$this->filename, $this->url);
			}else{
				$thumburl = $module->GetFileIcon($this->path);
			}
		}	
		return $fulltag?'<img border=0 src="'.$thumburl.'" alt=""/>':$thumburl;
	}
	
	public function GetIcon(){
		if($this->is_folder){
			global $gCms;
			return '<img border=0 src="'.$gCms->config['root_url'].'/modules/plFileHandler/images/dir_small.png" alt=""/>';
		}else{
			global $module;
			return '<img border=0 src="'.$module->GetFileIcon($this->path, true).'" alt=""/>';
		}
	}
	
	public function GetViewLink(){
		if($this->is_folder || !$this->url)	return false;
		global $gCms;
		return '<a href="'.$this->url.'" target="_blank"><img border=0 src="'.$gCms->config['root_url'].'/modules/plFileHandler/images/view.gif" alt=""/></a>';
	}
}
?>
