<?php

function getDeleteIcon(){
	global $gCms;
	return '<img border="0" src="'.$gCms->config['root_url'].'/modules/plFileHandler/images/delete.gif" alt="Delete"/>';
}
function getModuleImageUrl($imagename, $alt=''){
	global $gCms;
	return '<img src="'.$gCms->config['root_url'].'/modules/plFileHandler/images/'.$imagename.'" alt="'.$alt.'"/>';
}
function clean_join_path($string){
	return str_replace('/',DIRECTORY_SEPARATOR,clean_join_url($string));
}
function clean_join_url($string){
	str_replace('\\','/',$string);
	str_replace('//','/',$string);
	str_replace('//','/',$string);
	str_replace(':/','://',$string);
	return $string;
}

function createBrowseLink($newparams){
	global $params;
	foreach(array('allowedext','mode','resize','crop','curdir','startdir','multiple','lang') as $key){
		if(isset($params[$key]) && !isset($newparams[$key]))	$newparams[$key] = $params[$key];
	}
	$href = '';
	foreach($newparams as $key=>$value){
		$href .= ($href==''?'':'&').$key.'='.urlencode($value);
	}
	return "bg_select.php?".$href;
}

function makeDirObj($filepath, $curdir){
	global $gCms;
	$filename = basename($filepath);
	$parent = ($filename == '..');
	if($parent && trim(str_replace('\\','/',$curdir), '/') == '')	return false;
	if(!($obj = new plFileHandler_file($filepath, false, true))) return false;
	$obj->is_folder = true;
	if($parent){
		$tmp = explode('/',$curdir);
		unset($tmp[count($tmp)-1]);
		$obj->thelink = createBrowseLink( array('curdir' => implode('/',$tmp)) );		
	}else{
		$obj->thelink = createBrowseLink( array('curdir' => $curdir.'/'.$filename) );
	}
	$obj->rowlink = '<a href="'.$obj->thelink.'">'.$filename.($parent?' &nbsp;':'')."</a>";
	$obj->imagesizecol = false;
	$obj->sizecol = false;
	return $obj;
}

function makeFileObj($filepath, $fileurl){
	global $gCms;
	global $module;
	$info = $module->GetFileInfo($filepath);
	if(!($obj = new plFileHandler_file($filepath, $fileurl, false, $info))) return false;
	$extension = $info['ext'];
	$obj->sizecol = '<a style="display:none;">'.$info["size"].'</a>'.$info["size_wformat"];
	$obj->imagesizecol = $info["imagesize"]?'<a style="display:none;">'.$info["width"].'</a>'.$info["imagesize"]:'';
	$obj->deletelink = '<a href="'.createBrowseLink(array('deletefile'=>$obj->filename)).'">'.getDeleteIcon().'</a>';
	$obj->thelink = createBrowseLink(array('selectfile'=>$obj->filename));
	$obj->modified = '<a style="display:none;">'.$info["filemtime"].'</a>'.$info["modified"];
	return $obj;
}
