<?php

//function watermark($wm_path, $img_path, $dest_path='', $margin=5, $alpha=100, $position='bottom right'){
// adds a watermark ($wm_path) to the $img_path image and saves it to $dest_path (if specified)
// watermark is positionned according to $position, with a margin of $margin pixels and an opacity of $alpha
// Possible positions: combinations of bottom/top left/right

if(!$dest_path || $dest_path == '')	$dest_path = $img_path;
$margin = (int)	$margin;
$alpha = (int) $alpha;
if($alpha <= 0)	return false;
$position = explode(' ',strtolower($position==''?'bottom right':$position));

$watermark = $this->getImage($wm_path);
list($wm_width, $wm_height) = getimagesize($wm_path); 

$image = $this->getImage($img_path);
list($img_width, $img_height) = getimagesize($img_path);

if($position[0] == 'top'){
	$dist_y = $margin;
}else{
	$dist_y = $img_height - $wm_height - $margin;
}

if(isset($position[1]) && $position[1] == 'left'){
	$dist_x = $margin;
}else{
	$dist_x = $img_width - $wm_width - $margin;
}

imagecopymerge($image, $watermark, $dist_x, $dist_y, 0, 0, $wm_width, $wm_height, $alpha);

imagedestroy($watermark);
$return = $this->saveImage($image, $dest_path);
imagedestroy($image);

