<?php
require "class.plFileHandler_file.php";
require "functions.select.php";

$params = array();
foreach($_GET as $key=>$val)	$params[$key] = urldecode($val);
$params = array_merge($params, $_POST);

require '../../include.php';

if(!isset($gCms->modules['plFileHandler']) || !$gCms->modules['plFileHandler']['active'])	die('Could not find module');
$module = $gCms->modules['plFileHandler']['object'];

if(!$module->CheckAccess())	exit('Permission denied. Ask your administrator for the "plFileHandler: usage" permission.');

if(isset($params['lang']))	$params['lang'] = $str_replace('"','',$params['lang']);
if(isset($params['lang']) && file_exists('lang'.DIRECTORY_SEPARATOR.$params['lang'].'.php')){
	require 'lang'.DIRECTORY_SEPARATOR.$params['lang'].'.php';
}elseif(isset($params['lang']) && file_exists('lang'.DIRECTORY_SEPARATOR.'ext'.DIRECTORY_SEPARATOR.$params['lang'].'.php')){
	require 'lang'.DIRECTORY_SEPARATOR.'ext'.DIRECTORY_SEPARATOR.$params['lang'].'.php';
}else{
	if(isset($params['lang']))	unset($params['lang']);
	require 'lang/en_US.php';
}
function fhlang($string){
	global $lang;
	return isset($lang[$string])?$lang[$string]:'';
}

if(isset($params['mode']) && in_array($params['mode'],array('image','file'))){
	$mode = $params['mode'];
}else{
	$mode = $module->GetPreference('default_imagemode',false)?'image':'file';
}

$crop = false;
$resize = false;
if(isset($params['resize'])){
	$resize = explode('x',$params['resize']);
	if(count($resize)==2 && $resize[0] > 0 && $resize[1] > 0){
		$crop = isset($params['crop'])?$params['crop']:$module->GetPreference('default_crop',false);
	}
}


$imgext = array('jpeg','jpg','png','gif');
$allowedext = isset($params['allowedext'])?$params['allowedext']:$module->GetPreference('default_allowed','');
if($allowedext && $allowedext != ''){
	$allowedext = array();
	foreach(explode(',',$params['allowedext']) as $ext){
		if($resize || $mode == 'image'){
			if(in_array($ext, $imgext))	array_push($allowedext, strtolower(trim($ext)));
		}else{
			array_push($allowedext, strtolower(trim($ext)));
		}
	}
}elseif($resize || $mode == 'image'){
	$allowedext = $imgext;
}else{
	$allowedext = false;
}


$resize_existing = $module->GetPreference('resize_existing',true);
$hidethumbs = $module->GetPreference('hide_thumbs',true);
$allowdelete = $module->GetPreference('allow_filedelete',true);
if(!$allowdelete && !$module->CheckPermission('modify_files'))	$allowdelete = false;

$filename_limit = (int) $module->GetPreference('filename_limit',20);
if(!($filename_limit>0))	$filename_limit = 20;

$startdir = isset($params['startdir'])?'/'.ltrim($params['startdir'],'/'):'';
$path_base = clean_join_path($gCms->config['uploads_path'].$startdir);
$curdir = isset($params['curdir'])?'/'.ltrim($params['curdir'],'/'):'';
$current_path = clean_join_path($path_base.$curdir);
$current_url = clean_join_url($gCms->config['uploads_url'].$startdir.$curdir);


if ($allowdelete && isset($params['deletefile'])){
	$filepath = clean_join_path($current_path.'/'.$params['deletefile']);
	if(file_exists($filepath) && unlink($filepath)){
		$message = fhlang("message_deleted");
	}
}




/* FORM SUBMISSION */

if(isset($params['selectfile']) && $params['selectfile'] != ''){
	$filename = $params['selectfile'];
	$filepath = clean_join_path($current_path.'/'.$filename);
	if(file_exists($filepath)){
		if($resize && $resize_existing && $info = $module->GetFileInfo($filepath)){
			if($info['width'] > $resize[0] || $info['height'] > $resize[1]){
				if($module->GetPreference('resize_exsiting_replace',true)){
					$module->plResize($filepath, $filepath, $resize[0], $resize[1], true, $crop);
				}else{
					$newpath = $module->iterate_to_unique($filepath);
					$module->plResize($filepath, $newpath, $resize[0], $resize[1], true, $crop);
					$filename = basename($newpath);
				}
			}
		}
		$returnUrl = ltrim(clean_join_url($current_url.'/'.$filename),'/');
		$obj = new plFileHandler_file($filepath, $returnUrl, false);
		$content = $module->GetReturnScript(false).'
plFileHandler_return("'.$returnUrl.'", "'.$obj->GetPic(false).'");
</script>';
		$message = fhlang('message_successful');
	}else{
		$content = '';
		$message = fhlang("error_couldnotfindfile");
	}
	$module->smarty->assign("message", $message);
	$module->smarty->assign("content", $content);
	echo $module->ProcessTemplateFromDatabase('minimal');
	exit;
}





###################################################
# RETRIEVING FILES & FOLDERS
#

$dh  = opendir($current_path);
$folders = array();
$files = array();
$upfolder = false;
while ($filename = readdir($dh)){
	$filepath = clean_join_path($current_path.'/'.$filename);
	$fileurl = clean_join_url($current_url.'/'.$filename);
	if(is_dir($filepath)){
		if($filename!='.' && $filename!=''){
			$obj = makeDirObj($filepath, $curdir);
			if ($filename=='..') {
				$upfolder = $obj;
			}else{
				if($obj)	array_push($folders, $obj);
			}
		}
	}elseif($filename != '.'){
		$extension = strtolower(substr(strrchr($filename, "."), 1));
		if( (!$allowedext || in_array($extension, $allowedext))
		 && (!$hidethumbs || (substr($filename,0,6) != 'thumb_' && substr($filename,0,8) != 'plthumb_')) ){
			$obj = makeFileObj($filepath, $fileurl);
			if(!$allowdelete)	$obj->deletelink = false;
			$obj->onclick = ($resize && $resize_existing)?false:"plFileHandler_return('".ltrim(clean_join_url($current_url.'/'.$obj->filename),'/')."', '".$obj->GetPic(false)."'); return false;";
			$obj->rowlink = '<a href="'.$obj->thelink.'" '.($obj->onclick?'onclick="'.$obj->onclick.'"':'').'>'.($mode=='image'?$obj->limitName():$obj->filename).'</a>';
			array_push($files, $obj);
		}
	}
}
if (isset($dh))	closedir($dh);
sort($folders);
sort($files);
$itemlist = array();
if($upfolder) array_push($itemlist, $upfolder);
foreach($folders as $one)	if($one)	array_push($itemlist, $one);
foreach($files as $one)	if($one)	array_push($itemlist, $one);

$module->smarty->assign("title",fhlang('prompt_select'));
$module->smarty->assign("curdir",$curdir);
//$module->smarty->assign("showingdir",fhlang('showingdir').$current_path);
$module->smarty->assign("showingdir",$current_path);
$module->smarty->assign("instantsearch", $mode=='image'?'':fhlang("searchthistable")." ".$module->CreateInputText('fh_', "searchfiletable", "", 10, 64, ' onkeyup="plFileHandler_searchtable(this.value,\'filelist_table\');"'));
$module->smarty->assign("tablename", 'filelist_table');

if($mode == 'file'){
	$sortlinks = array();
	$numeric_sortlinks = array();
	$i = 0;
	while($i < 10){
		$sortlinks[$i] = '<div style="float:left;"><a style="cursor: pointer;" onclick="plFileHandler_sortRows(\'filelist_table\','.$i.');">'.getModuleImageUrl('arrow-u.gif', $alt='^').'</a><br/><a style="cursor: pointer;" onclick="plFileHandler_sortRows(\'filelist_table\','.$i.',true);">'.getModuleImageUrl('arrow-d.gif', $alt='v').'</a></div> &nbsp;';
		$numeric_sortlinks[$i] = '<div style="float:left;"><a style="cursor: pointer;" onclick="plFileHandler_sortRows(\'filelist_table\','.$i.',false,true);">'.getModuleImageUrl('arrow-u.gif', $alt='^').'</a><br/><a style="cursor: pointer;" onclick="plFileHandler_sortRows(\'filelist_table\','.$i.',true,true);">'.getModuleImageUrl('arrow-d.gif', $alt='v').'</a></div> &nbsp;';
		$i++;
	}
	$module->smarty->assign("sortlinks",$sortlinks);
	$module->smarty->assign("numeric_sortlinks",$numeric_sortlinks);
}

$obj = new StdClass();
$obj->filename = fhlang("filename");
$obj->ext = fhlang("fileext");
$obj->size = fhlang("filesize");
$obj->imagesize = fhlang("imagesize");
$obj->deletelink = fhlang("Actions");
$obj->modified = fhlang("lastmod");
$obj->owner = fhlang("fileowner");
$obj->permissions = fhlang("fileperms");
$module->smarty->assign("headers",$obj);

$module->smarty->assign("itemlist", $itemlist);

$javascript = $module->GetReturnScript(false).'
'.$module->getFileContent("instantsearch.js");
if($mode == 'file')	$javascript .= $module->getFileContent("instantsort.js");
$javascript .= '</script>
';
$module->smarty->assign("javascript",$javascript);
$module->smarty->assign("message",isset($message)?$message:false);

echo $module->ProcessTemplateFromDatabase("select_".$mode);
