<?php
#-------------------------------------------------------------------------
# Module: EMoneyateway - A Emoney gateway module for the Orders module
# Version: 1.0, SjG <sjg@cmsmodules.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/emoneygateway
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$cgpaymentgatewaybase = cms_join_path($gCms->config['root_path'],'modules',
	'CGPaymentGatewayBase','CGPaymentGatewayBase.module.php');
if( !is_readable( $cgpaymentgatewaybase ) )
{
	echo '<h1><font color="red">ERROR: The CGPaymentGatewayBase module could not be found.  Please install it</font></h1>';
	return;
}
if( !class_exists('CGPaymentGatewayBase') )
{
  require_once($cgpaymentgatewaybase);
}

class EMoneyGateway extends CGPaymentGatewayBase
{

  var $_weightunits;
  var $_currencycode;
  var $_successurl;
  var $_successpage;
  var $_cancelurl;
  var $_cancelpage;
  var $_items;
  var $_ordertax;
  var $_ordershipping;
  var $_orderid;

  /*---------------------------------------------------------
   Constructor()
   ---------------------------------------------------------*/
  function EMoneyGateway()
  {
    parent::CMSModule();
    $this->Reset();
  }

  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  function GetName()
  {
    return 'EMoneyGateway';
  }
  
  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }


  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  function GetVersion()
  {
    return '2.1';
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  function GetAuthor()
  {
    return 'SjG';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  function GetAuthorEmail()
  {
    return 'sjg@cmsmodules.com';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  function GetChangeLog()
  {
    return $this->Lang('changelog');
  }

  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  function IsPluginModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'extensions';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Templates') ||
      $this->CheckPermission('Modify Site Preferences');
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array('CGPaymentGatewayBase'=>'1.0.3',
		 'CGExtensions'=>'1.17.3');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.6.5";
  }


  /*---------------------------------------------------------
   SetParameters()
   ---------------------------------------------------------*/
  function SetParameters()
  {
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();

	$this->SetParameterType('key', CLEAN_STRING);
	
  }


  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }

	
  /*---------------------------------------------------------
   IsPaymentGatewayModule()
   ---------------------------------------------------------*/
  function IsPaymentGatewayModule()
  {
    return true;
  }

  /*---------------------------------------------------------
   New Methods from CGPaymentGatewayBase
   ---------------------------------------------------------*/
  
/*---------------------------------------------------------
 RequiresCreditCardInfo()
 ---------------------------------------------------------*/
public function RequiresCreditCardInfo()
{
  return true;
}


/*---------------------------------------------------------
 RequiresSSL()
 ---------------------------------------------------------*/
public function RequiresSSL()
{
  return true;
}


/*---------------------------------------------------------
 RequiresShippingInfo()
 ---------------------------------------------------------*/
public function RequiresShippingInfo()
{
  return false;
}


/*---------------------------------------------------------
 RequiresBillingInfo()
 ---------------------------------------------------------*/
public function RequiresBillingInfo()
{
  return false;
}

/*---------------------------------------------------------
  SaveState()
  ---------------------------------------------------------*/
 public function SaveState($encrypt = false)
 {
   if( $encrypt )
     {
	$key = str_shuffle(md5(session_id().time()));
	$raw = serialize($this->_data);
	$enc = $this->encrypt($key,$raw);
	$_SESSION['emoneygate'] = base64_encode($enc);
	return $key;
     }
   else
     {
	$raw = serialize($this->_data);
	$_SESSION['emoneygate'] = base64_encode($raw);
     }
 }


 /*---------------------------------------------------------
  RestoreState()
  ---------------------------------------------------------*/
 public function RestoreState($key = '')
 {
   if( !isset($_SESSION['emoneygate']) ) return FALSE;
   if( empty($key) )
     {
	$raw = base64_decode($_SESSION['emoneygate']);
     }
   else
     {
	$enc = base64_decode($_SESSION['emoneygate']);
	$raw = $this->decrypt($key,$enc);
	if( $raw === FALSE ) return FALSE;
     }
   $this->_data = unserialize($raw);
   unset($_SESSION['emoneygate']);
   return TRUE;
 }


 /*---------------------------------------------------------
  SetCreditCardInfo()
  ---------------------------------------------------------*/
 public function SetCreditCardInfo($ccnumber,$ccexp,$ccvcode)
 {
   $_ccinfo = array();
   $_ccinfo['x_card_num'] = preg_replace('([^0-9])','',$ccnumber);
   $_ccinfo['x_exp_date'] = date('m',$ccexp).'/'.date('Y',$ccexp);
   if( !empty($ccvcode) )
     {
	$_ccinfo['x_card_code'] = preg_replace('([^0-9])','',$ccvcode);
     }
   debug_to_log('-- ccinfo --');
   debug_to_log($_ccinfo);
   $this->_data['ccinfo'] = $_ccinfo;
 }


 /*---------------------------------------------------------
  SetWeightUnits()
  ---------------------------------------------------------*/
 public function SetWeightUnits($units = 'lbs')
 {
   $this->_data['weightunits'] = $units;
 }


 /*---------------------------------------------------------
  SetDestination()
  ---------------------------------------------------------*/
 public function SetDestination($url)
 {
   $this->_data['destination'] = $url;
 }
   
 /*---------------------------------------------------------
  ProcessTransaction()
  ---------------------------------------------------------*/
 public function ProcessTransaction()
 {
   $key = $this->SaveState(true);
   $params = array();
   $params['key'] = $key;
   return $this->DoAction('process_payment','cntnt01',$params);
 }

 /*---------------------------------------------------------
  CheckInfo()
  ---------------------------------------------------------*/
 public function CheckInfo()
 {
   // TODO: fill this in.
   return TRUE;
 }


  /*---------------------------------------------------------
   End New Methods from CGPaymentGatewayBase
   ---------------------------------------------------------*/

/*---------------------------------------------------------
 GetForm()
 ---------------------------------------------------------*/
public function GetForm($returnid)
{
  if( !$this->CheckInfo() ) return FALSE;
/*  $loginid = $this->GetPreference('loginid');
  $transactionkey = $this->GetPreference('transactionkey');
  if( empty($loginid) || empty($transactionkey) )
    {
	return $this->DisplayErrorMessage($this->GetName().': '.$this->Lang('error_configuration'));
    }
*/  
  $key = $this->SaveState(true);

  global $gCms;
  $smarty =& $gCms->GetSmarty();
  $smarty->assign('formstart',
		    $this->CGCreateFormStart('cntnt01','process',$returnid,
					     array('key'=>$key)));
  $smarty->assign('formend',$this->CreateFormEnd());
		    
					     
  // and process the template.
  return $this->ProcessTemplate('newform.tpl');
}



  function GetFormOld($returnid)
	{
	// force https?
	$id = 'cntnt07';
		
	$key = $this->SaveState(true);

	$this->smarty->assign('form_start',	$this->CreateFrontendFormStart($id,$returnid,'process','post',
		'',false,'',array('key'=>$key)));

	$this->smarty->assign('prompt_card',$this->Lang('prompt_card'));
	$this->smarty->assign('prompt_expiration',$this->Lang('prompt_expiration'));
	$this->smarty->assign('prompt_cvv',$this->Lang('prompt_cvv'));
	
	$this->smarty->assign('input_card',  $this->CreateInputText($id, 'card_number','',16,19));
	$this->smarty->assign('input_cvv',  $this->CreateInputText($id, 'cvv','',3,5));
	$this->smarty->assign('submit',$this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
	$mon = array();
	$year = array();
	for ($i=1;$i<13;$i++)
		{
		$mn = ''.($i<10?'0':'').$i;
		$mon[$mn] = $i;
		}
	$yr = date('Y');
	for ($i=$yr;$i<($yr+11);$i++)
		{
		$year[$i]=$i;
		}
	
	$this->smarty->assign('input_expiration', $this->CreateInputDropdown($id, 'exp_month', $mon). $this->CreateInputDropdown($id, 'exp_year', $year));
	return $this->ProcessTemplate('form.tpl');
	}

  function SetCurrencyCode($code = 'USD')
  {
    $this->_data['currencycode'] = strtoupper($code);
  }


  function SetSuccessURL($url)
  {
    $this->_data['successurl'] = $url;
  }


  function SetSuccessPage($page)
  {
    $this->_data['successpage'] = $page;
  }


  function SetCancelURL($url)
  {
    $this->_data['cancelurl'] = $url;
  }


  function SetCancelPage($page)
  {
    $this->_data['cancelpage'] = $page;
  }

  /*---------------------------------------------------------
   AddItem()
   ---------------------------------------------------------*/
  public function AddItem($name,$number,$quantity,$weight,$amount,$tax = '')
  {
    $name = strip_tags($name);
    $name = preg_replace('/\&.*\;/','',$name);
    $name = trim($name);

    if( !isset($this->_data['items']) )
      {
	$this->_data['items'] = array();
      }

    if( !isset($this->_items[$name]) )
      {
	$this->_data['items'][$name] = array('name'=>$name,
				     'number'=>$number,
				     'quantity'=>$quantity,
				     'weight'=>$weight,
				     'amount'=>$amount);
	if(!empty($tax))
	  {
	    $this->_data['items'][$name]['tax'] = $tax;
	  }
      }
  }

  /*---------------------------------------------------------
   SetOrderDescription()
   ---------------------------------------------------------*/
  public function SetOrderDescription($txt)
  {
    $this->_data['description'] = substr($txt,0,255);
  }


  /*---------------------------------------------------------
   SetOrderTaxAmount()
   ---------------------------------------------------------*/
  public function SetOrderTaxAmount($tax)
  {
    $this->_data['ordertax'] = $tax;
  }


  /*---------------------------------------------------------
   SetOrderShipping()
   ---------------------------------------------------------*/
  public function SetOrderShipping($shipping)
  {
    $this->_data['ordershipping'] = $shipping;
  }



  /*---------------------------------------------------------
   SetInvoice()
   ---------------------------------------------------------*/
  public function SetInvoice($invoice)
  {
    $len = min(strlen($invoice),20)*-1;
    $this->_data['invoice'] = substr($invoice,$len);
  }


  /*---------------------------------------------------------
   SetOrderID()
   ---------------------------------------------------------*/
  public function SetOrderID($orderid)
  {
    $this->_data['orderid'] = $orderid;
  }


  /*---------------------------------------------------------
   GetOrderID()
   ---------------------------------------------------------*/
  public function GetOrderID()
  {
    if( isset($this->_data['orderid']) )
      return $this->_data['orderid'];
  }


  /*---------------------------------------------------------
   SetPaymentid()
   ---------------------------------------------------------*/
  public function SetPaymentid($paymentid)
  {
    $this->_data['paymentid'] = $paymentid;
  }


  /*---------------------------------------------------------
   GetPaymentID()
   ---------------------------------------------------------*/
  public function GetPaymentID()
  {
    if( isset($this->_data['paymentid']) )
      return $this->_data['paymentid'];
  }


  /*---------------------------------------------------------
   SetTransactionId()
   ---------------------------------------------------------*/
  public function SetTransactionId($tid)
  {
    $this->_data['transaction_id'] = $tid;
  }


  /*---------------------------------------------------------
   SetTransactionStatus()
   ---------------------------------------------------------*/
  public function SetTransactionStatus($status)
  {
    $this->_data['status'] = $status;
  }


  /*---------------------------------------------------------
   SetTransactionAmount()
   ---------------------------------------------------------*/
  public function SetTransactionAmount($tid)
  {
    $this->_data['amount'] = $tid;
  }


  /*---------------------------------------------------------
   SetError()
   ---------------------------------------------------------*/
  public function SetError($message)
  {
    $this->_data['status'] = PAYMENT_STATUS_ERROR;
    $this->_data['error_message'] = $message;
  }


  /*---------------------------------------------------------
   SetCancelled()
   ---------------------------------------------------------*/
  public function SetCancelled($message)
  {
    $this->_data['status'] = PAYMENT_STATUS_CANCELLED;
  }


  /*---------------------------------------------------------
   Reset()
   ---------------------------------------------------------*/
  public function Reset()
  {
    $this->_data = array();
  }


  /*---------------------------------------------------------
   SetDeclined()
   ---------------------------------------------------------*/
  public function SetDeclined($message='')
  {
    $this->_data['status'] = PAYMENT_STATUS_DECLINED;
	if ($message == '')
		{
    	$this->_data['error_message'] = $this->Lang('error_payment_declined');
		}
	else
		{
		$this->_data['error_message'] = $message;	
		}
  }


  /*---------------------------------------------------------
   GetTransactionStatus()
   ---------------------------------------------------------*/
  public function GetTransactionStatus()
  {
    if( isset($this->_data['status']) )
      return $this->_data['status'];
    return FALSE;
  }


  /*---------------------------------------------------------
   GetTransactionId()
   ---------------------------------------------------------*/
  public function GetTransactionId()
  {
    if( isset($this->_data['transaction_id']) )
      return $this->_data['transaction_id'];
    return FALSE;
  }


  /*---------------------------------------------------------
   GetTransactionAmount()
   ---------------------------------------------------------*/
  public function GetTransactionAmount()
  {
    if( isset($this->_data['amount']) )
      return $this->_data['amount'];
    return FALSE;
  }


  /*---------------------------------------------------------
   GetMessage()
   ---------------------------------------------------------*/
  public function GetMessage()
  {
    if( isset($this->_data['error_message']) )
      return $this->_data['error_message'];
    return FALSE;
  }


  /*---------------------------------------------------------
   FinishTransaction()
   ---------------------------------------------------------*/
  public function FinishTransaction()
  {
    if( !isset($this->_data['destination']) ) return FALSE;
    $key = $this->SaveState();
    $url = $this->_data['destination'];
    $url = html_entity_decode($url);
    $url .= "&cntnt01datakey=$key";
    redirect($url);
  }



  function SetReturnStatus($status)
  {
    if( !isset($_SESSION['gateway_return_params']) )
      {
	$_SESSION['gateway_return_params'] = array();
      }
    $_SESSION['gateway_return_params']['status'] = $status;
  }


  function GetReturnStatus()
  {
    if( !isset($_SESSION['gateway_return_params']) ) return false;
    if( !isset($_SESSION['gateway_return_params']['status']) ) return false;
    return $_SESSION['gateway_return_params']['status'];
  }


  function SetReturnTransactionID($tx)
  {
    if( !isset($_SESSION['gateway_return_params']) )
      {
	$_SESSION['gateway_return_params'] = array();
      }
    $_SESSION['gateway_return_params']['transid'] = $tx;
  }


  function GetReturnTransactionID()
  {
    if( !isset($_SESSION['gateway_return_params']) ) return false;
    if( !isset($_SESSION['gateway_return_params']['transid']) ) return false;
    return $_SESSION['gateway_return_params']['transid'];
  }


  function SetReturnText($txt)
  {
    if( !isset($_SESSION['gateway_return_params']) )
      {
	$_SESSION['gateway_return_params'] = array();
      }
    $_SESSION['gateway_return_params']['data'] = $txt;
  }


  function GetReturnTransactionText()
  {
    if( !isset($_SESSION['gateway_return_params']) ) return false;
    if( !isset($_SESSION['gateway_return_params']['data']) ) return false;
    return $_SESSION['gateway_return_params']['data'];
  }

  function ClearsessionVars()
  {
    unset( $_SESSION['emgw_success_url'] );
    unset( $_SESSION['emgw_cancel_url'] );
    unset( $_SESSION['emgw_custom_field'] );
    unset( $_SESSION['gateway_return_params'] );
  }

  function ExtractResponseString($tag, $result)
	{
	$regex = '/<'.$tag.'>([^<]+)<\/'.$tag.'>/i';
	$matches = array();
	if (! preg_match($regex,$result, $matches))
		{
		return false;
		}
	else
		{
		return $matches[1];
		}
	}

} // class
