<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is http://dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
#          The projects homepage is: http://www.cmsmadesimple.org
# Version: 0.5.1
# File   : method.upgrade.php
# Purpose: performs a module upgrade
# License: GPL
#
#-------------------------------------------------------------------------------

if (!isset($gCms)) exit;

$current_version = $oldversion;
$db              =& $this->GetDb();

switch($current_version) {
	
	case '0.3':
	case '0.3.1':
		
		$this->RemovePermission('Approve AdvancedContent');
		$this->RemovePermission('Modify AdvancedContent Block Order');
		$this->RemovePermission('Add AdvancedContent Blocks');
		$this->RemovePermission('Delete AdvancedContent Blocks');
		$this->RemovePermission('Modify AdvancedContent Block Options');
		
		$this->RemoveEventHandler( 'Core', 'ContentEditPre');
		$this->RemoveEventHandler( 'Core', 'ContentEditPost');
		$this->RemoveEventHandler( 'Core', 'ContentDeletePost');
		$this->RemoveEventHandler( 'Core', 'EditTemplatePost');
		$this->RemoveEventHandler( 'Core', 'DeleteTemplatePost');

		$dict     = NewDataDictionary( $db );
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_AdvancedContent" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_AdvancedContent_drafts" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_AdvancedContent_props" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( cms_db_prefix()."module_AdvancedContent_props_drafts" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( 
			cms_db_prefix()."module_AdvancedContent_addt_editors" );
		$dict->ExecuteSQLArray($sqlarray);
		
		$sqlarray = $dict->DropTableSQL( 
			cms_db_prefix()."module_AdvancedContent_addt_editors_drafts" );
		$dict->ExecuteSQLArray($sqlarray);
		
		// get propname of all content of type AdvancedContent
		$query    = "SELECT CP.prop_name, C.content_id FROM ". cms_db_prefix()."content C 
			LEFT JOIN ".cms_db_prefix()."content_props CP ON CP.content_id = C.content_id 
			WHERE C.type = ?";
			
		$dbresult = $db->Execute($query, array('content2'));
		$contents = array();
		
		while($dbresult && $row = $dbresult->FetchRow()) {
			
			// update propnames (removing special chars, umlauts and whitespaces)
			$query = "UPDATE ".cms_db_prefix()."content_props SET prop_name = ? 
				WHERE content_id = ? AND prop_name = ?";
				
			$db->Execute($query, array(preg_replace('/-+/','_',munge_string_to_url($row['prop_name'])),$row['content_id'],$row['prop_name']));
		}
		
		$current_version = '0.3.2';
		
	case '0.3.2':
	case '0.3.3 pre':
		$this->AddEventHandler( 'Core', 'ContentPostRender', false );
		$current_version = '0.3.3';
		
	case '0.3.3':
		// remove userprefs
		$query    = "DELETE FROM ". cms_db_prefix()."userprefs WHERE preference LIKE 'AdvancedContent_%";
		$dbresult = $db->Execute($query);
		
		// add new table for user prefs
		$taboptarray = array('mysql' => 'TYPE=MyISAM');
		$dict = NewDataDictionary($db);
		$flds = "user_id I, content_id I, block_id X, block_display I";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_AdvancedContent_blockdisplay", 
			$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		
		$current_version = '0.3.4';
	
	case '0.3.4':
	case '0.4':
		// add new table for user prefs
		$taboptarray = array('mysql' => 'TYPE=MyISAM');
		$dict = NewDataDictionary($db);
		$flds = "user_id I, content_id I, block_id X, message_display I";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_AdvancedContent_messagedisplay", 
			$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		
		$current_version = '0.4.1';
	
	case '0.4.1':
	case '0.4.2':
	case '0.4.3':
	case '0.4.4':
		$this->CreatePermission('Manage AdvancedContent Options', 'Manage AdvancedContent Options');
		$current_version = '0.5';

	default: 
		$current_version = $this->GetVersion();
		break;
}

?>
