<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.5.1
# File   : contenttype.Content2.php
#          This file is a modification of the default content type "Content"
# Purpose: the content object
# License: GPL
#
#-------------------------------------------------------------------------------

class Content2 extends CMSModuleContentType {
	/**
	 * @access private
	 * @var string
	 */
    var $stylesheet;
    /**
	 * @access private
	 * @var array
	 */
    var $_contentBlocks;
    /**
	 * @access private
	 * @var boolean
	 */
    var $_contentBlocksLoaded;
    /**
	 * @access private
	 * @var array
	 */
    var $contentAreas;
    /**
	 * @access private
	 * @var array
	 */
    var $pageTabs;
    /**
	 * @access private
	 * @var array
	 */
	var $userGroups;
	/**
	 * @access private
	 * @var boolean
	 */
	var $isAdmin;
	
	/**
	 * MLE support
	 * @access public
	 * @var boolean
	 */
	var $mle = false;
	/**
	 * MLE support
	 * @access public
	 * @var string
	 */
	var $lang;
	/**
	 * MLE support
	 * @access public
	 * @var string
	 */
	var $blockLang;
	/**
	 * MLE support
	 * @access public
	 * @var string
	 */
	var $defaultBlockLang;
	
	function Content2() {
		parent::ContentBase();
		$this->_contentBlocks       = array();
		$this->contentAreas        = array();
		$this->_contentBlocksLoaded = false;
		global $CMS_ADMIN_PAGE;
		if(isset($CMS_ADMIN_PAGE) && $CMS_ADMIN_PAGE == 1) {
			$this->pageTabs   = array('main', 'options');
			$this->userGroups = $this->GetGroups();
			global $gCms;
			$userOps       =& $gCms->GetUserOperations();
			$this->isAdmin = $userOps->UserInGroup(get_userid(),1);
		}
		
		# MLE support
		global $hls, $mleblock, $mleblockfallback;
		if(isset($hls)) {
			$this->mle              = true;
			$this->lang             = $hls;
			$this->blockLang        = $mleblock;
			$this->defaultBlockLang = $mleblockfallback;
		}
		#---
	}
	
	function ModuleName() {
		return 'AdvancedContent';
	}
	
	function IsDefaultPossible() {
		return TRUE;
	}
	
	function IsCopyable() {
		return TRUE;
	}
	
	function FriendlyName() {
		return $this->lang('AdvancedContent');
	}
	
	function get_content_blocks() {
		if ($this->_contentBlocksLoaded) return true;
		
		global $gCms;
		require(cms_join_path(dirname(__FILE__), 'inc', 'function.getContentBlocks.inc.php'));
		
		return $this->_contentBlocks;
	}
	
	function display_content_block($blockName,$blockInfo,$value,$adding = false) {
		# ToDo...
	}
	
	function SetProperties() {
		parent::SetProperties();
		
		$this->AddBaseProperty('template', 4, 0, 'int');
		$this->AddBaseProperty('pagemetadata', 20);
		
		$this->AddContentProperty('searchable', 8, 0, 'int');
		$this->AddContentProperty('pagedata', 25);
		$this->AddContentProperty('disable_wysiwyg', 60, 0, 'int');
		
		$this->AddContentProperty('feu_access', 99);
		$this->AddContentProperty('redirect_page', 100, 0, 'int');
		$this->AddContentProperty('redirect_params', 101, 0);
		$this->AddContentProperty('evaluate_smarty', 102, 0, 'int');
		$this->AddContentProperty('feu_action', 103, 0, 'int');
		
		$this->AddContentProperty('use_expire_date', 104, 0, 'int');
		$this->AddContentProperty('start_date', 105, 0, 'int');
		$this->AddContentProperty('end_date', 106, 0, 'int');
		
		$this->mPreview = true;
	}
	
	function ReadyForEdit() {
		$this->get_content_blocks();
	}
	
	function Show($param = 'content_en') {
		$this->get_content_blocks();
		
		# MLE support
		if($this->mle && $this->blockLang != '') {
			if($param == 'content_en') {
				$param = 'content'.$this->blockLang;
			}
			else if(!endswith($param,$this->blockLang)) {
				$param .= $this->blockLang;
			}
			
			$result = $this->GetPropertyValue($param);
			
			if($result == '' && $this->defaultBlockLang != '' && $this->defaultBlockLang != $this->blockLang) {
				$param = str_replace($this->blockLang, $this->defaultBlockLang, $param);
				$result = $this->GetPropertyValue($param);
			}
			
			return $result;
		}
		#---
		
		return $this->GetPropertyValue($param);
	}
	
	function TabNames() {
		$res = array(lang('main'));
		if( check_permission(get_userid(), 'Manage All Content') ) {
			$res[] = lang('options');
		}
		if( check_permission(get_userid(), 'Manage AdvancedContent Options') ) {
			$res[] = 'AdvancedContent';
		}
		$this->pageTabs = array('main');
		if( check_permission(get_userid(), 'Manage All Content') ) {
			$this->pageTabs[] = 'options';
		}
		if( check_permission(get_userid(), 'Manage AdvancedContent Options') ) {
			$this->pageTabs[] = 'AdvancedContent';
		}
		$this->get_content_blocks();
		foreach($this->_contentBlocks as $blockInfo) {
			if(!in_array($blockInfo['page_tab'], $this->pageTabs) && $blockInfo['page_tab'] != '') {
				
				if(!$this->CheckBlockPermission($blockInfo))
					continue;
				
				$res[] = ucwords($blockInfo['page_tab']);
				$this->pageTabs[] = $blockInfo['page_tab'];
			}
		}
		return $res;
	}
	
	function FillParams($params) {
		global $gCms;
		require(cms_join_path(dirname(__FILE__), 'inc', 'function.fillParams.inc.php'));
		parent::FillParams($params);
	}
	
	function EditAsArray($adding = false, $tab = 0, $showadmin = false) {
		$this->get_content_blocks();
		$ret = array();
		$tmp = array();
		if($tab == 0 || (isset($this->pageTabs[$tab]) && $this->pageTabs[$tab] == 'options' && check_permission(get_userid(), 'Manage All Content'))) {
			$tmp = $this->CleanArray($this->display_attributes($adding, $tab));
		}
		else if(isset($this->pageTabs[$tab]) && $this->pageTabs[$tab] == 'AdvancedContent' && check_permission(get_userid(), 'Manage AdvancedContent Options')) {
			$tmp = $this->DisplayAdvancedContentOptions($adding);
		}
		foreach( $tmp as $one ) {
			$ret[] = $one;
		}
		global $gCms;
		require(cms_join_path(dirname(__FILE__), 'inc', 'function.displayContentBlocks.inc.php'));
		
		return $ret;
	}
	
	function ValidateData() {
		$errors = parent::ValidateData();
		if( $errors === FALSE ) {
			$errors = array();
		}
		
		if ($this->mTemplateId <= 0 ) {
			$errors[] = lang('nofieldgiven', array(lang('template')));
			$result   = false;
		}
		
		#if ($this->GetPropertyValue('content_en') == '') {
		#	$errors[] = lang('nofieldgiven', array(lang('content')));
		#	$result   = false;
		#}
		if ( check_permission(get_userid(), 'Manage AdvancedContent Options') && $this->GetPropertyValue('use_expire_date') == '1' && $this->GetPropertyValue('end_date') <= $this->GetPropertyValue('start_date')) {
			global $gCms;
			$AdvancedContent =& $gCms->modules['AdvancedContent']['object'];
			$errors[] = $AdvancedContent->lang('error_expiredate');
			$result   = false;
		}
		
		return (count($errors) > 0?$errors:FALSE);
	}
	
	function ContentPreRender($tplSource) {
		$this->get_content_blocks();
		return $tplSource;
	}
	
	function display_single_element($one, $adding) {
		global $gCms;
		switch($one) {
			case 'template':
				$templateops =& $gCms->GetTemplateOperations();
				return array(lang('template') . ':', $templateops->TemplateDropdown('template_id', $this->mTemplateId, 'onchange="document.contentform.submit()"'));
			
			case 'pagemetadata':
				return array(lang('page_metadata') . ':', create_textarea(false, $this->Metadata(), 'metadata', 'pagesmalltextarea', 'metadata', '', '', '80', '6'));
			
			case 'pagedata':
				return array(lang('pagedata_codeblock') . ':', create_textarea(false, $this->GetPropertyValue('pagedata'), 'pagedata', 'pagesmalltextarea', 'pagedata', '', '', '80', '6'));
			
			case 'searchable':
				$searchable = $this->GetPropertyValue('searchable');
				if( $searchable == '' ) {
					$searchable = 1;
				}
				return array(lang('searchable') . ':',
					'<div class="hidden" ><input type="hidden" name="searchable" value="0" /></div>
					<input type="checkbox" name="searchable" value="1" ' . ($searchable == 1?'checked="checked"':'') . ' />');
			
			case 'disable_wysiwyg':
				$disableWysiwyg = $this->GetPropertyValue('disable_wysiwyg');
				if( $disableWysiwyg == '' ) {
					$disableWysiwyg = 0;
				}
				return array(lang('disable_wysiwyg') . ':',
					'<div class="hidden" ><input type="hidden" name="disable_wysiwyg" value="0" /></div>
					<input type="checkbox" name="disable_wysiwyg" value="1"  ' . ($disableWysiwyg == 1?'checked="checked"':'') . ' onclick="this.form.submit()" />');
			
			case 'feu_access':
			case 'redirect_page':
			case 'redirect_params':
			case 'evaluate_smarty':
			case 'feu_action':
			case 'start_date':
			case 'end_date':
			case 'use_expire_date': 
				return '';
			
			default:
				return parent::display_single_element($one, $adding);
		}
	}

/**
 * -----------------------------------------------------------------------------
 * Custom functions
 * -----------------------------------------------------------------------------
 */
	/**
	 * function DisplayAdvancedContentOptions($adding)
	 * not part of the module api
	 * this is just a wrapper to process a template from data
	 *
	 * @param boolean $adding - true if page is added, false if edited
	 *
	 * @return array - array(array(prompt,imput))
	 */
	function DisplayAdvancedContentOptions($adding) {
		global $gCms;
		$AdvancedContent =& $gCms->modules['AdvancedContent']['object'];
		$ret = array();
		
		foreach( $this->_attributes as $oneAttrib ) {
			switch($oneAttrib[0]) {
				
				case 'feu_access':
					if(isset($gCms->modules['FrontEndUsers']['object']) && is_object($gCms->modules['FrontEndUsers']['object']) ) {
						
						$feusers =& $gCms->modules['FrontEndUsers']['object'];
						if($adding)
							$selectedGroups = $this->CleanArray(explode(';',$AdvancedContent->GetPreference('feu_access')));
						else
							$selectedGroups = $this->CleanArray(explode(';', $this->GetPropertyValue('feu_access')));
						
						$feuAccess = array($AdvancedContent->lang('inherit_from_parent')=>-1);
						$feuAccess = array_merge($feuAccess,$feusers->GetGroupList());
						$ret[] = array($AdvancedContent->lang('frontendaccess').' : ', 
							'<input type="hidden" value="" name="feu_access" />'.
							$AdvancedContent->CreateInputSelectList('','feu_access[]',$feuAccess,$selectedGroups,count($feuAccess),'',1));
					}
					break;
				
				case 'redirect_page':
					if(isset($gCms->modules['FrontEndUsers']['object']) && is_object($gCms->modules['FrontEndUsers']['object']) ) {
						if($adding)
							$selectedPage = $AdvancedContent->GetPreference('redirect_page','');
						else
							$selectedPage = $this->GetPropertyValue("redirect_page");
						
						$ret[] = array($AdvancedContent->lang('redirectpage').' : ', 
							$AdvancedContent->CreateRedirectDropdown('', 'redirect_page',$selectedPage, $this->mId));
					}
					break;
				
				case 'redirect_params':
					if(isset($gCms->modules['FrontEndUsers']['object']) && is_object($gCms->modules['FrontEndUsers']['object']) ) {
						if($adding) {
							$redirectParams = $AdvancedContent->GetPreference('redirect_params','');
							$evaluateSmarty = $AdvancedContent->GetPreference('evaluate_smarty','');
						}
						else {
							$redirectParams = $this->GetPropertyValue("redirect_params");
							$evaluateSmarty = $this->GetPropertyValue("evaluate_smarty");
						}
							
						$ret[] = array($AdvancedContent->lang('redirectparams').' : ', 
							'<input type="text" size="32" maxlength="128" name="redirect_params" value="'.$redirectParams.'" />&nbsp;<em>(param1=value1 param2=value2 ...)</em><br />
							<input type="hidden" name="evaluate_smarty" value="0" />'.
							$AdvancedContent->lang('evaluatesmarty') . ':&nbsp;'.
							'<input type="checkbox" name="evaluate_smarty" value="1"  ' . ($evaluateSmarty == 1?'checked="checked"':'') . ' />');
					}
					break;
				
				case 'feu_action':
					if(isset($gCms->modules['FrontEndUsers']['object']) && is_object($gCms->modules['FrontEndUsers']['object']) ) {
						if($adding)
							$feuAction = $AdvancedContent->GetPreference('feu_action','');
						else
							$feuAction = $this->GetPropertyValue('feu_action');
						$ret[] = array($AdvancedContent->lang('showloginform').' : ', 
							$AdvancedContent->CreateInputDropdown('','feu_action',
								array($AdvancedContent->lang('no')=>'',
									$AdvancedContent->lang('inherit_from_parent')=>-1,
									$AdvancedContent->lang('yes')=>1)
								,0,$feuAction));
					}
					break;
				
				case 'start_date':
					$startDate = $this->GetPropertyValue('start_date');
					if(!$startDate)
						$startDate = time();
					
					$date        = strftime('%x', intval($startDate));
					$time        = strftime('%H:%M', intval($startDate));
					
					$_tmp        = $this->CleanArray(explode(':',$time));
					$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
					$dateSeconds = $startDate - $timeSeconds;
					
					$startDateInput = '
						<img id="AdvancedContentStartDatePickerTrigger" src="../modules/AdvancedContent/images/calendar.png" class="calendarTrigger" />&nbsp;
						<span id="AdvancedContentStartDatePickerDisplay">'.$date.'</span>&nbsp;&nbsp;-&nbsp;&nbsp;
						<input id="AdvancedContentStartDate" type="hidden" name="AdvancedContentStartDate" value="'.$dateSeconds.'" />
						<select name="AdvancedContentStartTime">';
						
					for($i=0; $i<=23; $i++) {
						for($j=0; $j<=59; $j++) {
							$value = ($i*3600) + ($j*60);
							$startDateInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:$i) .':'. ($j<10?'0'.$j:$j) .'</option>';
						}
						$j = 0;
					}
					$startDateInput .= '</select>';
					$ret[] = array($AdvancedContent->lang('startdate').' : ', $startDateInput);
					break;
				
				case 'end_date':
					$endDate = $this->GetPropertyValue('end_date');
					if(!$endDate)
						$endDate = time();
					
					$date        = strftime('%x', intval($endDate));
					$time        = strftime('%H:%M', intval($endDate));
					
					$_tmp        = $this->CleanArray(explode(':',$time));
					$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
					$dateSeconds = $endDate - $timeSeconds;
					
					$endDateInput = '
						<img id="AdvancedContentEndDatePickerTrigger" src="../modules/AdvancedContent/images/calendar.png" class="calendarTrigger" />&nbsp;
						<span id="AdvancedContentEndDatePickerDisplay">'.$date.'</span>&nbsp;&nbsp;-&nbsp;&nbsp;
						<input id="AdvancedContentEndDate" type="hidden" name="AdvancedContentEndDate" value="'.$dateSeconds.'" />
						<select name="AdvancedContentEndTime">';
						
					for($i=0; $i<=23; $i++) {
						for($j=0; $j<=59; $j++) {
							$value = ($i*3600) + ($j*60);
							$endDateInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:$i) .':'. ($j<10?'0'.$j:$j) .'</option>';
						}
						$j = 0;
					}
					$endDateInput .= '</select>';
					$ret[] = array($AdvancedContent->lang('enddate').' : ', $endDateInput);
					break;
				
				case 'use_expire_date':
					$useExp = $this->GetPropertyValue('use_expire_date');
					if( $useExp == '' ) {
						$useExp = 0;
					}
					$ret[] = array($AdvancedContent->lang('useexpiredate') . ':',
						'<div class="hidden" ><input type="hidden" name="use_expire_date" value="0" /></div>
						<input type="checkbox" name="use_expire_date" value="1"  ' . ($useExp == 1?'checked="checked"':'') . ' />');
					break;
				
				default:break;
			}
		}
		return $ret;
	}
	
	
	/**
	 * function DoSmarty($data)
	 * not part of the module api
	 * this is just a wrapper to process a template from data
	 *
	 * @param string $data - The template content to process
	 *
	 * @return string - The processed template data
	 */
	function DoSmarty($data) {
		
		// only process smarty if there is actually something to process
		if(!is_array($data) && !is_object($data) && preg_match_all('/:::([^:]+):::/', $data, $matches)) {
			
			global $gCms;
			$AdvancedContent =& $gCms->modules['AdvancedContent']['object'];
			
			// only do this if we did not do this before
			if(!isset($gCms->variables['pageinfo']->content_id)) {
				// fake frontend rendering
				$gCms->variables['pageinfo']                              = new stdClass();
				$gCms->variables['pageinfo']->content_id                  = $this->mId;
				$gCms->variables['pageinfo']->content_title               = $this->mName;
				$gCms->variables['pageinfo']->content_alias               = $this->mAlias;
				$gCms->variables['pageinfo']->content_menutext            = $this->mMenuText;
				$gCms->variables['pageinfo']->content_titleattribute      = $this->mTitleAttribute;
				$gCms->variables['pageinfo']->content_hierarchy           = $this->mHierarchy;
				$gCms->variables['pageinfo']->content_id_hierarchy        = $this->mIdHierarchy;
				$gCms->variables['pageinfo']->content_type                = $this->mType;
				$gCms->variables['pageinfo']->content_props               = $this->mProperties->mPropertyNames;
				$gCms->variables['pageinfo']->content_metadata            = $this->mMetadata;
				$gCms->variables['pageinfo']->content_modified_date       = $this->mModifiedDate;
				$gCms->variables['pageinfo']->content_created_date        = $this->mCreationDate;
				$gCms->variables['pageinfo']->content_last_modified_date  = $this->mModifiedDate;
				$gCms->variables['pageinfo']->content_last_modified_by_id = $this->mOwner;
				$gCms->variables['pageinfo']->template_id                 = $this->mTemplateId;
				$gCms->variables['pageinfo']->template_encoding           = get_encoding('');
				$gCms->variables['pageinfo']->template_modified_date      = time(); // ???
				$gCms->variables['pageinfo']->cachable                    = $this->mCachable;
				$gCms->variables['pageinfo']->content_hierarchy_path      = $this->mHierarchyPath;
				
				$gCms->variables['content_id']                            = $this->mId;
				$gCms->variables['page']                                  = $this->mAlias;
				$gCms->variables['page_id']                               = $this->mAlias;
				$gCms->variables['page_alias']                            = $this->mAlias;
				$gCms->variables['content_alias']                         = $this->mAlias;
				$gCms->variables['page_name']                             = $this->mAlias;
				$gCms->variables['position']                              = $this->mHierarchy;
				$gCms->variables['friendly_position']                     = ContentOperations::CreateFriendlyHierarchyPosition($this->mHierarchy);
				
				$AdvancedContent->smarty->assign('content_id', $this->mId);
				$AdvancedContent->smarty->assign('content_alias', $this->mAlias);
				$AdvancedContent->smarty->assign('page', $this->mAlias);
				$AdvancedContent->smarty->assign('page_id', $this->mAlias);
				$AdvancedContent->smarty->assign('page_alias', $this->mAlias);
				$AdvancedContent->smarty->assign('page_name', $this->mAlias);
				$AdvancedContent->smarty->assign('position', $this->mHierarchy);
				$AdvancedContent->smarty->assign('friendly_position', ContentOperations::CreateFriendlyHierarchyPosition($this->mHierarchy));
			}
			$data = $AdvancedContent->ProcessTemplateFromData(preg_replace('/:::([^:]+):::/', '{$1}', $data));
		}
		return $data;
	}
	
	
	/**
	 * function InheritParentProp($parentId, $propName, $currentProp)
	 * not part of the module api
	 * inherits a property of a parent page;
	 * if parent page has also selected inheritance for that property -> do recursion
	 *
	 * @param int $parentId - The id of the parent page
	 * @param string $propName - The name of the property to inherit
	 * @param array $currentProp (optional) - If prop is an array this will be the items of the current page; So return array will contain all items of the current page and parent pages; otherwise only the parents items will be returned
	 *
	 * @return array|string - The prop of the last found parent that has no inheritance or an array of items of all parents that have inheritance
	 */
	function InheritParentProp($parentId, $propName, $currentProp = array()) {
		
		// default return value
		// feu_access is a special case (because of multiple selections are possible)
		if($propName == 'feu_access') {
			$prop = array();
			
			// this will "merge" the parents prop with the current one
			// but removing the inherit stuff; 
			// so if currentProp is set this will return an array with all props 
			// (real values only; no inherit flag)
			// including the parents ones and the current one but without duplicate values
			foreach($currentProp as $k=>$v) {
				if($v != '-1')
					$prop[] = $v;
			}
		}
		else
			$prop = '';
		
		// as long as page has parents...
		while( $parentId > 0 ) {
			
			$content = $this->GetContentProp($parentId, $propName, 'content2');
			
			if(!$content)
				return $prop;
			
			$parentId  = $content['parent_id'];
			$propValue = $content['prop_value'];
			
			// feu_access is a special case (because of multiple selections are possible)
			if($propName == 'feu_access') {
				
				$_prop = $this->CleanArray(explode(";", $propValue));
				
				foreach($_prop as $_p) {
					if(!in_array($_p, $prop) && $_p != '-1' && $_p != '') 
						$prop[] = $_p;
				}
				
				// if the current obj does not inherit its prop anymore OR has no parents 
				// but wants to inherit -> return the prop array
				if(!in_array('-1', $_prop) || ($parentId <= 0 && in_array('-1', $_prop))) 
					return $prop;
				
			}
			else {
				
				// if content has no parents but wants to inherit -> return
				if($parentId <= 0 && $propValue == '-1') {
					return;
				}
				// if no inheritance anymore -> return the prop
				else if($propertyValue != '-1') {
					return $propValue;
				}
			}
		}
	}
	
	
	/**
	 * function GetContentProp($contentId, $propName, $contentType)
	 * not part of the module api
	 * gets a property of a content page
	 *
	 * @param int $contentId - The id of the content to get the property from
	 * @param string $propName - The name of the property to get the value from
	 * @param string $contentType (optional) - The type of the content
	 *
	 * @return mixed - False if not exists or array('parent_id','prop_value')
	 *
	 */
	function GetContentProp($contentId, $propName, $contentType = '') {
		global $gCms;
		$db =& $gCms->GetDb();
		$query = "SELECT CP.content, C.parent_id, C.content_alias FROM " . cms_db_prefix() . "content_props CP 
			LEFT JOIN " . cms_db_prefix() . "content C ON C.content_id = CP.content_id 
			WHERE CP.content_id = ? AND CP.prop_name = ?";
		$p = array($contentId, $propName);
		if($contentType != '') {
			$query .= " AND C.type = ?";
			$p[]    = $contentType;
		}
		$query .= " LIMIT 1";
		$dbresult = $db->Execute($query, $p);
		if($dbresult && $row = $dbresult->FetchRow())
			return array('parent_id'=>$row['parent_id'], 'prop_value'=>$row['content'], 'alias'=>$row['alias']);
		
		return false;
	}
	
	
	/**
	 * function SortContentBlocks()
	 * not part of the module api
	 * simple sorting function
	 * sorts the content blocks by sequence attribute that is given in FillParams()
	 * this is only important for content blocks that are not defined in template
	 */
	function SortContentBlocks() {
		$_contentBlocks = array();
		foreach($this->_contentBlocks as $blockInfo) {
			$_contentBlocks['number_'.$blockInfo['sequence']] = $blockInfo;
		}
		$this->_contentBlocks = array();
		ksort($_contentBlocks);
		reset($_contentBlocks);
		foreach($_contentBlocks as $blockInfo) {
			$this->_contentBlocks[$blockInfo['block_id']] = $blockInfo;
		}
	}
	
	
	function DisplayBlockOptions($blockId, $adding = false) {
		global $gCms;
		$blockOptions = '';
		if($this->_contentBlocks[$blockId]['save_db']) {
			require(cms_join_path(dirname(__FILE__), 'inc', 'function.displayBlockOptions.inc.php'));
		}
		return $blockOptions;
	}
	
	
	function GetGroups() {
		global $gCms;
		$db =& $gCms->GetDb();
		$groups = array();
		$query = "SELECT group_id FROM ".cms_db_prefix()."user_groups WHERE user_id = ?";
		$dbresult = $db->Execute($query, array(get_userid()));
		while( $dbresult && $row = $dbresult->FetchRow() ) {
			$groups[] = $row['group_id'] * -1;
		}
		return $groups;
	}
	
	function CheckBlockPermission($blockInfo) {
		global $gCms;
		$this->_contentBlocks[$blockInfo['block_id']]['addt_editors'] = array();
		// check if user has permission to edit this block
		if(!$blockInfo['save_db'] 
		&& ($blockInfo['editor_users'] != '' || $blockInfo['editor_groups'] != '') 
		&& !check_permission(get_userid(), 'Manage All AdvancedContent Blocks')) {
			$userops      =& $gCms->GetUserOperations();
			$groupops     =& $gCms->GetGroupOperations();
			$allusers     =& $userops->LoadUsers();
			$allgroups    =& $groupops->LoadGroups();
			$editorGroups =  $this->CleanArray(explode(',',$blockInfo['editor_groups']));
			$editorUsers  =  $this->CleanArray(explode(',',$blockInfo['editor_users']));
			
			foreach ($allgroups as $oneGroup) {
				if(in_array($oneGroup->name,$editorGroups))
					$this->_contentBlocks[$blockInfo['block_id']]['addt_editors'][] = $oneGroup->id*-1;
			}
			
			foreach ($allusers as $oneUser) {
				if(in_array($oneUser->username,$editorUsers))
					$this->_contentBlocks[$blockInfo['block_id']]['addt_editors'][] = $oneUser->id;
			}
			
			if(!in_array(get_userid(),$this->_contentBlocks[$blockInfo['block_id']]['addt_editors']) 
			&& !count(array_intersect($this->userGroups,$this->_contentBlocks[$blockInfo['block_id']]['addt_editors']))) {
				unset($this->_contentBlocks[$blockInfo['block_id']]);
				return false;
			}
		}
		return true;
	}
	
	
	/**
	 * function IsVarEmpty($var, $trim, $unsetEmptyIndexes)
	 * not part of the module api
	 * checks if a var is empty. if var is an array it recursivley checks all elements
	 *
	 * @param mixed $var - the var to check for empty value(s)
	 * @param boolean $trim - true to trim off spaces
	 * @param boolean $unsetEmptyIndexes - true to delete empty elements from array
	 * @return boolean - true if empty, false if not
	 */
	function IsVarEmpty(&$var, $trim = true, $unsetEmptyIndexes = false) {
		if (is_array($var)) {
			foreach ($var as $k=>$v) {
				if (!$this->IsVarEmpty($v)) {
					return false;
				}
				else {
					if($unsetEmptyIndexes)
						unset($var[$k]);
					return true;
				}
			}
		}
		else if($trim && trim($var) == '') {
			return true;
		}
		else if($var == '') {
			return true;
		}
		return false;
	}
	
	
	/**
	 * function CleanArray($array)
	 * not part of the module api
	 * removes empty elements from an array 
	 * (can be useful when using function explode to create the array of a csv)
	 *
	 * @param array $array - the array to clean up
	 * @return array - an array without empty elements or an empty array
	 */
	function CleanArray($array) {
		if (is_array($array)) {
			foreach ($array as $k=>$v) {
				if ($this->IsVarEmpty($v,true,true)) {
					unset($array[$k]);
				}
				else {
					if(is_array($v)) {
						$v = $this->CleanArray($v);
						if($this->IsVarEmpty($v,true,true))
							unset($array[$k]);
						else
							$array[$k] = $v;
					}
				}
			}
			return $array;
		}
		return array();
	}
	
	
	/**
	 * function IsTrue($value)
	 * not part of the module api
	 * checks if a value is literally "true"
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsTrue($value) {
		return (strtolower($value) === 'true' || $value === 1 || $value === '1' || $value === true);
	}
	
	
	/**
	 * function IsFalse($value)
	 * not part of the module api
	 * checks if a value is literally "false"
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsFalse($value) {
		return (strtolower($value) === 'false' || $value === '0' || $value === 0 || $value === false || $value === '');
	}
}
?>
