<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.5.1
# File   : action.savePrefs.php
# Purpose: saves the preferences in the database
# License: GPL
#
#-------------------------------------------------------------------------------

if(!isset($gCms)) exit;

if(isset($params['submit'])) {
	
	if(isset($params['uninstall_action']))
		$this->SetPreference('uninstall_action', $params['uninstall_action']);
	
	if(isset($params['restrictdirs']))
		$this->SetPreference('restrictdirs', $params['restrictdirs']);

	if(isset($params['showfilemanagement']))
		$this->SetPreference('showfilemanagement', $params['showfilemanagement']);

	if(isset($params['showthumbnailfiles']))
		$this->SetPreference('showthumbnailfiles', $params['showthumbnailfiles']);

	if(isset($params['allowscaling']))
		$this->SetPreference('allowscaling', $params['allowscaling']);

	if(isset($params['scalingwidth']))
		$this->SetPreference('scalingwidth', $params['scalingwidth']);

	if(isset($params['scalingheight']))
		$this->SetPreference('scalingheight', $params['scalingheight']);
	
	if(isset($params['filepickerstyle']))
		$this->SetPreference('filepickerstyle', $params['filepickerstyle']);
	
	if(isset($params['makethumbnail']))
		$this->SetPreference('makethumbnail', $params['makethumbnail']);
	
	if(isset($params['filepickerwidth']))
		$this->SetPreference('filepickerwidth', $params['filepickerwidth']);
	if(isset($params['filepickerheight']))
		$this->SetPreference('filepickerheight', $params['filepickerheight']);
	if(isset($params['filepickerwidthunit']))
		$this->SetPreference('filepickerwidthunit', $params['filepickerwidthunit']);
	if(isset($params['filepickerheightunit']))
		$this->SetPreference('filepickerheightunit', $params['filepickerheightunit']);
	
	if(isset($params['allowupscaling']))
		$this->SetPreference('allowupscaling', $params['allowupscaling']);
	
	if(isset($params['usemimetype']))
		$this->SetPreference('usemimetype', $params['usemimetype']);
	
	if(isset($params['feu_access']))
		$this->SetPreference('feu_access', implode(';',$this->CleanArray($params['feu_access'])));
	
	if(isset($params['redirect_page']))
		$this->SetPreference('redirect_page', $params['redirect_page']);
	
	if(isset($params['redirect_params']))
		$this->SetPreference('redirect_params', $params['redirect_params']);
	
	if(isset($params['evaluate_smarty']))
		$this->SetPreference('evaluate_smarty', $params['evaluate_smarty']);
	
	if(isset($params['feu_action']))
		$this->SetPreference('feu_action', $params['feu_action']);
	
}

if(isset($params['toggle']) && isset($params['display'])) {
	switch($params['toggle']) {
		
		case 'block':
		case 'message':
			if(isset($params['content_id']) && $params['content_id'] != '' && isset($params['block_id']))
				$this->SetElmDisplay($params['toggle'],$params['content_id'], $params['block_id'], $params['display']);
			break;
			
		case 'fileoperations':
			set_preference(get_userid(), 'file_operations_display', $params['display']);
			break;
			
		default: break;
	}
}

if(isset($params['ajax'])) {
	header('Content-Type: text/xml');
	print '<?xml version="1.0" encoding="UTF-8"?>';
	print '<response>';
	print '<message>';
	print '<![CDATA[<div class="pagemcontainer"><p class="pagemessage">'.$this->lang('prefsupdated').'</p></div>]]>';
	print '</message>';
	print '</response>';
	exit;
}
else {
	$this->Redirect($id, 'defaultadmin', $returnid, array('message' => 'prefsupdated', 'submit' => true));
}
?>
