<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Postcode (c) 2009 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow conversion of postal codes
#  from the geoname service.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if (!isset($gCms)) exit;
$db =& $this->GetDb();

$taboptarray = array('mysql' => 'TYPE=MyISAM');
$dict = NewDataDictionary($db);
$flds = "
        country   C(2) KEY,
        postal    C(10) KEY,
        place     C(255),
        state     C(20),
        latitude  F,
        longitude F
";


$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_postcode",
				  $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$this->CreatePermission('manage_postcodes','Manage Postal Codes');
$this->SetPreference('assume_country','US');
$this->SetPreference('operation_mode',3);
$this->SetPreference('import_delimeter',"[TAB]");
$dflt_fieldmap = <<<EOT
country=1
postal=2
placename=3
state=5
latitude=9
longitude=10
EOT;
$this->SetPreference('import_fieldmap',$dflt_fieldmap);
$this->SetPreference('operation_mode',1);

#
# EOF
#
?>