<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.6
# File   : contenttype.Content2.php
#          This file is a modification of the default content type "Content"
# Purpose: the content object
# License: GPL
#
#-------------------------------------------------------------------------------
/**
 * this is just a dummy class to access the module without using CMSms internals
 */
class AdvancedContentModule extends AdvancedContent 
{
	function AdvancedContentModule() 
	{
		parent::AdvancedContent();
	}
}

class Content2 extends CMSModuleContentType 
{
	/**
	 * @access private
	 * @var string
	 */
    var $_stylesheet;
    
    /**
	 * @access private
	 * @var array
	 */
    var $_contentBlocks;
    
    /**
	 * @access private
	 * @var boolean
	 */
    var $_contentBlocksLoaded;
    
    /**
	 * @access private
	 * @var array
	 */
    var $_tabIds;
    
    /**
	 * @access private
	 * @var array
	 */
    var $_pageTabs;
    
    /**
	 * @access private
	 * @var array
	 */
    var $_blockTabs;
    
    /**
	 * @access private
	 * @var array
	 */
    var $_blockGroups;
    
	/**
	 * @access private
	 * @var array
	 */
	var $_userGroups;
	
	/**
	 * @access private
	 * @var array
	 */
	var $_dateBlocks;
	
	/**
	 * @access private
	 * @var boolean
	 */
	var $_isAdmin;
	
	/**
	 * MLE support
	 * @access public
	 * @var boolean
	 */
	var $mle = false;
	
	/**
	 * MLE support
	 * @access public
	 * @var string
	 */
	var $lang;
	
	/**
	 * MLE support
	 * @access public
	 * @var string
	 */
	var $blockLang;
	
	/**
	 * MLE support
	 * @access public
	 * @var string
	 */
	var $defaultBlockLang;
	
	
	/**
	 * Constructor
	 */
	function Content2() 
	{
		parent::ContentBase();
		$this->_contentBlocks       = array();
		$this->_contentBlocksLoaded = false;
		global $CMS_ADMIN_PAGE;
		if(isset($CMS_ADMIN_PAGE) && $CMS_ADMIN_PAGE == 1) 
		{
			$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
			$this->_tabIds      = array();
			$this->_dateBlocks  = array();
			$this->_blockTabs   = array();
			$this->_blockGroups = array();
			
			$this->_pageTabs = array(
				'main' => array(
					'tab_id'         => 'main', 
					'tab_name'       => lang('main'), 
					'block_tabs'     => array(),
					'block_groups'   => array(),
					'content_blocks' => array()));
			$this->_tabIds[] = 'main';
			
			if( check_permission(get_userid(), 'Manage All Content') ) 
			{
				$this->_pageTabs['options'] = array(
					'tab_id'         => 'options', 
					'tab_name'       => lang('options'), 
					'block_tabs'     => array(),
					'block_groups'   => array(),
					'content_blocks' => array());
				$this->_tabIds[] = 'options';
			}
			
			if( check_permission(get_userid(), 'Manage AdvancedContent Options') && $AdvancedContent->GetPreference('show_advancedcontent_options',1) ) 
			{
				$this->_pageTabs['AdvancedContent'] = array(
					'tab_id'         => 'AdvancedContent', 
					'tab_name'       => 'AdvancedContent', 
					'block_tabs'     => array(),
					'block_groups'   => array(),
					'content_blocks' => array());
				$this->_tabIds[] = 'AdvancedContent';
			}
			
			$this->_userGroups = $this->GetGroups();
			$this->_isAdmin    = cmsms()->GetUserOperations()->UserInGroup(get_userid(false),1);
		}
		
		# MLE support
		global $hls, $mleblock, $mleblockfallback;
		if(isset($hls)) 
		{
			$this->mle              = true;
			$this->lang             = $hls;
			$this->blockLang        = $mleblock;
			$this->defaultBlockLang = $mleblockfallback;
		}
		#---
	}
	
	function ModuleName() 
	{
		return 'AdvancedContent';
	}
	
	function IsDefaultPossible() 
	{
		return TRUE;
	}
	
	function IsCopyable() 
	{
		return TRUE;
	}
	
	function FriendlyName() 
	{
		return $this->lang('AdvancedContent');
	}
	
	function get_content_blocks() 
	{
		$this->parse_content_blocks('get_content_blocks');
		return $this->_contentBlocks;
	}
	
	function parse_content_blocks($function = '') 
	{
		
		if($this->_contentBlocksLoaded) 
		{
			return true;
		}
		
		if($this->mType != 'content2' && $this->mType != 'content') 
		{
			return true;
		}
		
		$config =& cmsms()->GetConfig();
		$templateops =& cmsms()->GetTemplateOperations();
		
		if ($this->mTemplateId && $this->mTemplateId > -1) 
		{
			$template = $templateops->LoadTemplateByID($this->mTemplateId);
			$this->_stylesheet = '../stylesheet.php?templateid='.$this->mTemplateId;
		}
		else 
		{
			$template = $templateops->LoadDefaultTemplate();
		}
		
		$this->_contentBlocks = array();
		
		if($template !== false) 
		{
			if($config['debug']) 
			{
				debug_buffer('parsing template for content blocks ('.$function.')','AdvancedContent');
			}
			
			$content = $template->content;
			
			// read content blocks
			# this will search for {content} {content_image} {content_module} and {AdvancedContent} with or without params (case insensitive)
			$pattern = '/{(AdvancedContent|content(_image|_module)?)([^}]*)}/i';
			$pattern2 = '/([\w]+)=(["][^"]*["]|[\'][^\']*[\']|[^\'"\s]*)/';
			
			$matches = array();
			// get all the tags
			$result = preg_match_all($pattern, $content, $matches);
			
			if ($result && count($matches[3]) > 0) 
			{
				$AdvancedContent =& AdvancedContent::GetModuleInstance('AdvancedContent');
				
				// get the basic content properties
				$basicAttribs = array();
				foreach( $this->_attributes as $oneAttrib ) 
				{
					$basicAttribs[] = $oneAttrib[0];
				}
				
				$j = 0;
				// foreach tag
				foreach ($matches[3] as $key=>$wholetag) 
				{
					$j++;
					
					// get the arguments.
					$morematches = array();
					$result2 = preg_match_all($pattern2, $wholetag, $morematches);
					
					$keyval = array();
					for ($i = 0; $i < count($morematches[1]); $i++) 
					{
						if(startswith($morematches[2][$i],'\''))
							$morematches[2][$i] = trim($morematches[2][$i],'\'');
						else if(startswith($morematches[2][$i],'"'))
							$morematches[2][$i] = trim($morematches[2][$i],'"');
						
						$keyval[strtolower($morematches[1][$i])] = $morematches[2][$i];
					}
					
					// block = active?
					if(isset($keyval['active']) && $this->IsFalse($keyval['active'])) 
					{
						continue; // don't process inactive blocks
					}
					
					// additional editors
					$editorGroups = '';
					if(isset($keyval['editor_groups']) && $keyval['editor_groups'] != '') 
					{
						$editorGroups = trim($keyval['editor_groups']);
					}
					$editorUsers = '';
					if(isset($keyval['editor_users']) && $keyval['editor_users'] != '') 
					{
						$editorUsers = trim($keyval['editor_users']);
					}
					
					// blocktype
					$blockType = 'text';
					$tag = '';
					$defaultMode = false;
					if(isset($matches[1][$key]))
						$tag = strtolower($matches[1][$key]);
					if(startswith($tag, 'content_image')) 
					{
						$blockType = 'image';
						$defaultMode = true;
					}
					elseif(startswith($tag, 'content_module')) 
					{
						$blockType = 'module';
						$defaultMode = true;
					}
					elseif(isset($keyval['block_type']) && $keyval['block_type'] != '')
						$blockType = strtolower($keyval['block_type']);
					
					// blockname
					$name = 'content_en';
					# MLE support
					if($this->mle && $this->blockLang != '') 
					{
						$name = 'content'.$this->blockLang;
					}
					#---
					
					if(isset($keyval['block']) && $keyval['block'] != '')
						$name = trim($keyval['block']);
					
					// block id
					$blockId = preg_replace('/-+/','_',munge_string_to_url($name));
					if(isset($this->_contentBlocks[$blockId])) 
					{
						$this->_contentBlocks[$blockId]['multiple'] = true;
						continue;
					}
					$smarty = false;
					if(isset($keyval['smarty']) && $this->IsTrue($keyval['smarty'])) 
					{
						$smarty = true;
					}
					
					$translateLabels = false;
					if(isset($keyval['translate_labels']) && $this->IsTrue($keyval['translate_labels'])) 
					{
						$translateLabels = true;
					}
					
					$translateValues = false;
					if(isset($keyval['translate_values']) && $this->IsTrue($keyval['translate_values'])) 
					{
						$translateValues = true;
					}
					
					$area = 'default';
					if(isset($keyval['area']) && $keyval['area'] != '')
						$area = strtolower($keyval['area']);
					
					$label = ucwords($name);
					if(isset($keyval['label']) && $keyval['label'] != '')
						$label = trim($keyval['label']);
					
					// default content/value
					$defaultValue 	= '';
					if(isset($keyval['default']) && $keyval['default'] != '')
						$defaultValue = $keyval['default'];
					
					// backend style (e.g. to mark required fields...)
					$style = '';
					if(isset($keyval['style'])) 
					{
						$style = $keyval['style'];
					}
					
					// size of the input field
					$size = '';
					if(isset($keyval['size'])) 
					{
						$size = intval($keyval['size']);
					}
					
					$pageTab = 'main';
					$this->_pageTabs[$pageTab]['content_blocks'][$blockId] = $blockId;
					if(isset($keyval['page_tab']) && trim($keyval['page_tab'] != '')) 
					{
						unset($this->_pageTabs[$pageTab]['content_blocks'][$blockId]);
						$pageTab = preg_replace('/-+/','_',munge_string_to_url(strtolower(trim($keyval['page_tab']))));
						if(!isset($this->_pageTabs[$pageTab])) 
						{
							$this->_pageTabs[$pageTab]['tab_id']       = $pageTab;
							$this->_pageTabs[$pageTab]['tab_name']     = $keyval['page_tab'];
							$this->_pageTabs[$pageTab]['block_tabs']   = array();
							$this->_pageTabs[$pageTab]['block_groups'] = array();
						}
						$this->_pageTabs[$pageTab]['content_blocks'][$blockId] = $blockId;
					}
					
					$blockTab = '';
					if(isset($keyval['block_tab']) && trim($keyval['block_tab'] != '')) 
					{
						$blockTab = $pageTab . '_' . preg_replace('/-+/','_',munge_string_to_url(strtolower(trim($keyval['block_tab']))));
						if(!isset($this->_blockTabs[$blockTab])) 
						{
							$this->_blockTabs[$blockTab]['tab_id']       = $blockTab;
							$this->_blockTabs[$blockTab]['tab_name']     = $keyval['block_tab'];
							$this->_blockTabs[$blockTab]['block_groups'] = array();
						}
						$this->_blockTabs[$blockTab]['content_blocks'][$blockId] = $blockId;
						$this->_pageTabs[$pageTab]['block_tabs'][$blockTab]      = $blockTab;
						#unset($this->_pageTabs[$pageTab]['content_blocks'][$blockId]);
					}
					
					$blockGroup = '';
					if(isset($keyval['block_group']) && trim($keyval['block_group'] != '')) 
					{
						$blockGroup = ($blockTab?$blockTab:$pageTab) . '_' . preg_replace('/-+/','_',munge_string_to_url(strtolower(trim($keyval['block_group']))));
						if(!isset($this->_blockGroups[$blockGroup])) 
						{
							$this->_blockGroups[$blockGroup]['group_id']   = $blockGroup;
							$this->_blockGroups[$blockGroup]['group_name'] = $keyval['block_group'];
							$this->_pageTabs[$pageTab]['block_groups'][$blockGroup] = $blockGroup;
						}
						$this->_blockGroups[$blockGroup]['content_blocks'][$blockId] = $blockId;
						unset($this->_blockTabs[$blockTab]['content_blocks'][$blockId]);
						if($blockTab) 
						{
							$this->_blockTabs[$blockTab]['block_groups'][$blockGroup] = $blockGroup;
							#unset($this->_pageTabs[$pageTab]['block_groups'][$blockGroup]);
						}
						else 
						{
							unset($this->_blockTabs[$blockTab]['block_groups'][$blockGroup]);
							#unset($this->_pageTabs[$pageTab]['content_blocks'][$blockId]);
						}
					}
					
					$allowNone = true;
					if(isset($keyval['allow_none']) && $this->IsFalse($keyval['allow_none']))
						$allowNone = false;
					
					// if this block has been added to the template after page has been created
					$newBlock = false;
					if(!in_array($blockId,$this->mProperties->mPropertyNames)) 
					{
						$newBlock = true;
					}
					
					$description = '';
					if(isset($keyval['description']))
						$description = trim($keyval['description']);
					
					$collapse = !$AdvancedContent->GetPreference('collapse_block_default',1);
					if(isset($keyval['collapse']) && $this->IsTrue($keyval['collapse']))
						$collapse = trim($keyval['collapse']);
					
					// this will create an invalid block type to print out a 
					// message when using a basic content property as block name
					if(in_array($blockId, $basicAttribs) 
					|| $blockId == $blockId . '_feu_action' 
					|| $blockId == $blockId . '_feu_action[]' 
					|| $blockId == $blockId . '_feu_access' 
					|| $blockId == $blockId . '_feu_access[]' 
					|| $blockId == 'AdvancedContentStartDate' 
					|| $blockId == 'AdvancedContentEndDate' 
					|| $blockId == 'AdvancedContentStartTime' 
					|| $blockId == 'AdvancedContentEndTime' 
					|| $blockId == 'start_date' 
					|| $blockId == 'end_date' 
					|| $blockId == $blockId . '_AdvancedContentTime' 
					|| $blockId == $blockId . '_AdvancedContentDate') 
					{
						$blockId = md5($blockId . $j);
						
						$this->_contentBlocks[$blockId]['name']             = $name;
						$this->_contentBlocks[$blockId]['id']               = $blockId;
						$this->_contentBlocks[$blockId]['block_type']       = '';
						$this->_contentBlocks[$blockId]['default_value']    = $this->lang('error_basicattrib', $name);
						$this->_contentBlocks[$blockId]['block_tab']        = $blockTab;
						$this->_contentBlocks[$blockId]['page_tab']         = $pageTab;
						$this->_contentBlocks[$blockId]['block_group']      = $blockGroup;
						$this->_contentBlocks[$blockId]['style']            = '';
						$this->_contentBlocks[$blockId]['label']            = $label;
						$this->_contentBlocks[$blockId]['allow_none']       = false;
						$this->_contentBlocks[$blockId]['smarty']           = false;
						$this->_contentBlocks[$blockId]['new_block']        = false;
						$this->_contentBlocks[$blockId]['description']      = '';
						$this->_contentBlocks[$blockId]['translate_labels'] = $translateLabels;
						$this->_contentBlocks[$blockId]['translate_values'] = $translateValues;
						$this->_contentBlocks[$blockId]['editor_users']     = $editorUsers;
						$this->_contentBlocks[$blockId]['editor_groups']    = $editorGroups;
						$this->_contentBlocks[$blockId]['sequence']         = count($this->_contentBlocks);
						$this->_contentBlocks[$blockId]['default_mode']     = false;
						$this->_contentBlocks[$blockId]['collapse']         = false;
						continue;
					}
					
					if($blockType == 'text') 
					{
						
						$maxlength = '';
						if(isset($keyval['maxlength'])) 
						{
							$maxlength = $keyval['maxlength'];
						}
						
						$usewysiwyg = true;
						if(isset($keyval['wysiwyg']) && $this->IsFalse($keyval['wysiwyg'])) 
						{
							$usewysiwyg = false;
						}
						
						$oneline = false;
						if(isset($keyval['oneline']) && $this->IsTrue($keyval['oneline'])) 
						{
							$oneline = true;
						}
						
						$this->_contentBlocks[$blockId]['maxlength']  = $maxlength;
						$this->_contentBlocks[$blockId]['usewysiwyg'] = $usewysiwyg;
						$this->_contentBlocks[$blockId]['oneline']    = $oneline;
						$this->_contentBlocks[$blockId]['size']       = $size;
					}
					else if ($blockType == 'date') 
					{
						$this->_dateBlocks[] = $blockId;
						
						$showClock = true;
						if(isset($keyval['show_clock']) && $this->IsTFalse($keyval['show_clock']))
							$showClock = false;
						
						$mode = 'calendar';
						if(isset($keyval['mode']) && strtolower($keyval['mode']) == 'dropdown')
							$mode = 'dropdown';
						
						$show24h = true;
						if(isset($keyval['show24h']) && $this->IsFalse($keyval['show24h']))
							$show24h = false;
						
						$startHour = 0;
						$endHour   = 23;
						if(isset($keyval['start_hour'])) 
						{
							if(endswith($keyval['start_hour'],'pm')) 
							{
								$keyval['start_hour'] = trim(str_ireplace('pm','',$keyval['start_hour'])) + 12;
							}
							else
								$keyval['start_hour'] = trim(str_ireplace(array('am','pm'),'',$keyval['start_hour']));
								
							if($keyval['start_hour'] > 0 && $keyval['start_hour'] <= $endHour)
								$startHour = trim($keyval['start_hour']);
						}
						if(isset($keyval['end_hour'])) 
						{
							if(endswith($keyval['end_hour'],'pm')) {
								$keyval['end_hour'] = trim(str_ireplace('pm','',$keyval['end_hour'])) + 12;
							}
							else
								$keyval['end_hour'] = trim(str_ireplace(array('am','pm'),'',$keyval['end_hour']));
								
							if($keyval['end_hour'] >= 0 && $keyval['end_hour'] < $endHour)
								$endHour = trim($keyval['end_hour']);
						}
						
						if($endHour < $startHour)
							$endHour = $startHour;
						
						$startMinute = 0;
						if(isset($keyval['start_minute']) && $keyval['start_minute'] > 0 && $keyval['start_minute'] <= 59)
							$startMinute = trim($keyval['start_minute']);
						
						$endMinute = 59;
						if(isset($keyval['end_minute']) && $keyval['end_minute'] >= 0 && $keyval['end_minute'] < 59)
							$endMinute = trim($keyval['end_minute']);
						
						if($endMinute < $startMinute)
							$endMinute = $startMinute;
						
						$startSecond = 0;
						if(isset($keyval['start_second']) && $keyval['start_second'] > 0 && $keyval['start_second'] <= 59)
							$startSecond = trim($keyval['start_second']);
						
						$endSecond = 59;
						if(isset($keyval['end_second']) && $keyval['end_second'] >= 0 && $keyval['end_second'] < 59)
							$endSecond = trim($keyval['end_second']);
						
						if($endSecond < $startSecond)
							$endSecond = $startSecond;
						
						$stepHours = 1;
						if(isset($keyval['step_hours']) && $keyval['step_hours'] > 0 && $keyval['step_hours'] <= ($endHour-$startHour))
							$stepHours = trim($keyval['step_hours']);
						else if(isset($keyval['step_hours']) && $keyval['step_hours'] > 0 && $keyval['step_hours'] >= ($endHour-$startHour))
							$stepHours = $endHour-$startHour;
						
						$stepMinutes = 10;
						if(isset($keyval['step_minutes']) && $keyval['step_minutes'] > 0 && $keyval['step_minutes'] <= ($endMinute-$startMinute))
							$stepMinutes = trim($keyval['step_minutes']);
						else if(isset($keyval['step_minutes']) && $keyval['step_minutes'] > 0 && $keyval['step_minutes'] >= ($endMinute-$startMinute))
							$stepMinutes = $endMinute-$startMinute;
						
						$stepSeconds = 1;
						if(isset($keyval['step_seconds']) && $keyval['step_seconds'] > 0 && $keyval['step_seconds'] <= ($endSecond-$startSeconds))
							$stepSeconds = trim($keyval['step_seconds']);
						else if(isset($keyval['step_seconds']) && $keyval['step_seconds'] > 0 && $keyval['step_seconds'] >= ($endSecond-$startSeconds))
							$stepSeconds = $endSecond-$startSeconds;
						
						$this->_contentBlocks[$blockId]['show24h']      = $show24h;
						$this->_contentBlocks[$blockId]['mode']         = $mode;
						$this->_contentBlocks[$blockId]['start_hour']   = $startHour;
						$this->_contentBlocks[$blockId]['end_hour']     = $endHour;
						$this->_contentBlocks[$blockId]['start_minute'] = $startMinute;
						$this->_contentBlocks[$blockId]['end_minute']   = $endMinute;
						$this->_contentBlocks[$blockId]['start_second'] = $startSecond;
						$this->_contentBlocks[$blockId]['end_second']   = $endSecond;
						$this->_contentBlocks[$blockId]['step_hours']   = $stepHours;
						$this->_contentBlocks[$blockId]['step_minutes'] = $stepMinutes;
						$this->_contentBlocks[$blockId]['step_seconds'] = $stepSeconds;
						$this->_contentBlocks[$blockId]['show_clock']   = $showClock;
					}
					else if($blockType == 'dropdown' || $blockType == 'select_multiple') 
					{
						if($blockType == 'select_multiple') 
						{
							$sortable = false;
							if(isset($keyval['sortable_items']) && $this->IsTrue($keyval['sortable_items'])) 
							{
								$sortable = true;
							}
							$this->_contentBlocks[$blockId]['sortable_items'] = $sortable;
						}
						
						$delimiter = '|';
						if(isset($keyval['delimiter']) && $keyval['delimiter'] != '') 
						{
							$delimiter = $keyval['delimiter'];
						}
						$items = '';
						if(isset($keyval['items']) && $keyval['items'] != '') 
						{
							$items = trim($keyval['items']);
						}
						$values = '';
						if(isset($keyval['values']) && $keyval['values'] != '') 
						{
							$values = trim($keyval['values']);
						}
						
						$this->_contentBlocks[$blockId]['items']     = $items;
						$this->_contentBlocks[$blockId]['values']    = $values;
						$this->_contentBlocks[$blockId]['delimiter'] = $delimiter;
						
					}
					else if($blockType == 'module') 
					{
						$module = '';
						if(isset($keyval['module']))
							$module = trim($keyval['module']);
						
						$this->_contentBlocks[$blockId]['module'] = $module;
						$this->_contentBlocks[$blockId]['params'] = $keyval;
					}
					
					$this->_contentBlocks[$blockId]['multiple']         = false;
					$this->_contentBlocks[$blockId]['smarty']           = $smarty;
					$this->_contentBlocks[$blockId]['style']            = $style;
					$this->_contentBlocks[$blockId]['name']             = $name;
					$this->_contentBlocks[$blockId]['id']               = $blockId;
					$this->_contentBlocks[$blockId]['block_type']       = $blockType;
					$this->_contentBlocks[$blockId]['default_value']    = $defaultValue;
					$this->_contentBlocks[$blockId]['label']            = $label;
					$this->_contentBlocks[$blockId]['block_tab']        = $blockTab;
					$this->_contentBlocks[$blockId]['page_tab']         = $pageTab;
					$this->_contentBlocks[$blockId]['new_block']        = $newBlock;
					$this->_contentBlocks[$blockId]['editor_users']     = $editorUsers;
					$this->_contentBlocks[$blockId]['editor_groups']    = $editorGroups;
					$this->_contentBlocks[$blockId]['allow_none']       = $allowNone;
					$this->_contentBlocks[$blockId]['translate_labels'] = $translateLabels;
					$this->_contentBlocks[$blockId]['translate_values'] = $translateValues;
					$this->_contentBlocks[$blockId]['description']      = $description;
					$this->_contentBlocks[$blockId]['sequence']         = count($this->_contentBlocks);
					$this->_contentBlocks[$blockId]['default_mode']     = $defaultMode;
					$this->_contentBlocks[$blockId]['collapse']         = $collapse;
					$this->_contentBlocks[$blockId]['block_group']      = $blockGroup;
					$this->AddExtraProperty($blockId);
					
				}
				
			}
			
			// force a load
			$this->mProperties->Load($this->mId);
			$this->_contentBlocksLoaded = true;
		}
		return $this->_contentBlocksLoaded;
	}
	
	function display_content_block($blockName,$blockInfo,$value,$adding = false) 
	{
		# ToDo...
	}
	
	function SetProperties() 
	{
		parent::SetProperties();
		
		$this->AddBaseProperty('template', 4, 0, 'int');
		$this->AddBaseProperty('pagemetadata', 20);
		
		$this->AddContentProperty('searchable', 8, 0, 'int');
		$this->AddContentProperty('pagedata', 25);
		$this->AddContentProperty('disable_wysiwyg', 60, 0, 'int');
		
		$this->AddContentProperty('feu_access', 99);
		$this->AddContentProperty('redirect_page', 100, 0, 'int');
		$this->AddContentProperty('redirect_params', 101, 0);
		$this->AddContentProperty('evaluate_smarty', 102, 0, 'int');
		$this->AddContentProperty('feu_action', 103, 0, 'int');
		
		$this->AddContentProperty('use_expire_date', 104, 0, 'int');
		$this->AddContentProperty('start_date', 105, 0, 'int');
		$this->AddContentProperty('end_date', 106, 0, 'int');
		
		$this->mPreview = true;
	}
	
	function ReadyForEdit() 
	{
		$this->parse_content_blocks('ReadyForEdit');
	}
	
	function Show($param = 'content_en') 
	{
		$this->parse_content_blocks('Show');
		
		# MLE support
		if($this->mle && $this->blockLang != '') 
		{
			if($param == 'content_en') 
			{
				$param = 'content'.$this->blockLang;
			}
			else if(!endswith($param,$this->blockLang)) 
			{
				$param .= $this->blockLang;
			}
			
			$result = $this->GetPropertyValue($param);
			
			if($result == '' && $this->defaultBlockLang != '' && $this->defaultBlockLang != $this->blockLang) 
			{
				$param = str_replace($this->blockLang, $this->defaultBlockLang, $param);
				$result = $this->GetPropertyValue($param);
			}
			
			return $result;
		}
		#---
		
		return $this->GetPropertyValue($param);
	}
	
	function TabNames() 
	{
		$config =& cmsms()->GetConfig();
		$tabs = array(lang('main'));
		if( check_permission(get_userid(), 'Manage All Content') ) 
		{
			$tabs[] = lang('options');
		}
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		if( check_permission(get_userid(), 'Manage AdvancedContent Options') && $AdvancedContent->GetPreference('show_advancedcontent_options',1)) 
		{
			$tabs[] = 'AdvancedContent';
		}
		
		$this->parse_content_blocks('TabNames');
		
		foreach($this->_pageTabs as $tab) 
		{
			if(!in_array($tab['tab_name'], $tabs)) 
			{
				$tabs[] = $tab['tab_name'];
			}
			if(!in_array($tab['tab_id'], $this->_tabIds)) 
			{
				$this->_tabIds[] = $tab['tab_id'];
			}
		}
		if($config['debug']) 
		{
			debug_buffer($this->_pageTabs,'AdvancedContent _pageTabs');
			debug_buffer($this->_blockTabs,'AdvancedContent _blockTabs');
			debug_buffer($this->_blockGroups,'AdvancedContent _blockGroups');
			debug_buffer($this->_contentBlocks,'AdvancedContent _contentBlocks');
			debug_buffer($this->_tabIds,'AdvancedContent _tabIds');
		}
		return $tabs;
	}
	
	function FillParams($params) 
	{
		if(isset($params['content_type'])) 
		{
			$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
			
			$parameters = array('pagedata', 'searchable', 'disable_wysiwyg', 'feu_access', 'redirect_page', 'redirect_params', 'evaluate_smarty', 'feu_action', 'start_date', 'end_date', 'use_expire_date');
			
			$this->_contentBlocksLoaded = false;
			//pick up the template id before we do parameters
			if (isset($params['template_id'])) 
			{
				#if($this->mTemplateId != $params['template_id']) {
				#	$this->_contentBlocksLoaded = false;
				#}
				$this->mTemplateId = $params['template_id'];
			}
			//pick up the content type before we do parameters
			if (isset($params['content_type'])) {
				#if($this->mType != $params['content_type']) {
				#	$this->_contentBlocksLoaded = false;
				#}
				$this->mType = $params['content_type'];
			}
			
			if($this->mType == 'content2' || $this->mType == 'content') 
			{
				// add content blocks
				$this->parse_content_blocks('FillParams');
				
				# added by NaN:
				$parentId = -1;
				if(isset($params['parent_id']))
					$parentId = $params['parent_id'];
				
				if(check_permission(get_userid(), 'Manage AdvancedContent Options') && isset($params['feu_access'])) 
				{
					
					if(!is_array($params['feu_access']))
						$feuAccess = array();
					else
						$feuAccess = $params['feu_access'];
					
					// if page has no parents but wants to inherit -> remove inheritance
					if($parentId <= 0 && in_array('-1', $feuAccess)) 
					{
						foreach($feuAccess as $k=>$v) 
						{
							if($v == '-1') 
								unset($feuAccess[$k]);
						}
					}
					
					// if there is still inheritance -> check if there actually is any feu group selected by parents
					$_feuAccess = array();
					if(in_array('-1', $feuAccess)) 
					{
						// $_feuAccess contains all feu groups (of current page as well as of all parent pages)
						$_feuAccess = $this->InheritParentProp($parentId, 'feu_access', $feuAccess);
					}
					
					// if we have selected any feu group -> disable caching and search
					if(count($_feuAccess) || (count($feuAccess) && !in_array('-1', $feuAccess))) 
					{
						$params['cachable']   = false;
						$this->mCachable      = false;
						$params['searchable'] = false;
					}
					
					$params['feu_access'] = implode(';', $feuAccess);
					
					$redirectPage = '';
					if(isset($params['redirect_page'])) 
					{
						$redirectPage = $params['redirect_page'];
					}
					// if page has no parents but wants to inherit -> remove inheritance
					if($parentId <= 0 && $redirectPage == -1) 
					{
						$redirectPage = '';
					}
					
					$feuAction = ''; 
					if(isset($params['feu_action']))
						$feuAction = $params['feu_action'];
					// if page has no parents but wants to inherit -> remove inheritance
					if($parentId <= 0 && $feuAction == -1) {
						$feuAction = '';
					}
					$params['redirect_page'] = $redirectPage;
					$params['feu_action']    = $feuAction;
				}
				
				// do the content property parameters
				foreach ($parameters as $oneparam) 
				{
					if(check_permission(get_userid(), 'Manage AdvancedContent Options') && $oneparam == 'start_date' || $oneparam == 'end_date') 
					{
						$_string           = ucfirst(str_replace('_date','',$oneparam));
						$params[$oneparam] = 0;
						if(isset($params['AdvancedContent'.$_string.'Time']) && isset($params['AdvancedContent'.$_string.'Date']))
							$params[$oneparam] = $params['AdvancedContent'.$_string.'Time'] + $params['AdvancedContent'.$_string.'Date'];
					}
					if (isset($params[$oneparam])) 
					{
						$this->SetPropertyValue($oneparam, $params[$oneparam]);
					}
				}
				
				if(check_permission(get_userid(), 'Manage AdvancedContent Options') && isset($params['start_date']) && isset($params['use_expire_date']) && $params['use_expire_date'] == 1 && $params['start_date'] > time()) 
				{
					$params['active'] = false;
					$this->mActive    = false;
				}
				
				// metadata
				if (isset($params['metadata'])) 
				{
					$this->mMetadata = $params['metadata'];
				}
				
				// content blocks
				$i = 0;
				foreach($params as $paramName => $paramValue) 
				{
					
					$paramName = str_replace('_AdvancedContentDate', '', $paramName);
					if(isset($this->_contentBlocks[$paramName])) 
					{
						$i++;
						$value = '';
						if($this->_contentBlocks[$paramName]['block_type'] == 'select_multiple') 
						{
							if(is_array($paramValue))
								$value = implode($this->_contentBlocks[$paramName]['delimiter'], $paramValue);
							else if ($this->_contentBlocks[$paramName]['sortable_items']) 
							{
								$items = array();
								foreach($params as $itemName => $itemValue) 
								{
									if(startswith($itemName,$paramName.'_AdvancedContentSortableItem_')) 
									{
										$items[] = $itemValue;
									}
								}
								$value = implode($this->_contentBlocks[$paramName]['delimiter'], $items);
							}
						}
						else if($this->_contentBlocks[$paramName]['block_type'] == 'date' 
						&& $this->_contentBlocks[$paramName]['mode'] == 'calendar' 
						&& isset($params[$paramName . '_AdvancedContentDate'])) 
						{
							$time = 0;
							if(isset($params[$paramName . '_AdvancedContentTime']))
								$time = $params[$paramName . '_AdvancedContentTime'];
							#$_tmp         = explode(':', $params[$paramName . '_AdvancedContentTime']);
							#$time_seconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
							#$value       = $time_seconds + $params[$paramName . '_AdvancedContentDate'];
							$value        = $time + $params[$paramName . '_AdvancedContentDate'];
						}
						else 
						{
							$value = trim($paramValue);
						}
						if($value == '' && !$this->_contentBlocks[$paramName]['allow_none']) 
						{
							$value = $this->_contentBlocks[$paramName]['default_value'];
							if($this->_contentBlocks[$paramName]['smarty'])
								$value = $this->DoSmarty($value);
						}
						
						# MLE support
						if($this->mle && $this->blockLang != '' && $paramName != 'content' . $this->blockLang)
							$paramName .= $this->blockLang;
						#---
						
						$this->AddExtraProperty($paramName);
						$this->SetPropertyValue($paramName, $value);
					}
				}
				#if(isset($params['submitbutton']) || isset($params['applybutton']))
				#	$this->SortContentBlocks();
				
				// this is only while bug #4952 of CMSms isn't fixed
				// ToDo: get cms version -> only do this if cms version is < CMSms 1.8
				// if we have a new menutext -> use new one
				if(isset($params['menutext']))
					$this->mMenuText = trim($params['menutext']);
				// else use old one
				else
					$params['menutext'] = $this->mMenuText;
					
				// if we have a new title -> use new one
				if(isset($params['title']))
					$this->mName = trim($params['title']);
				// else use old one
				else
					$params['title'] = $this->mName;
				
				// if we have no title given but menutext -> use menutext as title
				if($this->mName == '' && $this->mMenuText !='') 
				{
					$this->mName     = $this->mMenuText;
					$params['title'] = $this->mName;
				}
				// if we have no menutext given but title -> use title as menutext
				if($this->mMenuText == '' && $this->mName != '') 
				{
					$this->mMenuText    = $this->mName;
					$params['menutext'] = $this->mMenuText;
				}
				
				// if we have a new alias -> use new one
				if(isset($params['alias']))
					$this->mAlias = munge_string_to_url(trim($params['alias']),true);
				// else use old one
				else
					$params['alias'] = $this->mAlias;
				
				// if alias is empty -> use menutext as alias
				if($this->mAlias == '') 
				{
					$this->mAlias    = munge_string_to_url($this->mMenuText, true);
					$params['alias'] = $this->mAlias;
				}
			}
		}
		parent::FillParams($params);
	}
	
	function EditAsArray($adding = false, $tab = 0, $showadmin = false) 
	{
		$this->parse_content_blocks('EditAsArray');
		$ret = array();
		$tmp = array();
		if(isset($this->_tabIds[$tab])) 
		{
			$tab_id = $this->_tabIds[$tab];
		}
		else 
		{
			return array();
		}
		if($tab_id == 'main' || ($tab_id == 'options' && check_permission(get_userid(), 'Manage All Content'))) 
		{
			$tmp = $this->CleanArray($this->display_attributes($adding, $tab));
		}
		else if($tab_id == 'AdvancedContent' && check_permission(get_userid(), 'Manage AdvancedContent Options')) 
		{
			$tmp = $this->DisplayAdvancedOptions($adding);
		}
		
		foreach( $tmp as $one ) 
		{
			$ret[] = $one;
		}
		
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		$j = 0;
		foreach($this->_pageTabs[$tab_id]['block_groups'] as $blockGroup) 
		{
			$this->_blockGroups[$blockGroup]['display'] = $AdvancedContent->GetItemDisplay('group', $blockGroup, $this->mId, $this->mTemplateId, !$AdvancedContent->GetPreference('collapse_group_default',1));
				$this->_blockGroups[$blockGroup]['pref_url'] = str_replace('&amp;','&',
					$AdvancedContent->CreateLink('m1_', 'savePrefs', '', $this->lang('toggle_group'), 
						array('item_type'=>'group',
							'disable_theme'=>true, 
							'ajax'=>true, 
							'content_id'=>$this->mId,
							'template_id'=>$this->mTemplateId,
							'item_id'=>$blockGroup), 
						'', true));
		}
		foreach($this->_pageTabs[$tab_id]['content_blocks'] as $blockId) 
		{
			$j++;
			
			if(!$this->CheckBlockPermission($blockId))
				continue;
			
			if($this->_contentBlocks[$blockId]['block_type'] != '' && $this->_contentBlocks[$blockId]['smarty']) 
			{
				foreach($this->_contentBlocks[$blockId] as $propName=>$propValue) 
				{
					$this->_contentBlocks[$blockId] = $this->DoSmarty($propValue);
				}
			}
			# MLE support
			if($this->mle && $this->blockLang != '' && $blockId != 'content' . $this->blockLang)
			{
				$data = $this->GetPropertyValue($blockId . $this->blockLang);
			}
			else #---
			{
				$data = $this->GetPropertyValue($blockId);
			}
			# MLE support
			if($this->mle && $data == '' && $this->defaultBlockLang != '' && $this->defaultBlockLang != $this->blockLang) 
			{
				if($blockId != 'content' . $this->blockLang)
				{
					$data = $this->GetPropertyValue($blockId . $this->defaultBlockLang);
				}
				else
				{
					$data = $this->GetPropertyValue('content' . $this->defaultBlockLang);
				}
			}
			#---
			
			if(($adding && $data == '') 
			|| ($data == '' && !$this->_contentBlocks[$blockId]['allow_none']) || $this->_contentBlocks[$blockId]['new_block']) 
			{
				$data = $this->_contentBlocks[$blockId]['default_value'];
			}
			
			$this->_contentBlocks[$blockId]['content'] = cms_htmlentities($data, ENT_NOQUOTES, get_encoding(''));
			$this->_contentBlocks[$blockId]['input']   = $AdvancedContent->lang('invalid_blocktype',$this->_contentBlocks[$blockId]['block_type'],$this->_contentBlocks[$blockId]['name']);
			
			if($this->_contentBlocks[$blockId]['label'] == ucwords($this->_contentBlocks[$blockId]['name']) 
			&& ($blockId == md5('content_en'.$j) 
			|| $blockId == 'content_en' 
			|| ($this->mle && $this->blockLang != '' 
			&& ($blockId == 'content' . $this->blockLang 
			|| $blockId == md5('content' . $this->blockLang.$j)))))
			{
				$this->_contentBlocks[$blockId]['label'] = lang('content');
			}
			
			if($this->_contentBlocks[$blockId]['translate_labels'])
			{
				$this->_contentBlocks[$blockId]['label'] = $AdvancedContent->lang($blockId);
			}
			
			$blockDisplay = $AdvancedContent->GetItemDisplay('block', $blockId, $this->mId, $this->mTemplateId, !$this->_contentBlocks[$blockId]['collapse']);
			$this->_contentBlocks[$blockId]['display'] = $blockDisplay;
			$this->_contentBlocks[$blockId]['pref_url'] = str_replace('&amp;','&',
				$AdvancedContent->CreateLink('m1_', 'savePrefs', '', $this->lang('toggle_block'), 
					array('item_type'=>'block',
						'disable_theme'=>true, 
						'ajax'=>true, 
						'content_id'=>$this->mId,
						'template_id'=>$this->mTemplateId,
						'item_id'=>$blockId), 
					'', true));
			
			if($this->_contentBlocks[$blockId]['multiple'] && $AdvancedContent->GetItemDisplay('message', $blockId, $this->mId, $this->mTemplateId)) 
			{
				$hideLink = str_replace('&amp;','&',
					$AdvancedContent->CreateLink('m1_', 'savePrefs', '', $this->lang('toggle_message'), 
						array('item_type'=>'message',
							'disable_theme'=>true, 
							'ajax'=>true, 
							'content_id'=>$this->mId,
							'template_id'=>$this->mTemplateId,
							'item_id'=>$blockId,
							'item_display'=>0), 
						'', false,'','onclick="jQuery.get(this.href); jQuery(this).parent().toggle(\'fast\'); return false;"'));
					$this->_contentBlocks[$blockId]['description'] = '<p>'.$AdvancedContent->lang('notice_duplicatecontent', $this->_contentBlocks[$blockId]['name']).' ('. $hideLink .')</p>'.$this->_contentBlocks[$blockId]['description'];
			}
			switch($this->_contentBlocks[$blockId]['block_type']) 
			{
				case 'module':
					
					if($this->_contentBlocks[$blockId]['module'] == '') 
					{
						$this->_contentBlocks[$blockId]['content'] = '';
						$this->_contentBlocks[$blockId]['input']   = $AdvancedContent->lang('error_insufficient_blockparams','module',$this->_contentBlocks[$blockId]['name']);
						break;
					}
					if( !$module =& $AdvancedContent->GetModuleInstance($this->_contentBlocks[$blockId]['module'])) 
					{
						$this->_contentBlocks[$blockId]['content'] = '';
						$this->_contentBlocks[$blockId]['input']   = $AdvancedContent->lang('error_loading_module',$this->_contentBlocks[$blockId]['module'],$this->_contentBlocks[$blockId]['name']);
						break;
					}
					if( !$module->HasCapability('contentblocks') ) 
					{ 
						$this->_contentBlocks[$blockId]['content'] = '';
						$this->_contentBlocks[$blockId]['input']   = $AdvancedContent->lang('error_contentblock_support',$this->_contentBlocks[$blockId]['module'],$this->_contentBlocks[$blockId]['name']);
						break;
					}
					$this->_contentBlocks[$blockId]['input'] = $module->GetContentBlockInput($blockId,$data,$this->_contentBlocks[$blockId]['params'],$adding);
					
					break;
					
				case 'date':
					
					if(!$data)
						$data = time();
					
					$date = strftime('%x', intval($data));
					$time = '0:0';
					if($this->_contentBlocks[$blockId]['show_clock'])
						$time = strftime('%H:%M', intval($data));
					
					$_tmp        = $this->CleanArray(explode(':',$time));
					$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
					$dateSeconds = $data - $timeSeconds;
					
					$dateInput = '<img id="'.$blockId.'_AdvancedContentDatePickerTrigger" src="../modules/AdvancedContent/images/calendar.png" class="calendarTrigger" />&nbsp;
						<span id="'.$blockId.'_AdvancedContentDatePickerDisplay">'.$date.'</span>
						<input id="'.$blockId.'_AdvancedContentDate" type="hidden" name="'.$blockId.'_AdvancedContentDate" value="'.$dateSeconds.'" />';
						
					$suffix    = '';
					$timeInput = '';
					if($this->_contentBlocks[$blockId]['show_clock']) 
					{
						$timeInput = '&nbsp;&nbsp;-&nbsp;&nbsp;<select name="'.$blockId.'_AdvancedContentTime">';
						$_i        = 0;
						for($i=$this->_contentBlocks[$blockId]['start_hour']; $i<=$this->_contentBlocks[$blockId]['end_hour']; $i += $this->_contentBlocks[$blockId]['step_hours']) 
						{
							if($i<12 && !$this->_contentBlocks[$blockId]['show24h'])
							{
								$suffix = ' am';
							}
							else if(!$this->_contentBlocks[$blockId]['show24h'])
							{
								$suffix = ' pm';
							}
							for($j=$this->_contentBlocks[$blockId]['start_minute']; $j<=$this->_contentBlocks[$blockId]['end_minute']; $j += $this->_contentBlocks[$blockId]['step_minutes']) 
							{
								$value = ($i*3600) + ($j*60);
								if(($this->_contentBlocks[$blockId]['end_hour'] < 23 && $value <= ($this->_contentBlocks[$blockId]['end_hour'] * 3600)) || $this->_contentBlocks[$blockId]['end_hour'] == 23)
								{
									$timeInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:(!$this->_contentBlocks[$blockId]['show24h'] && $i>12?$i-12:$i)) .':'. ($j<10?'0'.$j:$j) . $suffix . '</option>';
								}
							}
							$j = $this->_contentBlocks[$blockId]['start_minute'];
						}
						$timeInput .= '</select>';
					}
					
					$this->_contentBlocks[$blockId]['input']      = $dateInput.$timeInput;
					$this->_contentBlocks[$blockId]['date']       = $date;
					$this->_contentBlocks[$blockId]['date_value'] = $dateSeconds;
					$this->_contentBlocks[$blockId]['date_input'] = $dateInput;
					$this->_contentBlocks[$blockId]['time']       = $time;
					$this->_contentBlocks[$blockId]['time_value'] = $timeSeconds;
					$this->_contentBlocks[$blockId]['time_input'] = $timeInput;
					
					break;
				
				case 'checkbox':
					$this->_contentBlocks[$blockId]['input'] = '
						<input type="hidden" name="' . $blockId . '" value="0" />
						<input class="pagecheckbox"' . ($this->_contentBlocks[$blockId]['style'] != ''?' style="' . $this->_contentBlocks[$blockId]['style'] . ' "':'') . ' type="checkbox" value="1" name="' . $blockId . '"' . ($data == 1 ? ' checked="checked"':'') . ' />';
					break;
				
				case 'dropdown':
					
					$items = array();
					if($this->_contentBlocks[$blockId]['items'] != '') 
					{
						foreach(explode($this->_contentBlocks[$blockId]['delimiter'], $this->_contentBlocks[$blockId]['items']) as $key => $val) 
						{
							$items[$key]['label'] = trim($val);
							if($this->_contentBlocks[$blockId]['translate_labels'])
								$items[$key]['label'] = $AdvancedContent->lang($items[$key]['label']);
							
							$items[$key]['value']    = $items[$key]['label'];
							$items[$key]['selected'] = ($data === $val);
						}
					}
					if($this->_contentBlocks[$blockId]['values'] != '') 
					{
						foreach(explode($this->_contentBlocks[$blockId]['delimiter'], $this->_contentBlocks[$blockId]['values']) as $key => $val) {
							$items[$key]['value'] = trim($val);
							if($this->_contentBlocks[$blockId]['translate_values'])
								$items[$key]['value'] = $AdvancedContent->lang($items[$key]['value']);
							
							$items[$key]['selected'] = ($data === $items[$key]['value']);
							
							if(!isset($items[$key]['label']))
								$items[$key]['label'] = $items[$key]['value'];
						}
					}
					
					$this->_contentBlocks[$blockId]['input'] = '<select name="' . $blockId . '" ' . ($this->_contentBlocks[$blockId]['style'] != ''?'style="' . $this->_contentBlocks[$blockId]['style'] . ' "':'') . ' >';
					foreach($items as $item) {
						
						$this->_contentBlocks[$blockId]['input'] .= '<option value="' . $item['value'] . '"';
						if($item['selected'])
							$this->_contentBlocks[$blockId]['input'] .= ' selected="selected"';
						$this->_contentBlocks[$blockId]['input'] .= '>' . $item['label'] . '</option>';
					}
					$this->_contentBlocks[$blockId]['input'] .= '</select>';
					
					break;
				
				case 'select_multiple':
					
					$selItems = array();
					foreach(explode($this->_contentBlocks[$blockId]['delimiter'], $data) as $key => $val) {
						$selItems[$key] = trim($val);
					}
					$items = array();
					if($this->_contentBlocks[$blockId]['items'] != '') {
						foreach(explode($this->_contentBlocks[$blockId]['delimiter'], $this->_contentBlocks[$blockId]['items']) as $key => $val) {
							$items[$key]['label']    = trim($val);
							if($this->_contentBlocks[$blockId]['translate_labels'])
								$items[$key]['label'] = $AdvancedContent->lang($items[$key]['label']);
							
							$items[$key]['value']    = $items[$key]['label'];
							$items[$key]['selected'] = in_array($items[$key]['label'],$selItems);
						}
					}
					if($this->_contentBlocks[$blockId]['values'] != '') {
						foreach(explode($this->_contentBlocks[$blockId]['delimiter'], $this->_contentBlocks[$blockId]['values']) as $key => $val) {
							$items[$key]['value']    = trim($val);
							if($this->_contentBlocks[$blockId]['translate_values'])
								$items[$key]['value'] = $AdvancedContent->lang($items[$key]['value']);
							
							$items[$key]['selected'] = in_array($items[$key]['value'],$selItems);
							if(!isset($items[$key]['label']))
								$items[$key]['label'] = $items[$key]['value'];
						}
					}
					
					$this->_contentBlocks[$blockId]['input'] = '
						<input type="hidden" value="" "name="' . $blockId . '" />';
					
					if(!$this->_contentBlocks[$blockId]['sortable_items']) 
					{
						$size = count($items);
						if(isset($this->_contentBlocks[$blockId]['size']))
						{
							$size = $this->_contentBlocks[$blockId]['size'];
						}
						$this->_contentBlocks[$blockId]['input'] .= '
							<select name="' . $blockId . '[]"' . ($this->_contentBlocks[$blockId]['style'] != ''?' style="' . $this->_contentBlocks[$blockId]['style'] . ' "':'') . '  multiple="multiple" size="'.$size.'">';
						foreach($items as $item) 
						{
							$this->_contentBlocks[$blockId]['input'] .= '<option value="' . $item['value'] . '"';
							if($item['selected'])
								$this->_contentBlocks[$blockId]['input'] .= ' selected="selected"';
							$this->_contentBlocks[$blockId]['input'] .= '>' . $item['label'] . '</option>';
						}
						$this->_contentBlocks[$blockId]['input'] .= '</select>';
					}
					else 
					{
						// sort the items
						$_items = array();
						foreach($selItems as $selKey => $selItem) 
						{
							reset($items);
							foreach($items as $itemKey => $item) 
							{
								if($item['value'] === $selItem) 
								{
									$_items[] = $item;
									unset($items[$itemKey]);
									unset($selItems[$selKey]);
									break;
								}
							}
						}
						
						$items = array_merge($_items,$items);
						$this->_contentBlocks[$blockId]['input'] .= '<div class="sortable_items">';
						foreach($items as $item) 
						{
							$this->_contentBlocks[$blockId]['input'] .= 
							'<div class="sortable_item">
								<img class="sortable_item_handler" src="../modules/AdvancedContent/images/sort.png" />
								<input class="pagecheckbox"' . ($this->_contentBlocks[$blockId]['style'] != ''?' style="' . $this->_contentBlocks[$blockId]['style'] . ' "':'') . ' type="checkbox" value="'.$item['value'].'" name="' . $blockId . '_AdvancedContentSortableItem_' . munge_string_to_url($item['label']) . '"' . ($item['selected']? ' checked="checked"':'') . ' />
								'.$item['label'].'
							</div>';
						}
						$this->_contentBlocks[$blockId]['input'] .= '</div>';
					}
					break;
				
				case 'text':
					$usewysiwyg = !$this->GetPropertyValue('disable_wysiwyg');
					if(!$usewysiwyg)
						$this->_contentBlocks[$blockId]['usewysiwyg'] = false;
					if ($this->_contentBlocks[$blockId]['oneline'] == false) 
					{
						$this->_contentBlocks[$blockId]['input'] = create_textarea($this->_contentBlocks[$blockId]['usewysiwyg'], $data, $blockId, '', $blockId, '', $this->_stylesheet);
					}
					else 
					{
						$this->_contentBlocks[$blockId]['input'] = '<input type="text"' . ($this->_contentBlocks[$blockId]['style'] != ''?'style="' . $this->_contentBlocks[$blockId]['style'] . ' "':'') . ($this->_contentBlocks[$blockId]['maxlength'] != ''?' maxlength="' . $this->_contentBlocks[$blockId]['maxlength'] . ' "':'') . ($this->_contentBlocks[$blockId]['size'] != ''?' size="' . $this->_contentBlocks[$blockId]['size'] . ' "':'') . ' name="' . $blockId . '" value="' . $this->_contentBlocks[$blockId]['content'] . '" />';
					}
					break;
				
				default: 
					$this->_contentBlocks[$blockId]['content'] = $this->_contentBlocks[$blockId]['default_value'];
					break;
			}
			if($this->_contentBlocks[$blockId]['block_tab'] != '' || $this->_contentBlocks[$blockId]['block_group'] != '') 
			{
				unset($this->_pageTabs[$tab_id]['content_blocks'][$blockId]);
			}
			if($this->_contentBlocks[$blockId]['block_tab'] != '' && $this->_contentBlocks[$blockId]['block_group'] != '') 
			{
				unset($this->_pageTabs[$tab_id]['block_groups'][$this->_contentBlocks[$blockId]['block_group']]);
			}
		}
		
		$AdvancedContent->smarty->assign('module_id', 'm1_');
		$AdvancedContent->smarty->assign_by_ref('page_tab_nr', $tab);
		$AdvancedContent->smarty->assign_by_ref('page_tab_id', $tab_id);
		$AdvancedContent->smarty->assign_by_ref('page_tabs', $this->_pageTabs);
		$AdvancedContent->smarty->assign_by_ref('block_tabs', $this->_blockTabs);
		$AdvancedContent->smarty->assign_by_ref('block_groups', $this->_blockGroups);
		$AdvancedContent->smarty->assign_by_ref('date_blocks', $this->_dateBlocks);
		$AdvancedContent->smarty->assign_by_ref('content_blocks', $this->_contentBlocks);
		
		$ret[] = array('', $AdvancedContent->ProcessTemplate('contentType.tpl'));
		return $ret;
	}
	
	function ValidateData() 
	{
		$errors = parent::ValidateData();
		if( $errors === FALSE ) 
		{
			$errors = array();
		}
		
		if ($this->mTemplateId <= 0 ) 
		{
			$errors[] = lang('nofieldgiven', array(lang('template')));
			$result   = false;
		}
		
		#if ($this->GetPropertyValue('content_en') == '') {
		#	$errors[] = lang('nofieldgiven', array(lang('content')));
		#	$result   = false;
		#}
		if (check_permission(get_userid(), 'Manage AdvancedContent Options') && $this->GetPropertyValue('use_expire_date') == '1' && $this->GetPropertyValue('end_date') <= $this->GetPropertyValue('start_date')) 
		{
			$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
			$errors[] = $AdvancedContent->lang('error_expiredate');
			$result   = false;
		}
		return (count($errors) > 0?$errors:FALSE);
	}
	
	function ContentPreRender($tplSource) 
	{
		$this->parse_content_blocks('ContentPreRender');
		return $tplSource;
	}
	
	function display_single_element($one, $adding) 
	{
		switch($one) 
		{
			case 'template':
				$templateops =& cmsms()->GetTemplateOperations();
				return array(lang('template') . ':', $templateops->TemplateDropdown('template_id', $this->mTemplateId, 'onchange="document.contentform.submit()"'));
			
			case 'pagemetadata':
				return array(lang('page_metadata') . ':', create_textarea(false, $this->Metadata(), 'metadata', 'pagesmalltextarea', 'metadata', '', '', '80', '6'));
			
			case 'pagedata':
				return array(lang('pagedata_codeblock') . ':', create_textarea(false, $this->GetPropertyValue('pagedata'), 'pagedata', 'pagesmalltextarea', 'pagedata', '', '', '80', '6'));
			
			case 'searchable':
				$searchable = $this->GetPropertyValue('searchable');
				if( $searchable == '' ) 
				{
					$searchable = 1;
				}
				return array(lang('searchable') . ':',
					'<div class="hidden" ><input type="hidden" name="searchable" value="0" /></div>
					<input type="checkbox" name="searchable" value="1" ' . ($searchable == 1?'checked="checked"':'') . ' />');
			
			case 'disable_wysiwyg':
				$disableWysiwyg = $this->GetPropertyValue('disable_wysiwyg');
				if( $disableWysiwyg == '' ) 
				{
					$disableWysiwyg = 0;
				}
				return array(lang('disable_wysiwyg') . ':',
					'<div class="hidden" ><input type="hidden" name="disable_wysiwyg" value="0" /></div>
					<input type="checkbox" name="disable_wysiwyg" value="1"  ' . ($disableWysiwyg == 1?'checked="checked"':'') . ' onclick="this.form.submit()" />');
			
			default:
				if($one != 'feu_access'
				&& $one != 'redirect_page'
				&& $one != 'redirect_params'
				&& $one != 'evaluate_smarty'
				&& $one != 'feu_action'
				&& $one != 'start_date'
				&& $one != 'end_date'
				&& $one != 'use_expire_date')
				{
					return parent::display_single_element($one, $adding);
				}
				break;
		}
	}

/**
 * -----------------------------------------------------------------------------
 * Custom functions
 * -----------------------------------------------------------------------------
 */
	/**
	 * function DisplayAdvancedOptions($adding)
	 * not part of the module api
	 * this is just a wrapper to process a template from data
	 *
	 * @param boolean $adding - true if page is added, false if edited
	 *
	 * @return array - array(array(prompt,imput))
	 */
	function DisplayAdvancedOptions($adding) 
	{
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		$ret = array();
		
		foreach( $this->_attributes as $oneAttrib ) 
		{
			switch($oneAttrib[0]) 
			{
				
				case 'feu_access':
					if($feusers =& AdvancedContentModule::GetModuleInstance('FrontEndUsers')) 
					{
						if($adding)
							$selectedGroups = $this->CleanArray(explode(';',$AdvancedContent->GetPreference('feu_access')));
						else
							$selectedGroups = $this->CleanArray(explode(';', $this->GetPropertyValue('feu_access')));
						
						$feuAccess = array($AdvancedContent->lang('inherit_from_parent')=>-1);
						$feuAccess = array_merge($feuAccess,$feusers->GetGroupList());
						$ret[] = array($AdvancedContent->lang('frontendaccess').' : ', 
							'<input type="hidden" value="" name="feu_access" />'.
							$AdvancedContent->CreateInputSelectList('','feu_access[]',$feuAccess,$selectedGroups,count($feuAccess),'',1));
					}
					break;
				
				case 'redirect_page':
					if($feusers =& AdvancedContentModule::GetModuleInstance('FrontEndUsers')) 
					{
						if($adding)
							$selectedPage = $AdvancedContent->GetPreference('redirect_page','');
						else
							$selectedPage = $this->GetPropertyValue("redirect_page");
						
						$ret[] = array($AdvancedContent->lang('redirectpage').' : ', 
							$AdvancedContent->CreateRedirectDropdown('', 'redirect_page',$selectedPage, $this->mId));
					}
					break;
				
				case 'redirect_params':
					if($feusers =& AdvancedContentModule::GetModuleInstance('FrontEndUsers')) 
					{
						if($adding) 
						{
							$redirectParams = $AdvancedContent->GetPreference('redirect_params','');
							$evaluateSmarty = $AdvancedContent->GetPreference('evaluate_smarty','');
						}
						else 
						{
							$redirectParams = $this->GetPropertyValue("redirect_params");
							$evaluateSmarty = $this->GetPropertyValue("evaluate_smarty");
						}
							
						$ret[] = array($AdvancedContent->lang('redirectparams').' : ', 
							'<input type="text" size="32" maxlength="128" name="redirect_params" value="'.$redirectParams.'" />&nbsp;<em>(param1=value1 param2=value2 ...)</em><br />
							<input type="hidden" name="evaluate_smarty" value="0" />'.
							$AdvancedContent->lang('evaluatesmarty') . ':&nbsp;'.
							'<input type="checkbox" name="evaluate_smarty" value="1"  ' . ($evaluateSmarty == 1?'checked="checked"':'') . ' />');
					}
					break;
				
				case 'feu_action':
					if($feusers =& AdvancedContentModule::GetModuleInstance('FrontEndUsers')) 
					{
						if($adding)
							$feuAction = $AdvancedContent->GetPreference('feu_action','');
						else
							$feuAction = $this->GetPropertyValue('feu_action');
						$ret[] = array($AdvancedContent->lang('showloginform').' : ', 
							$AdvancedContent->CreateInputDropdown('','feu_action',
								array($AdvancedContent->lang('no')=>'',
									$AdvancedContent->lang('inherit_from_parent')=>-1,
									$AdvancedContent->lang('yes')=>1)
								,0,$feuAction));
					}
					break;
				
				case 'start_date':
					$startDate = $this->GetPropertyValue('start_date');
					if(!$startDate)
						$startDate = time();
					
					$date        = strftime('%x', intval($startDate));
					$time        = strftime('%H:%M', intval($startDate));
					
					$_tmp        = $this->CleanArray(explode(':',$time));
					$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
					$dateSeconds = $startDate - $timeSeconds;
					
					$startDateInput = '
						<img id="AdvancedContentStartDatePickerTrigger" src="../modules/AdvancedContent/images/calendar.png" class="calendarTrigger" />&nbsp;
						<span id="AdvancedContentStartDatePickerDisplay">'.$date.'</span>&nbsp;&nbsp;-&nbsp;&nbsp;
						<input id="AdvancedContentStartDate" type="hidden" name="AdvancedContentStartDate" value="'.$dateSeconds.'" />
						<select name="AdvancedContentStartTime">';
						
					for($i=0; $i<=23; $i++) 
					{
						for($j=0; $j<=59; $j++) 
						{
							$value = ($i*3600) + ($j*60);
							$startDateInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:$i) .':'. ($j<10?'0'.$j:$j) .'</option>';
						}
						$j = 0;
					}
					$startDateInput .= '</select>';
					$ret[] = array($AdvancedContent->lang('startdate').' : ', $startDateInput);
					break;
				
				case 'end_date':
					$endDate = $this->GetPropertyValue('end_date');
					if(!$endDate)
						$endDate = time();
					
					$date        = strftime('%x', intval($endDate));
					$time        = strftime('%H:%M', intval($endDate));
					
					$_tmp        = $this->CleanArray(explode(':',$time));
					$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
					$dateSeconds = $endDate - $timeSeconds;
					
					$endDateInput = '
						<img id="AdvancedContentEndDatePickerTrigger" src="../modules/AdvancedContent/images/calendar.png" class="calendarTrigger" />&nbsp;
						<span id="AdvancedContentEndDatePickerDisplay">'.$date.'</span>&nbsp;&nbsp;-&nbsp;&nbsp;
						<input id="AdvancedContentEndDate" type="hidden" name="AdvancedContentEndDate" value="'.$dateSeconds.'" />
						<select name="AdvancedContentEndTime">';
						
					for($i=0; $i<=23; $i++) 
					{
						for($j=0; $j<=59; $j++) 
						{
							$value = ($i*3600) + ($j*60);
							$endDateInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:$i) .':'. ($j<10?'0'.$j:$j) .'</option>';
						}
						$j = 0;
					}
					$endDateInput .= '</select>';
					$ret[] = array($AdvancedContent->lang('enddate').' : ', $endDateInput);
					break;
				
				case 'use_expire_date':
					$useExp = $this->GetPropertyValue('use_expire_date');
					if( $useExp == '' ) 
					{
						$useExp = 0;
					}
					$ret[] = array($AdvancedContent->lang('useexpiredate') . ':',
						'<div class="hidden" ><input type="hidden" name="use_expire_date" value="0" /></div>
						<input type="checkbox" name="use_expire_date" value="1"  ' . ($useExp == 1?'checked="checked"':'') . ' />');
					break;
				
				default:break;
			}
		}
		return $ret;
	}
	
	
	/**
	 * function DoSmarty($data)
	 * not part of the module api
	 * this is just a wrapper to process a template from data
	 *
	 * @param string $data - The template content to process
	 *
	 * @return string - The processed template data
	 */
	function DoSmarty($data) 
	{
		// only process smarty if there is actually something to process
		if(!is_array($data) && !is_object($data) && preg_match_all('/:::([^:]+):::/', $data, $matches)) 
		{
			$gCms = cmsms();
			$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
			// TODO: do not use the CMSms internals here!
			// only do this if we did not do this before
			if(!isset($gCms->variables['pageinfo']->content_id)) 
			{
				// fake frontend rendering
				$gCms->variables['pageinfo']                              = new stdClass();
				$gCms->variables['pageinfo']->content_id                  = $this->mId;
				$gCms->variables['pageinfo']->content_title               = $this->mName;
				$gCms->variables['pageinfo']->content_alias               = $this->mAlias;
				$gCms->variables['pageinfo']->content_menutext            = $this->mMenuText;
				$gCms->variables['pageinfo']->content_titleattribute      = $this->mTitleAttribute;
				$gCms->variables['pageinfo']->content_hierarchy           = $this->mHierarchy;
				$gCms->variables['pageinfo']->content_id_hierarchy        = $this->mIdHierarchy;
				$gCms->variables['pageinfo']->content_type                = $this->mType;
				$gCms->variables['pageinfo']->content_props               = $this->mProperties->mPropertyNames;
				$gCms->variables['pageinfo']->content_metadata            = $this->mMetadata;
				$gCms->variables['pageinfo']->content_modified_date       = $this->mModifiedDate;
				$gCms->variables['pageinfo']->content_created_date        = $this->mCreationDate;
				$gCms->variables['pageinfo']->content_last_modified_date  = $this->mModifiedDate;
				$gCms->variables['pageinfo']->content_last_modified_by_id = $this->mOwner;
				$gCms->variables['pageinfo']->template_id                 = $this->mTemplateId;
				$gCms->variables['pageinfo']->template_encoding           = get_encoding('');
				$gCms->variables['pageinfo']->template_modified_date      = time(); // ???
				$gCms->variables['pageinfo']->cachable                    = $this->mCachable;
				$gCms->variables['pageinfo']->content_hierarchy_path      = $this->mHierarchyPath;
				
				$gCms->variables['content_id']                            = $this->mId;
				$gCms->variables['page']                                  = $this->mAlias;
				$gCms->variables['page_id']                               = $this->mAlias;
				$gCms->variables['page_alias']                            = $this->mAlias;
				$gCms->variables['content_alias']                         = $this->mAlias;
				$gCms->variables['page_name']                             = $this->mAlias;
				$gCms->variables['position']                              = $this->mHierarchy;
				$gCms->variables['friendly_position']                     = ContentOperations::CreateFriendlyHierarchyPosition($this->mHierarchy);
				
				$AdvancedContent->smarty->assign('content_id', $this->mId);
				$AdvancedContent->smarty->assign('content_alias', $this->mAlias);
				$AdvancedContent->smarty->assign('page', $this->mAlias);
				$AdvancedContent->smarty->assign('page_id', $this->mAlias);
				$AdvancedContent->smarty->assign('page_alias', $this->mAlias);
				$AdvancedContent->smarty->assign('page_name', $this->mAlias);
				$AdvancedContent->smarty->assign('position', $this->mHierarchy);
				$AdvancedContent->smarty->assign('friendly_position', ContentOperations::CreateFriendlyHierarchyPosition($this->mHierarchy));
			}
			$data = $AdvancedContent->ProcessTemplateFromData(preg_replace('/:::([^:]+):::/', '{$1}', $data));
		}
		return $data;
	}
	
	
	/**
	 * function InheritParentProp($parentId, $propName, $currentProp)
	 * not part of the module api
	 * inherits a property of a parent page;
	 * if parent page has also selected inheritance for that property -> do recursion
	 *
	 * @param int $parentId - The id of the parent page
	 * @param string $propName - The name of the property to inherit
	 * @param array $currentProp (optional) - If prop is an array this will be the items of the current page; So return array will contain all items of the current page and parent pages; otherwise only the parents items will be returned
	 *
	 * @return array|string - The prop of the last found parent that has no inheritance or an array of items of all parents that have inheritance
	 */
	function InheritParentProp($parentId, $propName, $currentProp = array()) 
	{
		// default return value
		// feu_access is a special case (because of multiple selections are possible)
		if($propName == 'feu_access') 
		{
			$prop = array();
			
			// this will "merge" the parents prop with the current one
			// but removing the inherit stuff; 
			// so if currentProp is set this will return an array with all props 
			// (real values only; no inherit flag)
			// including the parents ones and the current one but without duplicate values
			foreach($currentProp as $k=>$v) 
			{
				if($v != '-1')
					$prop[] = $v;
			}
		}
		else
			$prop = '';
		
		// as long as page has parents...
		while( $parentId > 0 ) 
		{
			$content = $this->GetContentProp($parentId, $propName, 'content2');
			
			if(!$content)
				return $prop;
			
			$parentId  = $content['parent_id'];
			$propValue = $content['prop_value'];
			
			// feu_access is a special case (because of multiple selections are possible)
			if($propName == 'feu_access') 
			{
				$_prop = $this->CleanArray(explode(";", $propValue));
				
				foreach($_prop as $_p) 
				{
					if(!in_array($_p, $prop) && $_p != '-1' && $_p != '') 
						$prop[] = $_p;
				}
				
				// if the current obj does not inherit its prop anymore OR has no parents 
				// but wants to inherit -> return the prop array
				if(!in_array('-1', $_prop) || ($parentId <= 0 && in_array('-1', $_prop))) 
					return $prop;
				
			}
			else 
			{
				// if content has no parents but wants to inherit -> return
				if($parentId <= 0 && $propValue == '-1') 
				{
					return;
				}
				// if no inheritance anymore -> return the prop
				else if($propertyValue != '-1') 
				{
					return $propValue;
				}
			}
		}
	}
	
	
	/**
	 * function GetContentProp($contentId, $propName, $contentType)
	 * not part of the module api
	 * gets a property of a content page
	 *
	 * @param int $contentId - The id of the content to get the property from
	 * @param string $propName - The name of the property to get the value from
	 * @param string $contentType (optional) - The type of the content
	 *
	 * @return mixed - False if not exists or array('parent_id','prop_value')
	 *
	 */
	function GetContentProp($contentId, $propName, $contentType = '') 
	{
		$db =& cmsms()->GetDb();
		$query = "SELECT CP.content, C.parent_id, C.content_alias FROM " . cms_db_prefix() . "content_props CP 
			LEFT JOIN " . cms_db_prefix() . "content C ON C.content_id = CP.content_id 
			WHERE CP.content_id = ? AND CP.prop_name = ?";
		$p = array($contentId, $propName);
		if($contentType != '') 
		{
			$query .= " AND C.type = ?";
			$p[]    = $contentType;
		}
		$query .= " LIMIT 1";
		$dbresult = $db->Execute($query, $p);
		if($dbresult && $row = $dbresult->FetchRow())
			return array('parent_id'=>$row['parent_id'], 'prop_value'=>$row['content'], 'alias'=>$row['alias']);
		
		return false;
	}
	
	
	/**
	 * function SortContentBlocks()
	 * not part of the module api
	 * simple sorting function
	 * sorts the content blocks by sequence attribute that is given in FillParams()
	 * this is only important for content blocks that are not defined in template
	 */
	function SortContentBlocks() 
	{
		$_contentBlocks = array();
		foreach($this->_contentBlocks as $blockInfo) 
		{
			$_contentBlocks['number_'.$blockInfo['sequence']] = $blockInfo;
		}
		$this->_contentBlocks = array();
		ksort($_contentBlocks);
		reset($_contentBlocks);
		foreach($_contentBlocks as $blockInfo) 
		{
			$this->_contentBlocks[$blockInfo['id']] = $blockInfo;
		}
	}
	
	function GetGroups() 
	{
		$db =& cmsms()->GetDb();
		$groups = array();
		$query = "SELECT group_id FROM ".cms_db_prefix()."user_groups WHERE user_id = ?";
		$dbresult = $db->Execute($query, array(get_userid()));
		while( $dbresult && $row = $dbresult->FetchRow() ) 
		{
			$groups[] = $row['group_id'] * -1;
		}
		return $groups;
	}
	
	function CheckBlockPermission($blockId) 
	{
		$this->_contentBlocks[$blockId]['addt_editors'] = array();
		// check if user has permission to edit this block
		if(($this->_contentBlocks[$blockId]['editor_users'] != '' || $this->_contentBlocks[$blockId]['editor_groups'] != '') 
		&& !check_permission(get_userid(), 'Manage All AdvancedContent Blocks')) 
		{
			$userops      =& cmsms()->GetUserOperations();
			$groupops     =& cmsms()->GetGroupOperations();
			$allusers     =& $userops->LoadUsers();
			$allgroups    =& $groupops->LoadGroups();
			$editorGroups =  $this->CleanArray(explode(',',$this->_contentBlocks[$blockId]['editor_groups']));
			$editorUsers  =  $this->CleanArray(explode(',',$this->_contentBlocks[$blockId]['editor_users']));
			
			foreach ($allgroups as $oneGroup) 
			{
				if(in_array($oneGroup->name,$editorGroups))
					$this->_contentBlocks[$blockId]['addt_editors'][] = $oneGroup->id*-1;
			}
			
			foreach ($allusers as $oneUser) 
			{
				if(in_array($oneUser->username,$editorUsers))
					$this->_contentBlocks[$blockId]['addt_editors'][] = $oneUser->id;
			}
			
			if(!in_array(get_userid(),$this->_contentBlocks[$blockId]['addt_editors']) 
			&& !count(array_intersect($this->_userGroups,$this->_contentBlocks[$blockId]['addt_editors']))) 
			{
				unset($this->_contentBlocks[$blockId]);
				return false;
			}
		}
		return true;
	}
	
	
	/**
	 * function IsVarEmpty($var, $trim, $unsetEmptyIndexes)
	 * not part of the module api
	 * checks if a var is empty. if var is an array it recursivley checks all elements
	 *
	 * @param mixed $var - the var to check for empty value(s)
	 * @param boolean $trim - true to trim off spaces
	 * @param boolean $unsetEmptyIndexes - true to delete empty elements from array
	 * @return boolean - true if empty, false if not
	 */
	function IsVarEmpty(&$var, $trim = true, $unsetEmptyIndexes = false) 
	{
		if (is_array($var)) 
		{
			foreach ($var as $k=>$v) 
			{
				if (!$this->IsVarEmpty($v)) 
				{
					return false;
				}
				else 
				{
					if($unsetEmptyIndexes)
						unset($var[$k]);
					return true;
				}
			}
		}
		else if($trim && trim($var) == '') 
		{
			return true;
		}
		else if($var == '') 
		{
			return true;
		}
		return false;
	}
	
	
	/**
	 * function CleanArray($array)
	 * not part of the module api
	 * removes empty elements from an array 
	 * (can be useful when using function explode to create the array of a csv)
	 *
	 * @param array $array - the array to clean up
	 * @return array - an array without empty elements or an empty array
	 */
	function CleanArray($array) 
	{
		if (is_array($array)) 
		{
			foreach ($array as $k=>$v) 
			{
				if ($this->IsVarEmpty($v,true,true)) 
				{
					unset($array[$k]);
				}
				else 
				{
					if(is_array($v)) 
					{
						$v = $this->CleanArray($v);
						if($this->IsVarEmpty($v,true,true))
							unset($array[$k]);
						else
							$array[$k] = $v;
					}
				}
			}
			return $array;
		}
		return array();
	}
	
	
	/**
	 * function IsTrue($value)
	 * not part of the module api
	 * checks if a value is literally "true"
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsTrue($value) 
	{
		return (strtolower($value) === 'true' || $value === 1 || $value === '1' || $value === true);
	}
	
	
	/**
	 * function IsFalse($value)
	 * not part of the module api
	 * checks if a value is literally "false"
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsFalse($value) 
	{
		return (strtolower($value) === 'false' || $value === '0' || $value === 0 || $value === false || $value === '');
	}
}
?>
