<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.6
# File   : action.defaultadmin.php
# Purpose: performs the default backend action if "Extensions->AdvancedContent"
#          is selected
# License: GPL
#
#-------------------------------------------------------------------------------

if(!isset($gCms)) exit;

$this->smarty->assign('startform', $this->CreateFormStart($id, 
	'savePrefs', $returnid,'post','multipart/form-data'));
$this->smarty->assign('endform', $this->CreateFormEnd());

$this->smarty->assign('importcontent_input', 
	$this->CreateLink($id, 'importpages', $returnid, 
		$gCms->variables['admintheme']->DisplayImage('icons/system/import.gif', '','','','systemicon') . 
		'&nbsp;' . $this->lang('importpages', lang('content'),$this->lang('AdvancedContent')), 
		array('old_type'=>'content','new_type'=>'content2'), '',
		false,false,'class="AdvancedContent_AJAX" onclick="if(confirm(\''. $this->lang('confirmimport',lang('content'),$this->lang('AdvancedContent')) .'\')) {AdvancedContent.ImportPages(this.href);} return false;"'));

$this->smarty->assign('importcontent2_input', 
	$this->CreateLink($id, 'importpages', '', 
		$gCms->variables['admintheme']->DisplayImage('icons/system/import.gif', '','','','systemicon') . 
		'&nbsp;' . $this->lang('importpages', $this->lang('AdvancedContent'),lang('content')), 
		array('old_type'=>'content2','new_type'=>'content'), 
		'',
		false,false,'class="AdvancedContent_AJAX" onclick="if(confirm(\''. $this->lang('confirmimport',$this->lang('AdvancedContent'),lang('content')) .'\')) {AdvancedContent.ImportPages(this.href);} return false;"'));

$this->smarty->assign('uninstallaction_text', $this->lang('uninstallaction'));

$actions = array(lang('none')=>'', 
	$this->lang('setcontent1')=>2, 
	$this->lang('setcontent2')=>3,
	$this->lang('deletepages')=>1);

$this->smarty->assign('uninstallaction_input', 
	$this->CreateInputDropdown($id, 'uninstall_action', $actions, '', 
		$this->GetPreference('uninstall_action')));

$actions = array($this->lang('per_page')=>'content', 
	$this->lang('per_template')=>'template', 
	$this->lang('both1')=>'both1',
	$this->lang('both2')=>'both2');

#$this->smarty->assign('block_display_settings_text', $this->lang('display_settings', $this->lang('content_blocks')));
$this->smarty->assign('block_display_settings_text', $this->lang('save_collapse_status', $this->lang('content_blocks')));
$this->smarty->assign('block_display_settings_input', 
	$this->CreateInputDropdown($id, 'block_display_settings', $actions, '', 
		$this->GetPreference('block_display_settings')));

$this->smarty->assign('collapse_block_default_text', $this->lang('collapse_default',$this->lang('content_blocks')));
	$this->smarty->assign('collapse_block_default_input', 
		$this->CreateInputHidden($id,'collapse_block_default',0) .
		$this->CreateInputCheckbox($id, 'collapse_block_default', '1', 
			$this->GetPreference('collapse_block_default',1)));

#$this->smarty->assign('message_display_settings_text', $this->lang('display_settings', $this->lang('block_message')));
$this->smarty->assign('message_display_settings_text', $this->lang('save_collapse_status', $this->lang('block_message')));
$this->smarty->assign('message_display_settings_input', 
	$this->CreateInputDropdown($id, 'message_display_settings', $actions, '', 
		$this->GetPreference('message_display_settings')));

#$this->smarty->assign('group_display_settings_text', $this->lang('display_settings', $this->lang('block_groups')));
$this->smarty->assign('group_display_settings_text', $this->lang('save_collapse_status', $this->lang('block_groups')));
$this->smarty->assign('group_display_settings_input', 
	$this->CreateInputDropdown($id, 'group_display_settings', $actions, '', 
		$this->GetPreference('group_display_settings')));

$this->smarty->assign('collapse_group_default_text', $this->lang('collapse_default',$this->lang('block_groups')));
	$this->smarty->assign('collapse_group_default_input', 
		$this->CreateInputHidden($id,'collapse_group_default',0) .
		$this->CreateInputCheckbox($id, 'collapse_group_default', '1', 
			$this->GetPreference('collapse_group_default',1)));

$this->smarty->assign('show_advancedcontent_options_text', $this->lang('show_advancedcontent_options'));
	$this->smarty->assign('show_advancedcontent_options_input', 
		$this->CreateInputHidden($id,'show_advancedcontent_options',0) .
		$this->CreateInputCheckbox($id, 'show_advancedcontent_options', '1', 
			$this->GetPreference('show_advancedcontent_options',1)));

// Content settings
if( $feusers =& $this->GetModuleInstance('FrontEndUsers' )) {
	$this->smarty->assign('contentsettings_text', $this->lang('contentsettings'));
	$this->smarty->assign('feuaccess_text', $this->lang('frontendaccess'));
	$feuAccess = array($this->lang('inherit_from_parent')=>-1);
	$feuAccess = array_merge($feuAccess,$feusers->GetGroupList());
	$this->smarty->assign('feuaccess_input', 
		$this->CreateInputHidden($id,'feu_access','').
		$this->CreateInputSelectList($id,'feu_access[]',$feuAccess,
			$this->CleanArray(explode(';',$this->GetPreference('feu_access'))),
		count($feuAccess),'',1));
	
	$this->smarty->assign('redirectpage_text', $this->lang('redirectpage'));
	$this->smarty->assign('redirectpage_input', 
		$this->CreateRedirectDropdown($id,'redirect_page',$this->GetPreference('redirect_page')));
	
	$this->smarty->assign('redirectparams_text', $this->lang('redirectparams'));
	$this->smarty->assign('redirectparams_input', 
		$this->CreateInputText($id, 'redirect_params', 
			$this->GetPreference('redirect_params'), 32, 128));
	
	$this->smarty->assign('evaluatesmarty_text', $this->lang('evaluatesmarty'));
	$this->smarty->assign('evaluatesmarty_input', 
		$this->CreateInputHidden($id,'evaluate_smarty',0) .
		$this->CreateInputCheckbox($id, 'evaluate_smarty', '1', 
			$this->GetPreference('evaluate_smarty')));
	
	$this->smarty->assign('feuaction_text', $this->lang('showloginform'));
	$this->smarty->assign('feuaction_input', 
		$this->CreateInputDropdown($id,'feu_action',
			array($this->lang('no')=>'',
				$this->lang('inherit_from_parent')=>-1,
				$this->lang('yes')=>1),
			0,$this->GetPreference('feu_action')));
}
//---

$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', 
	lang('submit'),'onClick="return AdvancedContent.SubmitForm(this,\'AdvancedContentResult\')"'));

$this->smarty->assign('moduleId', $id);

if(isset($params['message']) && isset($params['submit']))
	$this->smarty->assign('message', $this->lang($params['message'], (isset($params['old_type']) && isset($params['new_type']) ? $this->lang($params['old_type']) . ',' . $this->lang($params['new_type']) : '')));

if(isset($params['errormessage']) && isset($params['submit']))
	$this->smarty->assign('errormessage', $this->lang($params['errormessage'], (isset($params['old_type']) && isset($params['new_type']) ? $this->lang($params['old_type']) . ',' . $this->lang($params['new_type']) : '')));

echo $this->ProcessTemplate('defaultadmin.tpl');

?>
