<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.6
# File   : action.default.php
#          This file is a modification of the default plugin {content}
# Purpose: performs the default frontend action if {AdvancedContent} is used.
# License: GPL
#
#-------------------------------------------------------------------------------

if(!isset($gCms)) exit;

if(isset($params['active']) && $this->IsFalse($params['active'])) {
	return; // don't process inactive blocks
}

$pageinfo =& $gCms->variables['pageinfo'];
$result   = '';

$block = 'content_en';
$mainContent = true;

# MLE support
$mle = false;
global $hls, $mleblock, $mleblockfallback;
if(isset($hls))
	$mle = true;

if($mle && $mleblock != '') {
	$block = 'content'.$mleblock;
}
#---

if(isset($params['block']) && $params['block'] != $block) {
	$mainContent = false;
	$_block = preg_replace('/-+/','_',munge_string_to_url($params['block']));
	$block = $_block;
	# MLE support
	if($mle) {
		$block .= $mleblock;
	}
	#---
}

$defaultValue = '';
if(isset($params['default']))
	$defaultValue = trim($params['default']);

$doSmarty = false;
if(isset($params['smarty']) && $this->IsTrue($params['smarty']) && $gCms->smarty->_tpl_vars['content_obj']->mType == 'content2')
	$doSmarty = true;

if($doSmarty && $gCms->smarty->_tpl_vars['content_obj']->mType == 'content2') {
	$defaultValue = $gCms->smarty->_tpl_vars['content_obj']->DoSmarty($gCms->smarty->_tpl_vars['content_obj']->_contentBlocks[$block]['default_value']);
}

$allowNone = true;
if(isset($params['allow_none']) && $this->IsFalse($params['allow_none']))
	$allowNone = false;

if (isset($pageinfo) && $pageinfo !== FALSE && isset($pageinfo->content_id) )
{
	$id         = '';
	$modulename = '';
	$action     = '';
	$inline     = false;
	if (isset($_REQUEST['module'])) 
		$modulename = $_REQUEST['module'];
	
	if (isset($_REQUEST['id'])) {
		$id = $_REQUEST['id'];
	}
	elseif (isset($_REQUEST['mact'])) {
		$ary        = explode(',', cms_htmlentities($_REQUEST['mact']), 4);
		$modulename = (isset($ary[0])?$ary[0]:'');
		$id         = (isset($ary[1])?$ary[1]:'');
		$action     = (isset($ary[2])?$ary[2]:'');
		$inline     = (isset($ary[3]) && $ary[3] == 1?true:false);
	}
	
	if (isset($_REQUEST[$id.'action'])) {
		$action = $_REQUEST[$id.'action'];
	}
	else if (isset($_REQUEST['action'])) {
		$action = $_REQUEST['action'];
	}
	
	if (!isset($params['block']) && ($id == 'cntnt01' || ($id != '' && $inline == false))) {
		
		$cmsmodules = &$gCms->modules;
		
		if (isset($cmsmodules)) {
			
			foreach ($cmsmodules as $key=>$value) {
				if (strtolower($modulename) == strtolower($key)) {
					$modulename = $key; }
			}
			
			if (isset($modulename)) {
				if (isset($cmsmodules[$modulename])) {
					if (isset($cmsmodules[$modulename]['object'])
						&& $cmsmodules[$modulename]['installed'] == true
						&& $cmsmodules[$modulename]['active'] == true
						&& $cmsmodules[$modulename]['object']->IsPluginModule())
					{
						@ob_start();
						
						unset($params['label']);
						unset($params['class']);
						unset($params['id']);
						unset($params['name']);
						unset($params['width']);
						unset($params['height']);
						unset($params['alt']);
						unset($params['block']);
						unset($params['smarty']);
						unset($params['label']);
						unset($params['type']);
						unset($params['block_type']);
						unset($params['default']);
						unset($params['style']);
						unset($params['size']);
						unset($params['block_tab']);
						unset($params['page_tab']);
						unset($params['maxlength']);
						unset($params['wysiwyg']);
						unset($params['oneline']);
						unset($params['mode']);
						unset($params['start_time']);
						unset($params['end_time']);
						unset($params['date_format']);
						unset($params['start_hour']);
						unset($params['end_hour']);
						unset($params['start_minute']);
						unset($params['end_minute']);
						unset($params['start_seconds']);
						unset($params['end_seconds']);
						unset($params['show_clock']);
						unset($params['step_hours']);
						unset($params['step_minutes']);
						unset($params['step_seconds']);
						unset($params['show24h']);
						unset($params['upload']);
						unset($params['dir']);
						unset($params['allow_none']);
						unset($params['exclude_prefix']);
						unset($params['exclude_sufix']);
						unset($params['include_prefix']);
						unset($params['include_sufix']);
						unset($params['mode']);
						unset($params['lock_input']);
						unset($params['file_extension']);
						unset($params['delimiter']);
						unset($params['items']);
						unset($params['values']);
						unset($params['module']);
						unset($params['defaultModules']);
						unset($params['urlonly']);
						unset($params['feu_action']);
						unset($params['feu_access']);
						unset($params['editor_groups']);
						unset($params['editor_users']);
						unset($params['active']);
						unset($params['translate_labels']);
						unset($params['translate_values']);
						
						$params = array_merge($params, GetModuleParameters($id));
						
						// calguy1000 ... increment the modulenum 
						// if we're not in inlined mode.
						if( $id != 'cntnt01' ) {
							++$gCms->variables["modulenum"]; 
						}
						
						$returnid = '';
						if (isset($params['returnid'])) {
							$returnid = $params['returnid'];
						}
						else {
							$returnid = $pageinfo->content_id;
						}
						$result = $cmsmodules[$modulename]['object']->DoActionBase($action, $id, $params, $returnid);
						if ($result !== FALSE) {
							echo $result;
						}
						$modresult = @ob_get_contents();
						@ob_end_clean();
						$result = $modresult;
					}
					else {
					  $result = "<!-- Not a tag module -->\n";
					}
				}
			}
		}
	}
	else {
		$oldvalue              = $gCms->smarty->caching;
		$gCms->smarty->caching = false;
		$contentId             = $pageinfo->content_id;
		
		# MLE support
		if($mle)
			$contentId .= '-'.$hls;
		#---
		
		$result = $gCms->smarty->fetch(str_replace(' ', '_', 'content:' . $block), '', $contentId);
		
		# MLE support
		if($mle 
			&& $result == '' && $mleblockfallback != '' 
			&& $mleblockfallback != $mleblock) 
		{
			if($block != 'content'.$mleblock) {
				$block  = $_block . $mleblockfallback;
				$result = $gCms->smarty->fetch(str_replace(' ', '_', 'content:' . $block), '', $contentId);
			}
			else {
				$block  = 'content' . $mleblockfallback;
				$result = $gCms->smarty->fetch(str_replace(' ', '_', 'content:' . $block), '', $contentId);
			}
		}
		#---
		
		$gCms->smarty->caching = $oldvalue;
		
		if($result == '' && !$allowNone)
			$result = $defaultValue;
		
		# ToDo: test this (especially MLE)
		if (isset($params['block_type']) && (strtolower($params['block_type'])=='image' || strtolower($params['block_type'])=='file') && $result == '-1' && $gCms->smarty->_tpl_vars['content_obj']->mType == 'content2') {
			$result = $gCms->smarty->_tpl_vars['content_obj']->InheritParentProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,$block);
		}
		#---
		
		if (isset($params['block_type']) && (strtolower($params['block_type'])=='image' || strtolower($params['block_type'])=='file') && $result != '') {
			$name    = ' name="AdvancedContent'.ucfirst(strtolower($block)).'"';
			$urlonly = false;
			$elmId   = ' id="AdvancedContent'.ucfirst(strtolower($block)).'"';
			$class   = ' class="AdvancedContent'.ucfirst(strtolower($params['block_type'])).'"';
			$alt     = ' alt="'.ucfirst(strtolower($block)).'"';
			$width   = '';
			$height  = '';
			$title   = '';
			$text    = ucfirst(strtolower($block));
			
			if( isset($params['name']) )    $name    = ' name="'.$params['name'].'"';
			if( isset($params['class']) )   $class   = ' class="'.$params['class'];
			if( isset($params['id']) )      $elmId   = ' id="'.$params['id'];
			if( isset($params['alt']) )     $alt     = ' alt="'.$params['alt'];
			if( isset($params['width']) )   $width   = ' width="'.$params['width'];
			if( isset($params['height']) )  $height  = ' height="'.$params['height'];
			if( isset($params['title']) )   $title   = ' title="'.$params['title'];
			if( isset($params['text']) )    $text    = $params['text'];
			if( isset($params['urlonly']) && $this->IsTrue($params['urlonly']))
				$urlonly = true;
			
			if($gCms->smarty->_tpl_vars['content_obj']->mType == 'content2')
				$result = $gCms->config['uploads_url']. '/' . $result;
			
			if( !$urlonly ) {
				if(strtolower($params['block_type'])=='image') {
					$result = '<img src="' . $result . '"'.$name.$elmId.$class.$alt.$width.$height.$title.' />';
				}
				else if(strtolower($params['block_type'])=='file') {
					$result = '<a href="' . $result . '"'.$name.$elmId.$class.$title.'>'.$text.'</a>';
				}
			}
		}
		if (isset($params['block_type']) && strtolower($params['block_type'])=='date' && isset($params['date_format']) && $params['date_format'] != '')
			$result = strftime($params['date_format'],$result);
	}
	
	// grant page access by default
	$access = true;
	
	// only process feu_acces if there is a frontendusers module
	if( $feusers =& $this->GetModuleInstance('FrontEndUsers' ) && $gCms->smarty->_tpl_vars['content_obj']->mType == 'content2') {
		
		$feuAccess = $this->CleanArray(explode(';',$gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['feu_access']));
		
		// only process if we have selected anything in backend for feu access
		if(!empty($feuAccess)) {
			
			// if page has no parents but inheritance -> remove inheritance (should never happen but just in case)
			if($gCms->smarty->_tpl_vars['content_obj']->mParentId <= 0 && in_array("-1",$feuAccess)) {
				foreach($feuAccess as $k=>$v) {
					if($v=='-1') unset($feuAccess[$k]);
				}
			}
			
			// if there still is inheritance ...
			if(in_array('-1',$feuAccess)) {
				// ... finally inherit
				$feuAccess = $gCms->smarty->_tpl_vars['content_obj']->InheritParentProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,'feu_access',$feuAccess);
			}
			
			// if we have access for certain feu groups only ...
			if( !empty($feuAccess) ) {
				
				// ... deny access by default now ...
				$access = false;
				// ... check if user is logged in and belongs to a group ...
				$userId = $feusers->LoggedInId();
				if($userId && $groups = $feusers->GetMemberGroupsArray($userId)) {
					// compare users groups with selected ones
					foreach($groups as $oneGroup) {
						if(in_array($oneGroup['groupid'],$feuAccess)) {
							// if match -> grant access
							$access = true;
							break;
						}
					}
				}
			}
		}
	}

	// if we have access to the page...
	if($access) {
		echo trim($result);
	}
	else {
		
		// get the page to redirect to
		$redirectPage = $gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['redirect_page'];
		if($redirectPage == '-1')
			$redirectPage = $gCms->smarty->_tpl_vars['content_obj']->InheritParentProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,'redirect_page');
		
		// do not redirect to current page -> will result in endless recursive redirection
		if($redirectPage == $returnid || $redirectPage == $pageinfo->content_id || $redirectPage == $pageinfo->content_alias)
			$redirectPage = '';
		
		// get feu action
		$feuAction = $gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['feu_action'];
		
		if($feuAction == '-1')
			$feuAction = $gCms->smarty->_tpl_vars['content_obj']->InheritParentProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,'feu_action');
		
		// if we still don't have a redirect page -> do feu action in current page
		if($redirectPage == '') {
			
			// if we want an action (and we have not done this before) ...
			if($feuAction && $mainContent && !isset($gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['feu_action_flag'])) {
				// ... set a flag that we already have a login form now (just to prevent to display it again for other content blocks) ...
				$gCms->smarty->_tpl_vars['content_obj']->AddExtraProperty("feu_action_flag");
				$gCms->smarty->_tpl_vars['content_obj']->SetPropertyValue("feu_action_flag", true);
				// ... and finally do feu action
				return $feusers->DoAction('default', 'cntnt01', array('form'=>'login'), $returnid);
			}
			else {
				// ... otherwise just return nothing
				return;
			}
			
		}
		// else if we have a redirect page ...
		else {
			// get the redirect params
			$pattern        = '/([\w]+)=(["][^"]*["]|[\'][^\']*[\']|[^\'"\s]*)/';
			$redirectParams = $gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['redirect_params'];
			$evaluateSmarty = $gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['evaluate_smarty'];
			if($evaluateSmarty)
				$redirectParams = $this->ProcessTemplateFromData($redirectParams);
			
			$matches  = array();
			$result   = preg_match_all($pattern, $redirectParams, $matches);
			$_params1 = array();
			$_params2 = array();
			for ($i = 0; $i < count($matches[1]); $i++) {
				if(startswith($matches[2][$i],'\''))
					$matches[2][$i] = trim($matches[2][$i],'\'');
				else if(startswith($matches[2][$i],'"'))
					$matches[2][$i] = trim($matches[2][$i],'"');
				
				$_params1[$matches[1][$i]] = $matches[2][$i];
				$_params2[]                = $matches[1][$i] . '=' . $matches[2][$i];
			}
			// if we want an action ...
			if($feuAction) {
				// ... redirect to the specified page and do feu action
				return $feusers->RedirectForFrontEnd('cntnt01', $redirectPage, 'default', $_params1, false);
			}
			else {
				// ... otherwise just redirect
				$manager =& $gCms->GetHierarchyManager();
				$node    =& $manager->sureGetNodeByAlias($redirectPage);
				$content =& $node->GetContent();
				if (isset($content) && $url = $content->GetURL()) {
					if(!empty($_params1) && !empty($_params2)) {
						if($gCms->config['url_rewriting'] == 'none') {
							if($content->mDefaultContent)
								$url .= 'index.php?' . implode('&',$_params2);
							else
								$url .= '&' . implode('&',$_params2);
						}
						else if($gCms->config['url_rewriting'] == 'internal') {
							if($content->mDefaultContent)
								$url .= 'index.php/' . implode('/',$_params1) . '/' . $content->mAlias . $gCms->config['page_extension'];
							else {
								$url = str_replace($gCms->config['root_url'],
									$gCms->config['root_url'] . '/'. implode('/',$_params1),
									$url);
							}
						}
						else if($gCms->config['url_rewriting'] == 'mod_rewrite') {
							$url = str_replace($gCms->config['root_url'],
								$gCms->config['root_url'] . '/'. implode('/',$_params1),
								$url);
							if($content->mDefaultContent)
								$url .= $content->mAlias . $gCms->config['page_extension'];
						}
					}
					redirect($url);
				}
			}
		}
	}
}

?>
