<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.6
# File   : AdvancedContent.module.php
# Purpose: initial module class. this is the interface to the Module API
# License: GPL
#
#-------------------------------------------------------------------------------

class AdvancedContent extends CMSModule 
{
	/**
	 * @access private
	 * @var array
	 */
	private $_displaySettings;
	
	function AdvancedContent() 
	{
		parent::CMSModule();
		$this->RegisterContentType('Content2', dirname(__FILE__) . 
			DIRECTORY_SEPARATOR . 'contenttype.Content2.php', 'AdvancedContent');
		$this->_displaySettings = array();
	}
	
	function GetName() 
	{
		return 'AdvancedContent';
	}
	
	function GetFriendlyName() 
	{
		return $this->Lang('AdvancedContent');
	}
	
	function GetVersion() 
	{
		return '0.6';
	}
	
	function GetHelp() 
	{
		$path = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'doc' . DIRECTORY_SEPARATOR;
		if(file_exists($path . 'help_' . $this->curlang . '.html'))
			return file_get_contents($path . 'help_' . $this->curlang . '.html');
		else
			return file_get_contents($path . 'help_en_US.html');
	}
	
	function GetAuthor() 
	{
		return 'Georg Busch (NaN)';
	}
	
	function GetAuthorEmail() 
	{
		return;
	}
	
	function GetChangeLog() 
	{
		$changelog = dirname(__FILE__) . DIRECTORY_SEPARATOR . 
			'doc' . DIRECTORY_SEPARATOR . 'changelog.html';
		if(file_exists($changelog))
			return file_get_contents($changelog);
	}
	
	function HasContentType() 
	{
		return true;
	}
	
	function IsPluginModule() 
	{
		return true;
	}
	
	function HasAdmin() 
	{
		return true;
	}
	
	function GetAdminSection() 
	{
		return 'extensions';
	}
	
	function GetAdminDescription() 
	{
		return $this->lang('admindescription');
	}
	
	function VisibleToAdminUser() 
	{
		return $this->Checkpermission('Manage AdvancedContent');
	}
	
	function MinimumCMSVersion() 
	{
		return "1.8.2";
	}
	
	function MaximumCMSVersion() 
	{
		return "1.99";
	}
	
	function InstallPostMessage() 
	{
		return $this->Lang('postinstall', $this->GetVersion());
	}
	
	function UninstallPostMessage() 
	{
		return $this->Lang('postuninstall', $this->GetVersion());
	}
	
	function UninstallPreMessage() 
	{
		return $this->Lang('confirmuninstall');
	}
	
	function HandlesEvents() 
	{
		return true;
	}
	
	function DoAction($action, $id, $params, $returnid = '') 
	{
		switch($action) {
			
			case 'importpages':
				
				if(isset($params['old_type']) && isset($params['new_type'])
				&& $params['old_type'] != '' && $params['new_type'] != ''
				&& $params['new_type'] != $params['old_type']
				&& ($params['new_type'] == 'content' || $params['new_type'] == 'content2')
				&& ($params['old_type'] == 'content' || $params['old_type'] == 'content2')) 
				{
					$db =& $this->GetDb();
					$query    = "UPDATE ".cms_db_prefix()."content SET type = ? WHERE type = ?";
					$dbresult = $db->Execute($query, array($params['new_type'],$params['old_type']));
					if($dbresult) 
					{
						$message = $this->lang('success_importpages',$this->lang($params['old_type']), $this->lang($params['new_type']));
						$_params  = array(
							'new_type' => $params['new_type'], 
							'old_type' => $params['old_type'], 
							'message'  => 'success_importpages');
					}
					else 
					{
						$_params = array(
							'new_type'     => $params['new_type'], 
							'old_type'     => $params['old_type'], 
							'errormessage' => 'error_importpages');
						$errormessage = $this->lang('error_importpages',$this->lang($params['old_type']), $this->lang($params['new_type']));
					}
				}
				else 
				{
					$_params      = array('errormessage' => 'error_insufficientparams');
					$errormessage = $this->lang('error_insufficientparams', 'new_type, old_type');
				}
				
				if(isset($params['ajax'])) 
				{
					@ob_end_clean();
					@ob_start();
					if(isset($errormessage)) 
					{
						echo '<div class="pageerrorcontainer"><ul class="pageerror"><li>'. $errormessage . '</li></ul></div>';
					}
					if(isset($message)) 
					{
						echo '<div class="pagemcontainer"><p class="pagemessage">'.$message.'</p></div>';
					}
					ob_end_flush();
					exit;
				}
				$_params['submit'] = true;
				$this->Redirect($id, 'defaultadmin', $returnid, $_params);
				break;
				
			case 'default':
			case 'savePrefs':
			case 'defaultadmin':
				parent::DoAction($action, $id, $params, $returnid);
				break;
			default: break;
		}
	}
	
	function DoEvent($originator, $eventname, &$params) 
	{
		$gCms = cmsms();
		$redirect = false;
		$db =& $this->GetDb();
		// get all content of type advanced that need to be set to active/inactive
		$query = "SELECT C.content_id, C.active
			FROM " . cms_db_prefix() . "content C 
			LEFT JOIN " . cms_db_prefix() . "content_props USE_EXP
				ON USE_EXP.content_id = C.content_id
			LEFT JOIN " . cms_db_prefix() . "content_props START_DATE
				ON START_DATE.content_id = C.content_id
			LEFT JOIN " . cms_db_prefix() . "content_props END_DATE
				ON END_DATE.content_id = C.content_id
			WHERE 
				C.type = ? AND 
				USE_EXP.prop_name = ? AND 
				USE_EXP.content = ? AND (
					(
						START_DATE.prop_name = ? AND 
						START_DATE.content <= ? AND 
						END_DATE.prop_name = ? AND 
						END_DATE.content > ? AND
						C.active = ?
					)
					OR
					(
						END_DATE.prop_name = ? AND 
						END_DATE.content <= ? AND
						C.active = ?
					)
				)
			";
			
		$dbresult = $db->Execute($query, array('content2', 'use_expire_date', 
			'1', 'start_date', time(), 'end_date', time(), 0, 'end_date', 
			time(), 1));
		
		$contents = array();
		while($dbresult && $row = $dbresult->FetchRow()) 
		{
			if($row['active'])
				$contents[$row['content_id']] = 0;
			else
				$contents[$row['content_id']] = 1;
		}
		if(count($contents)) 
		{
			$gCms->smarty->clear_all_cache();
			foreach($contents as $contentId=>$active) 
			{
				$query = "UPDATE ". cms_db_prefix() . "content 
					SET active = ? WHERE content_id = ?";
				$dbresult = $db->Execute($query, array($active, $contentId));
				if($contentId == $gCms->variables['pageinfo']->content_id)
					$redirect = $contentId;
			}
		}
		if($redirect) 
		{
			$this->RedirectContent($redirect);
			return;
		}
		$access = true;
		if( $feusers =& $this->GetModuleInstance('FrontEndUsers' ) && $gCms->smarty->_tpl_vars['content_obj']->mType == 'content2') {
			$feuAccess = $this->CleanArray(explode(';',$gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['feu_access']));
			if(!empty($feuAccess)) 
			{
				// if page has no parents but inheritance -> remove inheritance (should never happen but just in case)
				if($gCms->smarty->_tpl_vars['content_obj']->mParentId <= 0 && in_array("-1",$feuAccess)) 
				{
					foreach($feuAccess as $k=>$v) 
					{
						if($v=='-1') unset($feuAccess[$k]);
					}
				}
				
				// if there still is inheritance ...
				if(in_array('-1',$feuAccess)) 
				{
					// ... finally inherit
					$feuAccess = $gCms->smarty->_tpl_vars['content_obj']->InheritParentProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,'feu_access',$feuAccess);
				}
				
				// if we have access for certain feu groups only ...
				if( !empty($feuAccess) ) 
				{
					// ... deny access by default now ...
					$access = false;
					// ... check if user is logged in and belongs to a group ...
					$userId = $feusers->LoggedInId();
					if($userId && $groups = $feusers->GetMemberGroupsArray($userId)) 
					{
						// compare users groups with selected ones
						foreach($groups as $oneGroup) 
						{
							if(in_array($oneGroup['groupid'],$feuAccess)) 
							{
								// if match -> grant access
								$access = true;
								break;
							}
						}
					}
				}
			}
		}
		if(!$access) 
		{
			// get the page to redirect to
			$redirectPage = $gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['redirect_page'];
			if($redirectPage == '-1')
				$redirectPage = $gCms->smarty->_tpl_vars['content_obj']->InheritParentProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,'redirect_page');
			
			// do not redirect to current page -> will result in endless recursive redirection
			if($redirectPage == $returnid || $redirectPage == $pageinfo->content_id || $redirectPage == $pageinfo->content_alias)
				$redirectPage = '';
			
			// get feu action
			$feuAction = $gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['feu_action'];
			
			if($feuAction == '-1')
				$feuAction = $gCms->smarty->_tpl_vars['content_obj']->InheritParentProp($gCms->smarty->_tpl_vars['content_obj']->mParentId,'feu_action');
			
			// if we still don't have a redirect page -> do feu action in current page
			if($redirectPage == '') 
			{
				// if we want an action (and we have not done this before) ...
				if($feuAction && $mainContent && !isset($gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['feu_action_flag'])) 
				{
					// ... set a flag that we already have a login form now (just to prevent to display it again for other content blocks) ...
					$gCms->smarty->_tpl_vars['content_obj']->AddExtraProperty("feu_action_flag");
					$gCms->smarty->_tpl_vars['content_obj']->SetPropertyValue("feu_action_flag", true);
					// ... and finally do feu action
					return $feusers->DoAction('default', 'cntnt01', array('form'=>'login'), $returnid);
				}
				else 
				{
					// ... otherwise just return nothing
					return;
				}
				
			}
			// else if we have a redirect page ...
			else 
			{
				// get the redirect params
				$pattern        = '/([\w]+)=(["][^"]*["]|[\'][^\']*[\']|[^\'"\s]*)/';
				$redirectParams = $gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['redirect_params'];
				$evaluateSmarty = $gCms->smarty->_tpl_vars['content_obj']->mProperties->mPropertyValues['evaluate_smarty'];
				if($evaluateSmarty)
					$redirectParams = $this->ProcessTemplateFromData($redirectParams);
				
				$matches  = array();
				$result   = preg_match_all($pattern, $redirectParams, $matches);
				$_params1 = array();
				$_params2 = array();
				for ($i = 0; $i < count($matches[1]); $i++) 
				{
					if(startswith($matches[2][$i],'\''))
						$matches[2][$i] = trim($matches[2][$i],'\'');
					else if(startswith($matches[2][$i],'"'))
						$matches[2][$i] = trim($matches[2][$i],'"');
					
					$_params1[$matches[1][$i]] = $matches[2][$i];
					$_params2[]                = $matches[1][$i] . '=' . $matches[2][$i];
				}
				// if we want an action ...
				if($feuAction) 
				{
					// ... redirect to the specified page and do feu action
					return $feusers->RedirectForFrontEnd('cntnt01', $redirectPage, 'default', $_params1, false);
				}
				else {
					// ... otherwise just redirect
					$manager =& $gCms->GetHierarchyManager();
					$node    =& $manager->sureGetNodeByAlias($redirectPage);
					$content =& $node->GetContent();
					if (isset($content) && $url = $content->GetURL()) 
					{
						if(!empty($_params1) && !empty($_params2)) {
							if($gCms->config['url_rewriting'] == 'none') 
							{
								if($content->mDefaultContent)
									$url .= 'index.php?' . implode('&',$_params2);
								else
									$url .= '&' . implode('&',$_params2);
							}
							else if($gCms->config['url_rewriting'] == 'internal') 
							{
								if($content->mDefaultContent)
									$url .= 'index.php/' . implode('/',$_params1) . '/' . $content->mAlias . $gCms->config['page_extension'];
								else 
								{
									$url = str_replace($gCms->config['root_url'],
										$gCms->config['root_url'] . '/'. implode('/',$_params1),
										$url);
								}
							}
							else if($gCms->config['url_rewriting'] == 'mod_rewrite') 
							{
								$url = str_replace($gCms->config['root_url'],
									$gCms->config['root_url'] . '/'. implode('/',$_params1),
									$url);
								if($content->mDefaultContent)
									$url .= $content->mAlias . $gCms->config['page_extension'];
							}
						}
						$this->RedirectContent($redirect);
						return;
					}
				}
			}
		}
	}
	
	/**
	* @todo: test parameterlist
	 */
	function SetParameters() 
	{
		$this->RegisterModulePlugin();
		$this->RestrictUnknownParams();
		$this->SetParameterType('uninstall_action',CLEAN_INT);
		$this->SetParameterType('redirect_page',CLEAN_INT);
		$this->SetParameterType('redirect_params',CLEAN_STRING);
		$this->SetParameterType('evaluate_smarty',CLEAN_INT);
		$this->SetParameterType('item_display',CLEAN_INT);
		$this->SetParameterType('item_type',CLEAN_STRING);
		$this->SetParameterType('content_id',CLEAN_INT);
		$this->SetParameterType('block_id',CLEAN_STRING);
		$this->SetParameterType('group_id',CLEAN_STRING);
		$this->SetParameterType('tpl_id',CLEAN_INT);
		$this->SetParameterType('ajax',CLEAN_INT);
		$this->SetParameterType('feu_action',CLEAN_INT);
		$this->SetParameterType('feu_access',CLEAN_STRING);
		$this->SetParameterType('dropdown',CLEAN_INT);
		$this->SetParameterType('default_mode',CLEAN_INT);
		$this->SetParameterType('message',CLEAN_STRING);
		$this->SetParameterType('errormessage',CLEAN_STRING);
		$this->SetParameterType('submit',CLEAN_STRING);
		$this->SetParameterType('errormessage',CLEAN_STRING);
		$this->SetParameterType('importpages',CLEAN_INT);
		$this->SetParameterType('assign',CLEAN_STRING);
		$this->SetParameterType('text',CLEAN_STRING);
		$this->SetParameterType('title',CLEAN_STRING);
		$this->SetParameterType('area',CLEAN_STRING);
		$this->SetParameterType('returnid',CLEAN_STRING);
		$this->SetParameterType('label',CLEAN_STRING);
		$this->SetParameterType('class',CLEAN_STRING);
		$this->SetParameterType('id',CLEAN_STRING);
		$this->SetParameterType('name',CLEAN_STRING);
		$this->SetParameterType('width',CLEAN_STRING);
		$this->SetParameterType('height',CLEAN_STRING);
		$this->SetParameterType('alt',CLEAN_STRING);
		$this->SetParameterType('block',CLEAN_STRING);
		$this->SetParameterType('smarty',CLEAN_STRING);
		$this->SetParameterType('type',CLEAN_STRING);
		$this->SetParameterType('block_type',CLEAN_STRING);
		$this->SetParameterType('default',CLEAN_STRING);
		$this->SetParameterType('style',CLEAN_STRING);
		$this->SetParameterType('size',CLEAN_INT);
		$this->SetParameterType('block_tab',CLEAN_STRING);
		$this->SetParameterType('page_tab',CLEAN_STRING);
		$this->SetParameterType('maxlength',CLEAN_INT);
		$this->SetParameterType('wysiwyg',CLEAN_STRING);
		$this->SetParameterType('oneline',CLEAN_STRING);
		$this->SetParameterType('mode',CLEAN_STRING);
		$this->SetParameterType('start_time',CLEAN_INT);
		$this->SetParameterType('end_time',CLEAN_INT);
		$this->SetParameterType('date_format',CLEAN_STRING);
		$this->SetParameterType('start_hour',CLEAN_INT);
		$this->SetParameterType('end_hour',CLEAN_INT);
		$this->SetParameterType('start_minute',CLEAN_STRING);
		$this->SetParameterType('end_minute',CLEAN_INT);
		$this->SetParameterType('start_seconds',CLEAN_INT);
		$this->SetParameterType('end_seconds',CLEAN_INT);
		$this->SetParameterType('show_clock',CLEAN_STRING);
		$this->SetParameterType('step_hours',CLEAN_INT);
		$this->SetParameterType('step_minutes',CLEAN_INT);
		$this->SetParameterType('step_seconds',CLEAN_INT);
		$this->SetParameterType('show24h',CLEAN_STRING);
		$this->SetParameterType('allow_none',CLEAN_STRING);
		$this->SetParameterType('delimiter',CLEAN_STRING);
		$this->SetParameterType('items',CLEAN_STRING);
		$this->SetParameterType('values',CLEAN_STRING);
		$this->SetParameterType('module',CLEAN_STRING);
		$this->SetParameterType('defaultModules',CLEAN_STRING);
		$this->SetParameterType('urlonly',CLEAN_STRING);
		$this->SetParameterType('editor_groups',CLEAN_STRING);
		$this->SetParameterType('editor_users',CLEAN_STRING);
		$this->SetParameterType('active',CLEAN_STRING);
		$this->SetParameterType('translate_labels',CLEAN_STRING);
		$this->SetParameterType('translate_values',CLEAN_STRING);
		$this->SetParameterType('block_display_settings',CLEAN_STRING);
		$this->SetParameterType('message_display_settings',CLEAN_STRING);
		$this->SetParameterType('group_display_settings',CLEAN_STRING);
		$this->SetParameterType('show_advancedcontent_options',CLEAN_INT);
	}
	
	
/**
 * -----------------------------------------------------------------------------
 * Not part of the CMSms module API
 * -----------------------------------------------------------------------------
 */
	
	
	/**
	 * function IsVarEmpty($var, $trim, $unsetEmptyIndexes)
	 * not part of the module api
	 * checks if a var is empty. id var is an array it recursivley checks all elements
	 *
	 * @param mixed $var - the var to check for empty value(s)
	 * @param boolean $trim - true to trim off spaces
	 * @param boolean $unsetEmptyIndexes - true to delete empty elements from array
	 * @return boolean - true if empty, false if not
	 */
	function IsVarEmpty(&$var, $trim = true, $unsetEmptyIndexes = false) 
	{
		if (is_array($var)) 
		{
			foreach ($var as $k=>$v) 
			{
				if (!$this->IsVarEmpty($v))
				{
					return false;
				}
				else 
				{
					if($unsetEmptyIndexes)
						unset($var[$k]);
					return true;
				}
			}
		}
		else if($trim && trim($var) == '') 
		{
			return true;
		}
		else if($var == '') 
		{
			return true;
		}
		return false;
	}
	
	
	/**
	 * function CleanArray($array)
	 * not part of the module api
	 * removes empty elements from an array 
	 * (can be useful when using function explode to create the array of a csv)
	 *
	 * @param array $array - the array to clean up
	 * @return array - an array without empty elements or an empty array
	 */
	function CleanArray($array) 
	{
		if (is_array($array)) 
		{
			foreach ($array as $k=>$v) 
			{
				if ($this->IsVarEmpty($v,true,true)) 
				{
					unset($array[$k]);
				}
				else 
				{
					if(is_array($v)) 
					{
						$v = $this->CleanArray($v);
						if($this->IsVarEmpty($v,true,true))
							unset($array[$k]);
						else
							$array[$k] = $v;
					}
				}
			}
			return $array;
		}
		return array();
	}
	
	
	/**
	 * function GetPages()
	 * not part of the module api
	 * gets all pages to list in a dropdown
	 *
	 * @return array - a set of pages
	 */
	function GetPages() 
	{
		$db =& $this->GetDb();
		$query = "SELECT C.active, C.type, C.content_id, C.hierarchy, C.menu_text, CP.content FROM " . cms_db_prefix() . "content C 
			LEFT JOIN " . cms_db_prefix() . "content_props CP ON CP.content_id = C.content_id AND CP.prop_name = ? 
			ORDER BY hierarchy";
		$dbresult = $db->Execute($query, array('feu_access'));
		if(!$pages = $dbresult->GetArray())
			return array();
		return $pages;
	}
	
	
	/**
	 * function CreateRedirectDropdown()
	 * not part of the module api
	 * this creates a dropdown of pages including only pages of type content but
	 * excluding the current page and pages that may only be accessed by frontend users
	 *
	 * @return string - HTML select element with options
	 */
	function CreateRedirectDropdown($id = '', $name = 'redirect_page', $selectedPage = '', $currentPage = '') 
	{
		$pages      = $this->GetPages();
		$dropdown   = '<select name="'.$id.$name.'" >';
		$dropdown  .= '<option value=""' . ($selectedPage == ''?' selected="selected"':'') . '>' . lang('none') . '</option>';
		$dropdown  .= '<option value="-1"' . ($selectedPage == '-1'?' selected="selected"':'') . '>' . $this->lang('inherit_from_parent') . '</option>';
		$contentops =& cmsms()->GetContentOperations();
		foreach($pages as $page) 
		{
			$disabled = '';
			// don't redirect to pages with no public access, invalid content type, inactive or same content id
			if($page['active'] != 1 || $page['content']>0 || $page['content_id'] == $currentPage || ($page['type'] != 'content' && $page['type'] != 'content2'))
				$disabled = ' disabled="disabled"';
			
			$dropdown .= '<option'. $disabled .' value="' . $page['content_id'] . '" ' . 
				($selectedPage == $page['content_id'] && $disabled == ''?'selected="selected"':'') . '>' . 
				$contentops->CreateFriendlyHierarchyPosition($page['hierarchy']) . 
				' - ' . $page['menu_text'] . ($disabled != ''?' (' . $this->lang('invalid') . ')':'') . '</option>';
		}
		$dropdown .= '</select>';
		return $dropdown;
	}
	
	
	/**
	 * function IsTrue($value)
	 * not part of the module api
	 * checks if a value is literally "true"
	 * can be usefull when checking smarty params for the value true
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsTrue($value) 
	{
		return (strtolower($value) === 'true' || $value === 1 || $value === '1' || $value === true);
	}
	
	
	/**
	 * function IsFalse($value)
	 * not part of the module api
	 * checks if a value is literally "false"
	 * can be usefull when checking smarty params for the value false
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsFalse($value) 
	{
		return (strtolower($value) === 'false' || $value === '0' || $value === 0 || $value === false || $value === '');
	}
	
	
	/**
	 * saves the display status of content blocks, content blocks messages and block groups
	 *
	 * @param int $content_id - the id of the content where to set the display status
	 * @param int $template_id - the id of the template where to set the display status
	 * @param string $block_id - the content block to toggle the block itself or the message/group
	 * @param int $display - 0 to hide, 1 to show
	 *
	 */
	function SetItemDisplay($item_type, $item_id, $content_id, $template_id, $display) 
	{
		$db =& $this->GetDb();
		$query = "SELECT item_display FROM ". cms_db_prefix() . "module_AdvancedContent_".$item_type."display
			WHERE user_id = ? AND item_id = ? AND ";
		
		$q = array();
		$p = array(get_userid(), $item_id);
		
		if($content_id 
		&& ($this->GetPreference($item_type.'_display_settings','content') == 'content'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both2')) 
		{
			$q[] = "content_id = ?";
			$p[] = $content_id;
		}
		
		if($template_id > 0 
		&& ($this->GetPreference($item_type.'_display_settings','content') == 'template'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both2')) 
		{
			$q[] = "template_id = ?";
			$p[] = $template_id;
		}
		
		if(!count($q)) {
			return;
		}
		
		if($this->GetPreference($item_type.'_display_settings','content') == 'both1') 
		{
			$query .= "(" . implode(" OR ",$q) . ")";
		}
		else if($this->GetPreference($item_type.'_display_settings','content') == 'both2') 
		{
			$query .= "(" . implode(" AND ",$q) . ")";
		}
		else 
		{
			$query .= $q[0];
		}
		
		$dbresult = $db->Execute($query, $p);
		if($dbresult && $row = $dbresult->FetchRow()) {
			echo $display;
			array_unshift($p,$display);
			$query = "UPDATE ". cms_db_prefix() . "module_AdvancedContent_".$item_type."display 
				SET item_display = ? WHERE user_id = ? AND item_id = ? AND ".implode(' AND ',$q);
			$dbresult = $db->Execute($query, $p);
		}
		else 
		{
			$query = "INSERT INTO ". cms_db_prefix() ."module_AdvancedContent_".$item_type."display 
				(user_id, content_id, template_id, item_id, item_display) VALUES (?,?,?,?,?)";
			$dbresult = $db->Execute($query, array(get_userid(), $content_id, $template_id, $item_id, $display));
		}
		$this->_displaySettings[$item_type][implode('_',array($content_id,$template_id))][$item_id] = $display;
	}
	
	
	/**
	 * gets the display status of content blocks, content blocks messages or block groups
	 *
	 * @param int $item_type - the id of the content/template to get the display status from
	 * @param int $tpl_or_content_id - the id of the content/template to get the display status from
	 * @param string $block_id - the content block to get the display status from
	 * @param int $default_value - the default status if nothing is found
	 *
	 * @return boolean - 0 = hidden, 1 = shown
	 */
	function GetItemDisplay($item_type, $item_id, $content_id, $template_id, $default_value = 1) 
	{
		$ids = array();
		
		if($content_id
		&& ($this->GetPreference($item_type.'_display_settings','content') == 'content'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both2')) 
		{
			$ids[] = $content_id;
		}
		
		if($template_id > 0 
		&& ($this->GetPreference($item_type.'_display_settings','content') == 'template'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both2')) 
		{
			$ids[] = $template_id;
		}
		
		if(!count($ids))
			return $default_value;
		
		debug_buffer($this->_displaySettings,'AdvancedContent display settings');
		if(!isset($this->_displaySettings[$item_type][implode('_',$ids)]))
			$this->GetAllItemsDisplay($item_type, $content_id, $template_id);
		debug_buffer($this->_displaySettings,'AdvancedContent display settings');
		if(!isset($this->_displaySettings[$item_type][implode('_',$ids)][$item_id]))
			$this->_displaySettings[$item_type][implode('_',$ids)][$item_id] = $default_value;
		debug_buffer($this->_displaySettings,'AdvancedContent display settings');
		return $this->_displaySettings[$item_type][implode('_',$ids)][$item_id];
	}
	
	
	/**
	 * gets the display status of all content blocks, content blocks messages or block groups of a given template or content id
	 * @access private
	 * @ignore
	 */
	private function GetAllItemsDisplay($item_type, $content_id, $template_id) 
	{
		$db =& $this->GetDb();
		$query = "SELECT * FROM ". cms_db_prefix() . "module_AdvancedContent_".$item_type."display 
			WHERE user_id = ? AND ";
		
		$q = array();
		$p = array(get_userid());
		
		if($content_id 
		&& ($this->GetPreference($item_type.'_display_settings','content') == 'content'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both2')) 
		{
			$q[] = "content_id = ?";
			$p[] = $content_id;
		}
		
		if($template_id > 0 
		&& ($this->GetPreference($item_type.'_display_settings','content') == 'template'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both1'
		|| $this->GetPreference($item_type.'_display_settings','content') == 'both2')) 
		{
			$q[] = "template_id = ?";
			$p[] = $template_id;
		}
		
		if(!count($q)) 
		{
			return;
		}
		
		if($this->GetPreference($item_type.'_display_settings','content') == 'both1') 
		{
			$query .= "(" . implode(" OR ",$q) . ")";
		}
		else if($this->GetPreference($item_type.'_display_settings','content') == 'both2')
		{
			$query .= "(" . implode(" AND ",$q) . ")";
		}
		else 
		{
			$query .= $q[0];
		}
		$dbresult = $db->Execute($query, $p);
		while($dbresult && $row = $dbresult->FetchRow()) {
			if($this->GetPreference($item_type.'_display_settings','content') == 'both1'
			|| $this->GetPreference($item_type.'_display_settings','content') == 'both2') 
			{
				$this->_displaySettings[$item_type][$row['content_id'] . '_' . $row['template_id']][$row['item_id']] = $row['item_display'];
			}
			else 
			{
				$this->_displaySettings[$item_type][$row[$this->GetPreference($item_type.'_display_settings','content').'_id']][$row['item_id']] = $row['item_display'];
			}
		}
	}
}
?>
