<?php
// Encryption Function
function NB_Encryption($string, $key){
   $TD = mcrypt_module_open('tripledes', '', 'ecb', '');
   $IV = mcrypt_create_iv (mcrypt_enc_get_iv_size($TD), MCRYPT_RAND);
   mcrypt_generic_init($TD, $key, $IV);
   $encrypted_data = mcrypt_generic($TD, $string);
   mcrypt_generic_deinit($TD);
   mcrypt_module_close($TD);
   return $encrypted_data;
}

// Basic Setup
global $gCms;
global $CMS_VERSION;
$db =& $gCms->db;
$config =& $gCms->GetConfig();
$modules = array_keys($gCms->modules);
$core_modules = array('CMSMailer', 'FileManager', 'MenuManager', 'ModuleManager', 'News', 'nuSOAP', 'Printing', 'Search', 'News', 'ThemeManager', 'TinyMCE');
$admin_url = $config['root_url'].'/'.$config['admin_dir'];
$updatable = 'black';

// nuSOAP Setup
$nusoap =& CMSModule::GetModuleInstance('nuSOAP');
$nusoap->Load();
$url = 'http://modules.cmsmadesimple.org/soap.php?module=ModuleRepository';
$nu_soapclient =& new nu_soapclient($url,false,false,false,false,false,90,90);
if($err = $nu_soapclient->GetError() ){echo $err;}
$qparms = array();
$qparms['names'] = implode(',',$modules);
$qparms['newest'] = 1;
$qparms['clientcmsversion'] = $CMS_VERSION;
$allmoduledetails = $nu_soapclient->call('ModuleRepository.soap_upgradelistgetall',$qparms);

// Password query
$query = "SELECT * FROM ".cms_db_prefix()."siteprefs WHERE sitepref_name LIKE 'SimpleSiteInfo%'";
$dbresult = $db->Execute($query);
$row = $dbresult->FetchRow();
$version_file_pwd = $row['sitepref_value'];

// CMSMS Version Check
$cmsms_version_check_url = "http://dev.cmsmadesimple.org/latest_version.php";
$txt = @file_get_contents($cmsms_version_check_url);
if( $txt !== FALSE ){
   $parts = explode(':',$txt);
   if( is_array($parts) && strtolower($parts[0]) == 'cmsmadesimple' ){
      $latest_cmsms_ver = $parts[1];
   }
}

// Output File Setup
$create_write = @fopen(($gCms->config["root_path"] . "/tmp/siteinfo.txt"), 'w') or die("ERROR set_version_file UDT: Can't create or open version file!!");

// Output Start
$file_out  = "CMSMS*" . $CMS_VERSION . "*" . $latest_cmsms_ver . "*\n"; 
$file_out .= $admin_url . "*\n"; 
$file_out .= "<table>\n<tbody>\n";
$file_out .= "<tr><th colspan='3'>Core Modules</th></tr>\n";
$file_out .= "<tr><th colspan='3'>&nbsp;</th></tr>\n";
$file_out .= "<tr><th>Module</th><th>Installed Version</th><th>Forge Version</th></tr>\n";

// Module Query - Core Modules minus TinyMCE
$query = "SELECT * FROM ".cms_db_prefix()."modules WHERE active=1 ORDER BY module_name ASC";
$dbresult = $db->Execute($query);

while($dbresult && $row = $dbresult->FetchRow()) {
   // Core Modules 
   if (in_array($row['module_name'], $core_modules) && $row['module_name']!='TinyMCE') {
      $file_out .= "<tr><td>".$row['module_name']."</td><td>".$row['version']."</td><td>".$row['version']."</td></tr>\n";
   }
}

// Module Query - TinyMCE
$query = "SELECT * FROM ".cms_db_prefix()."modules WHERE module_name='TinyMCE' ORDER BY module_name ASC";
$dbresult = $db->Execute($query);

while($dbresult && $row = $dbresult->FetchRow()) {
   // TinyMCE 
   $file_out .= "<tr><td>".$row['module_name']."</td><td>".$row['version']."</td><td>";
   foreach($allmoduledetails as $key=>$module) {
      if($module['name']===$row['module_name']) {

	   if(version_compare($row['version'], $module['version']) >= 0) {
         // if($module['version']===$row['version']) {
            $file_out .= $module['version']."</td></tr>\n";
         } else {
            $updatable = 'red';
            $file_out .= "<span style='font-weight:bold;color:red;'>".$module['version']."</span></td></tr>\n";
         }
      }
   }
}

$file_out .= "<tr><th colspan='3'>&nbsp;</th></tr>\n";
$file_out .= "<tr><th colspan='3'>Additional Modules</th></tr>\n";
$file_out .= "<tr><th colspan='3'>&nbsp;</th></tr>\n";
$file_out .= "<tr><th>Module</th><th>Installed Version</th><th>Forge Version</th></tr>\n";

// Module Query - Additional Modules
$query = "SELECT * FROM ".cms_db_prefix()."modules WHERE active=1 ORDER BY module_name ASC";
$dbresult = $db->Execute($query);

while($dbresult && $row = $dbresult->FetchRow()) {
   // Additional Modules  
   if (!in_array($row['module_name'], $core_modules)) {
      $file_out .= "<tr><td>".$row['module_name']."</td><td>".$row['version']."</td><td>";
      foreach($allmoduledetails as $key=>$module) {
         if($module['name']===$row['module_name']) {
	      if(version_compare($row['version'], $module['version']) >= 0) {
            // if($module['version']===$row['version']) {
               $file_out .= $module['version']."</td></tr>\n";
         	} else {
               $updatable = 'red';
               $file_out .= "<span style='font-weight:bold;color:red;'>".$module['version']."</span></td></tr>\n";
            }
         }
      }
   }
}

$file_out  .= "</tbody>\n</table>*\n";
$file_out  .= $updatable;

$file_enc = NB_Encryption($file_out,$version_file_pwd);

fwrite($create_write, $file_enc);
fclose($create_write);
?>


