<?php

if (!isset($gCms)) exit;

if (!$this->CheckAccess()) {
	return $this->DisplayErrorPage();
}

$c = new MCFCriteria();
$c->addAscendingOrderByColumn('module_name');
$modules = MCFModule::doSelect($c);
$rows = array();
foreach ($modules as $module) {
	$rows[] = array(
		'title' => $this->CreateLink($id, 'edit', $returnid, $module->getModuleName(), array('module_id' => $module->getId()), '', false, false, 'class="itemlink"'),
		'module_friendlyname' => $module->getModuleFriendlyName(),
		'delete' => $this->CreateLink($id, 'delete', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', 'Delete', '', '', 'systemicon'), array('module_id' => $module->getId()), 'Are you sure you want to delete this module?\n\n(No files will be deleted but the module will no longer be editable.)'),
		'edit' => $this->CreateLink($id, 'edit', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', 'Edit', '', '', 'systemicon'), array('module_id' => $module->getId())),
		'publish' => $this->CreateLink($id, 'publish', $returnid, $this->DisplayImage('wand.png', 'Publish'), array('module_id' => $module->getId())),
		'view' =>
		  	'<a href="moduleinterface.php?sp_='.$_REQUEST['sp_'].'&module='.$module->getModuleName().'">'.
			$gCms->variables['admintheme']->DisplayImage('icons/system/view.gif', 'View', '', '', 'systemicon')
			.'</a>'
	);
}

$this->smarty->assign('rows', $rows);
$this->smarty->assign('add', $this->CreateLink($id, 'edit', '', 'Create new module'));
$this->smarty->assign('add_icon', $this->CreateLink($id, 'edit', '', $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('title_create_module'), '', '', 'systemicon')));

echo $this->ProcessTemplate('defaultadmin.tpl');

?>