<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess())
{
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

  /*
   * 
   * Edit Option Title
   * 
   * This is to allow titles to be tweaked
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */
if (isset($params['option_id']) && $params['option_id'] != '')
{
  $option = MX_Option::retrieveByPk($params['option_id']);
}
elseif(isset($params['category_id']))
{
	$option = new MX_Option(); 
	$option->setCategoryId($params['category_id']);
}

if (isset($params['cancel']))
{
  $this->Redirect($id, 'manageCategory', $returnid, array('category_id' => $option->getCategoryId()));
}

  
if (isset($params['submit']) || isset($params['apply']))
{
  $option->setTitle($params['title']);
  $option->save(); 
  if (isset($params['submit']))
  {
  	$this->Redirect($id, 'manageCategory', $returnid, array('category_id' => $option->getCategoryId()));
  }
}

  if (isset($params['mx_action']))
  {
    switch ($params['mx_action'])
    {
      case 'delete':
        $option->delete();
        echo 'Option deleted';
        break;
      case 'move_up':
        $option->moveUp();
        echo 'Option moved up';
        break;
      case 'move_down':
        echo 'Option moved down';
        $option->moveDown();
        break;
    }
    
    $this->Redirect($id, 'manageCategory', $returnid, array('category_id' => $option->getCategoryId()));
  }  

$this->smarty->assign('option_id', $this->CreateInputHidden($id, 'option_id', $option->getId()));
$this->smarty->assign('category_id', $this->CreateInputHidden($id, 'category_id', $option->getCategoryId()));
$this->smarty->assign('title', $this->lang('add_option_for') . ' ' .$option->getCategory()->getTitle() );
$this->smarty->assign('edit_title', $this->lang('title_option_name'));
$this->smarty->assign('edit_title_input', $this->CreateInputText($id, 'title', $option->getTitle(), 50));

$this->smarty->assign('form_start',$this->CreateFormStart($id, 'manageOption', $returnid));
$this->smarty->assign('form_submit',$this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));         
$this->smarty->assign('form_apply',$this->CreateInputSubmit($id, 'apply', $this->Lang('apply')));         
  $this->smarty->assign('form_cancel', $this->CreateInputSubmit($id, 'cancel', $this->lang('cancel')));
$this->smarty->assign('form_end',$this->CreateFormEnd());

echo $this->ProcessTemplate('admin.manageOption.tpl');
