<?php
if (!isset($gCms)) exit;

/*
 * This capture the options list for a category
 */

$options = array();

if (isset($params['category_id']))
{
	$category = MX_Category::retrieveByPk($params['category_id']);
	
	if ($category)
	{
		$request = array();
		
		if (isset($params['order_by']))
		{
			switch ($params['order_by'])
			{
				case 'title asc':
					$request['order_by'] = 'title asc';
					break;
				case 'title desc':
					$request['order_by'] = 'title desc';
					break;
				default:
					break;
			}
		}

		if (isset($params['related_module']))
		{
	        $where = array(
   			   'where' => array (
   			                     'rel_code' => 'options',
   			                     'modulename' => $params['related_module'] 
   			             )
   			);

   			if (isset($params['related_module_id']))
   			{
   			   $where['where']['module_id'] = $params['related_module_id'];
   			}

   			$related_links = MX_RelationLink::doSelect($where);

			$in = array();
			
			foreach ($related_links as $related_link)
			{
				$in[] = $related_link->getLeftModuleId();
			}
			
			$request['where_in']['id'] = array_unique($in);
		}
	
		$options = $category->getOptions($request);
		
		if (isset($params['assign_to']))
		{
		  $this->smarty->assign($params['assign_to'], $options);
		}
		else
		{
			echo '<p class="debug">You maybe need to define the assigned smarty tag ?</p>';	
		}
	}
	else 
	{
		  echo '<p class="debug">Category not found</p>'; 
	}
}
else
{
	echo '<p class="debug">You maybe need to define a category id ?</p>';
}
