<?php
  
  /*
   * Xtended Module class
   * 
   * This class allow management of an extended module object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_XtendedModule extends CmsObject 
{
  // Vars

  var $modulename;
  var $installed;
  var $isactive;
  var $xtendversion;
  var $modulefriendlyname;
  var $options = array();
  
  var $loaded = false;
	
	const DB_NAME  = 'module_modulextender_xtendedmodules';

	public function __construct($modulename = null)
	{
		if ($modulename)
		{
			$this->modulename = $modulename;
			$this->load();
		}
	}
	
	
  public function __toString()
  {
    return $this->getModuleName();
  } 
	
  public function getModuleName()
  {
  	return $this->modulename;
  }

  public function getTitle()
  {
	  return $this->getModuleFriendlyName();
  }
  
  public function getItems()
  {  
    return MX_ModuleItem::loadFromArray(call_user_func(array($this->getModuleName() . 'Object', 'getTitles')), $this->getModuleName());
  }
	
  public function setModuleName($modulename)
  {
    $this->modulename = $modulename;
  }
  
  public function getInstalled()
  {
    return $this->installed;
  }
  
  public function setInstalled($installed)
  {
    $this->installed = $installed;
  }
  
  public function getIsActive()
  {
    return $this->isactive;
  }
  
  public function getXtendVersion()
  {
    return $this->xtendversion;
  }
  
  public function getModuleFriendlyName()
  {
    return $this->modulefriendlyname;
  }
    
  public function setIsActive($value)
  {
     $this->isactive = $value;
  }
  
  public function setXtendVersion($value)
  {
     $this->xtendversion = $value;
  }
  
  public function setModuleFriendlyName($value)
  {
     $this->modulefriendlyname = $value;
  }    
  
  public function getOptions($toString = false)
  {  	
  	if ($toString)
  	{
  		return $this->optionsToString();
  	}
  	else
  	{
  		return $this->options;
  	}
  }
  
  public function getRelations()
  {
  	return MX_Relation::doSelect(array('where' => array('modulename' => $this->modulename)));
  }
  
  public function setRelation($relation_type, $relation_id)
  {  	
  	if (!MX_Relation::relationExists($this->getModuleName(), $relation_type, $relation_id))
  	{
	  	$relation = new MX_Relation();
	    $relation->setModuleName($this->getModuleName());
	    $relation->setRelatedId($relation_id);
	    
	  	switch ($relation_type)
	  	{
	  		case 'page':
	  	   $relation->setType('page');		  	   
	  	   $relation->save();
	  	   break;
	  		case 'category':
	  		  $relation->setType('category');
	  		  $relation->save();
	  		  break;
	  		case 'module':
	  		  $relation->setType('module');
	  		  $relation->save();
	  		  break;
        default:
          break;
	  	}
  	}
  }
  
  public function setOptions($options)
  {
  	if (is_array($options))
  	{
  		$this->options = $options;
  	}
  	else
  	{
  		$options = str_replace('][', ',', $options);
  		$options = str_replace(']', '', $options);
  		$options = str_replace('[', '', $options);  		
  		if ($options != null)
  		{
  			$this->options = explode(',', $options);
  		}
  		else
  		{
  			$this->options = array();  		
  		}
  	}
  }
  
  public function optionsToString()
  {
  	if (count($this->options) > 0)
  	{
  		return '[' . implode('][', $this->options) . ']';
  	}
  	else
  	{
  		return null;
  	}
  }
  
  public function optionExists($option_name)
  {
  	if (array_search($option_name, $this->options) === false)
  	{
  		return false;
  	}
  	else
  	{
  		return true;
  	}
  }
  
  public function optionChange($option_name)
  {
     if (($option_id = array_search($option_name, $this->options)) === false)
    {
      $this->options[] = $option_name;
    }
    else
    {
      unset($this->options[$option_id]);
    }
  }
  
  public function setOption($option_name)
  {
    if (($option_id = array_search($option_name, $this->options)) === false)
    {
      $this->options[] = $option_name;
    }
  }
  
  public function unsetOption($option_name)
  {
    if (($option_id = array_search($option_name, $this->options)) !== false)
    {
     unset($this->options[$option_id]);
     return true;
    }
    else
    {
      return false;
    }
  }
    
  	
	public function load()
	{
		
    $db =& $this->GetDb();
    
		$query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME . ' WHERE modulename = ? LIMIT 1';
		
		$dbresult = $db->Execute($query, array($this->modulename));
		
	   if ($dbresult && $dbresult->RecordCount() > 0)
      {
      	$this->loaded = true;
        while ($dbresult && $row = $dbresult->FetchRow())
        {
          $this->PopulateFromDb($row);
        }
      }
	}
	
	public function PopulateFromDb($row)
	{
		  $this->modulename = $row['modulename'];
		  $this->installed = $row['installed'];
		  $this->isactive = $row['isactive'];
		  $this->xtendversion = $row['xtendversion'];
		  $this->modulefriendlyname = $row['modulefriendlyname'];
		  $this->setOptions($row['options']);
	}
	
  public function save()
  {
    // Upgrade or Insert ?    
    if ($module = self::retrieveByPk($this->getModuleName()))
    {
      $this->update();
    }
    else 
    {     
        $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= ' installed = ?,  isactive = ?,  xtendversion = ?,  modulefriendlyname = ?,  options = ?';
      
      $query .= '
      
      WHERE
      
      modulename = ?  ';
      
      $result = $db->Execute($query,
          array(
             $this->installed,
             $this->isactive,
             $this->xtendversion,
             $this->modulefriendlyname,
             $this->getOptions(true),
             $this->getModuleName()
          )
        );        
        
        /*FIXME: Test the $db status; */
        
        return true;
  }
  
  protected function insert()
  {
    $db =& $this->GetDb();
        
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET  modulename = ?,  ';
    
    $query .= ' installed = ?,  isactive = ?,  xtendversion = ?,  modulefriendlyname = ?,  options = ?';
     
       $db->Execute($query,
          array(
             $this->getModuleName(),
             $this->installed,
             $this->isactive,
             $this->xtendversion,
             $this->modulefriendlyname,
             $this->getOptions(true),
          )
        );

        return true;    
  }
  
  public function delete()
  {
  	 $db =& $this->GetDb();

    $query = "DELETE FROM ".cms_db_prefix().  self::DB_NAME . " WHERE modulename = ?";

    $dbresult = $db->Execute($query, array($this->modulename));
  }
  
  public function isLoaded()
  {
  	return $this->loaded;
  }
  
  public static function retrieveByPk($modulename)
  {
  	return self::doSelectOne(array('where' => array('modulename' => $modulename)));  	 
  }
  
  public static function doSelect($params = array())
  {
    $instance = new self();

    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;;
    
    $values = array();
    
    if (isset($params['where']))
    {

      $fields = array();
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
      
      $query .= ' WHERE ' . implode(' AND ', $fields);
    } 
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
    	$query .= ' ORDER BY modulename';
    }
    
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {
        $item = new self();
        $item->PopulateFromDb($row);
        $items[] = $item;
      }
    }
    
    return  $items;   
  }
  
  public static function doSelectOne($params = array())
  {
  	$items = self::doSelect($params);

  	if (count($items))
  	{
  		return $items[0];
  	}
  	else
  	{
  		return null;
  	}
  }

  
  public static function doSelectByModuleName($params = array())
  {
  	$modules = self::doSelect($params);
  	
  	$returned_modules = array();
  	
  	foreach ($modules as $module)
  	{
  		$returned_modules[$module->getModuleName()] = $module;
  	}
  	return $returned_modules;
  }
  
	public static function lab()
	{
		$self = new CmsObject();
		var_dump($self->getConfig());
		return 'test';
	}

	public static function preloadRelatedItems($module_name, $module_ids)
	{
		// Preloading system
		if (is_array($module_ids))
		{
			MX_Document::doLoadRelated($module_name, $module_ids);
			// MX_Image: Useless, done by MX_Document			
			MX_Link::doLoadRelated($module_name, $module_ids);
			MX_RelationLink::doLoadRelated($module_name,$module_ids);
			MX_RelationLink::doLoadRelated($module_name,$module_ids, null, 'items');
		}
	}

    public static function getRelatedItems($modulename, $moduleid)
    {	
		// Init
		
		global $gCms;
		$module =& $gCms->modules['ModuleXtender']['object'];
		$config = $module->getConfig();		
      	$relations = new stdClass();
      
     	//UNOPT.$relations->documents = MX_Document::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid, 'type' => 'document')));
		$documents = MX_Document::doSelectRelated($modulename,$moduleid,'document');
      	//UNOPT.$relations->images = MX_Image::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid, 'type' =>'image')));
		$images = MX_Image::doSelectRelated($modulename,$moduleid,'image');

		//UNOPT.$relations->links = MX_Link::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid)));
        $links = MX_Link::doSelectRelated($modulename, $moduleid);
      
		//UNOPT. $pages = MX_RelationLink::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid, 'rel_code' => 'pages')));
  	 	$pages = MX_RelationLink::doSelectRelated($modulename, $moduleid, 'pages');
		$pages_array = array();
			 foreach ($pages as $related_module)
			 {
			   $pages_array[] = $related_module->getRelation();
			 }      
			$relations->pages = $pages_array;
		
		//UNOPT.$categories = MX_RelationLink::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid, 'rel_code' => 'options')));  
		$categories = MX_RelationLink::doSelectRelated($modulename, $moduleid, 'options');
		$categories_array = array();
		foreach ($categories as $related_module)
		{
		  $option = $related_module->getRelation();
		  if (is_object($option)) $categories_array[$option->getCategory()->getTitle()][] = $option; 
		}      
		$relations->categories = $categories_array;
      	//UNOPT. $modules = MX_RelationLink::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $moduleid, 'type' => 'items')));  
		$modules = MX_RelationLink::doSelectRelated($modulename, $moduleid, 'items');
		//ar_dump($relations->modules);
      	//UNOPT.
		$target_modules = MX_RelationLink::doSelect(array('where' => array('rel_code' => $modulename, 'rel_id' => $moduleid, 'type' => 'items'))); 
    
			
			// Post treatment

			$relations->documents = array();
			foreach ($documents as $document)
			{
				$doc = $document;
			    $doc->url = $document->getUrl($module->config['uploads_url']);
			    $doc->categories = MX_RelatedCategory::getRelatedOptions($document->getId(), 'documents');
				$relations->documents[] = $doc;
			}

			$relations->images = array();
			foreach ($images as $document)
	      	{
				$doc = $document;
				$doc->categories = MX_RelatedCategory::getRelatedOptions($document->getId(), 'images');
	        	$doc->url = $document->getUrl($module->config['uploads_url']);
	        	$doc->image = $document->url;
	        	// TODO $doc->image_path = $document->url;
	        	$doc->thubnails = $document->getUrl($config['uploads_url'], 'images/thumbnails');   
	      		$doc->resized_images = $document->getThumbnailsUrl($document->getUrl($config['uploads_url'], 'images', false));
	      		// TODO $doc->resized_images_path = $document->getThumbnailsPath($document->getUrl($config['uploads_url'], 'images', false));
				$relations->images[] = $doc;
	      	}
	
			$relations->links = array();
			foreach ($links as $link)
			{
				$lnk = $link;
	         	$lnk->categories = MX_RelatedCategory::getRelatedOptions($link->getId(), 'links');
				$relations->links[] = $lnk;
			}
						
			 $modules_array = array();
			 foreach ($modules as $related_module)
			 {
			   $modules_array[] = $related_module->getRelation();
			 }      
			 $relations->modules = $modules_array;
			
			$target_modules_array = array();
			 foreach ($target_modules as $related_module)
			 {
			   $modules_array[] = $related_module->getRelation();
			 }      
			 $relations->target_modules = $target_modules_array;
			
			
		// Deprecated
		
			
		if ($module->getPreference('load_deprecated_features') == 'true')
		{
			
		//	$module->smarty->assign('listmode', $listmode);
			
			    if (count($relations->documents) > 0)
			    {
			      $module->smarty->assign('XtenderDocuments', $relations->documents);// TODO: To be removed
			      $relations->documentscontent = $module->ProcessTemplateFromDatabase($module->GetPreference('fe.documents'));
			      $module->smarty->assign('XtenderDocumentslist', $relations->documentscontent);
			    }
			    else
			    {
			      $relations->documentscontent = '';
			    }
			
			   if (count($relations->images) > 0)
			   {
			     $module->smarty->assign('XtenderImages', $relations->images);// TODO: To be removed
			     $relations->imagescontent  =  $module->ProcessTemplateFromDatabase($module->GetPreference('fe.images'));
			     $module->smarty->assign('XtenderImageslist', $relations->imagescontent);
			   }
			   else
			   {
			     $relations->imagescontent = '';
			   }
			
					$relations->pages = $module->pages->GetPagesList($modulename, $moduleid);
			
					if (count($relations->pages) > 0)
			    {
			      $module->smarty->assign('XtenderPages', $relations->pages);// TODO: To be removed
			      $relations->pagescontent  =  $module->ProcessTemplateFromDatabase($module->GetPreference('fe.pages'));
			      $module->smarty->assign('XtenderPageslist', $relations->pagescontent);
			    }
			    else
			    {
			      $relations->pagescontent = '';
			    }
			
					$relations->categories = $module->categories->GetCategoriesList($modulename, $moduleid);
			
					 if (count($relations->categories) > 0)
				    {
				      $module->smarty->assign('XtenderCategories', $relations->categories); // TODO: To be removed
				      $relations->categoriescontent  =  $module->ProcessTemplateFromDatabase($module->GetPreference('fe.categories'));
				      $module->smarty->assign('XtenderCategorieslist', $relations->categoriescontent);
				    }
				    else
				    {
				      $relations->categoriescontent = '';
				    }
			
					$relations->general = $module->ProcessTemplateFromDatabase($module->GetPreference('fe.general'));

		}

  		return $relations;
    }
}

?>