<?php
  
  /*
   * Relation class
   * 
   * This class allow management of a relation object
   * 
   * 
   * Copyrights: Morris & Chapman Belgium - Jean-Christophe Cuvelier - 2009
   * 
   */

class MX_Link extends CmsObject 
{
  // Vars

	var $id;
	
	var $modulename;
	var $module_id;
	
  var $title;
  var $url;
  var $is_new_window;  
  
  var $position;
 
	const DB_NAME  = 'module_modulextender_links';

	public function __construct()
	{

	}
	
	
  public function __toString()
  {
    return $this->getTitle();
  } 
		
	// Common
	public function getId()
	{
		return $this->id;
	}
	
	 public function setId($id)
  {
    $this->id = $id;
  }
  	
	public function getModuleName()
	{
		return $this->modulename;
	}

	public function setModuleName($modulename)
	{
		$this->modulename = $modulename;
	}
	
	public function getModuleId()
	{
		return $this->module_id;
	}

	public function setModuleId($module_id)
	{
		$this->module_id = $module_id;
	}
	
	public function getTitle()
	{
		return $this->title;
	}
	
	public function setTitle($title)
	{
		$this->title = $title; 
	}
	
	public function getUrl()
	{
		return $this->url;
	}
	
	public function setUrl($value)
	{
		$this->url = $value; 
	}
	
	public function getIsNewWindow()
	{
		return $this->is_new_window;
	}
	
	public function setIsNewWindow($value)
	{
		$this->is_new_window = $value; 
	}
	
	public function getPosition()
	{
		if ($this->position != '')
		{
			return $this->position;
		}
		else
		{
			return self::retrieveNextPosition($this->modulename, $this->module_id);
		}
	}

	public static function retrieveNextPosition($modulename, $module_id)
	{
		$last_document = self::doSelectOne(array('where' => array('modulename' => $modulename, 'module_id' => $module_id), 'order_by' => array('position desc')));
		
		if ($last_document)
		{
			return $last_document->getPosition()+1;
		}
		else
		{
			return 1;
		}
	}
	
	public function getNextItem()
	{
		$document =  self::doSelectOne(array('where' => array('modulename' => $this->modulename, 'module_id' => $this->module_id, 'position' => $this->position+1)));
		
		if ($document)
		{
			return $document;
		}
		else 
		{
			return false;
		}
	 }
	 
  public function getPreviousItem()
  {
    $document =  self::doSelectOne(array('where' => array('modulename' => $this->modulename, 'module_id' => $this->module_id,  'position' => $this->position-1)));
    
    if ($document)
    {
      return $document;
    }
    else 
    {
      return false;
    }
   }
	
   public function moveUp()
   {
    $this->switchPosition($this->getPreviousItem());
   }
   
   public function moveDown()
   {
   	$this->switchPosition($this->getNextItem());
   }
   
   protected function switchPosition($document)
   {
	   	if($document)
	   	{
	   	  $current_position = $this->getPosition();
	      $this->setPosition($document->getPosition());
	      $document->setPosition($current_position);
	      $this->save();
	      $document->save();
	   	}
   }
   
	public function setPosition($position)
	{
		$this->position = $position;
	}

	public static function resetPositions($modulename, $module_id, $type)
	{
		$documents = self::doSelect(array('where' => array('modulename' => $modulename, 'module_id' => $module_id), 'order_by' => array('position asc')));
		
		$position = 1;
		
		foreach ($documents as $document)
		{
			$document->setPosition($position);
      $position = $document->getPosition() + 1;
			$document->save();
		}
		
	}
	
	public function Populate($row)
	{
			if (isset($row['document_id']))
			{
				$this->id = $row['document_id'];
			}
			elseif (isset($row['id'])	)
			{
				$this->id = $row['id'];
			}
				  
		  if (isset($row['module_name']))
		  {		  	
        $this->modulename = $row['module_name'];
		  }
		  elseif(isset($row['modulename']))
		  {
		  	$this->modulename = $row['modulename'];
		  }
		  
		  if (isset($row['module_id']))
      {    
		    $this->module_id = $row['module_id'];
      }

      if (isset($row['title']))
      {
      	$this->title = $row['title'];
      }
      
      if (isset($row['url']))
      {
      	$this->url = $row['url'];
      }
      
      if (isset($row['is_new_window']))
      {
      	$this->is_new_window = $row['is_new_window'];
      }
      
      if (isset($row['position']))
      { 
      	$this->position = $row['position'];		  
      }
	}
	
 public function PopulateFromDb($row)
  {
    $this->Populate($row);
  }
	
  public function save()
  {
    // Upgrade or Insert ?
    if ($this->id != null)
    {
      $this->update();
    }
    else 
    {     
        $this->insert();
    }   
    
  }
  
  protected function update()
  {
    
    $db =& $this->GetDb();
    

      $query = 'UPDATE  ' . cms_db_prefix() .  self::DB_NAME . ' 
      
      SET ';
            
      $query .= 'modulename = ?, module_id = ?, title = ?, url = ?, is_new_window = ?, position = ?';
      
      $query .= '
      
      WHERE
      
      id = ?  ';
      
      
      $result = $db->Execute($query,
          array(      
				      $this->modulename,
				      $this->module_id,
				      $this->getTitle(),
				      $this->getUrl(),
				      $this->getIsNewWindow(),
				      $this->getPosition(),
             $this->getId()
          )
        );        
        
        //FIXME: Test the $db status; 
        
        return true;
  }
  
  protected function insert()
  {
    $db =& $this->GetDb();
    
    $this->setId($db->GenID(cms_db_prefix() .  self::DB_NAME .'_seq' ));
      
    $query = 'INSERT INTO ' . cms_db_prefix() .  self::DB_NAME .  ' 
      
      SET  id = ?,  ';

   $query .= 'modulename = ?, module_id = ?, title = ?, url = ?, is_new_window = ?, position = ?';
      
      
       $db->Execute($query,
          array(
            $this->getId(), 
              $this->modulename,
              $this->module_id,
              $this->getTitle(),
              $this->getUrl(),
              $this->getIsNewWindow(),
              $this->getPosition(),
          )
        );
        
        return true;    
  }  

  public static function retrieveByPk($id)
  {
	global $_MX;
	if (isset($_MX['datas']['link'][$id]))
	{
		return $_MX['datas']['link'][$id];
	}
  	return self::doSelectOne(array('where' => array('id' => $id)));  
  }
  
  public static function doSelectOne($params = array())
  {
  	$items = self::doSelect($params);
  	if ($items)
  	{
  		return $items[0];
  	}
  	else 
  	{
  		return null;
  	}  	
  }
  
  public static function doSelect($params = array())
  {
	global $_MX;
  	$instance = new self();
        
    $db =& $instance->GetDb();
    
    $query = 'SELECT * FROM ' . cms_db_prefix() . self::DB_NAME;
    
    $values = array();
    $fields = array();

	if (isset($params['where']))
    {
      foreach ($params['where'] as $field => $value) 
      {
        $fields[] = $field . ' =  ?';
        $values[] = $value;
      }
    }

 	if (isset($params['where_in']))
    {      
      foreach ($params['where_in'] as  $field => $value)
      {
         $fields[] =  $field . ' IN (' . "'" . implode("','", $value) . "'" . ')';
      }      
    }

	if (count($fields))
    {
       $query .= ' WHERE ' . implode(' AND ', $fields);
    }
    
    if(isset($params['order_by']))
    {
     $query .= ' ORDER BY ' . implode(', ' , $params['order_by']);
    }
    else
    {
      $query .= ' ORDER BY position asc';
    }
  	
    $dbresult = $db->Execute($query, $values);
  
    $items = array();
   if ($dbresult && $dbresult->RecordCount() > 0)
    {
      while ($dbresult && $row = $dbresult->FetchRow())
      {  
		if (isset($_MX['datas']['link'][$row['id']]))
		{
			$items[] = $_MX['datas']['link'][$row['id']];
		}
		else
		{
			
		    $_MX['datas']['link'][$row['id']] = new self();		    
		    $_MX['datas']['link'][$row['id']]->PopulateFromDb($row);
		    $items[] =& $_MX['datas']['link'][$row['id']];
		}
      }
    }
    
    return  $items;  	
  }

   public function doSelectRelated($module_name, $module_id)
  {
	global $_MX;
	if (isset($_MX['collections']['link'][$module_name][$module_id]))
	{
		return $_MX['collections']['link'][$module_name][$module_id];
	}
	else
	{
		$_MX['collections']['link'][$module_name][$module_id] = self::doSelect(array('where' => array('modulename' => $module_name, 'module_id' => $module_id)));
		return $_MX['collections']['link'][$module_name][$module_id];
	}

  }

 public function doLoadRelated($module_name, $module_ids)
 {
	global $_MX;
	// Prepare the request
	$items = self::doSelect( array('where' => array('modulename' => $module_name), 'where_in' => array('module_id' => $module_ids)));

	foreach ($items as $item)
	{
		$_MX['collections']['link'][$item->getModuleName()][$item->getModuleId()][] =&  $_MX['datas']['link'][$item->getId()];
	}
 }
 

  public function delete($path = null)
  {  	  	
  	$db =& $this->GetDb();
  	$query = 'DELETE FROM '. cms_db_prefix() . self::DB_NAME;
  	$query .= ' WHERE id = ?';
    $db->Execute($query, array($this->id));  	

    self::resetPositions($this->getModuleName(), $this->getModuleId(), $this->getType());
  }
  
  public static function resetAllPositions()
  {
  	$documents = self::doSelect(array('order_by' => array('modulename asc', 'module_id asc', 'position asc')));
  	
  	$modulename ='';
  	$module_id = '';
  	
  	foreach ($documents as $document)
  	{
  		if ($document->getModuleName() != $modulename || $document->getModuleId() != $module_id )
  		{
  			  $modulename =$document->getModuleName();
			    $module_id = $document->getModuleId();

			    self::resetPositions($modulename, $module_id);
  		}
  	}
  }
  
}

?>