<?php

global $gCms;
$config = $gCms->getConfig();

require_once(cms_join_path($config['root_path'], 'lib', 'classes', 'module_support', 'modtemplates.inc.php'));

class {{$module->getModuleName()}}Object {

	public $id;
	public $parent_id;
	public $title;
	public $created_at;
	public $created_by;
	public $updated_at;
	public $updated_by;
	public $order_by;
	public $parent_item;
	public $published;
	public $full_text_search;

	{{foreach from=$extra_fields item=field}}
	public ${{$field.name}};
	{{/foreach}}

	protected $is_modified = false;

	public function getId() {
		return $this->id;
	}

	public function getParentId() {
		return $this->parent_id;
	}

	public function getTitle() {
		return $this->title;
	}

	public function getCreatedAt() {
		return $this->created_at;
	}

	public function getCreatedBy() {
		return $this->created_by;
	}

	public function getUpdatedAt() {
		return $this->updated_at;
	}

	public function getUpdatedBy() {
		return $this->updated_by;
	}

	public function getOrderBy() {
		return $this->order_by;
	}

	public function getParentItem() {
		return $this->parent_item;
	}

	public function getPublished() {
		return $this->published;
	}

	protected function set($name, $value) {
		if ($this->$name != $value) {
			$this->$name = $value;
			$this->is_modified = true;
		}
	}

	public function setId($value) {
		$this->set('id', $value);
	}

	public function setParentId($value) {
		$this->set('parent_id', $value);
	}

	public function setTitle($value) {
		$this->set('title', $value);
	}

	public function setCreatedAt($value) {
		$this->set('created_at', $value);
	}

	public function setCreatedBy($value) {
		$this->set('created_by', $value);
	}

	public function setUpdatedAt($value) {
		$this->set('updated_at', $value);
	}

	public function setUpdatedBy($value) {
		$this->set('updated_by', $value);
	}

	public function setOrderBy($value) {
		$this->set('order_by', $value);
	}

	public function setParentItem($value) {
		$this->set('parent_item', $value);
	}

	public function setPublished($value) {
		$this->set('published', $value);
	}
	
	public function setFullTextSearch($value)
	{
		$this->set('full_text_search', $value);
	}
	
	public function getFullTextSearch()
	{
		$text = $this->getTitle();
		{{foreach from=$extra_fields item=field}}
		{{if $field.type == 'textarea' || $field.type == 'text' || $field.type == 'textarea_plain'}}
		$text .= ' ' . $this->get{{$field.camelcase}}();
		{{/if}}{{/foreach}}
		return $text;
	}

	{{foreach from=$extra_fields item=field}}

	public function get{{$field.camelcase}}($parse = {{if $field.type == 'textarea'}}true{{else}}false{{/if}}) {
	    if ($parse) {
	        return cms_module_ProcessTemplateFromData(new stdClass(), $this->{{$field.name}});
	    }
	    return $this->{{$field.name}};
	}

	public function set{{$field.camelcase}}($value) {
		{{if $field.type == 'date'}}
		if (is_array($value)) {
			$value = $value['year'] . '-' . $value['month'] . '-' . $value['day'];
		}
		$this->set('{{$field.name}}', $value);
		{{else}}
		$this->set('{{$field.name}}', $value);
		{{/if}}
	}
	
	{{if $field.form_type == 'file'}}
	public function get{{$field.camelcase}}Size($readable = false)
	{
		global $gCms;
		$config = $gCms->GetConfig();
		$file = $config['root_path'].'/' . $this->get{{$field.camelcase}}();				
	 	return MX_Document::getFileSize($file, $readable);
	}
	
	public function get{{$field.camelcase}}Icon($icon_type = 'small')
	{
		global $gCms;
		$config = $gCms->GetConfig();
		$file = $config['root_path'].'/' . $this->get{{$field.camelcase}}();				
		return MX_Document::getFileIcon($file, $icon_type);
	}
	
	{{/if}}

	{{/foreach}}

	public function getSearchString() {
		$fields[] = $this->getTitle();
		{{foreach from=$extra_fields item=field}}
			{{if $field.column_type == 'C(255)' || $field.column_type == 'X'}}
			$fields[] = $this->get{{$field.camelcase}}();
			{{/if}}
		{{/foreach}}
		return implode(' ', $fields);
	}

	public function getParent() {
	    if ($this->parent_id) {
	        return self::getById($this->parent_id);
	    }
		return false;
	}

	public function getPossibleParents() {
		$objects = self::doSelect(new MCFCriteria());
		$possible_objects = array(0 => '');
		foreach ($objects as $object) {
			if (($object->getId() != $this->getId()) && !$object->isDescendantOf($this->getId())) {
				$possible_objects[$object->getId()] = $object->getTitle();
			}
		}
		return $possible_objects;
	}

	public function isDescendantOf($id) {
		$item = $this;
		while ($item = $item->getParent()) {
			if ($item->getId() == $id) {
				return true;
			}
		}
		return false;
	}

	public static function doCount(MCFCriteria $crit) {
		$c = clone $crit;
		global $gCms;
		$db = $gCms->GetDb();
		$c->addSelectColumn('COUNT(*) AS nbitems');
		$query = $c->buildQuery(cms_db_prefix().'module_{{$table_name}}');
		$result = $db->execute($query, $c->values);
		$row = $result->FetchRow();
		return $row['nbitems'];
	}

	public static function doSelect(MCFCriteria $crit) {
		$c = clone $crit;
		global $gCms;
		$db = $gCms->GetDb();
		$query = $c->buildQuery(cms_db_prefix().'module_{{$table_name}}');
		$result = $db->execute($query, $c->values);
		$objects = array();
		while ($result && $row = $result->FetchRow()) {
			$object = new self();
			$object->populateFromArray($row);
			$object->is_modified = false;
			$objects[$object->getId()] = $object;
		}
		return $objects;
	}

    public static function doSelectOne(MCFCriteria $crit) {
        $c = clone $crit;
        $c->setLimit(1);
        $objects = self::doSelect($c);
        return (count($objects) > 0) ? array_shift($objects) : false;
    }

	public static function getById($id) {
	    $c = new MCFCriteria();
	    $c->add('id', $id);
	    return self::doSelectOne($c);
	}

	public static function getTitles() {
		global $gCms;
		$db = $gCms->GetDb();
		$c = new MCFCriteria();
		$c->addAscendingOrderByColumn('order_by');
		$query = $c->buildQuery(cms_db_prefix().'module_{{$table_name}}');
		$result = $db->execute($query, $c->values);
		$objects = array();
		while ($result && $row = $result->FetchRow()) {
			$objects[$row['id']] = $row['title'];
		}
		return $objects;
	}

	public static function query($sql, $values = array()) {
		global $gCms;
		$db = $gCms->GetDb();
		return $db->execute($sql, $values);
	}

	public function uploadFiles($id) {
		global $gCms;
		$config = $gCms->GetConfig();
		$upload_path = '/uploads/Modules/{{$module->getModuleName()}}/';
		$upload_full_path = $config['root_path'].$upload_path;
		
		if (!is_dir($upload_full_path))
		{
			mkdir($upload_full_path,0777,true);
		}
		
		{{foreach from=$extra_fields item=field}}
			{{if $field.form_type == 'file'}}
			if (isset($_POST[$id.'{{$field.name}}_delete'])) {
				$this->set{{$field.camelcase}}('');
			} elseif (isset($_FILES[$id.'{{$field.name}}']) && ($_FILES[$id.'{{$field.name}}']['size'] > 0)) {
				$pathinfo = pathinfo($_FILES[$id.'{{$field.name}}']['name']);
				$filename = $pathinfo['basename'];
				$i = 2;
				while (file_exists($upload_full_path.$filename)) {
					$filename = $pathinfo['filename'].'-'.$i.'.'.$pathinfo['extension'];
					++$i;
				}
				$destination = $upload_full_path.$filename;
				if (move_uploaded_file($_FILES[$id.'{{$field.name}}']['tmp_name'], $destination)) {
					$this->set{{$field.camelcase}}($upload_path.$filename);
					{{if ($field.type == 'image') && $field.image_width && $field.image_height}}
					list($image_width, $image_height, $image_type) = getimagesize($destination);
					switch ($image_type) {
						case IMAGETYPE_GIF:
							$img = imagecreatefromgif($destination);
							break;
						case IMAGETYPE_JPEG:
							$img = imagecreatefromjpeg($destination);
							break;
						case IMAGETYPE_PNG:
							$img = imagecreatefrompng($destination);
							break;
					}
					$factor = max($image_width / {{$field.image_width}}, $image_height / {{$field.image_height}});
					$new_width = min(round($image_width / $factor), $image_width);
					$new_height = min(round($image_height / $factor), $image_height);
					$new_img = imagecreatetruecolor($new_width, $new_height);
					imagecopyresampled($new_img, $img, 0, 0, 0, 0, $new_width, $new_height, $image_width, $image_height);
					switch ($image_type) {
						case IMAGETYPE_GIF:
							imagegif($new_img, $upload_full_path.'{{$field.image_width}}_{{$field.image_height}}_'.basename($_FILES[$id.'{{$field.name}}']['name']));
							break;
						case IMAGETYPE_JPEG:
							imagejpeg($new_img, $upload_full_path.'{{$field.image_width}}_{{$field.image_height}}_'.basename($_FILES[$id.'{{$field.name}}']['name']), 90);
							break;
						case IMAGETYPE_PNG:
							imagepng($new_img, $upload_full_path.'{{$field.image_width}}_{{$field.image_height}}_'.basename($_FILES[$id.'{{$field.name}}']['name']));
							break;
					}
					$this->set{{$field.camelcase}}($upload_path.'{{$field.image_width}}_{{$field.image_height}}_'.basename($_FILES[$id.'{{$field.name}}']['name']));
					{{/if}}
				}
			}
			{{/if}}
		{{/foreach}}
	}

	public function populateFromArray(array $params) {
		if (isset($params['id'])) {
			$this->setId($params['id']);
		}
		if (isset($params['parent_id'])) {
			$this->setParentId($params['parent_id']);
		}
		if (isset($params['title'])) {
			$this->setTitle($params['title']);
		}
		if (isset($params['created_at'])) {
			$this->setCreatedAt($params['created_at']);
		}
		if (isset($params['created_by'])) {
			$this->setCreatedBy($params['created_by']);
		}
		if (isset($params['updated_at'])) {
			$this->setUpdatedAt($params['updated_at']);
		}
		if (isset($params['updated_by'])) {
			$this->setUpdatedBy($params['updated_by']);
		}
		if (isset($params['order_by'])) {
			$this->setOrderBy($params['order_by']);
		}
		if (isset($params['parent_item'])) {
			$this->setParentItem($params['parent_item']);
		}
		if (isset($params['published'])) {
			$this->setPublished($params['published']);
		}
		if (isset($params['full_text_search']))
		{
			$this->setFullTextSearch($params['full_text_search']);
		}
		{{foreach from=$extra_fields item=field}}
		if (isset($params['{{$field.name}}'])) {
			$this->set{{$field.camelcase}}($params['{{$field.name}}']);
		}
		{{/foreach}}
	}

	public function isNew() {
		return $this->getId() ? false : true;
	}

	public function save() {
		global $gCms;
		if ($this->getId()) {
		    if ($this->is_modified) {
		        $this->update();
		    }
		} else {
			$this->insert();
		}
		$gCms->modules['{{$module->getModuleName()}}']['object']->index($this);
		return true;
	}

	public function delete() {
		global $gCms;
		if ($this->getId()) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_{{$table_name}} WHERE id = ?';
			$this->query($query, array($this->id));
			
			MX_RelationLink::cleanRelatedItems('{{$module->getModuleName()}}', $this->getId());
		}
		$gCms->modules['{{$module->getModuleName()}}']['object']->deindex($this);
		return true;
	}

	protected function insert() {
		global $gCms;
		$db = $gCms->GetDb();
		$this->setId($db->GenID(cms_db_prefix().'module_{{$table_name}}_seq'));
		$query = 'SELECT MAX(order_by) + 1 AS order_by FROM '.cms_db_prefix().'module_{{$table_name}}';
		$values = array();
		if ($this->parent_item) {
			$query .= ' WHERE parent_item = ?';
			$values[] = $this->parent_item;
		}
		$result = $db->execute($query, $values);
		$row = $result->FetchRow();
		$order_by = $row['order_by'] ? $row['order_by'] : 1;
		$query = 'INSERT INTO '.cms_db_prefix().'module_{{$table_name}}
			SET id = ?,
			    parent_id = ?,
				title = ?,
				{{foreach from=$extra_fields item=field}}
				{{$field.name}} = ?,
				{{/foreach}}
				created_by = ?,
				created_at = NOW(),
				updated_by = ?,
				updated_at = NOW(),
				order_by = ?,
				parent_item = ?,
				published = ?,
				full_text_search = ?';
		$db->Execute($query, array(
		    $this->id,
			$this->parent_id,
			$this->title,
			{{foreach from=$extra_fields item=field}}
			$this->{{$field.name}},
			{{/foreach}}
			get_userid(),
			get_userid(),
			$order_by,
			$this->parent_item,
			$this->published,
			$this->getFullTextSearch()
		));
		$gCms->modules['{{$module->getModuleName()}}']['object']->SendEvent('ContentEditPost', array());
		return true;
	}

	protected function update() {
		global $gCms;
		$db = $gCms->GetDb();
		$query = 'UPDATE '.cms_db_prefix().'module_{{$table_name}}
			SET parent_id = ?,
				title = ?,
				{{foreach from=$extra_fields item=field}}
				{{$field.name}} = ?,
				{{/foreach}}
				updated_by = ?,
				updated_at = NOW(),
				order_by = ?,
				parent_item = ?,
				published = ?,
				full_text_search = ?
			WHERE id = ?';
		$db->Execute($query, array(
			$this->parent_id,
			$this->title,
			{{foreach from=$extra_fields item=field}}
			$this->{{$field.name}},
			{{/foreach}}
			get_userid(),
			$this->order_by,
			$this->parent_item,
			$this->published,
			$this->getFullTextSearch(),
			$this->id
		));
		$gCms->modules['{{$module->getModuleName()}}']['object']->SendEvent('ContentEditPost',array());
		return true;
	}
	
	public static function updateObjects()
	{
		$c = new MCFCriteria();
		$objects = self::doSelect($c);
		foreach($objects as $object)
		{
			$object->is_modified = true;
			$object->save();
		}
	}
	
	public function forceUpdateObject($magic)
	{
		if ($magic = 'magic')
		{
			$this->is_modified = true;
			$this->save();
		}
	}

}

?>
