<?php
if (!isset($gCms)) exit;

$c = new MCFCriteria();
$c->add('published', '1');
$items = {{$module->getModuleName()}}Object::doSelect($c);

$tags = array();
foreach ($items as $item)
{
	if (method_exists($item, 'getTags'))
	{
		$elements = explode(',', $item->getTags());

		foreach ($elements as $element)
		{
			if (isset($tags[trim($element)]))
			{
				$tags[trim($element)]++;
			}
			else
			{
				$tags[trim($element)] = 1;
			}
		}
	}	
}
arsort($tags);

if(isset($params['limit']))
{
	$tags = array_slice($tags, 0, $params['limit']);
}
else
{	
	$tags = array_slice($tags, 0, 15);
}

// Now calculate percent

$max = max($tags);

$ntags = array();

foreach($tags as $tag => $popularity)
{
	$ntags[] = array('class' => floor($popularity/$max*10), 'tag' => $tag, 'popularity' => $popularity);
}

shuffle($ntags);

$this->smarty->assign('tags', $ntags);

if (isset($params['template']) && $this->GetTemplate($params['template'])) {
	echo $this->ProcessTemplateFromDatabase($params['template']);
} else {
	echo $this->ProcessTemplateFromDatabase('display_list');
}