<?php

if (!isset($gCms)) exit;

if (!$this->CheckAccess('Manage MC Factory')) {
	return $this->DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
}

$view = new MCFListView('{{$module->getModuleName()}}', $params);

$modulextender = $gCms->modules['ModuleXtender']['object'];

if (isset($params['item_id']) && !empty($params['item_id'])) {
	$item = {{$module->getModuleName()}}Object::getById($params['item_id']);
} else {
	$item = new {{$module->getModuleName()}}Object();
	$item->setParentItem($params['parent_item'] ? $params['parent_item'] : 0);
}

$c = new MCFCriteria();
$c->add('parent_module', {{$module->getId()}}, MCFCriteria::EQUAL);
$child_modules = MCFModule::doSelect($c);

$submodules = array();

foreach ($child_modules as $child) {
	if (isset($gCms->modules[$child->GetModuleName()]))
	{
		$submodules[$child->getId()] = array('name' => $child->GetModuleFriendlyName(), 'items' => array());
		if (!$item->isNew()) {
			$c = new MCFCriteria();
			$c->add('parent_item', $item->getId());
			$c->addAscendingOrderByColumn('order_by');
			$classname = $child->GetModuleName();
			$mod = new $classname();
			$items = call_user_func(array($child->GetModuleName() . 'Object', 'doSelect'), $c);
			
			//{{$module->getModuleName()}}Views::adminItems($gCms,$this,$id,$returnid,$params,$view,$items);
			$submodules[$child->getId()]['template'] = call_user_func(array($child->GetModuleName() . 'Views', 'adminItems'), $gCms,$mod,$id,$returnid,$view,$items,$item->getId());
			
			$submodules[$child->getId()]['add_item_link'] = $mod->CreateLink($id, 'edit', $returnid, $mod->Lang('add_item_for', $child->GetModuleFriendlyName()), array('parent_item' => $item->getId()));
			$submodules[$child->getId()]['add_item_icon'] = $mod->CreateLink($id, 'edit', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $mod->Lang('add_item_for', $child->GetModuleFriendlyName()), '', '', 'systemicon'));
			
			// $i = 0;
			// 			foreach ($items as $current) {
			// 				$submodules[$child->getId()]['items'][$i] = array(
			// 					'titlelink' => $mod->CreateLink($id, 'edit', $returnid, $current->getTitle(), array('view' => $view->getView(), 'item_id' => $current->getId()), '', false, false, 'class="itemlink"'),
			// 					'publishlink' => $mod->CreateLink($id, 'publish', $returnid, $gCms->variables['admintheme']->DisplayImage(($current->getPublished() ? 'icons/system/true.gif' : 'icons/system/false.gif'), ($current->getPublished() ? $mod->Lang('unpublish') : $mod->Lang('publish')), '', '', 'systemicon'), array('view' => $view->getView(), 'item_id' => $current->getId())),
			// 					'deletelink' => $mod->CreateLink($id, 'delete', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $mod->Lang('delete'), '', '', 'systemicon'), array('view' => $view->getView(), 'item_id' => $current->getId()), 'Are you sure you want to delete this item?'),
			// 					'editlink' => $mod->CreateLink($id, 'edit', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $current->getTitle(), '', '', 'systemicon'), array('view' => $view->getView(), 'item_id' => $current->getId()))
			// 				);
			// 				if ($i > 0) {
			// 					$submodules[$child->getId()]['items'][$i]['moveuplink'] = $mod->CreateLink($id, 'moveup', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/arrow-u.gif', $current->getTitle(), '', '', 'systemicon'), array('view' => $view->getView(), 'item_id' => $current->getId()), '', false, false, 'class="itemlink"');
			// 				}
			// 				if ($i < count($items) - 1) {
			// 					$submodules[$child->getId()]['items'][$i]['movedownlink'] = $mod->CreateLink($id, 'movedown', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/arrow-d.gif', $current->getTitle(), '', '', 'systemicon'), array('view' => $view->getView(), 'item_id' => $current->getId()), '', false, false, 'class="itemlink"');
			// 				}
			// 				++$i;
			// 			}
		}
	}
}

if (isset($params['cancel'])) {
	{{if $parent_module}}
	$parent = new {{$parent_module->getModuleName()}}();
	$parent->Redirect($id, 'edit', $returnid, array('view' => $view->getView(), 'item_id' => $item->getParentItem()));
	{{else}}
	$this->Redirect($id, 'defaultadmin', $returnid, array('view' => $view->getView()));
	{{/if}}
	exit;
}

if (isset($params['submit']) || isset($params['apply'])) {
	if (!isset($params['published'])) {
		$params['published'] = false;
	}
	$item->populateFromArray($params);
	$item->uploadFiles($id);
	$item->save();
	if ($modulextender->isXtendedModule($this->getName())) {
		$modulextender->getFormInput($this->getName(), $item->getId(), $params);
	}
	if (isset($params['submit'])) {
		{{if $parent_module}}
		$parent = new {{$parent_module->getModuleName()}}();
		$parent->Redirect($id, 'edit', $returnid, array('view' => $view->getView(), 'item_id' => $item->getParentItem()));
		{{else}}
		$this->Redirect($id, 'defaultadmin', $returnid, array('view' => $view->getView()));
		{{/if}}
		exit;
	} else {
		$this->Redirect($id, 'edit', $returnid, array('view' => $view->getView(), 'item_id' => $item->getId()));
		exit;
	}
}


$this->smarty->assign('form_start', $this->CreateFormStart($id, 'edit', $returnid, 'post', 'multipart/form-data', false, '', array('view' => $view->getView())));
$this->smarty->assign('submit_button',$this->CreateInputSubmit($id, 'submit', $this->Lang('save')));
$this->smarty->assign('apply_button',$this->CreateInputSubmit($id, 'apply', $this->Lang('save_continue')));
$this->smarty->assign('cancel_button',$this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));
$this->smarty->assign('input_item_id', $this->CreateInputHidden($id, 'item_id', $item->getId()));
$this->smarty->assign('input_parent_item', $this->CreateInputHidden($id, 'parent_item', $item->getParentItem()));
$this->smarty->assign('input_title', $this->CreateInputText($id, 'title', $item->getTitle(), 50));
$this->smarty->assign('input_published', $this->CreateInputCheckbox($id, 'published', '1', $item->getPublished()));
$this->smarty->assign('show_parent_id', $this->getPreference('show_parent', 'false'));
$this->smarty->assign('input_parent_id', $this->CreateInputDropdown($id, 'parent_id', array_flip($item->getPossibleParents()), -1, $item->getParentId()));

$this->smarty->assign('created_by', $gCms->GetUserOperations()->LoadUserByID($item->getCreatedBy())->username);
$this->smarty->assign('created_at', $item->getCreatedAt());
$this->smarty->assign('updated_by', $gCms->GetUserOperations()->LoadUserByID($item->getUpdatedBy())->username);
$this->smarty->assign('updated_at', $item->getUpdatedAt());
{{foreach from=$extra_fields item=field}}
{{if $field.form_type == 'select'}}
$this->smarty->assign('input_{{$field.name}}', $this->CreateInputDropdown($id, '{{$field.name}}', {{$field.select_options}}, -1, $item->get{{$field.camelcase}}()));
{{elseif $field.form_type == 'textarea'}}
$this->smarty->assign('input_{{$field.name}}', $this->CreateTextArea(true, $id, $item->get{{$field.camelcase}}(false), '{{$field.name}}'));
{{elseif $field.form_type == 'textarea_plain'}}
$this->smarty->assign('input_{{$field.name}}', $this->CreateTextArea(false, $id, $item->get{{$field.camelcase}}(false), '{{$field.name}}'));
{{elseif $field.form_type == 'file'}}
if ($item->get{{$field.camelcase}}()) {
	{{if ($field.type == 'image') && $field.image_width && $field.image_height}}
	$this->smarty->assign('input_{{$field.name}}', $this->CreateInputFile($id, '{{$field.name}}', '', 20) . ' <a href="'.$item->get{{$field.camelcase}}().'" target="_blank"><img src="'.$item->get{{$field.camelcase}}().'" alt="image"/></a> ' . $this->CreateInputCheckbox($id, '{{$field.name}}_delete', '1') . 'delete');
	{{else}}
	$this->smarty->assign('input_{{$field.name}}', $this->CreateInputFile($id, '{{$field.name}}', '', 20) . ' <a href="'.$item->get{{$field.camelcase}}().'" target="_blank">'.basename($item->get{{$field.camelcase}}()).'</a> ' . $this->CreateInputCheckbox($id, '{{$field.name}}_delete', '1') . 'delete');
	{{/if}}
} else {
	$this->smarty->assign('input_{{$field.name}}', $this->CreateInputFile($id, '{{$field.name}}', '', 20));
}
{{elseif $field.type == 'date'}}
for ($i = 1; $i <= 31; ++$i) {
	$days[$i] = $i;
}
for ($i = 1; $i <= 12; ++$i) {
	$t = mktime(0, 0, 0, $i, 1, 2000);
	$months[date('M', $t)] = $i;
}
for ($i = 1900; $i <= date('Y') + 10; ++$i) {
	$years[$i] = $i;
}
$date = $item->get{{$field.camelcase}}() ? $item->get{{$field.camelcase}}() : date('Y-m-d');
list($year, $month, $day) = explode('-', $date);
$input = $this->CreateInputDropdown($id, '{{$field.name}}[day]', $days, -1, $day);
$input .= $this->CreateInputDropdown($id, '{{$field.name}}[month]', $months, -1, $month);
$input .= $this->CreateInputDropdown($id, '{{$field.name}}[year]', $years, -1, $year);
$this->smarty->assign('input_{{$field.name}}', $input);
{{else}}
$this->smarty->assign('input_{{$field.name}}', $this->CreateInputText($id, '{{$field.name}}', $item->get{{$field.camelcase}}(), 50));
{{/if}}

{{/foreach}}
$this->smarty->assign('submodules', $submodules);

if ($modulextender->isXtendedModule($this->getName())) {  
	$this->smarty->assign('xtended_form', $modulextender->XtendModuleForm('{{$module->getModuleName()}}', $item->getId(), $id));
} else {
	$this->smarty->assign('xtended_form', '');
}

echo $this->ProcessTemplate('edit.tpl');

?>
