<?php

if (!isset($gCms)) exit;

$modulextender = $gCms->modules['ModuleXtender']['object'];

$c = new MCFCriteria();
$c->add('published', '1');

if (isset($params['currentpage'])) {
	$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', $gCms->variables['content_id'], 'pages'), MCFCriteria::IN);
}
if (isset($params['pages'])) {
	$glue = isset($params['all_pages']) ? 'AND' : 'OR';
	$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', explode(',', $params['pages']), 'pages', $glue), MCFCriteria::IN);
}
if (isset($params['options'])) {
	$glue = isset($params['all_options']) ? 'AND' : 'OR';
	$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', explode(',', $params['options']), 'options', $glue), MCFCriteria::IN);
}

if (isset($params['mxfilters_options']) && is_array($params['mxfilters_options'])) {
	$options = array();
	foreach ($params['mxfilters_options'] as $option) {
		if ($option) {
			$options[] = $option;
		}
	}
	if (count($options)) {
		$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', $options, 'options', 'AND'), MCFCriteria::IN);
	}
}

if (isset($params['mxfilters_pages']) && is_array($params['mxfilters_pages'])) {
	$pages = array();
	foreach ($params['mxfilters_pages'] as $page) {
		if ($page) {
			$pages[] = $page;
		}
	}
	if (count($pages)) {
		$c->add('id', MX_RelationLink::getRelatedItemsIds('{{$module->getModuleName()}}', $pages, 'pages', 'AND'), MCFCriteria::IN);
	}
}


if (isset($params['filter_title'])) {
	$filter_title = trim(html_entity_decode($params['filter_title']));
	$filter_title = str_replace(array('%', '?'), ' ', $filter_title);
	if (!empty($filter_title)) {
		preg_match_all('/(?:"([^"]+)")|(\w+)/', $filter_title, $matches);
		$clauses = array();
		foreach ($matches[0] as $key => $value) {
			$clauses[$key] = $matches[1][$key] ? $matches[1][$key] : $matches[2][$key];
		}
		foreach ($clauses as $clause) {
			$c->add('title', '%' . $clause . '%', MCFCriteria::LIKE);
		}
	}
}

if (isset($params['filter_all'])) {
	$filter_all = trim(html_entity_decode($params['filter_all']));
	$filter_all = str_replace(array('%', '?'), ' ', $filter_all);
	if (!empty($filter_all)) {
		preg_match_all('/(?:"([^"]+)")|(\w+)/', $filter_all, $matches);
		$clauses = array();
		foreach ($matches[0] as $key => $value) {
			$clauses[$key] = $matches[1][$key] ? $matches[1][$key] : $matches[2][$key];
		}
		foreach ($clauses as $clause) {
			$c->add('full_text_search', '%' . $clause . '%', MCFCriteria::LIKE);
		}
	}
}

if (isset($params['calendar']) && isset($params['start_date']) && isset($params['end_date']))
{
	$calendar = new MCFCalendar();
  $c->add('start_date', $params['start_date'], MCFCriteria::LESS_EQUAL);
  $c->add('end_date', $params['end_date'], MCFCriteria::GREATER_EQUAL);
	
}
elseif (isset($params['calendar']) && isset($params['month_from_date']))
{
   $calendar_time = strtotime($params['month_from_date']);
   $calendar = new MCFCalendar($calendar_time);
   $c->add('start_date', date('Y/m/d', $calendar->end_date), MCFCriteria::LESS_EQUAL);
   $c->add('end_date', date('Y/m/d', $calendar->start_date), MCFCriteria::GREATER_EQUAL);
}
elseif (isset($params['calendar']))
{
   $calendar_time = isset($params['cal_time'])?$params['cal_time']:time();
   $calendar = new MCFCalendar($calendar_time);
   $c->add('start_date', date('Y/m/d', $calendar->end_date), MCFCriteria::LESS_EQUAL);
   $c->add('end_date', date('Y/m/d', $calendar->start_date), MCFCriteria::GREATER_EQUAL);
}
if (isset($params['next_events']))
{
   $c->add('end_date', date('Y/m/d'), MCFCriteria::GREATER_EQUAL);
}
if (isset($params['previous_events']))
{
   $c->add('end_date', date('Y/m/d'), MCFCriteria::LESS_THAN);
}

{{foreach from=$filters item=filter}}
if (isset($params['{{$filter.name}}'])) {
	{{if in_array($filter.type, array('less', 'less_equal', 'greater', 'greater_equal'))}}
	$c->add('CAST({{$filter.field}} AS UNSIGNED)', $params['{{$filter.name}}'], MCFCriteria::{{$filter.criteria}});
	{{else}}
	$c->add('{{$filter.field}}', $params['{{$filter.name}}'], MCFCriteria::{{$filter.criteria}});
	{{/if}}
}
{{/foreach}}

$mxfilters = array();
if ($modulextender->isXtendedModule('{{$module->getModuleName()}}')) {
	foreach (MX_Relation::getFilters($this->getName()) as $filter) {
	    if ($filter->getType() == 'category') {
			if(isset($params['title_filter_category_'.$filter->getId()]))
			{
				$values = array($params['title_filter_category_'.$filter->getId()] => 0);
			}
			else
			{				
		        $values = array($filter->getTitle(false, true) => 0);
			}
    		foreach ($filter->getRelatedItems() as $item) {
    			$values[$item->title] = $item->id;
    		}
    		$mxfilters[$filter->getId()] = $this->CreateInputDropdown($id, 'mxfilters_options[' . $filter->id . ']', $values, -1, isset($params['mxfilters_options'][$filter->id]) ? $params['mxfilters_options'][$filter->id] : '');
	    } else if ($filter->getType() == 'page') {
			if(isset($params['title_filter_page_'.$filter->getId()]))
			{
				$values = array($params['title_filter_page_'.$filter->getId()] => 0);
			}
			else
			{				
		        $values = array($filter->getTitle(false, true) => 0);
			}
    		foreach ($filter->getRelatedItems() as $item) {
    			$values[$item->title] = $item->id;
    		}
    		$mxfilters[$filter->getId()] = $this->CreateInputDropdown($id, 'mxfilters_pages[' . $filter->id . ']', $values, -1, isset($params['mxfilters_pages'][$filter->id]) ? $params['mxfilters_pages'][$filter->id] : '');
	    }
	}
}
$this->smarty->assign('mxfilters', $mxfilters);
$this->smarty->assign('titlefilter', $this->CreateInputText($id, 'filter_title', isset($params['filter_title']) ? html_entity_decode($params['filter_title']) : '', 20));
$this->smarty->assign('filter_all', $this->CreateInputText($id, 'filter_all', isset($params['filter_all']) ? html_entity_decode($params['filter_all']) : '', 20));

if (isset($params['random'])) {
	$c->addAscendingOrderByColumn('RAND()');
} else if (isset($params['orderby'])) {
	$clauses = explode(',', $params['orderby']);
	foreach ($clauses as $clause) {
		$clause = trim($clause);
		if (preg_match('/(\w+)(?:\s+(asc|desc))?/i', $clause, $matches)) {
			$column = $matches[1];
			$order = isset($matches[2]) ? strtolower($matches[2]) : 'asc';
			if ($order == 'desc') {
				$c->addDescendingOrderByColumn($column);
			} else {
				$c->addAscendingOrderByColumn($column);
			}
		}
	}
} else {
    $c->addAscendingOrderByColumn('order_by');
}

if (isset($params['limit'])) {
	if (isset($params['page'])) {
		$page = $params['page'];
		$c->setOffset(($page - 1) * $params['limit']);
	} else {
		$page = 1;
	}
	$c->setLimit($params['limit']);
}

$items = {{$module->getModuleName()}}Object::doSelect($c);

if (isset($params['limit'])) {
	$c->setOffset(0);
	$c->setLimit(0);
	$total = {{$module->getModuleName()}}Object::doCount($c);
	$totalpages = ceil($total / $params['limit']);
	$page = $params['page'] ? $params['page'] : 1;
	$pager = array();
	$pager['has_to_paginate'] = $totalpages > 1;
	$pager['current'] = $page;
	$pager['total_pages'] = $totalpages;
	$pager['total_results'] = $total;
	$pager['pages'] = array();
	for ($i = 1; $i <= $totalpages; ++$i) {
		$pager['pages'][] = ($i == $page) ? $i : $this->createLink($id, 'default', $returnid, $i, array_merge($params, array('page' => $i)), '');
	}
	$pager['previous_page'] = ($page > 1) ? $this->createLink($id, 'default', $returnid, '', array_merge($params, array('page' => $page - 1)), '', true, true) : false;
	$pager['next_page'] = ($page < $totalpages) ? $this->createLink($id,'default', $returnid, '', array_merge($params, array('page' => $page + 1)), '', true, true) : false;
	$this->smarty->assign('pager', $pager);
}

$detailpage = $returnid;
if (isset($params['detailpage'])) {
    $manager = $gCms->GetHierarchyManager();
    $node = $manager->sureGetNodeByAlias($params['detailpage']);
    if ($node) {
        $content = $node->GetContent();
        if ($content)
        {
            $detailpage = $content->Id();
        }
    } else {
        $node = $manager->sureGetNodeById($params['detailpage']);
        if ($node) {
            $detailpage = $params['detailpage'];
        }
    }
    $params['origid'] = $returnid;
}

// MX Preloading
$ids = array();
foreach ($items as $item)
{
	$ids[] = $item->getId();
}
MX_XtendedModule::preloadRelatedItems($this->getName(), $ids);

foreach ($items as &$item) {
	$params['item_id'] = $item->getId();
	$params['title'] = $item->getTitle();
	$newparams = $params;
	unset($newparams['showtemplate']);
	$item->detail_link = $this->createLink($id, 'detail', $detailpage, $contents='', $newparams, '', true);

	$xtended_felist = MX_XtendedModule::getRelatedItems($this->getName(), $item->getId());
	$item->xtended_felist = $xtended_felist;
	/* DEPRECATED
	$xtended_felist = $modulextender->GetXtendedFrontendList($this->getName(), $item->getId(), true);
	
	// deprecated
	$item->documentscontent = $xtended_felist->documentscontent;
	$item->imagescontent = $xtended_felist->imagescontent;
	$item->pagescontent = $xtended_felist->pagescontent;
	$item->categoriescontent = $xtended_felist->categoriescontent;
	*/
}
unset($item);

if (isset($params['calendar']))
{
   $calendar->processEvents($items);
   $calendar->processCalendar();

   $this->smarty->assign('calendar', $calendar->calendar_table);
   $this->smarty->assign('current_month', $calendar_time);
   $this->smarty->assign('next_month', $this->createLink($id,'default', $returnid, $contents='', array_merge($params, array('cal_time' => strtotime('+ 1 MONTH',$calendar_time))), '', true, true));
   $this->smarty->assign('previous_month', $this->createLink($id, 'default', $returnid, $contents='', array_merge($params,   array('cal_time' => strtotime('- 1 MONTH', $calendar_time))), '', true, true));
}

if (isset($params['var'])) {
    $this->smarty->assign($params['var'], $items);
} else {
    $this->smarty->assign('items', $items);
    $paramsobj = new stdClass();
    $paramsobj->params = $params;
    $this->smarty->assign('mcfactory', $paramsobj);
    if (isset($params['template']) && $this->GetTemplate($params['template'])) {
    	echo $this->ProcessTemplateFromDatabase($params['template']);
    } else {
    	echo $this->ProcessTemplateFromDatabase('display_list');
    }
}

?>
