<?php

$GLOBALS['ADODB_QUOTE_FIELDNAMES'] = true;

require dirname(__FILE__) . '/classes/{{$module->getModuleName()}}Object.class.php';
require dirname(__FILE__) . '/classes/{{$module->getModuleName()}}Views.class.php';

class {{$module->getModuleName()}} extends CMSModule {

    public function DoAction($name, $id, $params, $returnid = '') {
        $methods = get_class_methods($this);
        foreach ($methods as $method) {
            if (strpos($method, 'modifier') === 0) {
                $modifier =substr($method, 8);
                $modifier{0} = strtolower($modifier{0});
                $this->smarty->register_modifier($modifier, array($this, $method));
            }
        }
        parent::DoAction($name, $id, $params, $returnid);
    }

	function GetName() {		return '{{$module->getModuleName()}}';	}
	function GetFriendlyName() {		return '{{$module->getModuleFriendlyName()}}';	}
	function GetVersion() {		return '{{$module->getModuleVersion()}}';	}
	function GetHelp() {		return $this->Lang('help');	}
	function GetAuthor() {		return 'Auto-generated by M&C Factory';	}
	function GetAuthorEmail() {		return 'jcc@morris-chapman.com';	}
	function GetChangeLog() {		return $this->Lang('changelog');	}
	function IsPluginModule() {		return true;	}
	function HasAdmin() {		return {{$has_admin}};	}
	function GetAdminSection() {		return 'content';	}
	function GetAdminDescription() {		return $this->Lang('admindescription');	}
	function VisibleToAdminUser() {		return true;	}
	function GetDependencies() {		return array('MCFactory' => '{{$mcfactoryversion}}');	}
	function CheckAccess() {		return $this->CheckPermission('Manage {{$module->getModuleName()}}');	}
	function DisplayErrorPage($id, &$params, $return_id, $message='') {
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);
		echo $this->ProcessTemplate('error.tpl');
	}

	function MinimumCMSVersion() {		return '1.4';	}
	function InstallPostMessage() {		return $this->Lang('postinstall');	}
	function UninstallPostMessage() {		return $this->Lang('postuninstall');	}
	function UninstallPreMessage() {		return $this->Lang('really_uninstall');	}
	public function Install() {
		global $gCms;
		$config = $gCms->GetConfig();
		$db = $this->cms->db;
		$dict = NewDataDictionary($db);
        $fields = 'id I KEY,
			parent_id I,
			title C(255),
			{{foreach from=$extra_fields item=field}}
			{{$field.name}} {{$field.column_type}},
			{{/foreach}}
			created_at D,
			created_by I,
			updated_at D,
			updated_by I,
			order_by I,
			published I,
			parent_item I,
			full_text_search XL';
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_{{$table_name}}', $fields);
		$dict->ExecuteSQLArray($sqlarray);
		$db->CreateSequence(cms_db_prefix().'module_{{$table_name}}_seq');
		$this->SetTemplate('display_list', $this->GetTemplateFromFile('template.list'));
		$this->SetTemplate('display_paginated', $this->GetTemplateFromFile('template.paginated'));
		$this->SetTemplate('display_details', $this->GetTemplateFromFile('template.details'));
		$this->SetTemplate('display_search', $this->GetTemplateFromFile('template.search'));
		$this->SetTemplate('display_calendar', $this->GetTemplateFromFile('template.calendar'));
		@mkdir($config['root_path'].'/uploads/{{$module->getModuleName()}}');
		$this->CreateEvent('ContentEditPost');
		$gCms->modules['MCFactory']['object']->AddEventHandler($this->getName(), 'ContentEditPost', false);
		$this->CreatePermission('Manage {{$module->getModuleName()}}', 'Manage {{$module->getModuleName()}}');	
		$this->CreatePermission('Admin {{$module->getModuleName()}}', 'Admin {{$module->getModuleName()}}');	
		$this->SetPreference('index_content', 'true');
	}

	private function sendStatistics()
	{
		// Send statistics
	}

	public function Upgrade()
	{
		$this->GetPreference('index_content',$this->GetPreference('index_content', 'true'));
	}

	public function Uninstall() {
		global $gCms;
		$db = $this->cms->db;
		$dict = NewDataDictionary($db);
		$sql = $dict->DropTableSQL(cms_db_prefix().'module_{{$table_name}}');
		$dict->ExecuteSQLArray($sql);
		$db->DropSequence(cms_db_prefix().'module_{{$table_name}}_seq');
		$gCms->modules['MCFactory']['object']->RemoveEventHandler($this->getName(), 'ContentEditPost');
		$this->RemoveEvent('ContentEditPost');
		$this->RemovePreference();
	}

	function XtendedModule () {
		return true;
	}

	function GetHeaderHTML() {
		$html  = '<script type="text/javascript" src="'.$this->config['root_url'].'/modules/MCFactory/js/jquery-1.3.2.min.js"></script>';
		$html .= '<script type="text/javascript">jQuery.noConflict();</script>';
		return $html;
	}

	function setParameters() {	
        $this->RegisterModulePlugin();
		$this->RegisterRoute('/{{$module->getModuleName()|lower}}\/(?P<item_id>[0-9]+)\/(?P<returnid>[0-9]+)(\/.*?)?$/', array('action' => 'detail'));
	}

	function createLink($id, $action, $returnid='', $contents='', $params=array(), $warn_message='', $onlyhref=false, $inline=false, $addttext='', $targetcontentonly=false, $prettyurl='') {
		if ($targetcontentonly || ($returnid != '' && !$inline)) {
			$id = 'cntnt01';
		}
		if (!$returnid) {
			if (isset($GLOBALS['gCms']->variables['content_id']))
			{			
				$returnid = $GLOBALS['gCms']->variables['content_id'];	
			}
			else
			{
				$returnid = '';
			}
		}
		if (empty($prettyurl)) {
			if ($action == 'detail') {
				$item_id = $params['item_id'];
				$prettyurl = '{{$module->getModuleName()|lower}}/' . $item_id . '/' . $returnid . '/';
				if (!empty($params['title'])) {
					$title = $params['title'];
					$prettyurl .= munge_string_to_url($title) . '/';
				}
				$query = array();
				foreach ($params as $name => $value) {
					if (!in_array($name, array('module', 'action', 'item_id', 'title'))) {
						$query[$id . $name] = $value;
					}
				}
				if (count($query)) {
					$prettyurl .= '?' . http_build_query($query);
				}
			}
		}
		return parent::createLink($id, $action, $returnid, $contents, $params, $warn_message, $onlyhref, $inline, $addttext, $targetcontentonly, $prettyurl);
	}

	function SearchReindex($module) {
		$c = new MCFCriteria();
		$c->add('published', 1);
		$items = {{$module->getModuleName()}}Object::doSelect($c);
		foreach ($items as $item) {
			$this->index($item);
		}
	}
	
	function SearchDeindex($module) {
		$c = new MCFCriteria();
		$c->add('published', 1);
		$items = {{$module->getModuleName()}}Object::doSelect($c);
		foreach ($items as $item) {
			$this->deindex($item);
		}
	}

	function index($item) {
		if ($this->getPreference('index_content') == 'true')
		{
			$search = $this->GetModuleInstance('Search');
			if ($search) {
				$search->AddWords(
					'{{$module->getModuleName()}}',
					$item->getId(),
					'{{$module->getModuleName()|lower}}_item',
					$item->getSearchString()
				);
			}
		}
	}

	function deindex($item) {
		$search = $this->GetModuleInstance('Search');
		if ($search) {
			$search->DeleteWords('{{$module->getModuleName()}}', $item->getId(), '{{$module->getModuleName()|lower}}_item');
		}
	}

	function SearchResult($returnid, $id, $attr = '') {
		$result = array();
		if ($attr == '{{$module->getModuleName()|lower}}_item') {
			$c = new MCFCriteria();
			$c->add('id', $id);
			$c->add('published', 1);
			$item = {{$module->getModuleName()}}Object::doSelectOne($c);
			if ($item) {
				$result[0] = $this->GetFriendlyName();
				$result[1] = $item->getTitle();
				$result[2] = $this->CreateLink('cntnt01', 'detail', $returnid, '', array('item_id' => $id, 'title' => $item->getTitle()), '', true);
			}
		}
		return $result;
	}
	
	/**
	 * NTList: Notification Tool function: Return the list of items uploaded since a certain date 
	 */

	function NTList($date, $template = null, $params = array())
	{
		global $gCms;
		$returnid = $this->getPreference('default_page', '');
		$c = new MCFCriteria();
		$c->add('published', '1');
		$c->add('updated_at', $date, MCFCriteria::GREATER_EQUAL);
		$c->addAscendingOrderByColumn('updated_at');
		$items = {{$module->getModuleName()}}Object::doSelect($c);

		if (empty($items))
		{
			return null;
		}
		
		if (!is_null($template))
		{
			$params['template'] = $template;
		}

		$detailpage = $returnid;

		if (isset($params['detailpage'])) {
		    $manager = $gCms->GetHierarchyManager();
		    $node = $manager->sureGetNodeByAlias($params['detailpage']);
		    if ($node) {
		        $content = $node->GetContent();
		        if ($content)
		        {
		            $detailpage = $content->Id();
		        }
		    } else {
		        $node = $manager->sureGetNodeById($params['detailpage']);
		        if ($node) {
		            $detailpage = $params['detailpage'];
		        }
		    }
		    $params['origid'] = $returnid;
		}

		foreach ($items as &$item) {
			$params['item_id'] = $item->getId();
			$params['title'] = $item->getTitle();
			$newparams = $params;
			unset($newparams['showtemplate']);
			$item->detail_link = $this->createLink($id, 'detail', $detailpage, $contents='', $newparams, '', true);
			$xtended_felist = MX_XtendedModule::getRelatedItems($this->getName(), $item->getId());
		}
		unset($item);

		    $this->smarty->assign('items', $items);
		    $paramsobj = new stdClass();
		    $paramsobj->params = $params;
		    $this->smarty->assign('mcfactory', $paramsobj);
		    if (isset($params['template']) && $this->GetTemplate($params['template'])) {
		    	return $this->ProcessTemplateFromDatabase($params['template']);
		    } else {
		    	return $this->ProcessTemplateFromDatabase('display_list');
		    }
	}
	
	public function updateItem($item_id)
	{
		$c = new MCFCriteria();
		$c->add('id', $item_id);
		$item = {{$module->getModuleName()}}Object::doSelectOne($c);
		
		if ($item !== false)
		{
			$item->forceUpdateObject('magic');	
		}
	}

	public function getAdminList($id,$returnid,$gCms)
	{
		
		/*if (!$this->CheckAccess('Manage MC Factory')) {
			return $this->DisplayErrorPage($id, $params, $returnid, $this->Lang('accessdenied'));
		}*/
		
		//return {{$module->getModuleName()}}Views::adminItems($this,$id,$returnid,$gCms);
	}
}

?>
