<?php

if (!isset($gCms)) exit;

$db = $this->GetDb();
$dict = NewDataDictionary($db);

switch(true) {
	case version_compare($oldversion, '0.1', '<'):
		$sql = $dict->AddColumnSQL(cms_db_prefix() . 'module_mcfactory_modules', 'filters X');
		$dict->ExecuteSQLArray($sql);
	case version_compare($oldversion, '0.3', '<'):
		$sql = $dict->AddColumnSQL(cms_db_prefix() . 'module_mcfactory_modules', 'parent_module I');
		$dict->ExecuteSQLArray($sql);
	case version_compare($oldversion, '1.0.1', '<'):
		$this->CreatePermission('Manage MCFactory', 'Manage MCFactory');
	case version_compare($oldversion, '1.1', '<'):
		$flds = array(
			'id I KEY',
			'attribute_name C(255)',
			'attribute_value C(255)'
		);
		$sql = $dict->CreateTableSQL(cms_db_prefix() . 'module_mcfactory_attributes', implode(',', $flds), array('mysql' => 'TYPE=MyISAM'));
		$dict->ExecuteSQLArray($sql);
		$db->CreateSequence(cms_db_prefix() . 'module_mcfactory_attributes_seq');
		$this->AddEventHandler('Core', 'ContentEditPost', false);
	case version_compare($oldversion, '2.7.1', '<'):
		$c = new MCFCriteria();
		$modules = MCFModule::doSelect($c);
		foreach ($modules as $module)
		{
				$sqlarray = $dict->AddColumnSQL(cms_db_prefix() . 'module_' . strtolower($module->getModuleName()), 'full_text_search XL');
				$dict->ExecuteSQLArray($sqlarray);
		}
	case version_compare($oldversion, '2.8.6', '<'):
		$sql = $dict->AddColumnSQL(cms_db_prefix() . 'module_mcfactory_modules', 'show_module I');
		$dict->ExecuteSQLArray($sql);
		
	
}

$this->Audit(0, $this->getFriendlyName(), $this->Lang('upgraded', $this->GetVersion()));

?>