<?php

class MCFListView {

	protected $module;
	protected $view;
	protected $titleFilter;
	protected $categoryFilters = array();
	protected $pageFilters = array();
	protected $orderBy = 'order_by';
	protected $customOrder = false;
	protected $page = 1;
	protected $itemsPerPage = 20;

	public function __construct($module, $params) {
		$this->module = $module;
		if (isset($params['view']) && $params['view']) {
			$this->view = $params['view'];
			$this->titleFilter = isset($_SESSION['views'][$this->view]['titleFilter']) ? $_SESSION['views'][$this->view]['titleFilter'] : null;
			$this->categoryFilters = isset($_SESSION['views'][$this->view]['categoryFilters']) ? $_SESSION['views'][$this->view]['categoryFilters'] : array();
			$this->pageFilters = isset($_SESSION['views'][$this->view]['pageFilters']) ? $_SESSION['views'][$this->view]['pageFilters'] : array();
			$this->page = isset($_SESSION['views'][$this->view]['page']) ? $_SESSION['views'][$this->view]['page'] : 1;
 		} else {
			$this->view = uniqid();
		}
		if (isset($params['page'])) {
		    $this->setPage($params['page']);
		}
		if (isset($params['clear_filters'])) {
			$this->setTitleFilter(null);
			$this->setCategoryFilters(array());
			$this->setPageFilters(array());
		} else {
			if (isset($params['titleFilter'])) {
				$this->setTitleFilter($params['titleFilter']);
			}
			if (isset($params['categoryFilters'])) {
				$this->setCategoryFilters($params['categoryFilters']);
			}
			if (isset($params['pageFilters'])) {
				$this->setPageFilters($params['pageFilters']);
			}
		}
	}

	public function getView() {
		return $this->view;
	}

	public function getTitleFilter() {
		return $this->titleFilter;
	}

	public function setTitleFilter($filter) {
		$clean = trim($filter);
		$this->titleFilter = $clean;
		$_SESSION['views'][$this->view]['titleFilter'] = $clean;
		$this->customOrder = ($this->orderBy != 'order_by') || !empty($this->titleFilter) || count($this->categoryFilters) || count($this->pageFilters);
	}

	public function getCategoryFilters() {
		return $this->categoryFilters;
	}

	public function setCategoryFilters($filters) {
		$clean = array();
		foreach ($filters as $filter) {
			if (!empty($filter)) {
				$clean[] = $filter;
			}
		}
		$this->categoryFilters = $clean;
		$_SESSION['views'][$this->view]['categoryFilters'] = $clean;
		$this->customOrder = ($this->orderBy != 'order_by') || !empty($this->titleFilter) || count($this->categoryFilters) || count($this->pageFilters);
	}

	public function getPageFilters() {
		return $this->pageFilters;
	}

	public function setPageFilters($filters) {
		$clean = array();
		foreach ($filters as $filter) {
			if (!empty($filter)) {
				$clean[] = $filter;
			}
		}
		$this->pageFilters = $clean;
		$_SESSION['views'][$this->view]['pageFilters'] = $clean;
		$this->customOrder = ($this->orderBy != 'order_by') || !empty($this->titleFilter) || count($this->categoryFilters) || count($this->pageFilters);
	}

	public function setOrderBy($value) {
		$this->orderBy = strtolower($value);
		$this->customOrder = (!in_array($this->orderBy, array('order_by', 'order_by asc'))) || !empty($this->titleFilter) || count($this->categoryFilters) || count($this->pageFilters);
	}

	public function setItemsPerPage($value) {
		$this->itemsPerPage = $value;
	}

	public function isCustomOrder() {
		return $this->customOrder;
	}

	public function getItemsPerPage() {
		return $this->itemsPerPage;
	}

	public function getPage() {
		return $this->page;
	}

	public function setPage($page) {
		$this->page = $page;
		$_SESSION['views'][$this->view]['page'] = $page;
	}

	public function getCriteria() {
		$c = new MCFCriteria();
		if (!empty($this->titleFilter)) {
			$c->add('title', '%' . $this->titleFilter . '%', MCFCriteria::LIKE);
		}
		if (count($this->categoryFilters)) {
			$c->add('id', MX_RelationLink::getRelatedItemsIds($this->module, $this->categoryFilters, 'options', 'AND'), MCFCriteria::IN);
		}
		if (count($this->pageFilters)) {
			$c->add('id', MX_RelationLink::getRelatedItemsIds($this->module, $this->pageFilters, 'pages', 'AND'), MCFCriteria::IN);
		}
		return $c;
	}

	public function getItems() {
		$totalPages = $this->getTotalPages();
		if ($this->page > $totalPages) {
			$this->setPage($totalPages);
		}
		$c = $this->getCriteria();
		if (preg_match('/(\w+)(?: (asc|desc))?/i', $this->orderBy, $matches)) {
			$column = $matches[1];
			$order = isset($matches[2]) ? strtolower($matches[2]) : 'asc';
			if ($order == 'desc') {
				$c->addDescendingOrderByColumn($column);
			} else {
				$c->addAscendingOrderByColumn($column);
			}
		}
		$c->setOffset(($this->page - 1) * $this->itemsPerPage);
		$c->setLimit($this->itemsPerPage);
		return call_user_func(array($this->module . 'Object', 'doSelect'), $c);
	}

	public function getTotalItems() {
		$c = $this->getCriteria();
		return call_user_func(array($this->module . 'Object', 'doCount'), $c);
	}

	public function getTotalPages() {
		return max(1, ceil($this->getTotalItems() / $this->itemsPerPage));
	}

}

?>