<?php

if (!isset($gCms)) exit;

if (!$this->CheckAccess()) {
	return $this->DisplayErrorPage();
}

if (isset($params['cancel'])) {
	$this->Redirect($id, 'defaultadmin', $returnid);
	exit;
}

if (isset($params['module_id']) && !empty($params['module_id'])) {
	$module = MCFModule::retrieveByPk($params['module_id']);
} else {
	$module = new MCFModule();
	$module->setParentModule(0);
}


if (isset($params['move_up']) && is_array($params['move_up']))
{
	foreach($params['move_up'] as $key => $value)
	{	
		$module->orderExtraFields($key, 'up');	
		$module->save();
	}
}

if (isset($params['move_down']) && is_array($params['move_down']))
{
	foreach($params['move_down'] as $key => $value)
	{	
		$module->orderExtraFields($key, 'down');	
		$module->save();
	}
}

if (isset($params['publish']) || isset($params['save']) ) {
	$module->populateFromArray($params);
	if (!isset($params['show_module']))
		{
			var_dump($params);
			$module->setShowModule(0);
		}
	$module->save();
	if (isset($params['publish']))
	{
		$module->publish();
		$this->Redirect($id, 'defaultadmin', $returnid);
		exit;	
	}
}

$c = new MCFCriteria();
$c->add('parent_module', 0);
if (isset($params['module_id']) && !empty($params['module_id'])) {
	$c->add('id', $module->getId(), MCFCriteria::NOT_EQUAL);
}
$modules = MCFModule::doSelect($c);
$modules_select = array('' => 0);
foreach ($modules as $mod) {
	$modules_select[$mod->getModuleFriendlyName()] = $mod->getId();
}

$field_types = $module->getFieldTypes();
$field_types_with_options = array();
foreach ($field_types as $field_type) {
	if ($field_type['options']) {
		$field_types_with_options[] = $field_type['type'];
	}
}

$filter_types = $module->getFilterTypes();

$this->smarty->assign('module_id', $id);
$this->smarty->assign('form_start', $this->CreateFormStart($id, 'edit', $returnid, 'post'));
$this->smarty->assign('input_module_id', $this->CreateInputHidden($id, 'module_id', $module->getId()));
$this->smarty->assign('input_module_parent', $this->CreateInputDropdown($id, 'parent_module', $modules_select, -1, $module->getParentModule()));
$this->smarty->assign('input_module_friendlyname', $this->CreateInputText($id, 'module_friendlyname', $module->getModuleFriendlyname(), 50));
$this->smarty->assign('created_by', $gCms->GetUserOperations()->LoadUserByID($module->getCreatedBy())->username);
$this->smarty->assign('created_at', $module->getCreatedAt());
$this->smarty->assign('updated_by', $gCms->GetUserOperations()->LoadUserByID($module->getUpdatedBy())->username);
$this->smarty->assign('updated_at', $module->getUpdatedAt());
$this->smarty->assign('extra_fields', $module->getExtraFields());
$this->smarty->assign('filters', $module->getFilters());
$this->smarty->assign('input_show_module', $this->CreateInputCheckbox($id, 'show_module', '1', is_null($module->getShowModule())?1:$module->getShowModule()));
$this->smarty->assign('publish_button', $this->CreateInputSubmit($id, 'publish', 'Publish')); 
$this->smarty->assign('save_button', $this->CreateInputSubmit($id, 'save', 'Save')); 
$this->smarty->assign('cancel_button', $this->CreateInputSubmit($id, 'cancel', 'Cancel'));
$this->smarty->assign('field_types', $field_types);
$this->smarty->assign('field_types_with_options', $field_types_with_options);
$this->smarty->assign('filter_types', $filter_types);

$this->smarty->assign('move_up', $this->getImage('arrow_up.png'));
$this->smarty->assign('move_down', $this->getImage('arrow_down.png'));

$this->smarty->assign('remove_icon',$gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'), '', '', 'systemicon'));
//$this->smarty->assign('up_icon',$gCms->variables['admintheme']->DisplayImage('icons/system/up.gif','', '', '', 'systemicon'));
//$this->smarty->assign('down_icon',$gCms->variables['admintheme']->DisplayImage('icons/system/down.gif', $this->Lang('move_down'), '', '', 'systemicon'));

echo $this->ProcessTemplate('edit.tpl');

?>
