<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.5
# File   : function.getContentBlocks.php
#          This file is included in the contenttype.Content2.php in function
#          get_content_blocks()
# Purpose: parses the template for content blocks and adds the content blocks
#          as property of the contenttype
# License: GPL
#
#-------------------------------------------------------------------------------
if(!isset($gCms)) exit;

$templateops =& $gCms->GetTemplateOperations();

if ($this->TemplateId() && $this->TemplateId() > -1) {
	$template = $templateops->LoadTemplateByID($this->TemplateId());
	$this->stylesheet = '../stylesheet.php?templateid='.$this->TemplateId();
}
else {
	$template = $templateops->LoadDefaultTemplate();
}

$this->_contentBlocks = array();
if($template !== false) {
	
	$content = $template->content;
	
	// read content blocks
	# this will search for {content} {content_image} {content_module} and {AdvancedContent} with or without params (case insensitive)
	$pattern = '/{(AdvancedContent|content(_image|_module)?)([^}]*)}/i';
	$pattern2 = '/([\w]+)=(["][^"]*["]|[\'][^\']*[\']|[^\'"\s]*)/';
	
	$matches = array();
	// get all the tags
	$result = preg_match_all($pattern, $content, $matches);
	
	if ($result && count($matches[3]) > 0) {
		
		// get the basic content properties
		$basicAttribs = array();
		foreach( $this->_attributes as $oneAttrib ) {
			$basicAttribs[] = $oneAttrib[0];
		}
		
		$j = 0;
		// foreach tag
		foreach ($matches[3] as $key=>$wholetag) {
			
			$j++;
			
			// get the arguments.
			$morematches = array();
			$result2 = preg_match_all($pattern2, $wholetag, $morematches);
			
			$keyval = array();
			for ($i = 0; $i < count($morematches[1]); $i++) {
				if(startswith($morematches[2][$i],'\''))
					$morematches[2][$i] = trim($morematches[2][$i],'\'');
				else if(startswith($morematches[2][$i],'"'))
					$morematches[2][$i] = trim($morematches[2][$i],'"');
				
				$keyval[strtolower($morematches[1][$i])] = $morematches[2][$i];
			}
			
			// block = active?
			if(isset($keyval['active']) && $this->IsFalse($keyval['active'])) {
				continue; // don't process inactive blocks
			}
			
			// additional editors
			$editorGroups = '';
			if(isset($keyval['editor_groups']) && $keyval['editor_groups'] != '') {
				$editorGroups = trim($keyval['editor_groups']);
			}
			$editorUsers = '';
			if(isset($keyval['editor_users']) && $keyval['editor_users'] != '') {
				$editorUsers = trim($keyval['editor_users']);
			}
			
			// blocktype
			$blockType = 'text';
			$tag = '';
			$defaultMode = false;
			if(isset($matches[1][$key]))
				$tag = strtolower($matches[1][$key]);
			if(startswith($tag, 'content_image')) {
				$blockType = 'image';
				$defaultMode = true;
			}
			elseif(startswith($tag, 'content_module')) {
				$blockType = 'module';
				$defaultMode = true;
			}
			elseif(isset($keyval['block_type']) && $keyval['block_type'] != '')
				$blockType = strtolower($keyval['block_type']);
			
			// blockname
			if($blockType == 'area')
				$name = 'default';
			else {
				$name = 'content_en';
				# MLE support
				if($this->mle && $this->blockLang != '') {
					$name = 'content'.$this->blockLang;
				}
				#---
			}
			
			if(isset($keyval['block']) && $keyval['block'] != '')
				$name = trim($keyval['block']);
			
			// block id
			$blockId = preg_replace('/-+/','_',munge_string_to_url($name));
			
			if($blockType == 'area') {
				$this->contentAreas[$blockId] = $name;
				continue;
			}
			
			$smarty = false;
			if(isset($keyval['smarty']) && $this->IsTrue($keyval['smarty'])) {
				$smarty = true;
			}
			
			$translateLabels = false;
			if(isset($keyval['translate_labels']) && $this->IsTrue($keyval['translate_labels'])) {
				$translateLabels = true;
			}
			
			$translateValues = false;
			if(isset($keyval['translate_values']) && $this->IsTrue($keyval['translate_values'])) {
				$translateValues = true;
			}
			
			$area = 'default';
			if(isset($keyval['area']) && $keyval['area'] != '')
				$area = strtolower($keyval['area']);
			
			$label = ucwords($name);
			if(isset($keyval['label']) && $keyval['label'] != '')
				$label = trim($keyval['label']);
			
			// default content/value
			$defaultValue 	= '';
			if(isset($keyval['default']) && $keyval['default'] != '')
				$defaultValue = $keyval['default'];
			
			// backend style (e.g. to mark required fields...)
			$style = '';
			if(isset($keyval['style'])) {
				$style = $keyval['style'];
			}
			
			// size of the input field
			$size = '';
			if(isset($keyval['size'])) {
				$size = intval($keyval['size']);
			}
			
			$pageTab = 'main';
			if(isset($keyval['page_tab']) && $keyval['page_tab'] != '')
				$pageTab = strtolower($keyval['page_tab']);
			
			$blockTab = '';
			if(isset($keyval['block_tab']) && $keyval['block_tab'] != '') {
				$blockTab = strtolower($keyval['block_tab']);
			}
			
			$allowNone = true;
			if(isset($keyval['allow_none']) && $this->IsFalse($keyval['allow_none']))
				$allowNone = false;
			
			// if this block has been added to the template after page has been created
			$newBlock = false;
			if(!in_array($blockId,$this->mProperties->mPropertyNames)) {
				$newBlock = true;
			}
			
			$description = '';
			if(isset($keyval['description']))
				$description = trim($keyval['description']);
			
			if(isset($this->_contentBlocks[$blockId])) {
				$this->_contentBlocks[$blockId]['multiple'] = true;
				continue;
			}
			
			// this will create an invalid block type to print out a 
			// message when using a basic content property as block name
			if(in_array($blockId, $basicAttribs) 
			|| $blockId == $blockId . '_feu_action' 
			|| $blockId == $blockId . '_feu_action[]' 
			|| $blockId == $blockId . '_feu_access' 
			|| $blockId == $blockId . '_feu_access[]' 
			|| $blockId == 'AdvancedContentStartDate' 
			|| $blockId == 'AdvancedContentEndDate' 
			|| $blockId == 'AdvancedContentStartTime' 
			|| $blockId == 'AdvancedContentEndTime' 
			|| $blockId == 'start_date' 
			|| $blockId == 'end_date' 
			|| $blockId == $blockId . '_AdvancedContentTime' 
			|| $blockId == $blockId . '_AdvancedContentDate') {
			
				$blockId = md5($blockId . $j);
				
				$this->_contentBlocks[$blockId]['name']             = $name;
				$this->_contentBlocks[$blockId]['block_id']         = $blockId;
				$this->_contentBlocks[$blockId]['block_type']       = '';
				$this->_contentBlocks[$blockId]['default_value']    = $this->lang('error_basicattrib', $name);
				$this->_contentBlocks[$blockId]['block_tab']        = $blockTab;
				$this->_contentBlocks[$blockId]['page_tab']         = $pageTab;
				$this->_contentBlocks[$blockId]['style']            = '';
				$this->_contentBlocks[$blockId]['label']            = $label;
				#$this->_contentBlocks[$blockId]['options']          = false;
				$this->_contentBlocks[$blockId]['allow_none']       = false;
				$this->_contentBlocks[$blockId]['sortable']         = false;
				$this->_contentBlocks[$blockId]['save_db']          = false;
				$this->_contentBlocks[$blockId]['smarty']           = false;
				$this->_contentBlocks[$blockId]['new_block']        = false;
				$this->_contentBlocks[$blockId]['description']      = '';
				$this->_contentBlocks[$blockId]['translate_labels'] = $translateLabels;
				$this->_contentBlocks[$blockId]['translate_values'] = $translateValues;
				$this->_contentBlocks[$blockId]['editor_users']     = $editorUsers;
				$this->_contentBlocks[$blockId]['editor_groups']    = $editorGroups;
				$this->_contentBlocks[$blockId]['sequence']         = count($this->_contentBlocks);
				$this->_contentBlocks[$blockId]['default_mode']     = false;
				continue;
			}
			
			if($blockType == 'text') {
				
				$maxlength = '';
				if(isset($keyval['maxlength'])) {
					$maxlength = $keyval['maxlength'];
				}
				
				$usewysiwyg = true;
				if(isset($keyval['wysiwyg']) && $this->IsFalse($keyval['wysiwyg'])) {
					$usewysiwyg = false;
				}
				
				$oneline = false;
				if(isset($keyval['oneline']) && $this->IsTrue($keyval['oneline'])) {
					$oneline = true;
				}
				
				$this->_contentBlocks[$blockId]['maxlength']  = $maxlength;
				$this->_contentBlocks[$blockId]['usewysiwyg'] = $usewysiwyg;
				$this->_contentBlocks[$blockId]['oneline']    = $oneline;
				$this->_contentBlocks[$blockId]['size']       = $size;
			}
			else if ($blockType == 'date') {
				
				$showClock = true;
				if(isset($keyval['show_clock']) && $this->IsTFalse($keyval['show_clock']))
					$showClock = false;
				
				$mode = 'calendar';
				if(isset($keyval['mode']) && strtolower($keyval['mode']) == 'dropdown')
					$mode = 'dropdown';
				
				$show24h = true;
				if(isset($keyval['show24h']) && $this->IsFalse($keyval['show24h']))
					$show24h = false;
				
				$startHour = 0;
				$endHour   = 23;
				if(isset($keyval['start_hour'])) {
					if(endswith($keyval['start_hour'],'pm')) {
						$keyval['start_hour'] = trim(str_ireplace('pm','',$keyval['start_hour'])) + 12;
					}
					else
						$keyval['start_hour'] = trim(str_ireplace(array('am','pm'),'',$keyval['start_hour']));
						
					if($keyval['start_hour'] > 0 && $keyval['start_hour'] <= $endHour)
						$startHour = trim($keyval['start_hour']);
				}
				
				if(isset($keyval['end_hour'])) {
					if(endswith($keyval['end_hour'],'pm')) {
						$keyval['end_hour'] = trim(str_ireplace('pm','',$keyval['end_hour'])) + 12;
					}
					else
						$keyval['end_hour'] = trim(str_ireplace(array('am','pm'),'',$keyval['end_hour']));
						
					if($keyval['end_hour'] >= 0 && $keyval['end_hour'] < $endHour)
						$endHour = trim($keyval['end_hour']);
				}
				
				if($endHour < $startHour)
					$endHour = $startHour;
				
				$startMinute = 0;
				if(isset($keyval['start_minute']) && $keyval['start_minute'] > 0 && $keyval['start_minute'] <= 59)
					$startMinute = trim($keyval['start_minute']);
				
				$endMinute = 59;
				if(isset($keyval['end_minute']) && $keyval['end_minute'] >= 0 && $keyval['end_minute'] < 59)
					$endMinute = trim($keyval['end_minute']);
				
				if($endMinute < $startMinute)
					$endMinute = $startMinute;
				
				$startSecond = 0;
				if(isset($keyval['start_second']) && $keyval['start_second'] > 0 && $keyval['start_second'] <= 59)
					$startSecond = trim($keyval['start_second']);
				
				$endSecond = 59;
				if(isset($keyval['end_second']) && $keyval['end_second'] >= 0 && $keyval['end_second'] < 59)
					$endSecond = trim($keyval['end_second']);
				
				if($endSecond < $startSecond)
					$endSecond = $startSecond;
				
				$stepHours = 1;
				if(isset($keyval['step_hours']) && $keyval['step_hours'] > 0 && $keyval['step_hours'] <= ($endHour-$startHour))
					$stepHours = trim($keyval['step_hours']);
				else if(isset($keyval['step_hours']) && $keyval['step_hours'] > 0 && $keyval['step_hours'] >= ($endHour-$startHour))
					$stepHours = $endHour-$startHour;
				
				$stepMinutes = 10;
				if(isset($keyval['step_minutes']) && $keyval['step_minutes'] > 0 && $keyval['step_minutes'] <= ($endMinute-$startMinute))
					$stepMinutes = trim($keyval['step_minutes']);
				else if(isset($keyval['step_minutes']) && $keyval['step_minutes'] > 0 && $keyval['step_minutes'] >= ($endMinute-$startMinute))
					$stepMinutes = $endMinute-$startMinute;
				
				$stepSeconds = 1;
				if(isset($keyval['step_seconds']) && $keyval['step_seconds'] > 0 && $keyval['step_seconds'] <= ($endSecond-$startSeconds))
					$stepSeconds = trim($keyval['step_seconds']);
				else if(isset($keyval['step_seconds']) && $keyval['step_seconds'] > 0 && $keyval['step_seconds'] >= ($endSecond-$startSeconds))
					$stepSeconds = $endSecond-$startSeconds;
				
				$this->_contentBlocks[$blockId]['show24h']      = $show24h;
				$this->_contentBlocks[$blockId]['mode']         = $mode;
				$this->_contentBlocks[$blockId]['start_hour']   = $startHour;
				$this->_contentBlocks[$blockId]['end_hour']     = $endHour;
				$this->_contentBlocks[$blockId]['start_minute'] = $startMinute;
				$this->_contentBlocks[$blockId]['end_minute']   = $endMinute;
				$this->_contentBlocks[$blockId]['start_second'] = $startSecond;
				$this->_contentBlocks[$blockId]['end_second']   = $endSecond;
				$this->_contentBlocks[$blockId]['step_hours']   = $stepHours;
				$this->_contentBlocks[$blockId]['step_minutes'] = $stepMinutes;
				$this->_contentBlocks[$blockId]['step_seconds'] = $stepSeconds;
				$this->_contentBlocks[$blockId]['show_clock']   = $showClock;
			}
			else if($blockType == 'file' || $blockType == 'image') {
				
				// todo: put this in display content blocks
				$upload = $delete = $createDirs = check_permission(get_userid(false), 'Modify Files');
				//---
				if(isset($keyval['upload']) && $this->IsTrue($keyval['upload'])) {
					$upload = true;
				}
				
				if(isset($keyval['delete']) && $this->IsTrue($keyval['delete'])) {
					$delete = true;
				}
				if(isset($keyval['create_dirs']) && $this->IsTrue($keyval['create_dirs'])) {
					$createDirs = true;
				}
				$dir = '';
				if(isset($keyval['dir']))
					$dir = trim($keyval['dir']);
				
				// filter stuff:
				$excludePrefix = 'thumb_';
				if(isset($keyval['exclude_prefix']))
					$excludePrefix = trim('thumb_,' . $keyval['exclude_prefix'], ', ');
				
				$excludeSufix = '';
				if(isset($keyval['exclude_sufix']))
					$excludeSufix = trim($keyval['exclude_sufix'],', ');
				
				$includePrefix = '';
				if(isset($keyval['include_prefix']))
					$includePrefix = trim($keyval['include_prefix'], ', ');
				
				$includeSufix = '';
				if(isset($keyval['include_sufix']))
					$includeSufix = trim($keyval['include_sufix'], ', ');
				
				$mode = 'dropdown';
				if(isset($keyval['mode']) && strtolower($keyval['mode']) == 'filepicker')
					$mode = 'filepicker';
				
				$lockInput = !$this->isAdmin;
				if(isset($keyval['lock_input']) && $this->IsFalse($keyval['lock_input']))
					$lockInput = false;
				
				$fileExt = '';
				if($blockType == 'image')
					$fileExt = 'jpg,jpeg,gif,png';
				if(isset($keyval['file_extensions']))
					$fileExt = $keyval['file_extensions'];
				
				$showSubDirs = $this->isAdmin;
				if(isset($keyval['show_subdirs']) && $this->IsTrue($keyval['show_subdirs']))
					$showSubDirs = true;
				
				$this->_contentBlocks[$blockId]['upload']          = $upload;
				$this->_contentBlocks[$blockId]['dir']             = $dir;
				$this->_contentBlocks[$blockId]['include_sufix']   = $includeSufix;
				$this->_contentBlocks[$blockId]['exclude_sufix']   = $excludeSufix;
				$this->_contentBlocks[$blockId]['include_prefix']  = $includePrefix;
				$this->_contentBlocks[$blockId]['exclude_prefix']  = $excludePrefix;
				$this->_contentBlocks[$blockId]['mode']            = $mode;
				$this->_contentBlocks[$blockId]['file_extensions'] = $fileExt;
				$this->_contentBlocks[$blockId]['size']            = $size;
				$this->_contentBlocks[$blockId]['lock_input']      = $lockInput;
				$this->_contentBlocks[$blockId]['show_subdirs']    = $showSubDirs;
				$this->_contentBlocks[$blockId]['delete']          = $delete;
				$this->_contentBlocks[$blockId]['create_dirs']     = $createDirs;
			}
			else if($blockType == 'checkbox') {
				// nothing to do here;
			}
			else if($blockType == 'dropdown' || $blockType == 'select_multiple') {
				
				if($blockType == 'select_multiple') {
					$sortable = false;
					if(isset($keyval['sortable_items']) && $this->IsTrue($keyval['sortable_items'])) {
						$sortable = true;
					}
					$this->_contentBlocks[$blockId]['sortable_items'] = $sortable;
				}
				
				$delimiter = '|';
				if(isset($keyval['delimiter']) && $keyval['delimiter'] != '') {
					$delimiter = $keyval['delimiter'];
				}
				$items = '';
				if(isset($keyval['items']) && $keyval['items'] != '') {
					$items = trim($keyval['items']);
				}
				$values = '';
				if(isset($keyval['values']) && $keyval['values'] != '') {
					$values = trim($keyval['values']);
				}
				
				$this->_contentBlocks[$blockId]['items']     = $items;
				$this->_contentBlocks[$blockId]['values']    = $values;
				$this->_contentBlocks[$blockId]['delimiter'] = $delimiter;
				
			}
			else if($blockType == 'module') {
				
				if(isset($keyval['module']))
					$module = trim($keyval['module']);
				else
					continue;
				
				$this->_contentBlocks[$blockId]['module'] = $module;
				$this->_contentBlocks[$blockId]['params'] = $keyval;
			}
			else if($blockType == 'note') {
				// ToDo: deprecated!
				if(isset($keyval['note']) && trim($keyval['note']) != '')
					$defaultValue = trim($keyval['note']);
				else
					continue; // don't show empty stuff here
			}
			else if($blockType == 'block_group') {
				// ToDo:
				// groups = groupname(s) (get from db)
				// multiple_groups (true/false)
			}
			
			$this->_contentBlocks[$blockId]['multiple']         = false;
			$this->_contentBlocks[$blockId]['smarty']           = $smarty;
			$this->_contentBlocks[$blockId]['style']            = $style;
			$this->_contentBlocks[$blockId]['name']             = $name;
			$this->_contentBlocks[$blockId]['block_id']         = $blockId;
			$this->_contentBlocks[$blockId]['block_type']       = $blockType;
			$this->_contentBlocks[$blockId]['default_value']    = $defaultValue;
			$this->_contentBlocks[$blockId]['label']            = $label;
			$this->_contentBlocks[$blockId]['block_tab']        = $blockTab;
			$this->_contentBlocks[$blockId]['page_tab']         = $pageTab;
			#$this->_contentBlocks[$blockId]['options']          = false;
			$this->_contentBlocks[$blockId]['save_db']          = false;
			$this->_contentBlocks[$blockId]['sortable']         = false;
			$this->_contentBlocks[$blockId]['new_block']        = $newBlock;
			$this->_contentBlocks[$blockId]['editor_users']     = $editorUsers;
			$this->_contentBlocks[$blockId]['editor_groups']    = $editorGroups;
			$this->_contentBlocks[$blockId]['allow_none']       = $allowNone;
			$this->_contentBlocks[$blockId]['translate_labels'] = $translateLabels;
			$this->_contentBlocks[$blockId]['translate_values'] = $translateValues;
			$this->_contentBlocks[$blockId]['description']      = $description;
			$this->_contentBlocks[$blockId]['sequence']         = count($this->_contentBlocks);
			$this->_contentBlocks[$blockId]['default_mode']     = $defaultMode;
			
			$this->AddExtraProperty($blockId);
			
		}
		
	}
	
	// force a load
	$this->mProperties->Load($this->mId);
	$this->_contentBlocksLoaded = true;
}

?>
