<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.5
# File   : function.displayContentBlocks.php
#          This file is included in ../contenttype.Content2.php in function
#          EditAsArray()
# Purpose: performs the ouptput of the content blocks using the contentType.tpl
# License: GPL
#
#-------------------------------------------------------------------------------

if(!isset($gCms)) exit;

$blockTabs = array();

$AdvancedContent =& $gCms->modules['AdvancedContent']['object'];
$filePicker      =& $AdvancedContent->GetFilePicker();
$rootUrl         = $gCms->config['root_url'] . '/';
$rootPath        = $gCms->config['root_path'] . DIRECTORY_SEPARATOR;
$j = 0;

// display the content blocks
foreach($this->_contentBlocks as $blockInfo) {
	
	$j++;
	
	if(!$this->CheckBlockPermission($blockInfo))
		continue;
	
	if(isset($this->pageTabs[$tab]) && $this->pageTabs[$tab] == $blockInfo['page_tab']) {
		
		if($blockInfo['block_type'] != '' && $blockInfo['smarty']) {
			foreach($blockInfo as $propName=>$propValue) {
				$blockInfo[$propName]                                   = $this->DoSmarty($propValue);
				$this->_contentBlocks[$blockInfo['block_id']][$propName] = $blockInfo[$propName];
			}
		}
		
		if($blockInfo['block_tab'] != '' && !in_array($blockInfo['block_tab'], $blockTabs))
			$blockTabs[] = $blockInfo['block_tab'];
		
		# MLE support
		if($this->mle && !$this->blockLang != '' && $blockInfo['block_id'] != 'content' . $this->blockLang)
			$data = $this->GetPropertyValue($blockInfo['block_id'] . $this->blockLang);
		else #---
			$data = $this->GetPropertyValue($blockInfo['block_id']);
		
		# MLE support
		if($this->mle && $data == '' && $this->defaultBlockLang != '' && $this->defaultBlockLang != $this->blockLang) {
			if($blockInfo['block_id'] != 'content' . $this->blockLang)
				$data = $this->GetPropertyValue($blockInfo['block_id'] . $this->defaultBlockLang);
			else
				$data = $this->GetPropertyValue('content' . $this->defaultBlockLang);
		}
		#---
		
		if(($adding && $data == '') 
		|| ($data == '' && !$blockInfo['allow_none']) || $blockInfo['new_block'])
			$data = $blockInfo['default_value'];
		
		$this->_contentBlocks[$blockInfo['block_id']]['content'] = cms_htmlentities($data, ENT_NOQUOTES, get_encoding(''));
		$this->_contentBlocks[$blockInfo['block_id']]['input']   = $AdvancedContent->lang('invalid_blocktype',$blockInfo['block_type'],$blockInfo['name']);
		
		#$blockInfo['options'] = ($blockInfo['block_type'] != '' && check_permission(get_userid(), 'Modify AdvancedContent Block Options') && $blockInfo['options']);
		#if($blockInfo['options']) {
		#	$this->_contentBlocks[$blockInfo['block_id']]['block_options'] = $this->DisplayBlockOptions($blockInfo['block_id']);
		#}
		
		if($blockInfo['label'] == ucwords($blockInfo['name']) 
		&& ($blockInfo['block_id'] == md5('content_en'.$j) 
		|| $blockInfo['block_id'] == 'content_en' 
		|| ($this->mle && $this->blockLang != '' 
		&& ($blockInfo['block_id'] == 'content' . $this->blockLang 
		|| $blockInfo['block_id'] == md5('content' . $this->blockLang.$j)))))
			$this->_contentBlocks[$blockInfo['block_id']]['label'] = lang('content');
		
		if($blockInfo['translate_labels'])
			$this->_contentBlocks[$blockInfo['block_id']]['label'] = $AdvancedContent->lang($blockInfo['label']);
		
		$blockDisplay = $AdvancedContent->GetElmDisplay('block',$this->mId, $blockInfo['block_id']);
		$this->_contentBlocks[$blockInfo['block_id']]['display']  = $blockDisplay;
		$this->_contentBlocks[$blockInfo['block_id']]['pref_url'] = str_replace('&amp;','&',
			$AdvancedContent->CreateLink('m1_', 'savePrefs', '', $this->lang('toggle_block'), 
				array('toggle'=>'block',
					'disable_theme'=>true, 
					'ajax'=>true, 
					'content_id'=>$this->mId,
					'block_id'=>$blockInfo['block_id']), 
				'', true));
		
		if($blockInfo['multiple'] && $AdvancedContent->GetElmDisplay('message',$this->mId, $blockInfo['block_id'])) {
			
			$hideLink = str_replace('&amp;','&',
				$AdvancedContent->CreateLink('m1_', 'savePrefs', '', $this->lang('toggle_message'), 
					array('toggle'=>'message',
						'disable_theme'=>true, 
						'ajax'=>true, 
						'content_id'=>$this->mId,
						'block_id'=>$blockInfo['block_id'],
						'display'=>0), 
					'', false,'','onclick="jQuery.get(this.href); jQuery(this).parent().toggle(\'fast\'); return false;"'));
				$this->_contentBlocks[$blockInfo['block_id']]['description'] = '<p>'.$AdvancedContent->lang('notice_duplicatecontent', $blockInfo['name']).' ('. $hideLink .')</p>'.$this->_contentBlocks[$blockInfo['block_id']]['description'];
		}
		switch($blockInfo['block_type']) {
			
			case 'module':
				
				if( !isset($gCms->modules[$blockInfo['module']]['object']) ) 
					continue; // ToDo: Display message here of missing module
				
				$module =& $gCms->modules[$blockInfo['module']]['object'];
				if( !is_object($module) ) 
					continue;// ToDo: Display message here of missing module instance
				
				if( !$module->HasCapability('contentblocks') ) 
					continue; // ToDo: Display message here of missing module function
				
				if( isset($blockInfo['inputname']) && $blockInfo['inputname'] != '' )
				{
					// a hack to allow overriding the input field name.
					$blockId = preg_replace('/-+/','_',munge_string_to_url($blockInfo['inputname']));
				}
				$this->_contentBlocks[$blockInfo['block_id']]['input'] = $module->GetContentBlockInput($blockInfo['block_id'],$data,$blockInfo['params'],$adding);
				
				break;
			
			case 'date':
				
				if(!$data)
					$data = time();
				
				$date = strftime('%x', intval($data));
				$time = '0:0';
				if($blockInfo['show_clock'])
					$time = strftime('%H:%M', intval($data));
				
				$_tmp        = $this->CleanArray(explode(':',$time));
				$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
				$dateSeconds = $data - $timeSeconds;
				
				$dateInput = '<img id="'.$blockInfo['block_id'].'_AdvancedContentDatePickerTrigger" src="../modules/AdvancedContent/images/calendar.png" class="calendarTrigger" />&nbsp;
					<span id="'.$blockInfo['block_id'].'_AdvancedContentDatePickerDisplay">'.$date.'</span>
					<input id="'.$blockInfo['block_id'].'_AdvancedContentDate" type="hidden" name="'.$blockInfo['block_id'].'_AdvancedContentDate" value="'.$dateSeconds.'" />';
					
				$suffix    = '';
				$timeInput = '';
				if($blockInfo['show_clock']) {
					
					$timeInput = '&nbsp;&nbsp;-&nbsp;&nbsp;<select name="'.$blockInfo['block_id'].'_AdvancedContentTime">';
					$_i        = 0;
					for($i=$blockInfo['start_hour']; $i<=$blockInfo['end_hour']; $i += $blockInfo['step_hours']) {
						
						if($i<12 && !$blockInfo['show24h'])
							$suffix = ' am';
						else if(!$blockInfo['show24h'])
							$suffix = ' pm';
						
						for($j=$blockInfo['start_minute']; $j<=$blockInfo['end_minute']; $j += $blockInfo['step_minutes']) {
							
							$value = ($i*3600) + ($j*60);
							if(($blockInfo['end_hour'] < 23 && $value <= ($blockInfo['end_hour'] * 3600)) || $blockInfo['end_hour'] == 23)
								$timeInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:(!$blockInfo['show24h'] && $i>12?$i-12:$i)) .':'. ($j<10?'0'.$j:$j) . $suffix . '</option>';
						}
						
						$j = $blockInfo['start_minute'];
					}
					
					$timeInput .= '</select>';
				}
				
				$this->_contentBlocks[$blockInfo['block_id']]['input']      = $dateInput.$timeInput;
				$this->_contentBlocks[$blockInfo['block_id']]['date']       = $date;
				$this->_contentBlocks[$blockInfo['block_id']]['date_value'] = $dateSeconds;
				$this->_contentBlocks[$blockInfo['block_id']]['date_input'] = $dateInput;
				$this->_contentBlocks[$blockInfo['block_id']]['time']       = $time;
				$this->_contentBlocks[$blockInfo['block_id']]['time_value'] = $timeSeconds;
				$this->_contentBlocks[$blockInfo['block_id']]['time_input'] = $timeInput;
				
				break;
			
			case 'file':
			case 'image':
				if(!$blockInfo['default_mode']) {
					$rootPath = $gCms->config['uploads_path'] . DIRECTORY_SEPARATOR;
					$rootUrl  = $gCms->config['uploads_url'] . '/';
				}
				if($blockInfo['block_type'] == 'image') {
					$this->_contentBlocks[$blockInfo['block_id']]['thumbnail'] = '<span id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerPreviewImage"><span class="ImgWrapper">';
					if($data != '') {
						if(!$thumbURL = $filePicker->GetThumbnail($rootPath . $data, $AdvancedContent->GetPreference('makethumbnail',0),true))
							$this->_contentBlocks[$blockInfo['block_id']]['thumbnail'] .= '<img src="'.$rootUrl . '/' . $data . '" width="200px" height="auto" alt="'.str_replace($gCms->config['root_url'] . '/','',$rootUrl).$data.'" title="'.str_replace($gCms->config['root_url'],'',$rootUrl).$data.'" />';
						else
							$this->_contentBlocks[$blockInfo['block_id']]['thumbnail'] .= '<img src="'. $thumbURL. '" alt="'.$data.'" title="'.str_replace($gCms->config['root_url'] . '/','',$gCms->config['uploads_url']).'/'.$data.'" />';
						if($blockInfo['mode'] == 'filepicker')
							$this->_contentBlocks[$blockInfo['block_id']]['thumbnail'] .= '<br />'. str_replace($gCms->config['root_url'] . '/','',$rootUrl) . $data;
					}
					$this->_contentBlocks[$blockInfo['block_id']]['thumbnail'] .= '</span>';
				}
				
				if($blockInfo['mode'] == 'dropdown') {
					$this->_contentBlocks[$blockInfo['block_id']]['input'] = $filePicker->CleanUrl(str_replace($gCms->config['root_url'] . '/','',$rootUrl).$blockInfo['dir'].'/',false).'/'.
						'<span id="'.$blockInfo['block_id'].'_DropdownWrapper">'.
							$filePicker->CreateFileDropdown($blockInfo['block_id'], 
								$rootPath . $blockInfo['dir'],
								$data,
								$blockInfo['exclude_prefix'], 
								$blockInfo['include_prefix'], 
								$blockInfo['exclude_sufix'], 
								$blockInfo['include_sufix'], 
								$blockInfo['file_extensions'], 
								$blockInfo['block_type'], 
								$blockInfo['allow_none'],
								$blockInfo['default_mode']).
						'</span>';
						
					if($blockInfo['upload'] && $AdvancedContent->GetPreference('showfilemanagement', 0)) {
						$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '&nbsp;|&nbsp;<input type="button" value="'.$this->lang('uploadfile').'" 
								id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerTrigger" class="FilePicker AdvancedContentXtraPanelTrigger" onclick="return false;" href="'.
								$AdvancedContent->CreateLink('m1_', 'filePicker', '', $this->lang('uploadfile'), 
									$this->CleanArray(array('dropdown'=>true,
										'disable_theme'=>true, 
										'show_subdirs'=>$blockInfo['show_subdirs'], 
										'subdir'=>($this->isAdmin?$blockInfo['dir']:''), 
										'startdir'=>($this->isAdmin?'':$blockInfo['dir']), 
										'type'=>$blockInfo['block_type'], 
										'picker_id' =>$blockInfo['block_id'], 
										'exclude_prefix'=>$blockInfo['exclude_prefix'], 
										'include_prefix'=>$blockInfo['include_prefix'], 
										'exclude_sufix'=>$blockInfo['exclude_sufix'], 
										'include_sufix'=>$blockInfo['include_sufix'], 
										'file_extensions'=>$blockInfo['file_extensions'], 
										'upload'=>$blockInfo['upload'],
										'delete'=>$blockInfo['delete'],
										'create_dirs'=>$blockInfo['create_dirs'],
										'allow_none'=>$blockInfo['allow_none'],
										'default_mode'=>$blockInfo['default_mode'])), 
									'', true).
							'" />';
					}
				}
				else if($blockInfo['mode'] == 'filepicker') {
					if($blockInfo['block_type'] == 'image') {
						$this->_contentBlocks[$blockInfo['block_id']]['input'] = '<input id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerInput" type="hidden" name="'.$blockInfo['block_id'].'" value="' . $data . '" />';
					}
					else if($blockInfo['block_type'] == 'file') {
						$this->_contentBlocks[$blockInfo['block_id']]['input'] = str_replace($gCms->config['root_url'] . '/','',$rootUrl).'<input id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerInput" type="text"' . ($blockInfo['lock_input']?' disabled="disabled"':'') . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . '"':'') . ($blockInfo['size'] != ''?' size="' . $blockInfo['size'] . '"':'') . ' name="' . $blockInfo['block_id'] . '" value="' . $data . '" />';
					}
					
					$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '
						<input type="button" value="'.$this->lang('select'.$blockInfo['block_type']).'"
							id="'.$blockInfo['block_id'].'_AdvancedContentFilePickerTrigger" class="FilePicker AdvancedContentXtraPanelTrigger" onclick="return false;" href="'.
							$AdvancedContent->CreateLink('m1_', 'filePicker', '', $this->lang('select'.$blockInfo['block_type']),
								$this->CleanArray(array('disable_theme'=>true, 
									'show_subdirs'=>$blockInfo['show_subdirs'], 
									'subdir'=>($this->isAdmin?$blockInfo['dir']:''), 
									'startdir'=>($this->isAdmin?'':$blockInfo['dir']), 
									'type'=>$blockInfo['block_type'], 
									'picker_id' =>$blockInfo['block_id'], 
									'exclude_prefix'=>$blockInfo['exclude_prefix'], 
									'include_prefix'=>$blockInfo['include_prefix'], 
									'exclude_sufix'=>$blockInfo['exclude_sufix'], 
									'include_sufix'=>$blockInfo['include_sufix'], 
									'file_extensions'=>$blockInfo['file_extensions'], 
									'upload'=>$blockInfo['upload'],
									'delete'=>$blockInfo['delete'],
									'create_dirs'=>$blockInfo['create_dirs'],
									'default_mode'=>$blockInfo['default_mode'])), 
							'', true).
						'" />';
					if($blockInfo['allow_none']) {
						$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '&nbsp;|&nbsp;<input type="button" value="'.lang('none').'" onclick="jQuery(\'#'.$blockInfo['block_id'].'_AdvancedContentFilePickerInput\').val(\'\'); toggleImage(\'#'.$blockInfo['block_id'].'_AdvancedContentFilePickerPreviewImage\',\'\'); return false;" />';
					}
				}
				break;
			
			case 'checkbox':
				$this->_contentBlocks[$blockInfo['block_id']]['input'] = '
					<input type="hidden" name="' . $blockInfo['block_id'] . '" value="0" />
					<input class="pagecheckbox"' . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . ' "':'') . ' type="checkbox" value="1" name="' . $blockInfo['block_id'] . '"' . ($data == 1 ? ' checked="checked"':'') . ' />';
				break;
			
			case 'dropdown':
				
				$items = array();
				if($blockInfo['items'] != '') {
					foreach($this->CleanArray(explode($blockInfo['delimiter'], $blockInfo['items'])) as $key => $val) {
						$items[$key]['label'] = trim($val);
						if($blockInfo['translate_labels'])
							$items[$key]['label'] = $AdvancedContent->lang($items[$key]['label']);
						
						$items[$key]['value']    = $items[$key]['label'];
						$items[$key]['selected'] = ($data === $val);
					}
				}
				if($blockInfo['values'] != '') {
					foreach($this->CleanArray(explode($blockInfo['delimiter'], $blockInfo['values'])) as $key => $val) {
						$items[$key]['value'] = trim($val);
						if($blockInfo['translate_values'])
							$items[$key]['value'] = $AdvancedContent->lang($items[$key]['value']);
						
						$items[$key]['selected'] = ($data === $items[$key]['value']);
						
						if(!isset($items[$key]['label']))
							$items[$key]['label'] = $items[$key]['value'];
					}
				}
				
				$this->_contentBlocks[$blockInfo['block_id']]['input'] = '<select name="' . $blockInfo['block_id'] . '" ' . ($blockInfo['style'] != ''?'style="' . $blockInfo['style'] . ' "':'') . ' >';
				foreach($items as $item) {
					
					$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '<option value="' . $item['value'] . '"';
					if($item['selected'])
						$this->_contentBlocks[$blockInfo['block_id']]['input'] .= ' selected="selected"';
					$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '>' . $item['label'] . '</option>';
				}
				$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '</select>';
				
				break;
			
			case 'select_multiple':
				
				$selItems = array();
				foreach($this->CleanArray(explode($blockInfo['delimiter'], $data)) as $key => $val) {
					$selItems[$key] = trim($val);
				}
				$items = array();
				if($blockInfo['items'] != '') {
					foreach($this->CleanArray(explode($blockInfo['delimiter'], $blockInfo['items'])) as $key => $val) {
						$items[$key]['label']    = trim($val);
						if($blockInfo['translate_labels'])
							$items[$key]['label'] = $AdvancedContent->lang($items[$key]['label']);
						
						$items[$key]['value']    = $items[$key]['label'];
						$items[$key]['selected'] = in_array($items[$key]['label'],$selItems);
					}
				}
				if($blockInfo['values'] != '') {
					foreach($this->CleanArray(explode($blockInfo['delimiter'], $blockInfo['values'])) as $key => $val) {
						$items[$key]['value']    = trim($val);
						if($blockInfo['translate_values'])
							$items[$key]['value'] = $AdvancedContent->lang($items[$key]['value']);
						
						$items[$key]['selected'] = in_array($items[$key]['value'],$selItems);
						if(!isset($items[$key]['label']))
							$items[$key]['label'] = $items[$key]['value'];
					}
				}
				
				$this->_contentBlocks[$blockInfo['block_id']]['input'] = '
					<input type="hidden" value="" "name="' . $blockInfo['block_id'] . '" />';
				
				if(!$blockInfo['sortable_items']) {
					$size = count($items);
					if(isset($blockInfo['size']))
						$size = $blockInfo['size'];
					
					$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '
						<select name="' . $blockInfo['block_id'] . '[]"' . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . ' "':'') . '  multiple="multiple" size="'.$size.'">';
					foreach($items as $item) {
						
						$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '<option value="' . $item['value'] . '"';
						if($item['selected'])
							$this->_contentBlocks[$blockInfo['block_id']]['input'] .= ' selected="selected"';
						$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '>' . $item['label'] . '</option>';
					}
					$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '</select>';
				}
				else {
					
					// sort the items
					$_items = array();
					foreach($selItems as $selKey => $selItem) {
						reset($items);
						foreach($items as $itemKey => $item) {
							if($item['value'] === $selItem) {
								$_items[] = $item;
								unset($items[$itemKey]);
								unset($selItems[$selKey]);
								break;
							}
						}
					}
					
					$items = array_merge($_items,$items);
					$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '<div class="sortable_items">';
					foreach($items as $item) {
						$this->_contentBlocks[$blockInfo['block_id']]['input'] .= 
						'<div class="sortable_item">
							<img class="sortable_item_handler" src="../modules/AdvancedContent/images/sort.png" />
							<input class="pagecheckbox"' . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . ' "':'') . ' type="checkbox" value="'.$item['value'].'" name="' . $blockInfo['block_id'] . '_AdvancedContentSortableItem_' . munge_string_to_url($item['label']) . '"' . ($item['selected']? ' checked="checked"':'') . ' />
							'.$item['label'].'
						</div>';
					}
					$this->_contentBlocks[$blockInfo['block_id']]['input'] .= '</div>';
				}
				break;
			
			case 'text':
				$usewysiwyg = !$this->GetPropertyValue('disable_wysiwyg');
				if(!$usewysiwyg)
					$blockInfo['usewysiwyg'] = false;
				if ($blockInfo['oneline'] == false) {
					$this->_contentBlocks[$blockInfo['block_id']]['input'] = create_textarea($blockInfo['usewysiwyg'], $data, $blockInfo['block_id'], '', $blockInfo['block_id'], '', $this->stylesheet);
				}
				else {
					$this->_contentBlocks[$blockInfo['block_id']]['input'] = '<input type="text"' . ($blockInfo['style'] != ''?'style="' . $blockInfo['style'] . ' "':'') . ($blockInfo['maxlength'] != ''?' maxlength="' . $blockInfo['maxlength'] . ' "':'') . ($blockInfo['size'] != ''?' size="' . $blockInfo['size'] . ' "':'') . ' name="' . $blockInfo['block_id'] . '" value="' . $this->_contentBlocks[$blockInfo['block_id']]['content'] . '" />';
				}
				break;
			
			case 'note':
			default: 
				$this->_contentBlocks[$blockInfo['block_id']]['content'] = $blockInfo['default_value'];
				break;
		}
	}
}

$gCms->smarty->assign('fpWidth', $AdvancedContent->GetPreference('filepickerwidth',0));
$gCms->smarty->assign('fpHeight', $AdvancedContent->GetPreference('filepickerheight',0));

$gCms->smarty->assign('fpWidthUnit', $AdvancedContent->GetPreference('filepickerwidthunit','px'));
$gCms->smarty->assign('fpHeightUnit', $AdvancedContent->GetPreference('filepickerheightunit','px'));

$gCms->smarty->assign('uploadsUrl', str_replace($gCms->config['root_url'] . '/','',$rootUrl));

$gCms->smarty->assign('blockContent_text', $AdvancedContent->lang('blockcontent'));
$gCms->smarty->assign('blockOptions_text', $AdvancedContent->lang('blockoptions'));
$gCms->smarty->assign('none_text', lang('none'));
$gCms->smarty->assign('preview_text', lang('preview'));
$gCms->smarty->assign('selectimage_text', $this->lang('selectimage'));
$gCms->smarty->assign('moduleId', 'm1_');
$gCms->smarty->assign('tab', $tab);
$gCms->smarty->assign('pageTab', $this->pageTabs[$tab]);
$gCms->smarty->assign('blockTabs', $blockTabs);
$gCms->smarty->assign('contentBlocks', $this->_contentBlocks);

$ret[] = array('', $AdvancedContent->ProcessTemplate('contentType.tpl'));
?>
