<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.5
# File   : action.filePicker.php
#          This file is a modification of the TinyMCE filepicker that comes by 
#          default with CMSms
# Purpose: browse through a given directory
# License: GPL
#
#-------------------------------------------------------------------------------

if(!isset($gCms)) exit;

//make sure that this action only can be accessed when logged in in backend
global $CMS_ADMIN_PAGE;
if(!isset($CMS_ADMIN_PAGE) || $CMS_ADMIN_PAGE !== 1)
	exit;

$userOps =& $gCms->GetUserOperations();
$isAdmin = $userOps->UserInGroup(get_userid(),1); // get_userid() checks login anyway

// ToDo: Check Permission?

$filePicker =& $this->GetFilepicker();

if(!isset($params['picker_id']) || $params['picker_id']=='')
	exit;
else
	$pickerId = trim($params['picker_id']);

$filePickerstyle = $this->GetPreference('filepickerstyle','both');

$defaultMode = false;
if(isset($params['default_mode']) && $this->IsTrue($params['default_mode']))
	$defaultMode = true;

$type = 'image';
if(isset($params['type']))
	$type = $params['type'];

$fileExt = array();
if($type == 'image') {
	$fileExt = array('jpg','jpeg','gif','png');
}

$rootPath = $gCms->config['uploads_path'] . DIRECTORY_SEPARATOR;
$rootUrl  = $gCms->config['uploads_url'] . '/';

$startDir = '';
if(isset($params['startdir']) && $params['startdir'] != '') {
	$startDir = $filePicker->CleanUrl($params['startdir'], false);
}
if($startDir != '') {
	$rootPath .= str_replace('/',DIRECTORY_SEPARATOR,$startDir) . DIRECTORY_SEPARATOR;
	$rootUrl  .= $startDir . '/';
}

if (($this->GetPreference('restrictdirs', 0) == 1)) {
	$username = $gCms->variables['username'];
	if(@mkdir($rootPath . $username) 
	|| (file_exists($rootPath . $username) && is_dir($rootPath . $username))) {
		if(!$isAdmin) {
			$rootPath .= $username;
			$rootUrl  .= $username;
		}
		else if ($isAdmin && !isset($params['goto_root']) && (!isset($params['subdir']) || $params['subdir'] == ''))
			$params['subdir'] = $username;
	}
}

$subDir = '';
if (isset($params['subdir'])) {
	$subDir = $filePicker->CleanUrl($params['subdir'], false);
}

$thisDir = $rootPath;
if ($subDir != '')
	$thisDir .= str_replace('/', DIRECTORY_SEPARATOR, $subDir) . DIRECTORY_SEPARATOR;

$thisUrl = $rootUrl;
if ($subDir != '') 
	$thisUrl .= $subDir . '/';

$allowNone = true;
if(isset($params['allow_none']) && $this->IsFalse($params['allow_none']))
	$allowNone = false;

$dropdown = false;
if(isset($params['dropdown']) && $this->IsTrue($params['dropdown']))
	$dropdown = true;

if(isset($params['file_extensions']) && $params['file_extensions'] != '') {
	$_fileExt = $filePicker->CleanArray(explode(',',$params['file_extensions']));
	if($params['type'] == 'image')
		$_fileExt = $filePicker->CleanArray(array_intersect($_fileExt, $fileExt));
	if(empty($_fileExt))
		$_fileExt = $fileExt;
	
	$fileExt = $_fileExt;
}

$excludePrefix = '';
if(isset($params['exclude_prefix']))
	$excludePrefix = trim($params['exclude_prefix']);

$excludeSufix = '';
if(isset($params['exclude_sufix']))
	$excludeSufix = trim($params['exclude_sufix']);

$includePrefix = '';
if(isset($params['include_prefix']))
	$includePrefix = trim($params['include_prefix']);

$includeSufix = '';
if(isset($params['include_sufix']))
	$includeSufix = trim($params['include_sufix']);

$showSubDirs = false;
if(isset($params['show_subdirs']) && $this->IsTrue($params['show_subdirs']))
	$showSubDirs = true;

if(file_exists($thisDir)) {

	$fmallowed = $upload = $delete = $createDirs = $this->CheckPermission('Modify Files');
	$showfm    = $this->GetPreference('showfilemanagement', 0);
	if(isset($params['upload']) && $params['upload'] == true) {
		$upload = true;
	}
	if(isset($params['delete']) && $params['delete'] == true) {
		$delete = true;
	}
	if(isset($params['create_dirs']) && $params['create_dirs'] == true) {
		$createDirs = true;
	}
	$usefm = (($fmallowed || $upload || $delete || $createDirs) && $showfm);
	
	//Handle File upload and dir creation
	if ($usefm) {
		if (isset($params['upload_file']) && $upload) {
			if (isset($_FILES[$id.'newfile'])) {
				//CHeck for uploaded file
				if ($_FILES[$id.'newfile']['name'] != '') {
					
					// get file type
					$fileType = $filePicker->GetFileType($_FILES[$id.'newfile']['tmp_name'],$this->GetPreference('usemimetype',0));
					if(!$fileType || $fileType == 'tmp') {
						if($this->GetPreference('usemimetype',0))
							$fileType = $_FILES[$id.'newfile']['type'];
						else
							$fileType = $filePicker->GetFileType($_FILES[$id.'newfile']['name']);
					}
					
					//check filename
					if ($filePicker->ContainsIllegalChars($_FILES[$id.'newfile']['name'])) {
						$errorMessage = $this->Lang('containsillegalchars', $_FILES[$id.'newfile']['name']);
					} 
					else if (($_FILES[$id.'newfile']['size']>$config['max_upload_size'])
					|| ($_FILES[$id.'newfile']['error'] == 1)) {
						$errorMessage = $this->Lang('filetoobig', $_FILES[$id.'newfile']['name']);
					}
					else if($type == 'image' && !in_array(str_replace('image/','',$fileType),$fileExt)) {
						$errorMessage = $this->Lang('noimagefile',$_FILES[$id.'newfile']['name'] . ' ('.$fileType.')');
					}
					else if($type != 'image' && !empty($fileExt) && !in_array(strtolower(substr($_FILES[$id.'newfile']['name'], strrpos($_FILES[$id.'newfile']['name'], '.') + 1)),$fileExt)) {
						$errorMessage = $this->Lang('filetypenotallowed', $fileType);
					}
					else {
						$fileName = $thisDir.$filePicker->CleanPath($_FILES[$id.'newfile']['name'], false);
						if (isset($params['resize_on'])) {
							// ToDo: keep tmp dir !!!
							if ($filePicker->HandleFileResizing($_FILES[$id.'newfile']['tmp_name'], $fileName,$params['resize_x'], $params['resize_y'],$params['keep_aspectratio'],$this->GetPreference('allowupscaling',0))) {
								if ($this->GetPreference('makethumbnail',0)==1) {
									$thumbname = $thisDir."thumb_".$filePicker->CleanPath($_FILES[$id.'newfile']['name'], false);
									$filePicker->HandleFileResizing($fileName,$thumbname,get_site_preference('thumbnail_width',96),get_site_preference('thumbnail_height',96),true,false,60);
								}
								$message = $this->Lang('fileuploaded', $_FILES[$id.'newfile']['name']);
							} else {
								$errorMessage = $this->Lang('uploadfailed', $_FILES[$id.'newfile']['name']);
							}
						} else {
							if (cms_move_uploaded_file($_FILES[$id.'newfile']['tmp_name'], $fileName)) {
								if ($this->GetPreference('makethumbnail',0)==1) {
									$thumbname = $thisDir."thumb_".$filePicker->CleanPath($_FILES[$id.'newfile']['name'],false);
									$filePicker->HandleFileResizing($fileName,$thumbname,get_site_preference('thumbnail_width',96),get_site_preference('thumbnail_height',96),true,false,60);
								}
								$message = $this->Lang('fileuploaded',$_FILES[$id.'newfile']['name']);
							} else {
								$errorMessage = $this->Lang('uploadfailed',$_FILES[$id.'newfile']['name']);
							}
						}
					}
				} else {
					$errorMessage = $this->Lang('nofile');
				}
			} else {
				//This shouldn't happen
				$errorMessage = $this->Lang('nofile');
			}
		}
		
		if (isset($params['create_dir']) && $createDirs) {
			
			if (isset($params['newdir']) && $params['newdir']!='') {
				$newDir = $filePicker->CleanPath($params['newdir'],false);
				if (!is_dir($thisDir . $newDir)) {
					if (mkdir($thisDir . $newDir)) {
						$message = $this->Lang('newdircreated', str_replace($gCms->config['root_path'],'', $thisDir . $newDir));
					} else {
						$errorMessage = $this->Lang('newdirfailed', str_replace($gCms->config['root_path'],'', $thisDir . $newDir));
					}
				} else {
					$errorMessage = $this->Lang('direxists', str_replace($gCms->config['root_path'],'', $thisDir . $newDir));
				}
			} else {
				$errorMessage = $this->Lang('nodirname');
			}
		}
		if (isset($params['deletefilename']) && $delete) {
			$fileName = $filePicker->CleanPath(base64_decode($params['deletefilename']),false);
			if (@unlink($thisDir.$fileName)) {
				@unlink($thisDir.'thumb_'.$fileName);
				$message = $this->Lang('deletefilesuccess',str_replace($gCms->config['root_url'],'',$thisUrl.$fileName));
			} else {
				$errorMessage = $this->Lang('deletefilefailed', str_replace($gCms->config['root_url'],'',$thisUrl.$fileName));
			}
		}
		if (isset($params['deletesubdir']) && $delete) {
			$fileName = $filePicker->CleanPath(base64_decode($params['deletesubdir']),false);
			if (@rmdir($thisDir.$fileName)) {
				$message = $this->Lang('deletesubdirsuccess', str_replace($gCms->config['root_url'],'',$thisUrl.$fileName));
			} else {
				$errorMessage = $this->Lang('deletesubdirfailed', str_replace($gCms->config['root_url'],'',$thisUrl.$fileName));
			}
		}
	}
	if(!$dropdown) {
		
		$files = $filePicker->GetFiles($thisDir, $excludePrefix, $includePrefix, $excludeSufix, 
			$includeSufix, $fileExt, $type, !$showSubDirs, $defaultMode);
		
		$showFiles = array();
		
		if ($subDir != '') {
			$onerow             = new stdClass();
			$onerow->isdir      = '1';
			$onerow->thumbnail  = '';
			$onerow->dimensions = '';
			$onerow->size       = '';
			$newSubDir          = dirname($subDir);
			$onerow->fileicon   = $filePicker->GetFileIcon(array('ext'=>'','isdir'=>1));
			$onerow->namelink   = $this->CreateLink($id, 'filePicker', $returnid,'[..]', 
				$this->CleanArray(array('disable_theme'=>true, '
					type'=>$type, 
					'subdir'=>$newSubDir, 
					'show_subdirs'=>$showSubDirs, 
					'startdir'=>$startDir,
					'picker_id'=>$pickerId, 
					'upload'=>$upload, 
					'delete'=>$delete, 
					'create_dirs'=>$createDirs, 
					'exclude_prefix'=>$excludePrefix,
					'exclude_sufix'=>$excludeSufix, 
					'include_prefix'=>$includePrefix, 
					'include_sufix'=>$includeSufix, 
					'file_extensions'=>implode(',',$fileExt),
					'default_mode'=>$defaultMode)),
				'','','','onclick="return getDir(this.href)"');
			array_push($showFiles, $onerow);
		}
		
		$fileCount = 0;
		$dirCount = 0;
		foreach($files as $file) {
			
			if ($file['isdir'] && !$showSubDirs)
				continue;
			
			$onerow           = new stdClass();
			$onerow->name     = $file['name'];
			$onerow->id       = munge_string_to_url($file['name']);
			if($gCms->config['debug']) {
				$onerow->debug = $file['debug'];
			}
			$onerow->fileicon = $file['fileicon'];
			if ($file['isdir']) {
				$onerow->isdir    = '1';
				$onerow->namelink = $this->CreateLink($id, 'filePicker', $returnid, '[' . $file['name'] . ']', 
					$this->CleanArray(array('disable_theme'=>true,
						'type'=>$type,
						'startdir'=>$startDir,
						'show_subdirs'=>$showSubDirs,
						'subdir'=>$subDir . '/' . $file['name'],
						'picker_id'=>$pickerId,
						'upload'=>$upload,
						'delete'=>$delete,
						'create_dirs'=>$createDirs,
						'exclude_prefix'=>$excludePrefix,
						'exclude_sufix'=>$excludeSufix,
						'include_prefix'=>$includePrefix,
						'include_sufix'=>$includeSufix,
						'file_extensions'=>implode(',',$fileExt),
						'default_mode'=>$defaultMode)),
					'','','','onclick="return getDir(this.href)"');
				if ($filePicker->IsDirEmpty($filePicker->CleanPath($thisDir.$file['name'])) && ($usefm && $delete)) {
					$onerow->deletelink = $this->CreateLink($id, 'filePicker', $returnid, $filePicker->GetActionIcon('delete'), 
						$this->CleanArray(array('disable_theme'=>true, 'type'=>$type, 
							'startdir'=>$startDir, 
							'show_subdirs'=>$showSubDirs, 
							'deletesubdir'=>base64_encode($file['name']), 
							'subdir'=>$subDir, 
							'picker_id'=>$pickerId, 
							'upload'=>$upload,
							'delete'=>$delete, 
							'create_dirs'=>$createDirs)),
						'','','','onclick="return deleteFile(this.href, \''.$this->lang('confirmdeletedir',str_replace($gCms->config['root_url'],'',$thisUrl.$file['name'])).'\')"');
				}
				$dirCount++;
			}
			else {
				$onerow->type    = $file['type'];
				$onerow->isdir   = '0';
				$onerow->isimage = $file['isimage'];
				if (isset($file['thumbnail'])) 
					$onerow->thumbnail = $file['thumbnail'];
				else
					$onerow->thumbnail  = '';
				$onerow->fullurl = $file['fullurl'];
				$onerow->rel_url = $file['rel_url'];
				if (isset($file['dimensions'])) {
					$onerow->dimensions = $file['dimensions'];
				} 
				else {
					$onerow->dimensions = '&nbsp;';
				}
				if ($usefm && $delete) {
					$onerow->deletelink = $this->CreateLink($id, 'filePicker', $returnid, $filePicker->GetActionIcon('delete'), 
							$this->CleanArray(array('disable_theme'=>true, 'type'=>$type, 
								'startdir'=>$startDir, 
								'show_subdirs'=>$showSubDirs, 
								'deletefilename'=>base64_encode($file['name']), 
								'subdir'=>$subDir, 'picker_id'=>$pickerId, 
								'upload'=>$upload,
								'delete'=>$delete, 
								'create_dirs'=>$createDirs)),
							'','','','onclick="return deleteFile(this.href, \''.$this->lang('confirmdelete',str_replace($gCms->config['root_url'],'',$thisUrl.$file['name'])).'\')"');
				}
				$i = 0;
				$unit = ' B';
				while($file['size'] > 1024) {
					$i++;
					$file['size'] = $file['size']/1024;
				}
				switch($i) {
					case '1': $unit = ' KB'; break;
					case '2': $unit = ' MB'; break;
					case '3': $unit = ' TB'; break;
				}
				$file['size'] = number_format($file['size'], ($i>0?2:0), $this->lang('decimaldelimiter'), $this->lang('thousanddelimiter'));
				$onerow->size = $file['size'] . $unit;
				$fileCount++;
			}
			array_push($showFiles, $onerow);
		}
		
		$this->smarty->assign('dirCount', $dirCount);
		$this->smarty->assign('fileCount', $fileCount);
		$this->smarty->assign('thumbWidth', get_site_preference('thumbnail_width',96)+15);
		$this->smarty->assign('sizetext', $this->Lang('size'));
		#$this->smarty->assign('dimensionstext', $this->Lang('dimensions'));
		$this->smarty->assign('delete', $usefm && $delete);
		
		$breadCrumbs = $this->CleanArray(explode('/', $subDir));
		$_subDir = '';
		foreach($breadCrumbs as $k => $v) {
			$_subDir .= '/' . $v;
			if(trim($_subDir,'/') != $subDir) {
				$breadCrumbs[$k] = $this->CreateLink($id, 'filePicker', $returnid, $v, 
					$this->CleanArray(array('disable_theme'=>true, 
						'type'=>$type, 
						'startdir'=>$startDir, 
						'show_subdirs'=>$showSubDirs, 
						'subdir'=> trim($_subDir,'/'),
						'picker_id'=>$pickerId, 
						'upload'=>$upload,
						'delete'=>$delete, 
						'create_dirs'=>$createDirs,
						'exclude_prefix'=>$excludePrefix, 
						'exclude_sufix'=>$excludeSufix, 
						'include_prefix'=>$includePrefix, 
						'include_sufix'=>$includeSufix, 
						'file_extensions'=>implode(',',$fileExt),
						'default_mode'=>$defaultMode)),
					'','','','onclick="return getDir(this.href)"');
			}
			
		}
		$this->smarty->assign('breadCrumbs', implode('/',$breadCrumbs));
		$this->smarty->assign('root', $this->CreateLink($id, 'filePicker', $returnid, 'root', 
				$this->CleanArray(array('disable_theme'=>true, 
					'goto_root'=>true,
					'type'=>$type, 
					'startdir'=>$startDir, 
					'show_subdirs'=>$showSubDirs, 
					'subdir'=> '',
					'picker_id'=>$pickerId, 
					'upload'=>$upload,
					'delete'=>$delete, 
					'create_dirs'=>$createDirs,
					'exclude_prefix'=>$excludePrefix, 
					'exclude_sufix'=>$excludeSufix, 
					'include_prefix'=>$includePrefix, 
					'include_sufix'=>$includeSufix,
					'file_extensions'=>implode(',',$fileExt),
					'default_mode'=>$defaultMode)),
				'',true,'','onclick="return getDir(this.href)"'));
		
		$this->smarty->assign('pickerId', $pickerId);
		$this->smarty->assign('filepickerstyle', $filePickerstyle);
		#$this->smarty->assign('filePickertitle', $this->Lang('filePickertitle'));
		$this->smarty->assign('youareintext', $this->Lang('youareintext'));
		$this->smarty->assign('subDir', $subDir);
		$this->smarty->assign_by_ref('files', $showFiles);
		$this->smarty->assign('filesCount', count($showFiles));
	}
	if ($usefm && ($upload || $createDirs)) {
		if(($dropdown && !isset($params['upload_file'])) || !$dropdown) {
			$this->smarty->assign('upload', $upload && $usefm);
			$this->smarty->assign('newdir', ($usefm && $showSubDirs && $createDirs));
			
			$this->smarty->assign('successtext', $this->Lang('success'));
			$this->smarty->assign('errortext', $this->Lang('error'));
			$this->smarty->assign('fileoperations', $this->Lang('fileoperations'));
			
			$controlDisplay = get_preference(get_userid(),'file_operations_display',1);
			$this->smarty->assign('fileOperationsDisplay', $controlDisplay);
			$prefUrl        = $this->CreateLink($id, 'savePrefs', $returnid, $this->lang('toggle_fileoperations'), 
				array('toggle'=>'fileoperations',
					'disable_theme'=>true, 
					'ajax'=>true),
				'',true);
			$this->smarty->assign('prefUrl', $prefUrl);
			
			$this->smarty->assign('formstart', $this->CreateFormStart($id, 'filePicker', 
				$returnid, 'post', 'multipart/form-data', false, '', 
				$this->CleanArray(array('picker_id'=>$pickerId,
					'type'=>$type,
					'startdir'=>$startDir,
					'file_extensions' => implode(',',$fileExt),
					'exclude_prefix'=>$excludePrefix, 
					'exclude_sufix'=>$excludeSufix, 
					'include_prefix'=>$includePrefix, 
					'include_sufix'=>$includeSufix,
					'show_subdirs'=>$showSubDirs,
					'subdir'=>$subDir, 
					'upload'=>$upload,
					'delete'=>$delete, 
					'create_dirs'=>$createDirs,
					'disable_theme'=>true,
					'dropdown'=>$dropdown,
					'allow_none'=>$allowNone,
					'default_mode'=>$defaultMode))));
			
			$this->smarty->assign('fileuploadtext', $this->Lang('uploadnewfile'));
			
			$this->smarty->assign('fileuploadinput', $this->CreateInputFile($id, 'newfile', 'id="'.$pickerId.'_FileUpload"', 20));
			
			$targetId = 'AdvancedContentFilePickerContent';
			$autoClosePanel = false;
			$messageId = '';
			if($dropdown) {
				$messageId = 'Edit_Content_Result';
				$autoClosePanel = true;
				$targetId = $pickerId.'_DropdownWrapper';
			}
			
			$this->smarty->assign('fileuploadsubmit', $this->CreateInputSubmit($id, 'upload_file', $this->Lang('uploadfile'), 'onClick="return submitForm(this,\''.$targetId.'\',\''.$messageId.'\',\''.$autoClosePanel.'\')"'));
			if($showSubDirs && $createDirs) {
				$this->smarty->assign('newdirtext', $this->Lang('createnewdir'));
				$this->smarty->assign('newdirinput', $this->CreateInputText($id, 'newdir', '', 20, 255, 'id="'.$pickerId.'_CreateDir"'));
				$this->smarty->assign('newdirsubmit', $this->CreateInputSubmit($id, 'create_dir', $this->Lang('createdir'), 'onClick="return submitForm(this,\'AdvancedContentFilePickerContent\')"'));
			}
			if ($this->GetPreference('allowscaling') == '1') {
				$this->smarty->assign('resizeto', $this->Lang('resizeto'));
				$this->smarty->assign('resize_x', $this->CreateInputText($id, 'resize_x', $this->GetPreference('scalingwidth'), 4, 4));
				$this->smarty->assign('resize_y', $this->CreateInputText($id, 'resize_y', $this->GetPreference('scalingheight'), 4, 4));
				$this->smarty->assign('resize_on', $this->CreateInputCheckbox($id, 'resize_on', '1'));
				$this->smarty->assign('keepaspectratio_text', $this->Lang('keepaspectratio'));
				$this->smarty->assign('keepaspectratio_input', 
					$this->CreateInputHidden($id,'keep_aspectratio',0).
					$this->CreateInputCheckbox($id, 'keep_aspectratio', '1',1));
			}
			$this->smarty->assign('formend', $this->CreateFormEnd());
			
			$this->smarty->assign('moduleId', $id);
			$this->smarty->assign('fpHeight', $this->GetPreference('filepickerheight',0));
			$this->smarty->assign('fpWidth', $this->GetPreference('filepickerwidth',0));
			$this->smarty->assign('fpWidthUnit', $this->GetPreference('filepickerwidthunit','px'));
			$this->smarty->assign('fpHeightUnit', $this->GetPreference('filepickerheightunit','px'));
		}
		else {
			$error = false;
			@ob_end_clean();
			@ob_start();
			header('Content-Type: text/xml');
			print '<?xml version="1.0" encoding="UTF-8"?>';
			print '<response>';
			print '<message>';
			if(isset($errorMessage)) {
				$error = true;
				print '<![CDATA[<div class="pageerrorcontainer"><ul class="pageerror"><li>'.$errorMessage.'</li></ul></div>]]>';
			}
			if(isset($message)) {
				print '<![CDATA[<div class="pagemcontainer"><p class="pagemessage">'.$message.'</p></div>]]>';
			}
			print '</message>';

			print '<result>';
			print '<![CDATA['.$filePicker->CreateFileDropdown($pickerId, 
					$thisDir, 
					'', 
					$excludePrefix, 
					$includePrefix, 
					$excludeSufix, 
					$includeSufix, 
					$fileExt,
					$type,
					$allowNone,
					$defaultMode).
			']]>';
			print '</result>';

			print '</response>';
			ob_end_flush();
			exit;
		}
	}
} 
else {
	$this->smarty->assign('errortext', $this->Lang('error'));
	$this->smarty->assign('errorMessage', $this->Lang('dirnotfound',$thisDir));
}
if(isset($errorMessage))
	$this->smarty->assign('errorMessage', $errorMessage);
if(isset($message))
	$this->smarty->assign('message', $message);

$this->smarty->assign('dropdown',$dropdown);
$this->smarty->assign('type', $type);
@ob_end_clean();
@ob_start();
header('Content-Type: text/xml');
print '<?xml version="1.0" encoding="UTF-8"?>';
print '<response>';
print '<result>';
print '<![CDATA['. $this->ProcessTemplate('filePicker.tpl') . ']]>';
print '</result>';
print '</response>';
ob_end_flush();
exit;

?>