<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.5
# File   : action.defaultadmin.php
# Purpose: performs the default backend action if "Extensions->AdvancedContent"
#          is selected
# License: GPL
#
#-------------------------------------------------------------------------------

if(!isset($gCms)) exit;

if(isset($params['importpages'])) {
	// Set to content2
	$query    = "UPDATE ".cms_db_prefix()."content SET type = ? WHERE type = ?";
	$dbresult = $db->Execute($query, array('content2','content'));
	$params['message'] = 'pagesimported';
	$params['submit'] = true;
}

$this->smarty->assign('startform', $this->CreateFormStart($id, 
	'savePrefs', $returnid,'post','multipart/form-data'));

$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('uninstallaction_text', $this->lang('uninstallaction'));

// Module settings

// ToDo: ajax stuff
$this->smarty->assign('importpages_input', 
	$this->CreateLink($id, 'defaultadmin', '', $gCms->variables['admintheme']->DisplayImage('icons/system/import.gif', '','','','systemicon') . '&nbsp;' . $this->lang('importpages'), 
		array('importpages'=>true), $this->lang('confirmimport')));
//---

$actions = array(lang('none')=>'', 
	$this->lang('setcontent1')=>2, 
	$this->lang('setcontent2')=>3,
	$this->lang('deletepages')=>1);

$this->smarty->assign('uninstallaction_input', 
	$this->CreateInputDropdown($id, 'uninstall_action', $actions, '', 
		$this->GetPreference('uninstall_action')));

$this->smarty->assign('uploadsdir_text', $this->lang('useimguploadsdir'));
$this->smarty->assign('uploadsdir_input', 
	$this->CreateInputHidden($id,'useimguploadsdir',0) .
	$this->CreateInputCheckbox($id, 'useimguploadsdir', '1', 
		$this->GetPreference('useimguploadsdir',0), 'class="pagecheckbox"'));

// FilePicker settings

$this->smarty->assign('filepickersettings_text', $this->lang('filepickersettings'));

$this->smarty->assign('filepickersize_text', $this->lang('filepickersize'));

$this->smarty->assign('filepickerwidth_input', 
	$this->CreateInputText($id, 'filepickerwidth', 
		$this->GetPreference('filepickerwidth'), 5, 4));

$this->smarty->assign('filepickerheight_input', 
	$this->CreateInputText($id, 'filepickerheight', 
		$this->GetPreference('filepickerheight',''), 5, 4));

$this->smarty->assign('filepickerheightunit_input', 
	$this->CreateInputDropdown($id,'filepickerheightunit',array('px'=>'px','%'=>'%','em'=>'em'),0,
		$this->GetPreference('filepickerheightunit','px')));

$this->smarty->assign('filepickerwidthunit_input', 
	$this->CreateInputDropdown($id,'filepickerwidthunit',array('px'=>'px','%'=>'%','em'=>'em'),0,
		$this->GetPreference('filepickerwidthunit','px')));

$this->smarty->assign('filepickerstyle_text', $this->lang('filepickerstyle'));
$filepickerstyles = array($this->Lang("filenameonly")=>"filename",
	$this->Lang('thumbnailsonly')=>'thumbnails',
	$this->Lang('filenameandthumbnails')=>'both');
$this->smarty->assign('filepickerstyle_input', 
	$this->CreateInputDropdown($id,'filepickerstyle',$filepickerstyles,0,
		$this->GetPreference('filepickerstyle')));

$this->smarty->assign('restrictdirs_text', $this->lang('restrictdirs'));
$this->smarty->assign('restrictdirs_input', 
	$this->CreateInputHidden($id,'restrictdirs',0) . 
	$this->CreateInputCheckbox($id, 'restrictdirs', '1', 
		$this->GetPreference('restrictdirs'), 'class="pagecheckbox"'));

$this->smarty->assign('showfilemanagement_text', 
	$this->lang('showfilemanagement'));
$this->smarty->assign('showfilemanagement_input',
	$this->CreateInputHidden($id,'showfilemanagement',0) .
	$this->CreateInputCheckbox($id, 'showfilemanagement', '1', 
		$this->GetPreference('showfilemanagement'), 'class="pagecheckbox"'));

$this->smarty->assign('showthumbnailfiles_text', 
	$this->lang('showthumbnailfiles'));
$this->smarty->assign('showthumbnailfiles_input', 
	$this->CreateInputHidden($id,'showthumbnailfiles',0) .
	$this->CreateInputCheckbox($id, 'showthumbnailfiles', '1', 
		$this->GetPreference('showthumbnailfiles'), 'class="pagecheckbox"'));

$this->smarty->assign('allowscaling_text', $this->lang('allowscaling'));
$this->smarty->assign('allowscaling_input', 
	$this->CreateInputHidden($id,'allowscaling',0) .
	$this->CreateInputCheckbox($id, 'allowscaling', '1', 
		$this->GetPreference('allowscaling'), 'class="pagecheckbox"'));

$this->smarty->assign('defaultdimensions_text', $this->lang('defaultdimensions'));

$this->smarty->assign('scalingwidth_text', $this->lang('scalingwidth'));
$this->smarty->assign('scalingwidth_input', 
	$this->CreateInputText($id, 'scalingwidth', 
		$this->GetPreference('scalingwidth'), 5, 4));

$this->smarty->assign('scalingheight_text', $this->lang('scalingheight'));
$this->smarty->assign('scalingheight_input', 
	$this->CreateInputText($id, 'scalingheight', 
		$this->GetPreference('scalingheight'), 5, 4));

$this->smarty->assign('allowupscaling_text', $this->lang('allowupscaling'));
$this->smarty->assign('allowupscaling_input', 
	$this->CreateInputHidden($id,'allowupscaling',0) .
	$this->CreateInputCheckbox($id, 'allowupscaling', '1', 
		$this->GetPreference('allowupscaling',0), 'class="pagecheckbox"'));

$this->smarty->assign('makethumbnail_text', $this->lang('makethumbnail'));
$this->smarty->assign('makethumbnail_input', 
	$this->CreateInputHidden($id,'makethumbnail',0) .
	$this->CreateInputCheckbox($id, 'makethumbnail', '1', 
		$this->GetPreference('makethumbnail'), 'class="pagecheckbox"'));

$filePicker =& $this->GetFilePicker();
$fileType = strtolower($filePicker->GetFileType('../modules/AdvancedContent/images/sort.png',true));
$this->smarty->assign('usemimetype_text', $this->lang('usemimetype'));
$this->smarty->assign('usemimetype_input', 
	$this->CreateInputHidden($id,'usemimetype',0) .
	$this->CreateInputCheckbox($id, 'usemimetype', '1', 
		($fileType != 'image/png'?$this->SetPreference('usemimetype',0):$this->GetPreference('usemimetype')), 'class="pagecheckbox"'.($fileType != 'image/png'?' disabled="disabled"':'')) . 
	($fileType == 'image/png'?'':$this->lang('nomimetype')));

// Content settings

if( $feusers =& $this->GetModuleInstance('FrontEndUsers' )) {
	
	$this->smarty->assign('contentsettings_text', $this->lang('contentsettings'));
	
	$this->smarty->assign('feuaccess_text', $this->lang('frontendaccess'));
	$feuAccess = array($this->lang('inherit_from_parent')=>-1);
	$feuAccess = array_merge($feuAccess,$feusers->GetGroupList());
	$this->smarty->assign('feuaccess_input', 
		$this->CreateInputHidden($id,'feu_access','').
		$this->CreateInputSelectList($id,'feu_access[]',$feuAccess,
			$this->CleanArray(explode(';',$this->GetPreference('feu_access'))),
		count($feuAccess),'',1));
	
	$this->smarty->assign('redirectpage_text', $this->lang('redirectpage'));
	$this->smarty->assign('redirectpage_input', 
		$this->CreateRedirectDropdown($id,'redirect_page',$this->GetPreference('redirect_page')));
	
	$this->smarty->assign('redirectparams_text', $this->lang('redirectparams'));
	$this->smarty->assign('redirectparams_input', 
		$this->CreateInputText($id, 'redirect_params', 
			$this->GetPreference('redirect_params'), 32, 128));
	
	$this->smarty->assign('evaluatesmarty_text', $this->lang('evaluatesmarty'));
	$this->smarty->assign('evaluatesmarty_input', 
		$this->CreateInputHidden($id,'evaluate_smarty',0) .
		$this->CreateInputCheckbox($id, 'evaluate_smarty', '1', 
			$this->GetPreference('evaluate_smarty'), 'class="pagecheckbox"'));
	
	$this->smarty->assign('feuaction_text', $this->lang('showloginform'));
	$this->smarty->assign('feuaction_input', 
		$this->CreateInputDropdown($id,'feu_action',
			array($this->lang('no')=>'',
				$this->lang('inherit_from_parent')=>-1,
				$this->lang('yes')=>1),
			0,$this->GetPreference('feu_action')));
}

#---

if(isset($params['message']) && isset($params['submit']))
	$this->smarty->assign('message', $this->lang($params['message']));

$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', 
	lang('submit'),'onClick="return submitForm(this,\'\',\'AdvancedContentResult\')"'));

$this->smarty->assign('moduleId', $id);

echo $this->ProcessTemplate('defaultadmin.tpl');

?>
