<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.5
# File   : AdvancedContent.module.php
# Purpose: initial module class. this is the interface to the Module API
# License: GPL
#
#-------------------------------------------------------------------------------

class AdvancedContent extends CMSModule {
	/**
	 * @access private
	 * @var array
	 */
	var $_displaySettings;
	/**
	 * @access private
	 * @var object
	 */
	var $_filePicker;
	
	function AdvancedContent() {
		parent::CMSModule();
		$this->RegisterContentType('Content2', dirname(__FILE__) . 
			DIRECTORY_SEPARATOR . 'contenttype.Content2.php', 'AdvancedContent');
		$this->_displaySettings = array();
		$this->_filePicker      = false;
	}
	
	function GetName() {
		return 'AdvancedContent';
	}
	
	function GetFriendlyName() {
		return $this->Lang('AdvancedContent');
	}
	
	function GetVersion() {
		return '0.5';
	}
	
	function GetHelp() {
		$path = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'doc' . DIRECTORY_SEPARATOR;
		if(file_exists($path . 'help_' . $this->curlang . '.html'))
			return file_get_contents($path . 'help_' . $this->curlang . '.html');
		else
			return file_get_contents($path . 'help_en_US.html');
	}
	
	function GetAuthor() {
		return 'NaN';
	}
	
	function GetAuthorEmail() {
		return;
	}
	
	function GetChangeLog() {
		$changelog = dirname(__FILE__) . DIRECTORY_SEPARATOR . 
			'doc' . DIRECTORY_SEPARATOR . 'changelog.html';
		if(file_exists($changelog))
			return file_get_contents($changelog);
	}
	
	function HasContentType() {
		return true;
	}
	
	function IsPluginModule() {
		return true;
	}
	
	function HasAdmin() {
		return true;
	}
	
	function GetAdminSection() {
		return 'extensions';
	}
	
	function GetAdminDescription() {
		return $this->lang('admindescription');
	}
	
	function VisibleToAdminUser() {
		return $this->Checkpermission('Manage AdvancedContent');
	}
	
	function MinimumCMSVersion() {
		return "1.6.8";
	}
	
	function MaximumCMSVersion() {
		return "1.9.9";
	}
	
	function InstallPostMessage() {
		return $this->Lang('postinstall', $this->GetVersion());
	}
	
	function UninstallPostMessage() {
		return $this->Lang('postuninstall', $this->GetVersion());
	}
	
	function UninstallPreMessage() {
		return $this->Lang('confirmuninstall');
	}
	
	function HandlesEvents() {
		return true;
	}
	
	function DoAction($action, $id, $params, $returnId = '') {
		switch($action) {
			case 'default':
			case 'savePrefs':
			case 'filePicker':
			case 'defaultadmin':
				parent::DoAction($action, $id, $params, $returnId);
				break;
				
			default: break;
		}
	}
	
	function DoEvent($originator, $eventname, &$params) {
		$redirect = false;
		$db =& $this->GetDb();
		// get all content of type advanced that need to be set to active/inactive
		$query = "SELECT C.content_id, C.active
			FROM " . cms_db_prefix() . "content C 
			LEFT JOIN " . cms_db_prefix() . "content_props USE_EXP
				ON USE_EXP.content_id = C.content_id
			LEFT JOIN " . cms_db_prefix() . "content_props START_DATE
				ON START_DATE.content_id = C.content_id
			LEFT JOIN " . cms_db_prefix() . "content_props END_DATE
				ON END_DATE.content_id = C.content_id
			WHERE 
				C.type = ? AND 
				USE_EXP.prop_name = ? AND 
				USE_EXP.content = ? AND (
					(
						START_DATE.prop_name = ? AND 
						START_DATE.content <= ? AND 
						END_DATE.prop_name = ? AND 
						END_DATE.content > ? AND
						C.active = ?
					)
					OR
					(
						END_DATE.prop_name = ? AND 
						END_DATE.content <= ? AND
						C.active = ?
					)
				)
			";
			
		$dbresult = $db->Execute($query, array('content2', 'use_expire_date', 
			'1', 'start_date', time(), 'end_date', time(), 0, 'end_date', 
			time(), 1));
		
		$contents = array();
		while($dbresult && $row = $dbresult->FetchRow()) {
			if($row['active'])
				$contents[$row['content_id']] = 0;
			else
				$contents[$row['content_id']] = 1;
		}
		if(count($contents)) {
			global $gCms;
			$gCms->smarty->clear_all_cache();
			foreach($contents as $contentId=>$active) {
				$query = "UPDATE ". cms_db_prefix() . "content 
					SET active = ? WHERE content_id = ?";
				$dbresult = $db->Execute($query, array($active, $contentId));
				if($contentId == $gCms->variables['pageinfo']->content_id)
					$redirect = $contentId;
			}
		}
		// ToDo: Check feu access?
		if($redirect)
			$this->RedirectContent($contentId);
	}
	
	function SetParameters() {
		
		$this->RegisterModulePlugin();
		/* ToDo: Test parameters... */
		$this->RestrictUnknownParams();
		
		$this->SetParameterType('keep_aspectratio',CLEAN_INT);
		$this->SetParameterType('resize_x',CLEAN_INT);
		$this->SetParameterType('resize_y',CLEAN_INT);
		$this->SetParameterType('resize_on',CLEAN_INT);
		$this->SetParameterType('uninstall_action',CLEAN_INT);
		$this->SetParameterType('restrictdirs',CLEAN_INT);
		$this->SetParameterType('showfilemanagement',CLEAN_INT);
		$this->SetParameterType('showthumbnailfiles',CLEAN_INT);
		$this->SetParameterType('allowscaling',CLEAN_INT);
		$this->SetParameterType('scalingwidth',CLEAN_INT);
		$this->SetParameterType('scalingheight',CLEAN_INT);
		$this->SetParameterType('allowupscaling',CLEAN_INT);
		$this->SetParameterType('makethumbnail',CLEAN_INT);
		$this->SetParameterType('filepickerwidth',CLEAN_INT);
		$this->SetParameterType('filepickerheight',CLEAN_INT);
		$this->SetParameterType('filepickerwidthunit',CLEAN_STRING);
		$this->SetParameterType('filepickerheightunit',CLEAN_STRING);
		$this->SetParameterType('usemimetype',CLEAN_INT);
		$this->SetParameterType('redirect_page',CLEAN_INT);
		$this->SetParameterType('redirect_params',CLEAN_STRING);
		$this->SetParameterType('evaluate_smarty',CLEAN_INT);
		$this->SetParameterType('display',CLEAN_INT);
		$this->SetParameterType('toggle',CLEAN_STRING);
		$this->SetParameterType('content_id',CLEAN_INT);
		$this->SetParameterType('block_id',CLEAN_STRING);
		$this->SetParameterType('ajax',CLEAN_INT);
		$this->SetParameterType('feu_action',CLEAN_INT);
		$this->SetParameterType('feu_access',CLEAN_STRING);
		$this->SetParameterType('filepickerstyle',CLEAN_STRING);
		$this->SetParameterType('newdir',CLEAN_STRING);
		$this->SetParameterType('deletesubdir',CLEAN_STRING);
		$this->SetParameterType('deletefilename',CLEAN_STRING);
		$this->SetParameterType('upload_file',CLEAN_STRING);
		$this->SetParameterType('create_dirs',CLEAN_STRING);
		$this->SetParameterType('goto_root',CLEAN_INT);
		$this->SetParameterType('delete',CLEAN_STRING);
		$this->SetParameterType('show_subdirs',CLEAN_STRING);
		$this->SetParameterType('dropdown',CLEAN_INT);
		$this->SetParameterType('subdir',CLEAN_STRING);
		$this->SetParameterType('startdir',CLEAN_STRING);
		$this->SetParameterType('default_mode',CLEAN_INT);
		$this->SetParameterType('picker_id',CLEAN_STRING);
		$this->SetParameterType('message',CLEAN_STRING);
		$this->SetParameterType('errormessage',CLEAN_STRING);
		$this->SetParameterType('submit',CLEAN_STRING);
		$this->SetParameterType('errormessage',CLEAN_STRING);
		$this->SetParameterType('importpages',CLEAN_INT);
		$this->SetParameterType('assign',CLEAN_STRING);
		$this->SetParameterType('text',CLEAN_STRING);
		$this->SetParameterType('title',CLEAN_STRING);
		$this->SetParameterType('area',CLEAN_STRING);
		$this->SetParameterType('returnid',CLEAN_STRING);
		$this->SetParameterType('label',CLEAN_STRING);
		$this->SetParameterType('class',CLEAN_STRING);
		$this->SetParameterType('id',CLEAN_STRING);
		$this->SetParameterType('name',CLEAN_STRING);
		$this->SetParameterType('width',CLEAN_STRING);
		$this->SetParameterType('height',CLEAN_STRING);
		$this->SetParameterType('alt',CLEAN_STRING);
		$this->SetParameterType('block',CLEAN_STRING);
		$this->SetParameterType('smarty',CLEAN_STRING);
		$this->SetParameterType('type',CLEAN_STRING);
		$this->SetParameterType('block_type',CLEAN_STRING);
		$this->SetParameterType('default',CLEAN_STRING);
		$this->SetParameterType('style',CLEAN_STRING);
		$this->SetParameterType('size',CLEAN_INT);
		$this->SetParameterType('block_tab',CLEAN_STRING);
		$this->SetParameterType('page_tab',CLEAN_STRING);
		$this->SetParameterType('maxlength',CLEAN_INT);
		$this->SetParameterType('wysiwyg',CLEAN_STRING);
		$this->SetParameterType('oneline',CLEAN_STRING);
		$this->SetParameterType('mode',CLEAN_STRING);
		$this->SetParameterType('start_time',CLEAN_INT);
		$this->SetParameterType('end_time',CLEAN_INT);
		$this->SetParameterType('date_format',CLEAN_STRING);
		$this->SetParameterType('start_hour',CLEAN_INT);
		$this->SetParameterType('end_hour',CLEAN_INT);
		$this->SetParameterType('start_minute',CLEAN_STRING);
		$this->SetParameterType('end_minute',CLEAN_INT);
		$this->SetParameterType('start_seconds',CLEAN_INT);
		$this->SetParameterType('end_seconds',CLEAN_INT);
		$this->SetParameterType('show_clock',CLEAN_STRING);
		$this->SetParameterType('step_hours',CLEAN_INT);
		$this->SetParameterType('step_minutes',CLEAN_INT);
		$this->SetParameterType('step_seconds',CLEAN_INT);
		$this->SetParameterType('show24h',CLEAN_STRING);
		$this->SetParameterType('upload',CLEAN_STRING);
		$this->SetParameterType('dir',CLEAN_STRING);
		$this->SetParameterType('allow_none',CLEAN_STRING);
		$this->SetParameterType('exclude_prefix',CLEAN_STRING);
		$this->SetParameterType('exclude_sufix',CLEAN_STRING);
		$this->SetParameterType('include_prefix',CLEAN_STRING);
		$this->SetParameterType('include_sufix',CLEAN_STRING);
		$this->SetParameterType('lock_input',CLEAN_STRING);
		$this->SetParameterType('file_extension',CLEAN_STRING);
		$this->SetParameterType('delimiter',CLEAN_STRING);
		$this->SetParameterType('items',CLEAN_STRING);
		$this->SetParameterType('values',CLEAN_STRING);
		$this->SetParameterType('module',CLEAN_STRING);
		$this->SetParameterType('defaultModules',CLEAN_STRING);
		$this->SetParameterType('urlonly',CLEAN_STRING);
		$this->SetParameterType('feu_action',CLEAN_STRING);
		$this->SetParameterType('feu_access',CLEAN_STRING);
		$this->SetParameterType('editor_groups',CLEAN_STRING);
		$this->SetParameterType('editor_users',CLEAN_STRING);
		$this->SetParameterType('active',CLEAN_STRING);
		$this->SetParameterType('translate_labels',CLEAN_STRING);
		$this->SetParameterType('translate_values',CLEAN_STRING);
	}
	
	#function GetNotificationOutput($priority) {
	#	$obj           = new StdClass();
	#	$obj->priority = 3;
	#	$obj->html     = '';
	#	return array($obj);
	#}
	
	#function GetDashboardOutput() {
	#	
	#}
	
/**
 * -----------------------------------------------------------------------------
 * Not part of the module API
 * -----------------------------------------------------------------------------
 */
	
	/**
	 * function _getElmDisplay($type,$contentId)
	 * not part of the module api
	 * gets the display status of content blocks and content blocks messages from db
	 *
	 * @param string $type - 'message' to get the block message only, 'block' to get the whole block
	 * @param int $contentId - the id of the content to get the display status from
	 *
	 * @return void
	 */
	function _getElmDisplay($type,$contentId) {
		$db =& $this->GetDb();
		$query = "SELECT * FROM ". cms_db_prefix() . "module_AdvancedContent_".$type."display
			WHERE user_id = ? AND content_id = ?";
		$dbresult = $db->Execute($query, array(get_userid(), $contentId));
		while($dbresult && $row = $dbresult->FetchRow()) {
			$this->_displaySettings[$type][$row['content_id']][$row['block_id']] = $row[$type.'_display'];
		}
	}
	
	
	/**
	 * function GetElmDisplay($type,$contentId,$blockId,$defaultValue)
	 * not part of the module api
	 * gets the display status of content blocks and content blocks messages
	 *
	 * @param string $type - 'message' to get the block message only, 'block' to get the whole block
	 * @param int $contentId - the id of the content to get the display status from
	 * @param string $blockId - the content block to get the display status from
	 * @param int $defaultValue - the default status if nothing is found
	 *
	 * @return boolean - 0 = hidden, 1 = shown
	 */
	function GetElmDisplay($type,$contentId,$blockId,$defaultValue = 1) {
		if(!isset($this->_displaySettings[$type][$contentId]))
			$this->_getElmDisplay($type,$contentId);
		if(!isset($this->_displaySettings[$type][$contentId][$blockId]))
			$this->_displaySettings[$type][$contentId][$blockId] = $defaultValue;
		
		return $this->_displaySettings[$type][$contentId][$blockId];
	}
	
	
	/**
	 * function SetElmDisplay($type,$contentId,$blockId,$display)
	 * not part of the module api
	 * saves the display status of content blocks and content blocks messages
	 *
	 * @param string $type - 'message' to toggle the block message only, 'block' to toggle the whole block
	 * @param int $contentId - the id of the content where to set the display status
	 * @param string $blockId - the content block to toggle the block itself or the message
	 * @param int $display - 0 to hide, 1 to show
	 *
	 * @return void
	 */
	function SetElmDisplay($type,$contentId,$blockId,$display) {
		$db =& $this->GetDb();
		$query = "SELECT ".$type."_display FROM ". cms_db_prefix() . "module_AdvancedContent_".$type."display
			WHERE user_id = ? AND content_id = ? AND block_id = ?";
		$dbresult = $db->Execute($query, array(get_userid(), $contentId, $blockId));
		if($dbresult && $row = $dbresult->FetchRow()) {
			$query = "UPDATE ". cms_db_prefix() . "module_AdvancedContent_".$type."display 
				SET ".$type."_display = ? WHERE user_id = ? AND content_id = ? AND block_id = ?";
			$dbresult = $db->Execute($query, array($display, get_userid(), $contentId, $blockId));
		}
		else {
			$query = "INSERT INTO ". cms_db_prefix() ."module_AdvancedContent_".$type."display 
				(user_id, content_id, block_id, ".$type."_display) VALUES (?,?,?,?)";
			$dbresult = $db->Execute($query, array(get_userid(), $contentId, $blockId, $display));
		}
		$this->_displaySettings[$type][$contentId][$blockId] = $display;
	}
	
	
	/**
	 * function IsVarEmpty($var, $trim, $unsetEmptyIndexes)
	 * not part of the module api
	 * checks if a var is empty. id var is an array it recursivley checks all elements
	 *
	 * @param mixed $var - the var to check for empty value(s)
	 * @param boolean $trim - true to trim off spaces
	 * @param boolean $unsetEmptyIndexes - true to delete empty elements from array
	 * @return boolean - true if empty, false if not
	 */
	function IsVarEmpty(&$var, $trim = true, $unsetEmptyIndexes = false) {
		if (is_array($var)) {
			foreach ($var as $k=>$v) {
				if (!$this->IsVarEmpty($v)) {
					return false;
				}
				else {
					if($unsetEmptyIndexes)
						unset($var[$k]);
					return true;
				}
			}
		}
		else if($trim && trim($var) == '') {
			return true;
		}
		else if($var == '') {
			return true;
		}
		return false;
	}
	
	
	/**
	 * function CleanArray($array)
	 * not part of the module api
	 * removes empty elements from an array 
	 * (can be useful when using function explode to create the array of a csv)
	 *
	 * @param array $array - the array to clean up
	 * @return array - an array without empty elements or an empty array
	 */
	function CleanArray($array) {
		if (is_array($array)) {
			foreach ($array as $k=>$v) {
				if ($this->IsVarEmpty($v,true,true)) {
					unset($array[$k]);
				}
				else {
					if(is_array($v)) {
						$v = $this->CleanArray($v);
						if($this->IsVarEmpty($v,true,true))
							unset($array[$k]);
						else
							$array[$k] = $v;
					}
				}
			}
			return $array;
		}
		return array();
	}
	
	
	/**
	 * function GetPages()
	 * not part of the module api
	 * gets all pages to list in a dropdown
	 *
	 * @return array - a set of pages
	 */
	function GetPages() {
		$db =& $this->GetDb();
		$query = "SELECT C.active, C.type, C.content_id, C.hierarchy, C.menu_text, CP.content FROM " . cms_db_prefix() . "content C 
			LEFT JOIN " . cms_db_prefix() . "content_props CP ON CP.content_id = C.content_id AND CP.prop_name = ? 
			ORDER BY hierarchy";
		$dbresult = $db->Execute($query, array('feu_access'));
		if(!$pages = $dbresult->GetArray())
			return array();
		return $pages;
	}
	
	
	/**
	 * function CreateRedirectDropdown()
	 * not part of the module api
	 * this creates a dropdown of pages including only pages of type content but
	 * excluding the current page and pages that may only be accessed by frontend users
	 *
	 * @return string - HTML select element with options
	 */
	function CreateRedirectDropdown($id = '', $name = 'redirect_page', $selectedPage = '', $currentPage = '') {
		global $gCms;
		$pages      = $this->GetPages();
		$dropdown   = '<select name="'.$id.$name.'" >';
		$dropdown  .= '<option value=""' . ($selectedPage == ''?' selected="selected"':'') . '>' . lang('none') . '</option>';
		$dropdown  .= '<option value="-1"' . ($selectedPage == '-1'?' selected="selected"':'') . '>' . $this->lang('inherit_from_parent') . '</option>';
		$contentops =& $gCms->GetContentOperations();
		foreach($pages as $page) {
			
			$disabled = '';
			// don't redirect to pages with no public access, invalid content type, inactive or same content id
			if($page['active'] != 1 || $page['content']>0 || $page['content_id'] == $currentPage || ($page['type'] != 'content' && $page['type'] != 'content2'))
				$disabled = ' disabled="disabled"';
			
			$dropdown .= '<option'. $disabled .' value="' . $page['content_id'] . '" ' . 
				($selectedPage == $page['content_id'] && $disabled == ''?'selected="selected"':'') . '>' . 
				$contentops->CreateFriendlyHierarchyPosition($page['hierarchy']) . 
				' - ' . $page['menu_text'] . ($disabled != ''?' (' . $this->lang('invalid') . ')':'') . '</option>';
		}
		$dropdown .= '</select>';
		
		return $dropdown;
	}
	
	
	/**
	 * function IsTrue($value)
	 * not part of the module api
	 * checks if a value is literally "true"
	 * can be usefull when checking smarty params for the value true
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsTrue($value) {
		return (strtolower($value) === 'true' || $value === 1 || $value === '1' || $value === true);
	}
	
	
	/**
	 * function IsFalse($value)
	 * not part of the module api
	 * checks if a value is literally "false"
	 * can be usefull when checking smarty params for the value false
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsFalse($value) {
		return (strtolower($value) === 'false' || $value === '0' || $value === 0 || $value === false || $value === '');
	}
	
	
	/**
	 * function GetFilePicker()
	 * not part of the module api
	 * loads the filepicker class
	 *
	 * @return object
	 */
	function &GetFilePicker() {
		if(!$this->_filePicker) {
			require_once(cms_join_path(dirname(__FILE__), 'inc', 'class.filePicker.inc.php'));
			$this->_filePicker = new AdvancedContentFilePicker($this);
		}
		return $this->_filePicker;
	}
}
?>
