<?php
#-------------------------------------------------------------------------
# Module: CGGoogleMaps - A simple module for creating google maps.
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;
if( !isset($gCms->variables[$this->GetName().'map_count']) )
  {
    $gCms->variables[$this->GetName().'map_count'] = 0;
  }
$map_count = $gCms->variables[$this->GetName().'map_count']++;

$thetemplate = $this->GetPreference(CGGM_PREF_DFLTMAP_TEMPLATE);
if( isset($params['maptemplate']) )
  {
    trim($params['maptemplate']);
  }
$defer = 0;
if( isset($params['defer']) && $params['defer'] == 1 )
  {
    $defer = 1;
  }

// Get icon information
$icons = '';
$default_icon = $this->GetPreference('default_marker');
{
  $query = 'SELECT * FROM '.cms_db_prefix().'module_cggooglemaps_icons ORDER BY name';
  $tmp = $db->GetArray($query);
  if( is_array($tmp) )
    {
      $icons = cge_array::to_hash($tmp,'name');
    }
}

// Get the map information
$mapid = $this->GetPreference('default_map',0);
if( isset($params['map']) )
  {
    $mapid = $params['map'];
  }
$query = 'SELECT * FROM '.cms_db_prefix().'module_cggooglemaps
               WHERE map_id = ? OR name = ?';
$map_data = $db->GetRow($query,array($mapid,$mapid));
if( !$map_data )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_invalidparams'));
    return;
  }

$apikey = $this->GetPreference('google_apikey','');
if( empty($apikey) )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_noapikey'));
    return;
  }

$currentLocale = setlocale(LC_ALL, 0);
setlocale(LC_ALL, 'en_US');
$dn = dirname(__FILE__).'/lib/pear';
ini_set('include_path',ini_get('include_path').":$dn");
require_once('lib/GoogleMapAPI-2.4/GoogleMapAPI.class.php');
$map = new GoogleMapAPI($this->GetName().$map_count, $this->GetName());

// Setup database connection
$config =& $gCms->GetConfig();
//$map->setFileRoot($config['root_path']);
$map->setDSN($db);
$map->setDBTable(cms_db_prefix()."module_cggooglemaps_cache");
$map->setAPIKey($apikey);
$map->setLookupService('GOOGLE');
$map->setWidth($map_data['width']);
$map->setHeight($map_data['height']);
if ($map_data['controls'] == 0) {
  $map->disableMapControls();
}
if ($map_data['type_controls'] == 0) {
  $map->disableTypeControls($map_data['type_controls']);
}
if( $map_data['zoom'] > 0 ) {
  $map->setZoomLevel($map_data['zoom']);
}
$map->setControlSize($map_data['controls_size']);
$map->setMapType($map_data['type']);
if ($map_data['sidebar'] == 0) {
  $map->disableSidebar();
}
if ($map_data['directions'] == 0) {
  $map->disableDirections();
}
if($map_data['zoom_encompass'] == 0) {
  $map->disableZoomEncompass();
}
if($map_data['info_window'] == 0) {
  $map->disableInfoWindow();
}
$map->setInfoWindowTrigger($map_data['info_trigger']);

$num_map_points = 0;
$num_icons = 0;

// get fixed markers for this map
$query = 'SELECT * FROM '.cms_db_prefix().'module_cggooglemaps_points
           WHERE map_id = ?';
$dbr = $db->Execute( $query, array( $map_data['map_id'] ));
while( $dbr && ($row = $dbr->FetchRow()) )
  {
    $tmp = TRUE;
    if( empty($row['lat']) || empty($row['lon']) && !empty($row['address']) )
      {
	$tmp2 = $map->addMarkerByAddress($row['address'],$row['name'],$row['info']);
	if( $tmp2 === FALSE ) {
	  echo '<!-- ERROR: Address "'.$row['address.'].'" failed geolocation test -->'."\n";
	  $tmp = FALSE;
	}
	else {
	  $num_map_points++;
	}
      }
    else if( !empty($row['lat']) && !empty($row['lon']) )
      {
	$map->addMarkerByCoords($row['lon'],$row['lat'],
				$row['name'],$row['info']);
	$num_map_points++;
      }

    if( $tmp !== FALSE )
      {
	// add the marker icon
	if( $num_icons == 0 && (empty($row['icon']) || $row['icon'] == -1 || !isset($icons[$row['icon']])) )
	  {
	    // this is the first icon... AND we don't have one yet, or it's invalid so use the default.	    
	    if( !empty($default_icon) && isset($icons[$default_icon]) )
	      {
		$icon =& $icons[$default_icon];
		if( is_array($icon) ) 
		  {
		    $anchorX = 'x';
		    $anchorY = 'x';
		    $info_anchorX = 'x';
		    $info_anchorY = 'x';
		    if( !empty($icon['anchor_x']) ) $anchorX = (int)$icon['anchor_x'];
		    if( !empty($icon['anchor_y']) ) $anchorY = (int)$icon['anchor_y'];
		    if( !empty($icon['anchor_x']) ) $info_anchorX = (int)$icon['info_anchor_x'];
		    if( !empty($icon['anchor_y']) ) $info_anchorY = (int)$icon['info_anchor_y'];
		    $map->addMarkerIcon($config['root_url'].'/'.$icon['url'],'',$anchorX,$anchorY,$info_anchorX,$info_anchorY);
		    $num_icons++;
		  }
	      }
	  }
	else
	  {
	    $icon =& $icons[$row['icon']];
	    $anchorX = 'x';
	    $anchorY = 'x';
	    $info_anchorX = 'x';
	    $info_anchorY = 'x';
	    if( !empty($icon['anchor_x']) ) $anchorX = (int)$icon['anchor_x'];
	    if( !empty($icon['anchor_y']) ) $anchorY = (int)$icon['anchor_y'];
	    if( !empty($icon['anchor_x']) ) $info_anchorX = (int)$icon['info_anchor_x'];
	    if( !empty($icon['anchor_y']) ) $info_anchorY = (int)$icon['info_anchor_y'];
	    $map->addMarkerIcon($config['root_url'].'/'.$icon['url'],'',$anchorX,$anchorY,$info_anchorX,$info_anchorY);
	    $num_icons++;
	  }
	
      }
  }

// get dynamic markers for this map
if( is_array($this->_dynamic_points) &&
    is_array($this->_dynamic_points[$mapid]) )
  {
    for( $i = 0; $i < count($this->_dynamic_points[$mapid]); $i++ )
      {
	$obj =& $this->_dynamic_points[$mapid][$i];

	$tmp = TRUE;
	if( empty($obj->lat) || empty($obj->long) && !empty($obj->address) )
	  {
	    $tmp2 = $map->addMarkerByAddress($obj->address,
				     $obj->name,
				     $obj->description);
	    if( $tmp2 === FALSE ) {
	      echo '<!-- ERROR: Address "'.$obj->address.'" failed geolocation test -->'."\n";
	      $tmp = FALSE;
	    }
	    else {
	      $num_map_points++;
	    }
	      
	  }
	else if( !empty($obj->lat) && !empty($obj->long) )
	  {
	    $map->addMarkerByCoords($obj->long,$obj->lat,
				    $obj->name,$obj->description);
	    $num_map_points++;
	  }

	if( $tmp !== FALSE )
	  {
	    // add the marker icon
	    if( (empty($obj->icon) || ($obj->icon == '-1') || !isset($icons[$obj->icon])) )
	      {
		// this is the first icon... AND we don't have one yet, or it's invalid so use the default.	    
		if( !empty($default_icon) && isset($icons[$default_icon]) )
		  {
		    $icon =& $icons[$default_icon];
		    if( is_array($icon) ) 
		      {
			$anchorX = 'x';
			$anchorY = 'x';
			$info_anchorX = 'x';
			$info_anchorY = 'x';
			if( !empty($icon['anchor_x']) ) $anchorX = (int)$icon['anchor_x'];
			if( !empty($icon['anchor_y']) ) $anchorY = (int)$icon['anchor_y'];
			if( !empty($icon['anchor_x']) ) $info_anchorX = (int)$icon['info_anchor_x'];
			if( !empty($icon['anchor_y']) ) $info_anchorY = (int)$icon['info_anchor_y'];
			$map->addMarkerIcon($config['root_url'].'/'.$icon['url'],'',$anchorX,$anchorY,$info_anchorX,$info_anchorY);
			$num_icons++;
		      }
		  }
	      }
	    else 
	      {
		$icon =& $icons[$obj->icon];
		$anchorX = 'x';
		$anchorY = 'x';
		$info_anchorX = 'x';
		$info_anchorY = 'x';
		if( !empty($icon['anchor_x']) ) $anchorX = (int)$icon['anchor_x'];
		if( !empty($icon['anchor_y']) ) $anchorY = (int)$icon['anchor_y'];
		if( !empty($icon['anchor_x']) ) $info_anchorX = (int)$icon['info_anchor_x'];
		if( !empty($icon['anchor_y']) ) $info_anchorY = (int)$icon['info_anchor_y'];
		$map->addMarkerIcon($config['root_url'].'/'.$icon['url'],'',$anchorX,$anchorY,$info_anchorX,$info_anchorY);
		$num_icons++;
	      }
	  }

	if( $tmp !== FALSE &&
	    !empty($obj->icon) && $obj->icon != '-1' && isset($icons[$obj->icon]) )
	  {
	    $icon =& $icons[$obj->icon];
	    $anchorX = 'x';
	    $anchorY = 'x';
	    $info_anchorX = 'x';
	    $info_anchorY = 'x';
	    if( !empty($icon['anchor_x']) ) $anchorX = (int)$icon['anchor_x'];
	    if( !empty($icon['anchor_y']) ) $anchorY = (int)$icon['anchor_y'];
	    if( !empty($icon['anchor_x']) ) $info_anchorX = (int)$icon['info_anchor_x'];
	    if( !empty($icon['anchor_y']) ) $info_anchorY = (int)$icon['info_anchor_y'];
	    $map->addMarkerIcon($config['root_url'].'/'.$icon['url'],'',$anchorX,$anchorY,$info_anchorX,$info_anchorY);
	  }

      }
  }

if( $num_map_points > 0 )
  {
    // set the default icon
    if( !empty($default_icon) && isset($icons[$default_icon]) )
      {
	$icon =& $icons[$default_icon];
	if( is_array($icon) ) 
	  {
	    $anchorX = 'x';
	    $anchorY = 'x';
	    $info_anchorX = 'x';
	    $info_anchorY = 'x';
	    if( !empty($icon['anchor_x']) ) $anchorX = (int)$icon['anchor_x'];
	    if( !empty($icon['anchor_y']) ) $anchorY = (int)$icon['anchor_y'];
	    if( !empty($icon['anchor_x']) ) $info_anchorX = (int)$icon['info_anchor_x'];
	    if( !empty($icon['anchor_y']) ) $info_anchorY = (int)$icon['info_anchor_y'];
	    $map->addMarkerIcon($config['root_url'].'/'.$icon['url'],'',$anchorX,$anchorY,$info_anchorX,$info_anchorY);
	  }
      }
    
    
    $map->disableOnLoad();
    if ($map_data['center_lat'] != '' && is_numeric($map_data['center_lat']) &&
	$map_data['center_lon'] != '' && is_numeric($map_data['center_lon']))
      {
	$map->setCenterCoords($map_data['center_lon'],$map_data['center_lat']);
      }
    
    // assign Smarty variables;
    $smarty->assign('google_map_header',$map->getHeaderJS($defer));
    $smarty->assign('google_map_js',$map->getMapJS($defer));
    $smarty->assign('google_map_sidebar',$map->getSidebar());
    $smarty->assign('google_map',$map->getMap($defer));
    $smarty->assign('map_description', $map_data['description']);
    
    // Process the template
    echo $this->ProcessTemplateFromDatabase('map_'.$thetemplate);
  }
    
#Set locale again
adodb_connect();
setlocale(LC_ALL, $currentLocale);
// EOF
?>
