<?php
#-------------------------------------------------------------------------
# Module: CGGoogleMaps - A simple module for creating google maps.
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit();
if( !$this->CheckPermission('Manage Map Locations') )
  {
    echo $this->ShowErrors($this->Lang('error_permissiondenied'));
    return;
  }
if( !isset($params['map_id']) )
  {
    echo $this->ShowErrors($this->Lang('error_invalidparams'));
    return;
  }
$map_id = (int)$params['map_id'];

#
# Setup
# 
$query = 'SELECT name,url FROM '.cms_db_prefix().'module_cggooglemaps_icons ORDER BY name';
$tmp = $db->GetArray($query);
$icons = array();
$iconsbyname = array();
if( is_array($tmp) )
  {
    for( $i = 0; $i < count($tmp); $i++ )
      {
	$icons[$tmp[$i]['name']] = $tmp[$i]['name'];
	$iconsbyname[$tmp[$i]['name']] = $tmp[$i]['url'];
      }
  }

// Get the details about the map
$query = 'SELECT * FROM '.cms_db_prefix().'module_cggooglemaps
           WHERE map_id = ?';
$mapinfo = $db->GetRow( $query, array( $map_id ) );
if( !$mapinfo )
  {
    echo $this->ShowErrors($this->Lang('error_invalidparams'));
    return;
  }

// default variables
$name = '';
$info = '';
$address = '';
$latitude = '';
$longitude = '';
$sel_icon = $this->GetPreference('default_marker');

if( isset($params['marker_id']) )
  {
    // load the marker 
    $query = 'SELECT * FROM '.cms_db_prefix().'module_cggooglemaps_points
               WHERE map_id = ? AND marker_id = ?';
    $row = $db->GetRow( $query, array( $map_id, $params['marker_id'] ) );
    if( !$row )
      {
	echo $this->ShowErrors($this->Lang('error_invalidparams'));
	return;
      }

    $name = $row['name'];
    $info = $row['info'];
    $address = $row['address'];
    $sel_icon = $row['icon'];
    $latitude = $row['lat'];
    $longitude = $row['lon'];
  }


// handle form actions
if( isset($params['cancel']) )
  {
    $this->Redirect($id,'admin_editmappoints',$returnid,array('map_id'=>$map_id));
    return;
  }
else if( isset($params['submit']) )
  {
    //
    // handle the submit
    //
    if( isset($params['name']) ) $name = trim($params['name']);
    if( isset($params['info']) ) $info = trim($params['info']);
    if( isset($params['address']) ) $address = trim($params['address']);
    if( isset($params['icon']) ) $sel_icon = trim($params['icon']);
    if( isset($params['latitude']) ) $latitude = trim($params['latitude']);
    if( isset($params['longitude']) ) $longitude = trim($params['longitude']);

    if( $name == '' || $sel_icon == '' ||
	($address == '' && ($latitude == '' || $longitude == '' )) )
      {
	echo $this->ShowErrors($this->Lang('error_invalidparams'));
      }
    else
      {
	// map info is valid
	if( isset($params['marker_id']) )
	  {
	    // update the point
	    // note, duplicate names are valid in this table
	    $query = 'UPDATE '.cms_db_prefix().'module_cggooglemaps_points
                         SET name = ?, info = ?, address = ?, lat = ?,
                             lon = ?, icon = ?
                       WHERE map_id = ? AND marker_id = ?';
	    $dbr = $db->Execute( $query, array($name,$info,$address,$latitude,
					       $longitude,$sel_icon,
					       $map_id,$params['marker_id']));
	  }
	else
	  {
	    // insert the point
	    // note, duplicate names are valid in this table
	    $query = 'INSERT INTO '.cms_db_prefix().'module_cggooglemaps_points
                    (map_id, name, info, address, lat, lon, icon)
                  VALUES (?,?,?,?,?,?,?)';
	    $dbr = $db->Execute( $query, array($map_id,$name,$info,$address,
					       $latitude,$longitude,$sel_icon));
	  }
	if( !$dbr )
	  {
	    echo "DEBUG: error = ".$db->ErrorMsg().'<br/>'.$db->sql;
	    die();
	  }
	
	$this->Redirect($id,'admin_editmappoints',$returnid,array('map_id'=>$map_id));
      }
  }

// build the form
if( isset($params['marker_id']) )
  {
    $smarty->assign('hidden',
		    $this->CreateInputHidden($id,'marker_id',$params['marker_id']));
  }
if( count($icons) )
  {
    $smarty->assign('icons',$icons);
    $smarty->assign('iconsbyname',$iconsbyname);
    $smarty->assign('sel_icon',$sel_icon);
  }
$smarty->assign('formstart',
		$this->CGCreateFormStart($id,'admin_addmappoint',$returnid,
					 array('map_id'=>$map_id)));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('title',$this->Lang('add_point_for_map',$mapinfo['name']));
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));
$smarty->assign('cancel',$this->CreateInputSubmit($id,'cancel',$this->Lang('cancel')));

if( !empty($address) )
  {
    $smarty->assign('point_address',$address);
  }
$smarty->assign('prompt_name',$this->Lang('point_name'));
$smarty->assign('input_name',$this->CreateInputText($id,'name',$name,40,80));
$smarty->assign('prompt_info',$this->Lang('text'));
$smarty->assign('input_info',$this->CreateTextArea(true,$id,$info,'info'));
$smarty->assign('prompt_address',$this->Lang('address'));
$smarty->assign('input_address',$this->CreateInputText($id,'address',$address,100,255));
$smarty->assign('prompt_lat',$this->Lang('latitude'));
$smarty->assign('input_lat',$this->CreateInputText($id,'latitude',$latitude,10,15));
$smarty->assign('prompt_lon',$this->Lang('longitude'));
$smarty->assign('input_lon',$this->CreateInputText($id,'longitude',$longitude,10,15));
$smarty->assign('info_address_latlong',$this->Lang('info_address_latlong'));

// process the template
echo $this->ProcessTemplate('addmappoint.tpl');

// EOF
?>