<?php
#-------------------------------------------------------------------------
# Module: CGGoogleMaps - A simple module for creating google maps.
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit();
if( !$this->CheckPermission('Manage Maps') )
  {
    echo $this->ShowErrors($this->Lang('error_permissiondenied'));
    return;
  }
$this->SetCurrentTab('maps');

$name = '';
$description = '';
$center_lat = '';
$center_lon = '';
$type = 'map';
$width = 400;
$height = 400;
$controls = 1;
$controls_size = 'large';
$type_controls = 1;
$sidebar = 0;
$directions = 0;
$zoom = 7;
$zoom_encompass = 1;
$info_window = 1;
$info_trigger = 'click';

if( isset($params['map_id'] ) )
  {
    $query = 'SELECT * FROM '.cms_db_prefix().'module_cggooglemaps 
               WHERE map_id = ?';
    $row = $db->GetRow($query, array($params['map_id']));
    if( !$row )
      {
	echo $this->ShowErrors($this->Lang('error_invalidparams'));
      }
    $name = $row['name'];
    $description = $row['description'];
    $center_lat = $row['center_lat'];
    $center_lon = $row['center_lon'];
    $type = $row['type'];
    $width = $row['width'];
    $height = $row['height'];
    $controls = $row['controls'];
    $controls_size = $row['controls_size'];
    $type_controls = $row['type_controls'];
    $sidebar = $row['sidebar'];
    $directions = $row['directions'];
    $zoom = $row['zoom'];
    $zoom_encompass = $row['zoom_encompass'];
    $info_window = $row['info_window'];
    $info_trigger = $row['info_trigger'];
  }

if( isset($params['cancel']) )
  {
    $this->RedirectToTab($id);
  }
else if( isset($params['submit']) )
  {
    // Get variables from the params
    if( isset($params['name']) ) $name = trim($params['name']);
    if( isset($params['description']) ) $description = trim($params['description']);
    if( isset($params['center_lat']) ) $center_lat = trim($params['center_lat']);
    if( isset($params['center_lon']) ) $center_lon = trim($params['center_lon']);
    if( isset($params['type']) ) $type = $params['type'];
    if( isset($params['width']) ) $width = (int)$params['width'];
    if( isset($params['height']) ) $height = $params['height'];
    if( isset($params['controls']) ) $controls = $params['controls'];
    if( isset($params['controls_size']) ) $controls_size = $params['controls_size'];
    if( isset($params['type_controls']) ) $type_controls = $params['type_controls'];
    if( isset($params['sidebar']) ) $sidebar = $params['sidebar'];
    if( isset($params['directions']) ) $directions = $params['directions'];
    if( isset($params['zoom']) ) $zoom = $params['zoom'];
    if( isset($params['zoom_encompass']) ) $zoom_encompass = $params['zoom_encompass'];
    if( isset($params['info_window']) ) $info_window = $params['info_window'];
    if( isset($params['info_trigger']) ) $info_trigger = $params['info_trigger'];

    // make sure that height, width, and name are specified
    if( empty($name) || $height <= 0 || $width <= 0 )
      {
	echo $this->ShowErrors($this->Lang('error_invalidparams'));
      }
    else
      {
	if( isset($params['map_id']) )
	  {
	    // make sure that an item by this name doesn't already exist
	    $query = 'SELECT map_id FROM '.cms_db_prefix().'module_cggooglemaps
                   WHERE name = ? AND map_id != ?';
	    $mapid = $db->GetOne($query, array($name,$params['map_id']));

	    if( $mapid )
	      {
		echo $this->ShowErrors($this->Lang('error_namexists'));
	      }
	    else
	      {
		// update the record
		$query = 'UPDATE '.cms_db_prefix().'module_cggooglemaps
                       SET name = ?, description = ?, center_lat = ?,
                           center_lon = ?, type = ?, width = ?, height = ?,
                           controls = ?, controls_size = ?,
                           type_controls = ?, sidebar = ?, directions = ?,
                           zoom = ?, zoom_encompass = ?,
                           info_window = ?, info_trigger = ?
                       WHERE map_id = ?';
		$dbr = $db->Execute( $query, array( $name,
						    $description,
						    $center_lat,
						    $center_lon,
						    $type,
						    $width,
						    $height,
						    $controls,
						    $controls_size,
						    $type_controls,
						    $sidebar,
						    $directions,
						    $zoom,
						    $zoom_encompass,
						    $info_window,
						    $info_trigger,
						    $params['map_id']));
	      }
	  }
	else
	  {
	    // make sure that an item by this name doesn't already exist
	    $query = 'SELECT map_id FROM '.cms_db_prefix().'module_cggooglemaps
                   WHERE name = ?';
	    $mapid = $db->GetOne($query, array($name));
	    
	    if( $mapid ) 
	      {
		echo $this->ShowErrors($this->Lang('error_namexists'));
	      }
	    else
	      {
		// add it
		$query = 'INSERT INTO '.cms_db_prefix().'module_cggooglemaps 
                       (name,description,center_lat,center_lon,type,width,height,controls,controls_size,type_controls,sidebar,directions,zoom,zoom_encompass,info_window,info_trigger)
                      VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
		$dbr = $db->Execute( $query, array( $name,
						    $description,
						    $center_lat,
						    $center_lon,
						    $type,
						    $width,
						    $height,
						    $controls,
						    $controls_size,
						    $type_controls,
						    $sidebar,
						    $directions,
						    $zoom,
						    $zoom_encompass,
						    $info_window,
						    $info_trigger));
	      }
	    if( !$dbr )
	      {
		echo "DEBUG: sql error = ".$db->ErrorMsg().'<br/>'.$db->sql; die();
	      }
	  }

	// redirect
	$this->RedirectToTab($id);
      }
  }

$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_add_map',$returnid));
if( isset($params['map_id']) )
  {
    $smarty->assign('hidden',$this->CreateInputHidden($id,'map_id',$params['map_id']));
  }
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));
$smarty->assign('cancel',$this->CreateInputSubmit($id,'cancel',$this->Lang('cancel')));

$smarty->assign('prompt_name',$this->Lang('map_name'));
$smarty->assign('input_name',$this->CreateInputText($id,'name',$name,40,80));

$smarty->assign('prompt_description',$this->Lang('description'));
$smarty->assign('input_description',$this->CreateTextArea(false,$id,$description,'description'));

$smarty->assign('prompt_center_lat',$this->Lang('center_lat'));
$smarty->assign('input_center_lat',$this->CreateInputText($id,'center_lat',$center_lat,10,15));

$smarty->assign('prompt_center_lon',$this->Lang('center_lon'));
$smarty->assign('input_center_lon',$this->CreateInputText($id,'center_lon',$center_lon,10,15));

$smarty->assign('prompt_type',$this->Lang('type'));
$maptypes = array();
$maptypes[$this->Lang('map')] = 'map';
$maptypes[$this->Lang('satellite')] = 'satellite';
$maptypes[$this->Lang('hybrid')] = 'hybrid';
$smarty->assign('input_type',$this->CreateInputDropdown($id,'type',$maptypes,-1,$type));

$smarty->assign('prompt_width',$this->Lang('width'));
$smarty->assign('input_width',$this->CreateInputText($id,'width',$width,5,10));

$smarty->assign('prompt_height',$this->Lang('height'));
$smarty->assign('input_height',$this->CreateInputText($id,'height',$height,5,10));

$smarty->assign('prompt_controls', $this->lang('controls'));
$smarty->assign('input_controls',$this->CreateInputYesNoDropdown($id,'controls',$controls));

$smarty->assign('prompt_controls_size', $this->lang('controls_size'));
$controls_sizes = array();
$controls_sizes[$this->Lang('large')] = 'large';
$controls_sizes[$this->Lang('small')] = 'small';
$smarty->assign('input_controls_size',$this->CreateInputDropdown($id,'controls_size',$controls_sizes,-1,$controls_size));

$smarty->assign('prompt_type_controls', $this->Lang('type_controls'));
$smarty->assign('input_type_controls',$this->CreateInputYesNoDropdown($id,'type_controls',$type_controls));

$smarty->assign('prompt_sidebar',$this->Lang('sidebar'));
$smarty->assign('input_sidebar',$this->CreateInputYesNoDropdown($id,'sidebar',$sidebar));

$smarty->assign('prompt_directions',$this->Lang('directions'));
$smarty->assign('input_directions',$this->CreateInputYesNoDropdown($id,'directions',$directions));

$smarty->assign('prompt_zoom',$this->Lang('zoom'));
$zoomlevels = array();
for( $i = 1; $i < 17; $i++ )
  {
    $zoomlevels[$i] = $i;
  }
$smarty->assign('input_zoom',$this->CreateInputDropdown($id,'zoom',$zoomlevels,-1,$zoom));

$smarty->assign('prompt_zoom_encompass',$this->Lang('zoom_encompass'));
$smarty->assign('input_zoom_encompass',$this->CreateInputYesNoDropdown($id,'zoom_encompass',$zoom_encompass));

$smarty->assign('prompt_info_window',$this->Lang('info_window'));
$smarty->assign('input_info_window',$this->CreateInputYesNoDropdown($id,'info_window',$info_window));

$smarty->assign('prompt_info_trigger',$this->Lang('info_trigger'));
$info_triggers = array();
$info_triggers[$this->Lang('click')] = 'click';
$info_triggers[$this->Lang('mouseover')] = 'mouseover';
$smarty->assign('input_info_trigger',$this->CreateInputDropdown($id,'info_trigger',$info_triggers,-1,$info_trigger));

echo $this->ProcessTemplate('add_map.tpl');
// EOF
?>
