<?php
#-------------------------------------------------------------------------
# Module: FlatRateShipping - A simple shipping module for Cart
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') )
  {
    echo $this->ShowErrors('error_permissiondenied');
    return;
  }

$this->SetCurrentTab('settings');
$smarty->assign('formstart',
		$this->CGCreateFormStart($id,'admin_save_settings',$returnid));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));

$weightunit = cg_ecomm::get_weight_units();
$priceunit = cg_ecomm::get_currency_symbol();
$smarty->assign('labeltext',$this->Lang('label'));
$smarty->assign('weighttext',$this->Lang('max_weight',$weightunit));
$smarty->assign('pricetext',$this->Lang('price',$priceunit));

$smarty->assign('input_label',
		$this->CreateInputText($id,'input_label','',20));
$smarty->assign('input_weight',
		$this->CreateInputText($id,'input_weight','',10,10));
$smarty->assign('input_price',
		$this->CreateInputText($id,'input_price','',10,10));

// Get the existing data out of the database
$entries = array();
$query = 'SELECT * FROM '.cms_db_prefix().'module_frshipping';
$dbr = $db->Execute( $query );
while( $dbr && ($row = $dbr->FetchRow() ) )
  {
    $obj = cge_array::to_object($row);
    $obj->input_label = $this->CreateInputText($id,'label[]',$row['label'],20);
    $obj->input_weight = 
      $this->CreateInputText($id,'weight[]',
			     sprintf("%.2f",$row['weight_limit']),10,10);
    $obj->input_price = 
      $this->CreateInputText($id,'price[]',
			     sprintf("%.2f",$row['price']),10,10);
    $entries[] = $obj;
  }
$smarty->assign('entries',$entries);

echo $this->ProcessTemplate('admin_settings_tab.tpl');
// EOF
?>
