<?php
#-------------------------------------------------------------------------
# Module: FlatRateShipping - A simple shipping module for Cart
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') )
  {
    echo $this->ShowErrors('error_permissiondenied');
    return;
  }

$this->SetCurrentTab('settings');

if( !isset($params['submit']) )
  {
    $this->RedirectToTab($id);
  }

$pricelist = array();
$error = false;
//
// Check the existing entries
//
if( (count($params['label']) != count($params['weight'])) ||
    (count($params['label']) != count($params['price'])) )
  {
    // todo
    die('invalid size');
  }
for( $i = 0; $i < count($params['label']); $i++ )
  {
    $label = $params['label'][$i];
    $weight = $params['weight'][$i];
    $price = $params['price'][$i];
    
    if( !preg_match('/[\.\d+]+/',$weight) )
      {
	$this->SetError($this->Lang('error_invalidparameter',
				    $this->Lang('weight')));
	$error = true;
      }
    if( !preg_match('/[\.\d+]+/',$price) )
      {
	$this->SetError($this->Lang('error_invalidparameter',
				    $this->Lang('price')));
	$error = true;
      }

    if( !$error )
      {   
	// They're valid
	$pricelist[] = array(trim($label),$weight,$price);
      }
  }

// 
// Check the new entries for quality
//
if( !empty($params['input_weight']) && !empty($params['input_price']) &&
    !$error)
  {
    // We may be adding

    if( !preg_match('/[\.\d+]+/',$params['input_weight']) )
      {
	$this->SetError($this->Lang('error_invalidparameter',
				    $this->Lang('weight')));
	$error = true;
      }
    if( !preg_match('/[\.\d+]+/',$params['input_price']) )
      {
	$this->SetError($this->Lang('error_invalidparameter',
				    $this->Lang('price')));
	$error = true;
      }

    if( !$error )
      {   
	// They're valid
	$pricelist[] = array(trim($params['input_label']),
			     (float)($params['input_weight']),
			     (float)($params['input_price']));
      }
  }

//
// Check everything to make sure that the weight limit is in ascending order
//
$minprice = 0;
$minweight = 0;
for( $i = 0; $i < count($pricelist); $i++ )
  {
    $refarray =& $pricelist[$i];

    if( $refarray[1] < $minweight )
      {
	$this->SetError($this->Lang('error_weightorder',$refarray[1]));
	$error = true;
      }
    else
      {
	$minweight = $refarray[1];
      }

    if( $refarray[2] < $minprice )
      {
	$this->SetError($this->Lang('error_priceorder',$refarray[2]));
	$error = true;
      }
    else
      {
	$minprice = $refarray[2];
      }
  }

// 
// Save the data
//
if( !$error )
  {
    $query = 'DELETE FROM '.cms_db_prefix().'module_frshipping';
    $db->Execute( $query );

    $query = 'INSERT INTO '.cms_db_prefix().'module_frshipping
                (label,weight_limit,price) VALUES (?,?,?)';
    foreach( $pricelist as $one )
      {
	$db->Execute( $query, $one );
      }
  }

$this->RedirectToTab($id);

// EOF
?>