<?php
#-------------------------------------------------------------------------
# Module: warehouse_taxes - A module to provide taxes to the cart module
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------


$cgextensions = cms_join_path($gCms->config['root_path'],'modules',
			      'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
  echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
  return;
}
require_once($cgextensions);

class warehouse_taxes extends CGExtensions
{
  var $applicable_state;

  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  function GetName()
  {
    return 'warehouse_taxes';
  }


  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }

	
  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  function GetVersion()
  {
    return '1.2';
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  function GetAuthor()
  {
    return 'calguy1000';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  function GetAuthorEmail()
  {
    return 'calguy1000@hotmail.com';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  function GetChangeLog()
  {
    return $this->Lang('changelog');
  }

  
  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  function IsPluginModule()
  {
    return false;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'ecommerce';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Site Preferences');
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array('Orders'=>'1.10',
		 'CGExtensions'=>'1.19.4');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.8.1";
  }
	
	
  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }	


  /*---------------------------------------------------------
   IsTaxModule()
   ---------------------------------------------------------*/
  function IsTaxModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   SetAdditionalInfo()
   ---------------------------------------------------------*/
  function SetAdditionalInfo($params)
  {
    if( is_array($params) )
      {
	if( isset($params['billing_state']) )
	  {
	    $this->applicable_state = $params['billing_state'];
	  }
	else if( isset($params['state']) )
	  {
	    $this->applicable_state = $params['state'];
	  }
	else if( isset($params['_state']) )
	  {
	    $this->applicable_state = $params['_state'];
	  }
      }
    else if( is_object($params) )
      {
	if( isset($params->state) )
	  {
	    $this->applicable_state = $params->state;
	  }
      }
  }


  /*---------------------------------------------------------
   GetTaxesForProduct()
   // returns an array of taxname => tax amount
   ---------------------------------------------------------*/
  function GetTaxesForProduct($item_price,$quantity)
  {
    // check to see if this user is exmpt.
    $exempt = false;
    $feu = cge_utils::get_module('FrontEndUsers');
    if( $feu )
      {
	$tax_exempt_groups = unserialize($this->GetPreference('tax_exempt_groups'));
	if( is_array($tax_exempt_groups) && count($tax_exempt_groups) )
	  {
	    $uid = $feu->LoggedInId();
	    if( $uid > 0 )
	      {
		// user is logged in.
		foreach( $tax_exempt_groups as $gid )
		  {
		    if( $feu->MemberOfGroup($uid,$gid) )
		      {
			$exempt = true;
			break;
		      }
		  }
	      }
	  }
      }
    if( $exempt ) 
      {
	// this user is exempt.
	return;
      }

    // Calculate a default tax
    $default = false;
    $name = $this->GetPreference('default_tax_name',$this->Lang('tax'));
    $rate = floatval($this->GetPreference('default_tax_rate'));
    if( $rate != 0.0 )
      {
	$tax = $item_price * $quantity * $rate;
	$default = array($name=>$tax);
      }

    // Now do a state lookup
    $db =& $this->GetDb();
    $query = 'SELECT rate FROM '.cms_db_prefix().'module_warehouse_taxes
               WHERE state = ?';
    $rate = $db->GetOne($query,array($this->applicable_state));
    if( !$rate )
      {
	return $default;
      }
    $tax = floatval($rate)*$item_price*$quantity;

    $res = array($this->applicable_state=>$tax);
    return $res;
  }

} // class

?>
