<?php
#-------------------------------------------------------------------------
# Module: warehouse_taxes - A module to provide taxes to the cart module
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;

if( !$this->CheckPermission('Modify Site Preferences') )
  {
    echo $this->ShowErrors('error_permissiondenied');
    return;
  }

$this->SetCurrentTab('settings');
$smarty->assign('formstart',
		$this->CGCreateFormStart($id,'admin_save_settings',$returnid));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('submit',$this->CreateInputSubmit($id,'submit',$this->Lang('submit')));
$smarty->assign('statetext',$this->Lang('state'));
$smarty->assign('ratetext',$this->Lang('tax_rate'));
$smarty->assign('state_taxes_text',$this->Lang('state_taxes'));
$smarty->assign('default_tax_nametext',$this->Lang('default_tax_name'));
$smarty->assign('default_tax_ratetext',$this->Lang('default_tax_rate'));

$smarty->assign('input_state',
		$this->CreateInputStateDropdown($id,'input_state','',true));
$smarty->assign('input_rate',
		$this->CreateInputText($id,'input_rate','',10,10));
$smarty->assign('input_add',
		$this->CreateInputSubmit($id,'add',$this->Lang('add')));

$smarty->assign('input_default_tax_name',
		$this->CreateInputText($id,'input_default_tax_name',
				       $this->GetPreference('default_tax_name'),
				       10,10));
$smarty->assign('input_default_tax_rate',
		$this->CreateInputText($id,'input_default_tax_rate',
				       $this->GetPreference('default_tax_rate'),
				       10,10));

$feu = cge_utils::get_module('FrontEndUsers');
if( $feu )
  {
    $grouplist = $feu->GetGroupList();
    $smarty->assign('grouplist',array_flip($grouplist));
    $smarty->assign('tax_exempt_groups',unserialize($this->GetPreference('tax_exempt_groups')));
  }

// Get the existing data out of the database
$entries = array();
$query = 'SELECT * FROM '.cms_db_prefix().'module_warehouse_taxes';
$dbr = $db->Execute( $query );
while( $dbr && ($row = $dbr->FetchRow() ) )
{
  $obj = cge_array::to_object($row);
  $obj->input_state = 
    $this->CreateInputStateDropdown($id,'state_'.$row['id'],$row['state']);
  $obj->input_rate = 
    $this->CreateInputText($id,'rate_'.$row['id'],
			   sprintf("%.4f",$row['rate']),10,10);
  $obj->input_delete =
    $this->CreateInputSubmit($id,'delete_'.$row['id'],$this->Lang('delete'));
  $obj->input_update =
    $this->CreateInputSubmit($id,'update_'.$row['id'],$this->Lang('update'));
  $entries[] = $obj;
}
$smarty->assign('entries',$entries);


echo $this->ProcessTemplate('admin_settings_tab.tpl');


// EOF
?>