<?php
#-------------------------------------------------------------------------
# Module: warehouse_taxes - A module to provide taxes to the cart module
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;

if( !$this->CheckPermission('Modify Site Preferences') )
  {
    echo $this->ShowErrors('error_permissiondenied');
    return;
  }
$this->SetCurrentTab('settings');

if( isset($params['add']) )
  {
    //
    // looks like we're trying to adding an entry
    //
    $state = $params['input_state'];
    $rate = trim($params['input_rate']);

    if( empty($state) || empty($rate) )
      {
	$this->RedirectToTab($id);
      }

    $rid = $params['rid'];
    $rate = floatval(trim($params['input_rate']));
    if( $rate <= 0.0 || $rate > 0.9 )
      {
	$this->SetError($this->Lang('error_invalid_rate'));
	$this->RedirectToTab($id);
      }

    $query = 'SELECT id FROM '.cms_db_prefix().'module_warehouse_taxes
               WHERE state = ?';
    $tmp = $db->GetOne($query,array($state));
    if( $tmp )
      {
	$this->SetError($this->Lang('error_state_tax_exists'));
	$this->RedirectToTab($id);
      }

    $query = 'INSERT INTO '.cms_db_prefix().'module_warehouse_taxes
                (state, rate) VALUES (?,?)';
    $db->Execute( $query, array( $state, $rate ) );

    $this->RedirectToTab($id);
  }
else if( isset($params['submit']) )
  {
    $rate = floatval($params['input_default_tax_rate']);
    $name = trim($params['input_default_tax_name']);
    if( $rate < 0.0 || $rate > 0.9 )
      {
	$this->SetError($this->Lang('error_invalid_rate'));
	$this->RedirectToTab($id);
      }
    if( empty($name) )
      {
	$this->SetError($this->Lang('error_invalid_tax_name'));
	$this->RedirectToTab($id);
      }
    $this->SetPreference('default_tax_name',$name);
    $this->SetPreference('default_tax_rate',$rate);
    $this->SetPreference('tax_exempt_groups',serialize($params['tax_exempt_groups']));
    $this->RedirectToTab($id);
  }

//
// if we got here, we're either updating or deleting
// an existing record
//

foreach( $params as $key => $value )
{
  if( preg_match('/^delete_/',$key) )
    {
      $rid =  intval(substr($key,7));
      $query = 'DELETE FROM '.cms_db_prefix().'module_warehouse_taxes
                 WHERE id = ?';
      $db->Execute($query,array($rid));
      $this->RedirectToTab();
    }
  else if( preg_match('/^update_/',$key) )
    {
      $rid  =  intval(substr($key,7));
      $state = trim($params['state_'.$rid]);
      $rate = floatval($params['rate_'.$rid]);
      if( $rate <= 0.0 || $rate > 0.9 )
	{
	  $this->SetError($this->Lang('error_invalid_rate'));
	  $this->RedirectToTab($id);
	}

      $query = 'SELECT id FROM '.cms_db_prefix().'module_warehouse_taxes
                 WHERE state = ? AND id != ?';
      $tmp = $db->GetOne($query,array($state,$rid));
      if( $tmp )
	{
	  $this->SetError($this->Lang('error_state_tax_exists'));
	  $this->RedirectToTab($id);
	}

      $query = 'UPDATE '.cms_db_prefix().'module_warehouse_taxes
                   SET state = ?, rate = ?
                 WHERE id = ?';
      $db->Execute( $query, array( $state, $rate, $rid ) );

      $this->RedirectToTab();
    }
}

die('fatal error');

// EOF
?>