<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class orders_ops
{
  static public function &find_last_feu_order($feu_uid)
  {
    global $gCms; $db =& $gCms->GetDb();
    $query = 'SELECT id FROM '.cms_db_prefix().'module_orders
               WHERE feu_user_id = ?
               ORDER by id DESC LIMIT 1';
    $tmp = $db->GetOne($query,array($feu_uid));
    if( !$tmp ) return FALSE;
    return $tmp;
  }


  static public function &load_by_id($id)
  {
    // load the order record itself
    $bad = null;
    global $gCms; $db =& $gCms->GetDb();
    $query = 'SELECT id, feu_user_id, invoice,
              billing_company,
              billing_first_name, billing_last_name, billing_address1,
              billing_address2, billing_city, billing_state, billing_postal,
              billing_country, billing_phone, billing_fax, billing_email,
              status, order_notes,
              create_date, modified_date
              FROM '.cms_db_prefix().'module_orders WHERE id = ?';
    $row = $db->GetRow($query,array($id));
    if( !$row ) 
      {
	return $bad;
      }

    $order = new orders_order();
    $order->from_array($row);

    // now fill the shipping stuff.
    $query = 'SELECT id FROM '.cms_db_prefix().'module_orders_shipping
               WHERE order_id = ?';
    $tmp = $db->GetCol($query,array($id));
    if( is_array($tmp) )
      {
	foreach( $tmp as $shipping_id )
	  {
	    $shipping = shipping_ops::load_by_id($shipping_id);
	    $order->add_shipping($shipping,false);
	  }
      }

    // now fill in the payments stuff
    $query = 'SELECT id FROM '.cms_db_prefix().'module_orders_payments
               WHERE order_id = ?';
    $tmp = $db->GetCol($query,array($id));
    if( is_array($tmp) )
      {
	foreach( $tmp as $payment_id )
	  {
	    $payment = payment_ops::load_by_id($payment_id);
	    $order->add_payment($payment,false);
	  }
      }

    // now fill in the notes stuff
    $query = 'SELECT id FROM '.cms_db_prefix().'module_orders_notes
               WHERE order_id = ?
               ORDER BY sent ASC';
    $tmp = $db->GetCol($query,array($id));
    if( is_array($tmp) )
      {
	foreach( $tmp as $note_id )
	  {
	    $message = message_ops::load_by_id($note_id);
	    $order->add_message($message,false);
	  }
      }
    return $order;
  }


  static public function insert(orders_order &$order)
  {
    global $gCms; $db =& $gCms->GetDb();
    $now = $db->DbTimeStamp(time());
    $query = 'INSERT INTO '.cms_db_prefix()."module_orders
               (feu_user_id,invoice,
                billing_company,billing_first_name,billing_last_name,
                billing_address1,billing_address2,billing_city,
                billing_state,billing_postal,billing_country,
                billing_phone,billing_fax,billing_email,
                status, order_notes,
                create_date, modified_date)
              VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,$now,$now)";

    $billing = $order->get_billing();
    $dbr = $db->Execute($query,
			array($order->get_feu_user(),
			      'NOTSET',
			      $billing->get_company(),
			      $billing->get_firstname(),
			      $billing->get_lastname(),
			      $billing->get_address1(),
			      $billing->get_address2(),
			      $billing->get_city(),
			      $billing->get_state(),
			      $billing->get_postal(),
			      $billing->get_country(),
			      $billing->get_phone(),
			      $billing->get_fax(),
			      $billing->get_email(),
			      $order->get_status(),
			      $order->get_order_notes()));

    if( !$dbr ) 
      {
	echo "DEBUG: ".$db->sql.'<br/>'.$db->ErrorMsg(); die();
	return FALSE;
      }

    $order->set_id($db->Insert_Id());
    $invoice = $order->get_invoice();
    if( !$invoice )
      {
	// generate an invoice number.
	$invoice = orders_helper::make_invoice_number($order->get_id());
	$order->set_invoice($invoice);
	$query = 'UPDATE '.cms_db_prefix().'module_orders SET invoice = ? WHERE id = ? and invoice = ?';
	$db->Execute($query,array($invoice,$order->get_id(),'NOTSET'));
      }
    $order->set_create_date($now);
    $order->set_modified_date($now);

    try 
      {
	// save the shipping stuff.
	for( $i = 0; $i < $order->count_destinations(); $i++ )
	  {
	    $shipping = $order->get_shipping($i);
	    $shipping->set_id(null);
	    $shipping->set_order_id($order->get_id());
	    $res = $shipping->save();
	    if( !$res ) return FALSE;
	  }

	// save the payments stuff
	for( $i = 0; $i < $order->count_payments(); $i++ )
	  {
	    $payment = $order->get_payment($i);
	    $payment->set_id(null);
	    $payment->set_order_id($order->get_id());
	    $res = $payment->save();
	    if( !$res ) return FALSE;
	  }

	// save the notes
	for( $i = 0; $i < $order->count_notes(); $i++ )
	  {
	    $message = $order->get_note($i);
	    $message->set_id(null);
	    $message->set_order_id($order->get_id());
	    $res = $message->save();
	    if( !$res ) return FALSE;
	  }

	cg_ecomm_order::on_order_created($order->get_id());
	return TRUE;
      }
    catch( cg_exception $e )
      {
	self::delete_by_id($order->get_id());
	return FALSE;
      }
  }


  static public function update(orders_order &$order,$delete_items = false)
  {
    global $gCms; $db =& $gCms->GetDb();
    $now = $db->DbTimeStamp(time());
    $query = 'UPDATE '.cms_db_prefix()."module_orders SET
                feu_user_id = ?, invoice = ?, 
                billing_company = ?, billing_first_name = ?, billing_last_name = ?,
                billing_address1 = ?, billing_address2 = ?, billing_city = ?,
                billing_state = ?, billing_postal = ?, billing_country = ?,
                billing_phone = ?, billing_fax = ?, billing_email = ?,
                status = ?, order_notes = ?,
                modified_date = $now
              WHERE id = ?";

    $billing = $order->get_billing();
    $dbr = $db->Execute($query,
			array($order->get_feu_user(),
			      $order->get_invoice(),
			      $billing->get_company(),
			      $billing->get_firstname(),
			      $billing->get_lastname(),
			      $billing->get_address1(),
			      $billing->get_address2(),
			      $billing->get_city(),
			      $billing->get_state(),
			      $billing->get_postal(),
			      $billing->get_country(),
			      $billing->get_phone(),
			      $billing->get_fax(),
			      $billing->get_email(),
			      $order->get_status(),
			      $order->get_order_notes(),
			      $order->get_id())
			);
    if( !$dbr ) 
      {
	echo "DEBUG: ".$db->sql.'<br/>'.$db->ErrorMsg(); die();
	return FALSE;
      }

    try 
      {
	$order->set_modified_date($now);
	if( $delete_items )
	  {
	    $query = 'DELETE FROM '.cms_db_prefix().'module_orders_items WHERE order_id = ?';
	    $dbr = $db->Execute($query,array($order->get_id()));
	    
	    $query = 'DELETE FROM '.cms_db_prefix().'module_orders_shipping WHERE order_id = ?';
	    $dbr = $db->Execute($query,array($order->get_id()));
	  }
	for( $i = 0; $i < $order->count_destinations(); $i++ )
	  {
	    $shipping =& $order->get_shipping($i);
	    $shipping->set_order_id($order->get_id());
	    $res = $shipping->save();
	    if( !$res ) return FALSE;
	  }

	// save the payments stuff
	for( $i = 0; $i < $order->count_payments(); $i++ )
	  {
	    $payment =& $order->get_payment($i);
	    $payment->set_order_id($order->get_id());
	    $res = $payment->save();
	    if( !$res ) return FALSE;
	  }
	
	// save the notes
	for( $i = 0; $i < $order->count_notes(); $i++ )
	  {
	    $message = $order->get_note($i);
	    $message->set_order_id($order->get_id());
	    $res = $message->save();
	    if( !$res ) return FALSE;
	  }
	
	cg_ecomm_order::on_order_updated($order->get_id());
	return TRUE;
      }
    catch( cg_exception $e )
      {
	die($e->__toString());
	// now what to do.
	return FALSE;
      }
  }


  static public function delete_by_id($order_id)
  {
    global $gCms; $db =& $gCms->GetDb();

    $query = 'DELETE FROM '.cms_db_prefix().'module_orders_messages WHERE order_id = ?';
    $db->Execute($query,array($order_id));

    $query = 'DELETE FROM '.cms_db_prefix().'module_orders_items WHERE order_id = ?';
    $db->Execute($query,array($order_id));

    $query = 'DELETE FROM '.cms_db_prefix().'module_orders_shipping WHERE order_id = ?';
    $db->Execute($query,array($order_id));

    $query = 'DELETE FROM '.cms_db_prefix().'module_orders_payments WHERE order_id = ?';
    $db->Execute($query,array($order_id));

    $query = 'DELETE FROM '.cms_db_prefix().'module_orders WHERE id = ?';
    $db->Execute($query,array($order_id));

    // delete all associated data.
    $assoc = new AssocData($db,'Orders');
    $assoc->Delete($order_id);

    cg_ecomm_order::on_order_deleted($order_id);
  }
} // end of class

// EOF
?>