<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class orders_helper extends module_helper
{
  static private $_encryption_key;
  static private $_invoice_prefix;
  static private $_security_key;

  static public function &instance()
  {
    return self::get_instance('Orders');
  }


  static public function get_encryption_key()
  {
    if( is_null(self::$_encryption_key) )
      {
	$module =& self::instance();
	self::$_encryption_key = $module->_getRealEncryptionKey();
      }
    return self::$_encryption_key;
  }


  static public function can_manage_orders()
  {
    $module =& self::instance();
    if( $module->CheckPermission(ORDERS_PERM_MANAGEORDERS) )
      {
	return TRUE;
      }
    return FALSE;
  }


  static public function postal_required()
  {
    $module = self::instance();
    return $module->GetPreference('require_postalcode',1);
  }


  static public function state_required()
  {
    $module = self::instance();
    return $module->GetPreference('require_state',1);
  }


  static public function set_invoice_prefix($txt)
  {
    self::$_invoice_prefix = $txt;
  }


  static public function make_invoice_number($order_id,$prefix = '')
  {
    if( !$prefix )
      {
	$module =& self::instance();
	$prefix = $module->GetPreference('ordernum_prefix','INV');
	if( isset($_SESSION['invoice_prefix']) )
	  {
	    $prefix = trim($_SESSION['invoice_prefix']);
	    unset($_SESSION['invoice_prefix']);
	  }
      }
    return $prefix.sprintf('%05d',$order_id);
  }


  static public function is_creditcard_number($str)
  {
    // uses the luhn/mod-10 algorithm.
    $number = preg_replace('/\D/', '', $number);
    $len = strlen($number);
    $parity = $len % 2;
    
    $total = 0;
    for( $i = 0; $i < $len; $i++ )
      {
	$digit = $number[$i];
	if( $i % 2 == $parity )
	  {
	    $digit *= 2;
	    if( $digit > 9 ) $digit -= 9;
	  }
	$total += $digit;
      }
    return ($total %10 == 0) ? TRUE : FALSE;
  }


  static public function requires_creditcard_number()
  {
    $module = self::instance();
    $allow_creditcard = $module->GetPreference('allow_creditcard_entry');
    $gateway_requires_creditcard = '';
    {
      $gateway_module = cg_ecomm::get_payment_module();
      if( is_object($gateway_module) )
	{
	  $gateway_requires_creditcard = $gateway_module->RequiresCreditCardInfo();
	}
    }
    if( $allow_creditcard || $gateway_requires_creditcard ) 
      {
	return TRUE;
      }
    return FALSE;
  }


  static public function creditcard_requires_ssl()
  {
    $module = self::instance();
    $force_ssl = $module->GetPreference('force_ssl');
    $requires_creditcard = self::requires_creditcard_number();
    $gateway_module = cg_ecomm::get_payment_module();
    $gateway_requires_ssl = FALSE;
    if( is_object($gateway_module) )
      {
	$gateway_requires_ssl = $gateway_module->RequiresSSL();
      }
    return ($force_ssl || $gateway_requires_ssl);
  }


  static public function is_valid_user()
  {
    $module = self::instance();
    if( $module->GetPreference('allow_anon_checkout',0) ) return -1;
    if( !$feu ) return FALSE;

    $uid = $feu->LoggedInId();
    if( $uid <= 0 ) return FALSE;

    $grpid = $module->GetPreference('require_membership',-1);
    if( $grpid <= 0 ) return $uid;

    $data = $feu->GetMemberGroupsArray($uid);
    $gids = cge_array::extract_field($data,'groupid');
    if( !in_array( $grpid, $gids ) )
      {
	return FALSE;
      }
    return $uid;
  }


  static public function get_security_key()
  {
    if( is_null(self::$_security_key) )
      {
	$uid = self::is_valid_user();
	if( $uid !== FALSE )
	  {
	    global $gCms;
	    $key = $gCms->config['root_url'].$uid.session_id().cge_utils::get_real_ip();
	    self::$_security_key = 'c_'.md5($key);
	  }
      }
    return self::$_security_key;
  }
}

#
# EOF
#
?>