<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple example frontend form module
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

// this should go into the orders_order class.
define('ORDERSTATUS_PROPOSED','proposed');      // customer has placed order, but not confirmed it yet
define('ORDERSTATUS_CONFIRMED','confirmed');    // customer has confirmed order, but not processed payment
define('ORDERSTATUS_INVOICED','invoiced');      // customer has completed manual invoice process
define('ORDERSTATUS_SUBMITTED','submitted');    // delete me?
define('ORDERSTATUS_CANCELLED','cancelled');    // this order has been cancelled (by an admin, or by the user)
define('ORDERSTATUS_PAID','paid');              // this order is paid in full
define('ORDERSTATUS_HOLD','hold');              // this order is on hold
define('ORDERSTATUS_BALANCEDUE','balancedue');  // this order has not been paid in full
define('ORDERSTATUS_INCOMPLETE','incomplete');  // not all items for this order have been shipped
define('ORDERSTATUS_COMPLETED','completed');    // this order has been paid in full, and shipped in full.
define('ORDERSTATUS_PENDING','pending');        // this order has been submitted for payment, but not yet approved.
define('ORDERSTATUS_SUBSCRIBED','subscribed');  // this order is a subscription only order, and is active.

define('ITEMSTATUS_PENDING','pending');         // this service item has not been delivered
define('ITEMSTATUS_DELIVERED','delivered');     // this service item has been delivered
define('ITEMSTATUS_BACKORDER','backorder');     // this order item is on backorder
define('ITEMSTATUS_SHIPPED','shipped');         // this order item has been shipped
define('ITEMSTATUS_NOTSHIPPED','notshipped');   // this order item has not been shppped
define('ITEMSTATUS_HOLD','hold');               // this order item is on hold

define('ORDERS_PERM_VIEWORDERS','View Orders');
define('ORDERS_PERM_MANAGEORDERS','Manage Orders');
define('ORDERS_PERM_CONTACT_CUSTOMERS','Contact Customers');
define('ORDERS_PERM_DELETE_ORDERS','Delete Orders');

$cgecommbase = cms_join_path($gCms->config['root_path'],'modules',
			      'CGEcommerceBase','CGEcommerceBase.module.php');
if( !is_readable( $cgecommbase ) )
{
  echo '<h1><font color="red">ERROR: The CGEcommerceBase module could not be found.</font></h1>';
  return;
}
require_once($cgecommbase);

class Orders extends CGEcommerceBase
{

  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  function GetName()
  {
    return 'Orders';
  }

  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }

	
  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  function GetVersion()
  {
    return '1.10.2';
  }


  /*---------------------------------------------------------
   AllowAutoInstall()
   ---------------------------------------------------------*/
  function AllowAutoInstall()
  {
    return FALSE;
  }


  /*---------------------------------------------------------
   AllowAutoUpgrade()
   ---------------------------------------------------------*/
  function AllowAutoUpgrade()
  {
    return FALSE;
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  function GetAuthor()
  {
    return 'calguy1000';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  function GetAuthorEmail()
  {
    return 'calguy1000@cmsmadesimple.org';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  function GetChangeLog()
  {
    return @file_get_contents(dirname(__FILE__).'/changelog.html.inc');
  }
  
  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  function IsPluginModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'content';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Templates') ||
      $this->CheckPermission('Modify Site Preferences') ||
      $this->CheckPermission(ORDERS_PERM_VIEWORDERS) ||
      $this->CheckPermission(ORDERS_PERM_MANAGEORDERS) ||
      $this->CheckPermission(ORDERS_PERM_CONTACT_CUSTOMERS);
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array('CGEcommerceBase'=>'1.2.2',
		 'FrontEndUsers'=>'1.12.2',
		 'CGExtensions'=>'1.19.4',
		 'CGSimpleSmarty'=>'1.3.1',
		 'CMSMailer'=>'1.73.13',
		 'CGPaymentGatewayBase'=>'1.0.9');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.8.1";
  }
	
	
  /*---------------------------------------------------------
   SetParameters()
   ---------------------------------------------------------*/
  function SetParameters()
  {
    encrypted_store::set_timeout($this->GetPreference('datastore_timeout',10)*60);

    $this->AddImageDir('icons');
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();

    $this->SetParameterType('order_notes',CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP.'/orders_.*/',CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP.'/billing_.*/',CLEAN_STRING);
    $this->SetParameterType(CLEAN_REGEXP.'/shipping_.*/',CLEAN_STRING);
    $this->SetParameterType('submit',CLEAN_STRING);
    $this->SetParameterType('submit_x',CLEAN_INT);
    $this->SetParameterType('submit_y',CLEAN_INT);
    $this->SetParameterType('gateway',CLEAN_STRING);
    $this->SetParameterType('confirmation_code',CLEAN_STRING);
    $this->SetParameterType('order_id',CLEAN_INT);
    $this->SetParameterType('datakey',CLEAN_STRING);
    $this->SetParameterType('invoice_prefix',CLEAN_STRING);

    $this->CreateParameter('invoice_prefix','',$this->Lang('help_param_invoice_prefix'));
    $this->CreateParameter('template','',$this->Lang('help_param_template'));
    $this->SetParameterType('template',CLEAN_STRING);

//     $this->CreateParameter('nocaptcha','',$this->Lang('help_param_nocaptcha'));
//     $this->SetParameterType('nocaptcha',CLEAN_INT);
  }


  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }	


  /*---------------------------------------------------------
   GetHeaderHTML()
   ---------------------------------------------------------*/
  function GetHeaderHTML()
  {
    global $gCms;
    $config =& $gCms->GetConfig();
    $output = '';

    $url = $config['root_url'].'/modules/'.$this->GetName().'/admin.css';
    $url2 = $config['root_url'].'/modules/'.$this->GetName().'/admin_print.css';
    $str = '';
    $str .= '<link rel="stylesheet" type="text/css" href="'.$url.'" />';
    $str .= '<link rel="stylesheet" type="text/css" href="'.$url2.'" media="print" />';
    $output = $str;

    $obj =& $this->GetModuleInstance('JQueryTools');
    if( is_object($obj) )
      {
$tmpl = <<<EOT
{JQueryTools action='incjs' exclude='form'}
{JQueryTools action='ready'}
EOT;
        $output .= "\n".$this->ProcessTemplateFromData($tmpl);
      }

    return $output;
  }	


  /*---------------------------------------------------------
   HandlesEvents();
   ---------------------------------------------------------*/
  function HandlesEvents()
  {
    return TRUE;
  }


  function SuppressAdminOutput(&$request)
  {
    if( isset($request['suppress_output']) ) return TRUE;

    $ret = FALSE;
    foreach( $request as $key => $value )
      {
	if( endswith($key,'showtemplate') && 
	    ($value == FALSE || $value == 'false') )
	  {
	    $ret = TRUE;
	    break;
	  }
      }
    return $ret;
  }


  function GetUsername($uid)
  {
    $feu =& $this->GetModuleInstance('FrontEndUsers');
    return $feu->GetUsername($uid);
  }


  public function _getRealEncryptionKey()
  {
    global $gCms;
    $config =& $gCms->GetConfig();
    $key = $this->GetPreference('encryption_key');
    if( empty( $key ) ) return '';
    $key = md5($config['root_path'].' '.$key);
    $key = substr($key,0,16);
    return $key;
  }


  // todo: get this out of this file.
/*
  function ProcessGatewayResult($uid,$order_id,$payment_id,$status,$transaction_id,$amount,$gateway,$message,$email_addr = '')
  {
    global $gCms;
    $db =& $gCms->GetDb();

    //
    // Get the data out of the order
    //
    $order_obj = $this->GetOrder($order_id);

    if( $uid )
      {
	//Make sure someone isn't pulling a fast one by just trolling for order id's
	$found_uid = $db->GetOne('SELECT feu_user_id FROM ' . cms_db_prefix() . 'module_orders WHERE id = ?', array($order_id));
	if ($uid != $found_uid)
	  {
	    // attempted hack
	    return $this->Lang('error_orderinvalid');
	  }
      }

    // Get the email address
    $billing = $order_obj->get_billing();
    $tmp = $billing->get_email();
    if( $tmp )
      {
	$email_addr = $tmp;
      }
    if( !$email_addr )
      {
	return $this->Lang('error_noemailaddress');
      }

    //
    // try to find a payment that matches
    //
    $payment = $order_obj->get_payment_by_txn_id($transaction_id);
    if( !$payment )
      {
	// so payment found, try to find one by it's id.
	if( $payment_id > 0 )
	  {
	    $payment = $order_obj->get_payment_by_id($payment_id);
	  }

	if( !$payment )
	  {
	    // still no payment found, this could mean that
	    // the gateway required credit card information but we're not storing it
	    // in which case we gotta create a new payment object.
	    $payment = new orders_payment();
	    $payment->set_payment_date(cge_utils::db_time(time()));
	    $payment->set_order_id($order_id);
	    $order_obj->add_payment($payment);
	  }
      }
    $payment->set_txn_id($transaction_id);
    $payment->set_method(orders_payment::TYPE_ONLINE);
    $payment->set_gateway($gateway);
    $payment->set_amount($amount);

    //
    // And give everything to smarty
    //
    global $gCms;
    $smarty =& $gCms->GetSmarty();
    $smarty->assign('transaction_id',$transaction_id);
    $smarty->assign('orders',$this);
    $smarty->assign('message',$message);
    $smarty->assign('gateway_status',$status);
    $smarty->assign('email_address',$email_addr);
2
    $returnstatus = null;

    // Update the payment.
    switch( $status )
      {
      case PAYMENT_STATUS_APPROVED:
	{
	  $payment->set_status(orders_payment::STATUS_APPROVED);
	  $smarty->assign('status','SUCCESS');
	  $smarty->assign('transaction_id',$transaction_id);
	  
	  $this->Audit('',$this->GetName(),$this->Lang('msg_payment_received',$transaction_id,$amount,$order_id));
	}
	break;

      case PAYMENT_STATUS_ERROR:
	{
	  // bad address or something
	  $payment->set_status(orders_payment::STATUS_ERROR);
	  if( !empty($message) ) 
	    {
	      $retstatus = $message;
	    }
	  else
	    {
	      $retstatus = $this->Lang('error_orderprocessing');
	    }

	  $this->Audit('',$this->GetName(),$this->Lang('msg_payment_error',$transaction_id,$order_id));
	}
	break;

      case PAYMENT_STATUS_OTHER:
	{
	  // bad address or something
	  $payment->set_status(orders_payment::STATUS_OTHER);
	  if( !empty($message) ) 
	    {
	      $retstatus = $message;
	    }
	  else
	    {
	      $retstatus = $this->Lang('error_orderprocessing');
	    }

	  $this->Audit('',$this->GetName(),$this->Lang('msg_payment_error',$transaction_id,$order_id));
	}
	break;

      case PAYMENT_STATUS_PENDING:
	{
	  // the gateway stuff worked, but we haven't had
	  // final approval for the purchase yet.
	  $cur_status = $payment->get_status();
	  if( $cur_status == orders_payment::STATUS_PAID )
	    {
	      $this->Audit('',$this->GetName(),$this->Lang('msg_payment_setbackwards',$order_id));
	    }
	  else
	    {
	      $smarty->assign('status','PENDING');
	      $payment->set_status(orders_payment::STATUS_PENDING);
	      $this->Audit('',$this->GetName(),$this->Lang('msg_payment_pending',$order_id));
	    }
	}
	break;

      case PAYMENT_STATUS_DECLINED:
	{
	  $payment->set_status(orders_payment::STATUS_DECLINED);
	  $this->Audit('',$this->GetName(),$this->Lang('msg_payment_declined',$transaction_id,$order_id));
	}
	break;

      case PAYMENT_STATUS_CANCELLED:
	{
	  $payment->set_status(orders_payment::STATUS_CANCELLED);
	  $this->Audit('',$this->GetName(),$this->Lang('msg_payment_cancelled',$transaction_id,$order_id));
	}
	break;

      default:
	$retstatus = $this->Lang('error_unknownstatus');
	break;
      }

    if( $retstatus != '' )
      {
	// oops, we have an error
	return $retstatus;
      }

    // figure out what the order status should be.
    // there prolly should be some preferences to help in decision making.
    $all_shipped = $order_obj->is_all_shipped();
    $part_shipped = $order_obj->is_partially_shipped();
    $none_shipped = (!$all_shipped && !$part_shipped)?TRUE:FALSE;
    $all_paid    = ($order_obj->get_amount_due() > 0.0)?FALSE:TRUE;
    $cur_status  = $order_obj->get_status();
    $has_services = $order_obj->has_services();
    $service_only = $order_obj->is_service_only();

    switch( $cur_status )
      {
	// finished checking out... we can adjust it
      case ORDERSTATUS_PROPOSED:
      case ORDERSTATUS_CONFIRMED:
      case ORDERSTATUS_PENDING:
	// user was invoiced... why are we even getting here?
      case ORDERSTATUS_INVOICED:
	// statuses set automagically.. we can adjust it.
      case ORDERSTATUS_PAID:
      case ORDERSTATUS_BALANCEDUE:
      case ORDERSTATUS_INCOMPLETE:
	$order_obj->set_status(ORDERSTATUS_CONFIRMED);
	if( $status == PAYMENT_STATUS_CANCELLED )
	  {
	    $order_obj->set_status(ORDERSTATUS_CANCELLED);
	  }
	else if( !$has_services )
	  {
	    // only products
	    if( $all_shipped && $all_paid )
	      {
		$order_obj->set_status(ORDERSTATUS_COMPLETE);
	      }
	    else if( $all_shipped && !$all_paid )
	      {
		$order_obj->set_status(ORDERSTATUS_BALANCEDUE);
	      }
	    else if( $part_shipped && $all_paid )
	      {
		$order_obj->set_status(ORDERSTATUS_INCOMPLETE);
	      }
	    else if( $all_paid )
	      {
		$order_obj->set_status(ORDERSTATUS_PAID);
	      }
	  }
	else
	  {
	    // have some services.
	    if( !$all_paid )
	      {
		$order_obj->set_status(ORDERSTATUS_BALANCEDUE);
	      }
	  }
	break;
	
	// completed already, shouldn't even get here.
      case ORDERSTATUS_COMPLETED:
	// admin set statuses... don't adjust.
      case ORDERSTATUS_CANCELLED:
      case ORDERSTATUS_HOLD:
      default:
	break;
      }

    // save the order
    $order_obj->save();

    // update smarty.
    $smarty->assign('order',$order_obj->to_array());
    $smarty->assign('order_obj',$order_obj);
    $smarty->assign('ordernumber',$order_obj->get_invoice());

    // do we need to send an email?
    // actually, we could use a different template for each status... but we won't for now.
    $sendemail = false;
    switch($order_obj->get_status())
      {
      case ORDERSTATUS_COMPLETED:
      case ORDERSTATUS_PAID:
      case ORDERSTATUS_INVOICED:
      case ORDERSTATUS_CONFIRMED:
	$sendemail = true;
	break;
      }

    // send it if we need to.
    if( $sendemail )
      {
	// Send an email to the administrator
	{
	  $subject = $this->ProcessTemplateFromData($this->GetPreference('adminemail_subject'));
	  $body = $this->ProcessTemplateFromData($this->GetPreference('adminemail_template'));
	  $cmsmailer =& $this->GetModuleInstance('CMSMailer');
	  $addresses = explode(',',$this->GetPreference('admin_email'));
	  foreach( $addresses as $addr )
	    {
	      $cmsmailer->AddAddress($addr);
	    }
	  $cmsmailer->SetSubject($subject);
	  $cmsmailer->SetBody($body);
	  $cmsmailer->IsHTML(true);
	  $cmsmailer->Send();
	  $cmsmailer->reset();
	}

	// Send an email to the user
	{
	  $subject = $this->ProcessTemplateFromData($this->GetPreference('useremail_subject'));
	  $body = $this->ProcessTemplateFromData($this->GetPreference('useremail_template'));
	  $cmsmailer =& $this->GetModuleInstance('CMSMailer');
	  $cmsmailer->AddAddress($email_addr);
	  $cmsmailer->SetSubject($subject);
	  $cmsmailer->SetBody($body);
	  $cmsmailer->IsHTML(true);
	  $cmsmailer->Send();
	  $cmsmailer->reset();
	}
      }

    // and we're done.
    return;
  }
*/


  static public function &GetOrder($order_id)
  {
    //require_once(dirname(__FILE__).'/lib/class.orders_ops.php');
    return orders_ops::load_by_id($order_id);
  }


  static public function get_portable_order($order_id)
  {
    $tmp = orders_ops::load_by_id($order_id);
    if( is_object($tmp) )
      {
	return $tmp->to_array();
      }
  }


//   public function IsValidUser()
//   {
//     $feu =& $this->GetModuleInstance('FrontEndUsers');
//     if( !$feu ) return FALSE;

//     $uid = $feu->LoggedInId();
//     if( $uid <= 0 ) return FALSE;

//     $grpid = $this->GetPreference('require_membership',-1);
//     if( $grpid <= 0 ) return $uid;

//     $data = $feu->GetMemberGroupsArray($uid);
//     $gids = cge_array::extract_field($data,'groupid');
//     if( !in_array( $grpid, $gids ) )
//       {
// 	return FALSE;
//       }
//     return $uid;
//   }


  protected function get_country_list()
  {
    $tmp = $this->GetPreference('valid_countries','');
    if( !$tmp )
      {
        return parent::get_country_list();
      }
    
    $tmp2 = explode("\n",$tmp);
    $tmp3 = array();
    foreach( $tmp2 as $one )
      {
        if( strstr($one,'=') === FALSE ) continue;
        $one = trim($one);
        list($code,$name) = explode('=',$one,2);
        $tmp3[] = array('name' => $name, 'code' => strtoupper($code));
      }
    return $tmp3;
  }


  protected function get_state_list()
  {
    $tmp = $this->GetPreference('valid_states','');
    if( !$tmp )
      {
        return parent::get_state_list();
      }
    
    $tmp2 = explode("\n",$tmp);
    $tmp3 = array();
    foreach( $tmp2 as $one )
      {
        if( strstr($one,'=') === FALSE ) continue;
        $one = trim($one);
        list($code,$name) = explode('=',$one,2);
        $tmp3[] = array('name' => $name, 'code' => strtoupper($code));
      }
    return $tmp3;
  }


  public function autoload($classname)
  {
    $ret = parent::autoload($classname);
    if( $ret ) return;

    $dirs = array();
    $dirs[] = $this->GetModulePath().'/lib/reports';
    
    foreach( $dirs as $onedir )
      {
	$fn = $onedir."/class.{$classname}.php";
	if( file_exists($fn) )
	  {
	    require_once($fn);
	    return TRUE;
	  }
      }

    return FALSE;
  }
} // class

#
# EOF
#
?>
