<?php
$lang['friendlyname'] = 'SEO Tools';
$lang['postinstall'] = 'SEO Tools have been installed. Be sure to read the module help to learn how to use them.';
$lang['postuninstall'] = 'SEO Tools have been uninstalled. Please be aware that you have just lost all meta information from your pages!';
$lang['really_uninstall'] = 'Do you really want to uninstall SEO Tools?';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['moddescription'] = 'Several tools to help with Search Engine Optimization and check for suboptimal SEO-related things.';

$lang['error'] = 'Error!';
$land['admin_title'] = 'SEO Tools Admin Panel';
$lang['admindescription'] = 'Test';
$lang['accessdenied'] = 'Access Denied. Please check your permissions.';
$lang['SEOAlerts'] = 'SEO Alerts';
$lang['Pagedescriptions'] = 'Page settings';
$lang['Sitemap'] = 'Sitemap';
$lang['SEOSettings'] = 'SEO Settings';
$lang['title_seoalerts'] = 'SEO Alerts';
$lang['title_pagedescriptions'] = 'Page settings';
$lang['title_sitemap'] = 'Sitemap';
$lang['title_seosettings'] = 'SEO Settings';

$lang['title_meta_type'] = 'Meta Tag Generator';
$lang['meta_create_standard'] = 'Generate standard Meta Tags';
$lang['meta_create_dublincore'] = 'Generate Dublin Core Meta Tags';
$lang['meta_create_opengraph'] = 'Generate OpenGraph Meta Tags (e.g. for Facebook Like Button)';

$lang['title_meta_defaults'] = 'META Tag Values';
$lang['meta_publisher'] = 'Site publisher';
$lang['meta_publisher_help'] = '(This is usually the organization you are building the website for)';
$lang['meta_contributor'] = 'Site contributor';
$lang['meta_contributor_help'] = '(Usually, this would be you or any other content author)';
$lang['meta_copyright'] = 'Site copyright';
$lang['meta_copyright_help'] = '(Something like "(C) Your Company. All Rights Reserved")';
$lang['meta_location_description'] = 'If your website is about an entitiy that can be located on a map, you should optionally fill in the following values:';
$lang['meta_location'] = 'Location of your entity';
$lang['meta_location_help'] = '(Usually, this would be the town name of your company)';
$lang['meta_region'] = 'Region of your entity';
$lang['meta_region_help'] = '(Enter something like "US-IL" for an entity located in Illinois, US)';
$lang['meta_latitude'] = 'Latitude of your entity';
$lang['meta_latitude_help'] = '(Enter the decimal latitude geo coodinate of your entitiy)';
$lang['meta_longitude'] = 'Longitude of your entity';
$lang['meta_longitude_help'] = '(Enter the decimal longitude geo coodinate of your entitiy)';
$lang['meta_opengraph_description'] = 'If you are creating OpenGraph META Tags, please fill in the following values:';
$lang['meta_opengraph_title'] = 'OpenGraph page title';
$lang['meta_opengraph_title_help'] = '(You can use the {title} tag here to replace with the actual page title)';
$lang['meta_opengraph_type'] = 'OpenGraph default page type';
$lang['meta_opengraph_type_help'] = '(The default page type for OpenGraph, can be overridden for each page. Look <a href="http://developers.facebook.com/docs/opengraph#types" taget="_blank">here</a> for a list of allowed values)';
$lang['meta_opengraph_sitename'] = 'OpenGraph site name';
$lang['meta_opengraph_sitename_help'] = '(A short version of your site name, e.g. "Your Company", max. 25 chars)';
$lang['meta_opengraph_image'] = 'OpenGraph default image';
$lang['meta_opengraph_image_help'] = '(Select an image from your /uploads/images directory to be used as the default for OpenGraph pages)';
$lang['meta_opengraph_admins'] = 'Facebook site administrators';
$lang['meta_opengraph_admins_help'] = '(A comma separated list of facebook account IDs who are able to administrate the streams of your pages)';
$lang['meta_opengraph_application'] = 'Facebook application';
$lang['meta_opengraph_application_help'] = '(The ID of a facebook application able to administrate the streams of your pages)';

$lang['title_title_description'] = 'Page title, description and keywords';
$lang['title_title'] = 'Page title';
$lang['title_title_help'] = '(The page title to be displayed in the browser\'s title bar. You can use the tags {title}, {pagetitle} and {seo_keywords} here)';
$lang['title_meta_title'] = 'Page Meta title';
$lang['title_meta_help'] = '(The page title to be used in the Meta title tags. You can use the tags {title}, {pagetitle} and {seo_keywords} here)';
$lang['description_block_title'] = 'Name of page description content block';
$lang['description_block_help'] = '(The name of your page description content block. Please see below for an explanation)';
$lang['default_keywords_title'] = 'Keywords to always include';
$lang['default_keywords_help'] = '(A space-separated list of keywords you would like to include on every page)';

$lang['title_sitemap_description'] = 'Google Sitemap and Crawler Settings';
$lang['create_sitemap_title'] = 'Create an XML Google Sitemap*';
$lang['push_sitemap_title'] = 'Automatically push the sitemap to Google after content changes';
$lang['create_robots_title'] = 'Create a robots.txt file*';
$lang['verification_title'] = 'Site verification code';
$lang['verification_help'] = '(The site verification code you obtain from Google Webmaster Tools, just the hash, not the complete meta tag)';

$lang['title_alerts_urgent'] = 'To be fixed immediately';
$lang['title_alerts_important'] = 'To be fixed as soon as possible';
$lang['title_alerts_notices'] = 'Things you should consider fixing';
$lang['nothing_to_be_fixed'] = 'There are no actions you need to take in this category';

$lang['save'] = 'Save settings';
$lang['none'] = '(none)';
$lang['settings_updated'] = 'The SEO settings were successfully updated.';
$lang['problem_alert'] = 'has detected severe problems with your SEO. %s';
$lang['problem_link_title'] = 'Click here to fix them';

$lang['help_description_content'] = '<b>How to use the "description content block":</b><br />To be able to enter a page description when editing a page, you must include the following code anywhere on every template:<br /><br /><pre>{capture}{content block="META Desciption" oneline="true"}{/capture}</pre><br />Then, put "META Description" into the field "Name of page description content block<br /><br />Alternatively, enable the option &quot;Automatically generate descriptions where none is given&quot;. This is not as good but still better than nothing.';
$lang['help_sitemap_robots'] = '*) To use the automatic generation of a sitemap- and robots-file, the root directory of your CMSMS installation must be writeable to the web server. If your already have a sitemap.xml and/pr robots.txt file, both of them must be writeable to the web server.';

$lang['use_standard_or_dublincore_meta'] = 'Use at least one of the standard or Dublin Core Meta Tag generators';
$lang['use_standard_meta'] = 'You should always enable the standard Meta generator';
$lang['meta_description_missing'] = 'The page <i>%s</i> is lacking a Meta description';
$lang['meta_description_short'] = 'The Meta description of <i>%s</i> is rather short ( < 75 chars)';
$lang['duplicate_titles'] = 'The pages <i>%s</i> and <i>%s</i> have the same title';
$lang['duplicate_descriptions'] = 'The pages <i>%s</i> and <i>%s</i> have the same Meta description';
$lang['provide_an_author'] = 'You should provide the name of the page publisher';
$lang['set_up_description_block'] = 'Set up a content block for Meta descriptions';
$lang['activate_pretty_urls'] = 'Activate the pretty URLs feature of CMSMS';
$lang['pretty_urls_help'] = '<a href="http://wiki.cmsmadesimple.org/index.php/User_Handbook/Installation/Optional_Settings" target="_blank">Get help</a>';
$lang['create_a_sitemap'] = 'Have a Google XML Sitemap automatically created for you';
$lang['automatically_upload_sitemap'] = 'Have your XML Sitemap automatically uploaded to Google';
$lang['create_robots'] = 'Have a robots.txt file automatically created for you';
$lang['sitemap_not_writeable'] = 'Your sitemap.xml file is not writeable';
$lang['chmod_sitemap'] = 'Set your /sitemap.xml file to be writeable by the web server';
$lang['robots_not_writeable'] = 'Your robots.txt file is not writeable';
$lang['no_opengraph_admins'] = 'You have not set an OpenGraph admin application resp. admin list';
$lang['no_opengraph_type'] = 'You have not set the default OpenGraph page type';
$lang['no_opengraph_sitename'] = 'You have not set the OpenGraph site name';
$lang['no_opengraph_image'] = 'You have not set an OpenGraph default image';
$lang['chmod_robots'] = 'Set your /robots.txt file to be writeable by the web server';
$lang['edit_page'] = 'Edit %s';
$lang['edit_page_to_fix'] = 'Click here to edit the page and fix the problem';
$lang['visit_settings'] = 'Change the settings of SEOTools to fix this problem';

$lang['page_id'] = 'ID';
$lang['page_name'] = 'Page name';
$lang['priority'] = 'Sitemap Priority';
$lang['og_type'] = 'OpenGraph type';
$lang['keywords'] = '# Keywords';
$lang['description'] = 'Description';
$lang['index'] = 'Indexable';

$lang['click_to_add_description'] = 'Click here to add a page description';
$lang['toggle'] = 'toggle';
$lang['reset'] = 'reset';
$lang['reset_to_default'] = 'Reset this to the default value';
$lang['edit_value'] = 'Edit this value';

$lang['help_opengraph'] = 'Look <a href="http://developers.facebook.com/docs/opengraph#types" taget="_blank">here</a> for a list of allowed values';
$lang['enter_new_ogtype'] = 'Enter the new value for this page\'s OpenGraph type';
$lang['help_new_ogtype'] = 'Leave blank to revert to the default setting';

$lang['enter_new_keywords'] = 'Enter the new keywords for this page';
$lang['help_new_keywords'] = 'Whitespace separated list of keywords. Leave blank to revert to auto generated keywords';

$lang['grouptitle_opengraph'] = 'We have detected %s OpenGraph related problem(s)';
$lang['grouptitle_system'] = 'We have detected %s problem(s) with your system configuration';
$lang['grouptitle_pages'] = 'We have detected %s problem(s) on your content pages';
$lang['grouptitle_settings'] = 'We have detected %s problem(s) with your SEO Settings';
$lang['grouptitle_descriptions'] = 'We have detected %s problem(s) with your page descriptions';
$lang['grouptitle_titles'] = 'We have detected %s problem(s) with your page titles';

$lang['view_all'] = 'View all';

$lang['title_metasettings'] = 'Page title & Meta information';
$lang['title_sitemapsettings'] = 'Sitemap & Crawler settings';
$lang['title_keywordsettings'] = 'Keyword generator settings';

$lang['description_auto_generate'] = 'Automatically generate a page description where none is provided';
$lang['description_auto_title'] = 'Text for auto-generated descriptions';
$lang['description_auto_help'] = '(You <b>must</b> include the tag {keywords} here)';

$lang['set_up_auto_description'] = 'Set up the description auto-generator and ensure the text contains the tag {keywords}';
$lang['auto_generated'] = 'Automatically generated';
$lang['and'] = 'and';

$lang['title_keyword_weight'] = 'Keyword weight settings';
$lang['keyword_minlength_title'] = 'Minimum keyword length';
$lang['keyword_minlength_help'] = '(The minimum length of a word to be considered as a keyword)';
$lang['keyword_title_weight_title'] = 'Weight of words in the page title';
$lang['keyword_title_weight_help'] = '(The weight of words in the page title. The higher a word\'s weight, the more likely it is to become a keyword)';
$lang['keyword_description_weight_title'] = 'Weight of words in the page description';
$lang['keyword_description_weight_help'] = '(The weight of words in the page description. The higher a word\'s weight, the more likely it is to become a keyword)';
$lang['keyword_headline_weight_title'] = 'Weight of words in content headlines';
$lang['keyword_headline_weight_help'] = '(The weight of words between &lt;h1&gt; to &lt;h6&gt; tags. The higher a word\'s weight, the more likely it is to become a keyword)';
$lang['keyword_content_weight_title'] = 'Weight of words in plain content';
$lang['keyword_content_weight_help'] = '(The weight of words inside the plain content. The higher a word\'s weight, the more likely it is to become a keyword)';

$lang['keyword_minimum_weight_title'] = 'Minimum total weight of a keyword';
$lang['keyword_minimum_weight_help'] = '(The minimum total weight of a word to become a keyword. Should be greater than the highest weight from above. The smaller the number, the more keywords you get)';

$lang['help_keyword_generator'] = 'The settings you change on this page will not affect any keywords you enter manually. Feel free to play with all values until you get the best results for your page.';

$lang['title_keyword_exclude'] = 'Keyword exclusion list';
$lang['keyword_exclude_title'] = 'Words to never consider as keywords';
$lang['keyword_exclude_help'] = '(Provide a space separated list of words that should never appear in keyword lists)';


$lang['changelog'] = '<ul>
<li>Version 1.0 - 24 August 2010. Initial Release.</li>
</ul>';

$lang['help'] = '<h3>What Does This Do?</h3>
<p>SEO Tools help you in getting your SEO (Search Engine Optimization) right. The module adds several SEO capabilities to your CMSMS installation and alerts you if you missed out on something SEO related. Currently, the following features are supported:</p>
<ul>
<li>- generates Meta tags in standard html, Dublin Core and OpenGraph formats</li>
<li>- automatically extracts keywords from your pages and adds them to the meta tags and page title</li>
<li>- lets you determine with a single click whether certain pages should be indexed by search engines or not</li>
<li>- generates a sitemap.xml file with your pages while giving you full control over the priorities of your pages</li>
<li>- generates a robots.txt file explicitly disallowing access to pages you don\'t want to be indexed</li>
<li>- alerts you when there are several pages featuring the same page titles and descriptions</li>
<li>- alerts you when very short page meta descriptions are detected</li>
<li>- automatically submits your sitemap file to Google when you change your content</li> 
</ul>
<h3>How Do I Use It</h3>
<p>First, open all templates where you want do use SEO Tools. Remove the complete &lt;title&gt; tag and the {metadata} tag (even if it says to never remove it) and replace them with the tag</p>
<pre>
{SEOTools}
</pre><br />
<p>Next, at the bottom of your template (after the closing &lt;/body&gt; tag), insert the following code:</p>
<pre>
{capture}{content block="Page Description" oneline="true"}{/capture}
</pre><br />
<p>This is where you\'ll enter a short page description (one or two sentences) that will appear in the search engine\'s results and if, for example, someone shares a link to your page on facebook.</p>
<p>Now, visit the settings tabs for page title & meta information, the sitemap & crawler settings and the keyword generator settings and fill in all required information for your page. Under "Name of page description content block" you need to enter the name of the content block you just added to your templates ("Page Description" in our example). The tab "SEO Alerts" will alert you if it detects anything that is required but not activated or filled in. You should also consider signing up your
site with Google Webmaster tools. There, select "Meta tag validation" and paste the verification code (quite a long string of characters and numbers) into the box "Verification Code" in "SEO Settings" to automatically verify that you are really
the owner of your page (no need to paste the Google Meta-code into your template).</p>
<p>As soon as everything is set up, look at the "SEO Alerts" tab and fix all problems detected here. Take care to insert a (unique) page description on every page you edit in the field "Page Description" at the bottom of your "Edit Page" form.</p>
<p>To set your own keywords (instead of the automatically generated ones) or OpenGraph type for certain pages, visit the "Page settings" tab where you\'ll find a list of all pages you have in your system. There, you can also change the sitemap priority (which is auto-calculated by default) of a page to indicate that it should
be considered more important for search engine matches on your page or exclude certain pages from the search index.</p>
<p>SEO Tools will also automatically insert a link to the image to be used as the main image of your page if you select an "Image" for the page from within your page\'s "Options" tab (this is important for people submitting a link to your page e.g. on facebook). Also, if you are using OpenGraph, the image selected here
will override the default OpenGraph image you specified from within "SEO Settings". Please be aware that you need to upload those images to your /uploads/images directory.</p> 
<h3>What Parameters Does It Take</h3>
<p>The module does not need any parameters</p>
<h3>Support</h3>
<p>As per the GPL, this software is provided as-is. Please read the text of the license for the full disclaimer.</p>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2010, Henning Schaefer <a href="mailto:henning.schaefer@gmail.com">&lt;henning.schaefer@gmail.com&gt;</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the module.</p>';
?>
