<?php
if (!isset($gCms)) exit;

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for SEOTools "default" action

   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

// Get page data
global $gCms;
$page_id = $gCms->variables['content_id'];
$hm =& $gCms->GetHierarchyManager();
$curnode =& $hm->getNodeById($page_id);
$curcontent =& $curnode->GetContent();
$page_url = $curcontent->GetURL();

$modified_date = $curcontent->mModifiedDate;
$modified_date = date('Y-m-d\TH:i:sP',strtotime($modified_date));

// Keyword generator

$keywords = explode(' ',$this->getPreference('default_keywords',''));

$db =& $gCms->db;
$query = 'SELECT * FROM '.cms_db_prefix().'module_seotools WHERE content_id = '.$page_id;
$result = $db->Execute($query);
$page_info = $result->fetchRow();

if ($page_info[keywords] != "") {
	$other_keywords = array_flip(explode(' ',$page_info[keywords]));
}else{
	$other_keywords = $this->getKeywordSuggestions($page_id);
}

$seo_keywords = implode(' ',array_merge($keywords, array_flip($other_keywords)));

// Page description

$description_id = str_replace(' ','_',$this->getPreference('description_block',''));
$description = strip_tags($curcontent->mProperties->mPropertyValues[$description_id]);

if (($description == "") && ($this->getPreference('description_auto_generate','false') == 'true')) {
  $kw = array_flip($other_keywords);
  $last_keyword = array_pop($kw);
  $keywords = implode(', ',$kw) . " " . $this->lang('and') . " " . $last_keyword;
  $description = str_replace('{keywords}',$keywords,$this->getPreference('description_auto',''));
  $description = str_replace('{title}',$curcontent->mName,$description);
}

// Show base?
if ($params[showbase] != 'false') {
	echo "<base href='http://".$_SERVER[HTTP_HOST]."/'></base>\n";
}

// Page title
$title = $this->getPreference('title','{title} | {sitename} - {seo_keywords}');
$title = str_replace('{title}',$curcontent->mName,$title);
$title = str_replace('{sitename}',$gCms->siteprefs[sitename],$title);
$title = str_replace('{seo_keywords}',$seo_keywords,$title);

$meta_title = $this->getPreference('meta_title','{title} | {sitename}');
$meta_title = str_replace('{title}',$curcontent->mName,$meta_title);
$meta_title = str_replace('{sitename}',$gCms->siteprefs[sitename],$meta_title);
$meta_title = str_replace('{seo_keywords}',$seo_keywords,$meta_title);

$opengraph_title = $this->getPreference('meta_opengraph_title','{title}');
$opengraph_title = str_replace('{title}',$curcontent->mName,$opengraph_title);

echo "<title>".$title."</title>\n";

// META tags for content type etc.
echo "<meta http-equiv='Content-Type' content='text/html; charset=".$gCms->config[default_encoding]."' />\n";
if (($page_info[indexable] == "") || ($page_info[indexable] == "1")) {
	echo "<meta name='robots' content='index' />\n";
}else{
	echo "<meta name='robots' content='noindex' />\n";
}

if ($this->getPreference('verification','') != '') {
	echo "<meta name='google-site-verification' content='".$this->getPreference('verification','')."' />\n";
}

// Standard META tags
if ($this->getPreference('meta_standard','true') == 'true') {
	echo "<meta name='description' content='$description' />\n";
    echo "<meta name='keywords' content='$seo_keywords' />\n";
    echo "<meta name='date' content='$modified_date' />\n";
    echo "<meta name='author' content='".$this->getPreference('meta_publisher','')."' />\n";
    if ($this->getPreference('meta_location','') != "") {
      echo "<meta name='geo.placename' content='".$this->getPreference('meta_location','')."' />\n";
    }
    if ($this->getPreference('meta_region','') != "") {
      echo "<meta name='geo.region' content='".$this->getPreference('meta_region','')."' />\n";
    }
    if (($this->getPreference('meta_latitude','') != "") && ($this->getPreference('meta_longitude','') != "")) {
      echo "<meta name='geo.position' content='".$this->getPreference('meta_latitude','').";".$this->getPreference('meta_longitude','')."' />\n";
      echo "<meta name='ICBM' content='".$this->getPreference('meta_latitude','').", ".$this->getPreference('meta_longitude','')."' />\n";
    }    
}

// DublinCore META tags
if ($this->getPreference('meta_dublincore','false') == 'true') {
    echo "<link rel='schema.DC' href='http://purl.org/dc/elements/1.1/' />\n";
    echo "<link rel='schema.DCTERMS' href='http://purl.org/dc/terms/' />\n";
    echo "<meta name='DC.type' content='Text' scheme='DCTERMS.DCMIType' />\n";
    echo "<meta name='DC.format' content='text/html' scheme='DCTERMS.IMT' />\n";
    echo "<meta name='DC.relation' content='http://dublincore.org/' scheme='DCTERMS.URI' />\n";
    echo "<meta name='DC.publisher' content='".$this->getPreference('meta_publisher','')."' />\n";
    echo "<meta name='DC.contributor' content='".$this->getPreference('meta_contributor','')."' />\n";    
    echo "<meta name='DC.language' content='".$gCms->siteprefs[frontendlang]."' scheme='DCTERMS.RFC3066' />\n";    
    echo "<meta name='DC.rights' content='".$this->getPreference('meta_copyright','')."' />\n";
    echo "<meta name='DC.title' content='$meta_title' />\n";
    echo "<meta name='DC.description' content='$description' />\n";
    echo "<meta name='DC.date' content='$modified_date' scheme='DCTERMS.W3CDTF' />\n";
    echo "<meta name='DC.identifier' content='$page_url' scheme='DCTERMS.URI' />\n";	
}

// OpenGraph META tags
if ($this->getPreference('meta_opengraph','false') == 'true') {
    echo "<meta property='og:title' content='$opengraph_title' />\n";
    if ($page_info[ogtype] == "") {
      echo "<meta property='og:type' content='".$this->getPreference('meta_opengraph_type','')."' />\n";
    }else{
      echo "<meta property='og:type' content='".$page_info[ogtype]."' />\n";
    }
    echo "<meta property='og:url' content='$page_url' />\n";
    
    if (($curcontent->mProperties->mPropertyValues['image'] != -1) && ($curcontent->mProperties->mPropertyValues['image'] != ""))  {
    	$image = $curcontent->mProperties->mPropertyValues['image'];
    }else{
    	$image = $this->getPreference('meta_opengraph_image','');
    }
    
    echo "<meta property='og:image' content='".$gCms->config[root_url]."/uploads/images/$image' />\n";
    echo "<meta property='og:site_name' content='".$this->getPreference('meta_opengraph_sitename',$gCms->siteprefs[sitename])."' />\n";    
    echo "<meta property='og:description' content='$description' />\n";
    if ($this->getPreference('meta_opengraph_application','') != "") {
      echo "<meta property='fb:admins' content='".$this->getPreference('meta_opengraph_application','')."' />\n";
    }else{
      echo "<meta property='fb:app_id' content='".$this->getPreference('meta_opengraph_admins','')."' />\n";
    }
    if ($this->getPreference('meta_location','') != "") {
      echo "<meta property='og:locality' content='".$this->getPreference('meta_location','')."' />\n";
    }
    if ($this->getPreference('meta_region','') != "") {
      echo "<meta property='og:region' content='".$this->getPreference('meta_region','')."' />\n";
    }
    if (($this->getPreference('meta_latitude','') != "") && ($this->getPreference('meta_longitude','') != "")) {
      echo "<meta property='og:latitude' content='".$this->getPreference('meta_latitude','')."' />\n";
      echo "<meta property='og:longitude' content='".$this->getPreference('meta_longitude','')."' />\n";
    }           
}

// Image-Link

if (($curcontent->mProperties->mPropertyValues['image'] != -1) && ($curcontent->mProperties->mPropertyValues['image'] != ""))  {
	echo "<link rel='image_src' href='".$gCms->config[root_url]."/uploads/images/".$curcontent->mProperties->mPropertyValues['image']."' />";
}

?>