<?php
#-------------------------------------------------------------------------
# Module: SEOTools - Several tools to help with Search Engine Optimization and check for suboptimal SEO-related things.
# Version: 0.9, Henning Schaefer
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
# This file originally created by ModuleMaker module, version 0.3.2
# Copyright (c) 2010 by Samuel Goldstein (sjg@cmsmadesimple.org) 
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
# For Help building modules:
# - Read the Documentation as it becomes available at
#   http://dev.cmsmadesimple.org/
# - Check out the Skeleton Module for a commented example
# - Look at other modules, and learn from the source
# - Check out the forums at http://forums.cmsmadesimple.org
# - Chat with developers on the #cms IRC channel
#-------------------------------------------------------------------------
class SEOTools extends CMSModule
{
	
	function GetName()
	{
		return 'SEOTools';
	}

	/*---------------------------------------------------------
	   GetFriendlyName()
	   This can return any string, preferably a localized name
	   of the module. This is the name that's shown in the
	   Admin Menus and section pages (if the module has an admin
	   component).
	   
	   See the note on localization at the top of this file.
	  ---------------------------------------------------------*/
	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}

	
	/*---------------------------------------------------------
	   GetVersion()
	   This can return any string, preferably a number or
	   something that makes sense for designating a version.
	   The CMS will use this to identify whether or not
	   the installed version of the module is current, and
	   the module will use it to figure out how to upgrade
	   itself if requested.	   
	  ---------------------------------------------------------*/
	function GetVersion()
	{
		return '1.0';
	}

	/*---------------------------------------------------------
	   GetHelp()
	   This returns HTML information on the module.
	   Typically, you'll want to include information on how to
	   use the module.
	   
	   See the note on localization at the top of this file.
	  ---------------------------------------------------------*/
	function GetHelp()
	{
		return $this->Lang('help');
	}

	/*---------------------------------------------------------
	   GetAuthor()
	   This returns a string that is presented in the Module
	   Admin if you click on the "About" link.
	  ---------------------------------------------------------*/
	function GetAuthor()
	{
		return 'Henning Schaefer';
	}

	/*---------------------------------------------------------
	   GetAuthorEmail()
	   This returns a string that is presented in the Module
	   Admin if you click on the "About" link. It helps users
	   of your module get in touch with you to send bug reports,
	   questions, cases of beer, and/or large sums of money.
	  ---------------------------------------------------------*/
	function GetAuthorEmail()
	{
		return 'henning.schaefer@gmail.com';
	}

	/*---------------------------------------------------------
	   GetChangeLog()
	   This returns a string that is presented in the module
	   Admin if you click on the About link. It helps users
	   figure out what's changed between releases.
	   See the note on localization at the top of this file.
	  ---------------------------------------------------------*/
	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}

	/*---------------------------------------------------------
	   IsPluginModule()
	   This function returns true or false, depending upon
	   whether users can include the module in a page or
	   template using a smarty tag of the form
	   {cms_module module='SEOTools' param1=val param2=val...}
	   
	   If your module does not get included in pages or
	   templates, return "false" here.
	  ---------------------------------------------------------*/
	function IsPluginModule()
	{
		return true;
	}

	/*---------------------------------------------------------
	   HasAdmin()
	   This function returns a boolean value, depending on
	   whether your module adds anything to the Admin area of
	   the site. For the rest of these comments, I'll be calling
	   the admin part of your module the "Admin Panel" for
	   want of a better term.
	  ---------------------------------------------------------*/
	function HasAdmin()
	{
		return true;
	}


	/*---------------------------------------------------------
	   GetAdminSection()
	   If your module has an Admin Panel, you can specify
	   which Admin Section (or top-level Admin Menu) it shows
	   up in. This method returns a string to specify that
	   section. Valid return values are:

	   main        - the Main menu tab.
	   content     - the Content menu
	   layout      - the Layout menu
	   usersgroups - the Users and Groups menu
	   extensions  - the Extensions menu (this is the default)
	   siteadmin   - the Site Admin menu
	   viewsite    - the View Site menu tab
	   logout      - the Logout menu tab
	   
	   Note that if you place your module in the main,
	   viewsite, or logout sections, it will show up in the
	   menus, but will not be visible in any top-level
	   section pages.
	  ---------------------------------------------------------*/
	function GetAdminSection()
	{
		return 'content';
	}


	/*---------------------------------------------------------
	   GetAdminDescription()
	   If your module does have an Admin Panel, you
	   can have it return a description string that gets shown
	   in the Admin Section page that contains the module.
	  ---------------------------------------------------------*/
	function GetAdminDescription()
	{
		return $this->Lang('admindescription');
	}


	/*---------------------------------------------------------
	   VisibleToAdminUser()
	   If your module does have an Admin Panel, you
	   can control whether or not it's displayed by the boolean
	   that is returned by this method. This is primarily used
	   to hide modules from admins who lack permission to use
	   them.
	   
	   Typically, you'll use some permission to set this
	   (e.g., $this->CheckPermission('Some Permission'); )
	  ---------------------------------------------------------*/
	function VisibleToAdminUser()
	{
        return true;
	}
	

	/*---------------------------------------------------------
	   CheckAccess()
	   This wrapper function will check against the specified permission,
	   and display an error page if the user doesn't have adequate permissions.
	  ---------------------------------------------------------*/
	function CheckAccess($perm = 'Edit SEO Settings')
		{
		return $this->CheckPermission($perm);
		}
	
	/*---------------------------------------------------------
	   DisplayErrorPage()
	   This is a simple function for generating error pages.
	  ---------------------------------------------------------*/
    function DisplayErrorPage($id, &$params, $return_id, $message='')
    {
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);

        // Display the populated template
        echo $this->ProcessTemplate('error.tpl');
    }
	


	/*---------------------------------------------------------
	   GetDependencies()
	   Your module may need another module to already be installed
	   before you can install it.
	   This method returns a list of those dependencies and
	   minimum version numbers that this module requires.
	   
	   It should return an hash, eg.
	   return array('somemodule'=>'1.0', 'othermodule'=>'1.1');
	  ---------------------------------------------------------*/
	function GetDependencies()
	{
		return array();
	}

	/*---------------------------------------------------------
	   MinimumCMSVersion()
	   Your module may require functions or objects from
	   a specific version of CMS Made Simple.
	   Ever since version 0.11, you can specify which minimum
	   CMS MS version is required for your module, which will
	   prevent it from being installed by a version of CMS that
	   can't run it.
	   
	   This method returns a string representing the
	   minimum version that this module requires.
	   ---------------------------------------------------------*/
	function MinimumCMSVersion()
	{
		return "1.6.0";
	}


	/*---------------------------------------------------------
	   MaximumCMSVersion()
	   You may want to prevent people from using your module in
	   future versions of CMS Made Simple, especially if you
	   think API features you use may change -- after all, you
	   never really know how the CMS MS API could evolve.
	   
	   So, to prevent people from flooding you with bug reports
	   when a new version of CMS MS is released, you can simply
	   restrict the version. Then, of course, the onus is on you
	   to release a new version of your module when a new version
	   of the CMS is released...
	   
	   This method returns a string representing the
	   maximum version that this module supports.
	   ---------------------------------------------------------*/
	function MaximumCMSVersion()
	{
		return "1.9.9";
	}


	/*---------------------------------------------------------
	   InstallPostMessage()
	   After installation, there may be things you want to
	   communicate to your admin. This function returns a
	   string which will be displayed.
	  ---------------------------------------------------------*/
	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	/*---------------------------------------------------------
	   UninstallPostMessage()
	   After removing a module, there may be things you want to
	   communicate to your admin. This function returns a
	   string which will be displayed.
	  ---------------------------------------------------------*/
	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}


	/**
	 * UninstallPreMessage()
	 * This allows you to display a message along with a Yes/No dialog box. If the user responds
	 * in the affirmative to your message, the uninstall will proceed. If they respond in the
	 * negative, the uninstall will be canceled. Thus, your message should be of the form
	 * "All module data will be deleted. Are you sure you want to uninstall this module?"
	 *
	 * If you don't want the dialog, have this method return a FALSE, which will cause the
	 * module to uninstall immediately if the user clicks the "uninstall" link.
	 */
	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}
	
	function GetNotificationOutput() {
		if (count($this->getUrgentAlerts()) > 0) {
		  $text = $this->lang('problem_alert',Array($this->createLink($this->id, 'defaultadmin', '', $this->lang('problem_link_title'))));
		  return (object) Array('priority'=>2, 'html'=>$text);
		}
	}
	
	
	function SetParameters() {
		$this->RegisterModulePlugin();
		$this->addEventHandler('Core','ContentEditPost',false);
		$this->addEventHandler('Core','ContentDeletePost',false);		
	}
	
	function DoEvent($origin, $name, $params) {
	  if ($this->getPreference('create_sitemap','true') == 'true') {
        $this->createSitemap($this->getPreference('push_sitemap','true') == true);
      }
	}
	
	function getUrgentAlerts() {
		global $gCms;
		$alerts = Array();
		// Enable Pretty URLs
        if (($gCms->config[assume_mod_rewrite] != 1) && ($gCms->config[internal_pretty_urls] != 1)) {
          $alert = Array();
          $alert[group] = 'system';
          $alert[message] = $this->lang('activate_pretty_urls');
          $alert[links][] = $this->lang('pretty_urls_help');
          $alerts[] = $alert;
        }       
		// No Meta tags are inserted
		if (($this->getPreference('meta_standard','false') != 'true') && ($this->getPreference('meta_dublincore','false') != 'true')) {			
			$alert = Array();
			$alert[group] = 'settings';
			$alert[message] = $this->lang('use_standard_or_dublincore_meta');
			$alert[links][] = $this->lang('visit_settings');
			$alerts[] = $alert;
		}
		$db =& $gCms->db;						
		if ($this->getPreference('description_auto_generate','false') != 'true') {
			if ($this->getPreference('description_block','') != '') {
			  // Pages without description
			  $query = 'SELECT *,c.content_id AS cid FROM '.cms_db_prefix().'content c LEFT JOIN '.cms_db_prefix().'content_props p ON (c.content_id = p.content_id AND p.prop_name = "'.str_replace(' ','_',$this->getPreference('description_block','')).'") WHERE (p.content IS NULL OR p.content = "") AND c.type = "content" LIMIT 0,21';		
			  $result =& $db->Execute($query);				
			  while ($problem = $result->fetchRow()) {			
				$alert = Array();
				$alert[group] = 'pages';
				$alert[message] = $this->lang('meta_description_missing',Array($problem[content_name]));
				$alert[links][] = '<a href="/admin/editcontent.php?sp_='.$_GET[sp_].'&content_id='.$problem[cid].'">'.$this->lang('edit_page_to_fix').'</a>';
				$alerts[] = $alert;
			  }
			}else{
			  $alert = Array();
			  $alert[group] = 'settings';
	          $alert[message] = $this->lang('set_up_description_block');
	          $alert[links][] = $this->lang('visit_settings');
	          $alerts[] = $alert;	
			}		
		}elseif(strpos($this->getPreference('description_auto',''),'{keywords}') === false) {
			$alert = Array();
			$alert[group] = 'settings';
	        $alert[message] = $this->lang('set_up_auto_description');
	        $alert[links][] = $this->lang('visit_settings');
	        $alerts[] = $alert;
		}
		
        // sitemap.xml not writeable
        if ($this->getPreference('create_sitemap','true') == 'true') {
		  if (!is_writeable($gCms->config[root_path] . '/sitemap.xml')) {
		  	$alert = Array();
		  	$alert[group] = 'system';
            $alert[message] = $this->lang('sitemap_not_writeable');
            $alert[links][] = $this->lang('chmod_sitemap');
            $alerts[] = $alert;
		  }			
		}
		
        // robots.txt not writeable
	   if ($this->getPreference('create_robots','true') == 'true') {
          if (!is_writeable($gCms->config[root_path] . '/robots.txt')) {
            $alert = Array();
            $alert[group] = 'system';
            $alert[message] = $this->lang('robots_not_writeable');
            $alert[links][] = $this->lang('chmod_robots');
            $alerts[] = $alert;
          }         
        }
				
       if ($this->getPreference('meta_opengraph','false') == 'true') {
        // No OpenGraph admin set
        if (($this->getPreference('meta_opengraph_admins','') == '') && ($this->getPreference('meta_opengraph_application','') == '')) {
        	$alert = Array();
        	$alert[group] = 'opengraph';
            $alert[message] = $this->lang('no_opengraph_admins');
            $alert[links][] = $this->lang('visit_settings');
            $alerts[] = $alert;
        }
        // No OpenGraph page type set
        if ($this->getPreference('meta_opengraph_type','') == '') {
            $alert = Array();
            $alert[group] = 'opengraph';
            $alert[message] = $this->lang('no_opengraph_type');
            $alert[links][] = $this->lang('visit_settings');
            $alerts[] = $alert;
        }
        // No OpenGraph sitename set
        if ($this->getPreference('meta_opengraph_sitename','') == '') {
            $alert = Array();
            $alert[group] = 'opengraph';
            $alert[message] = $this->lang('no_opengraph_sitename');
            $alert[links][] = $this->lang('visit_settings');
            $alerts[] = $alert;
        }
        // No OpenGraph image set
        if ($this->getPreference('meta_opengraph_image','') == '') {        	
            $alert = Array();
            $alert[group] = 'opengraph';
            $alert[message] = $this->lang('no_opengraph_image');
            $alert[links][] = $this->lang('visit_settings');
            $alerts[] = $alert;
        }
       }
		
		return $alerts;
	}
	
	function getImportantAlerts() {
		global $gCms;
        $alerts = Array();        
        $db =& $gCms->db;
        // Pages with short description
        $query = 'SELECT *,c.content_id AS cid FROM '.cms_db_prefix().'content c INNER JOIN '.cms_db_prefix().'content_props p ON (c.content_id = p.content_id AND p.prop_name = "'.str_replace(' ','_',$this->getPreference('description_block','')).'") WHERE CHAR_LENGTH(p.content) < 75 AND c.type = "content" AND p.content <> "" LIMIT 0,21';        
        $result =& $db->Execute($query);                       
        while ($problem = $result->fetchRow()) {            
            $alert = Array();
            $alert[group] = 'descriptions';
            $alert[message] = $this->lang('meta_description_short',Array($problem[content_name]));
            $alert[links][] = '<a href="/admin/editcontent.php?sp_='.$_GET[sp_].'&content_id='.$problem[cid].'">'.$this->lang('edit_page_to_fix').'</a>';
            $alerts[] = $alert;
        }

        // Pages with duplicate title
        $query = 'SELECT c1.content_alias AS c1name, c1.content_id AS c1id, c2.content_alias AS c2name, c2.content_id AS c2id FROM '.cms_db_prefix().'content c1 INNER JOIN '.cms_db_prefix().'content c2 ON (c1.content_name = c2.content_name AND c1.content_id < c2.content_id) WHERE c1.type = "content" AND c2.type = "content" LIMIT 0,21';
	    $result =& $db->Execute($query);                       
        while ($problem = $result->fetchRow()) {            
            $alert = Array();
            $alert[group] = 'titles';
            $alert[message] = $this->lang('duplicate_titles',Array($problem[c1name],$problem[c2name]));
            $alert[links][] = '<a href="/admin/editcontent.php?sp_='.$_GET[sp_].'&content_id='.$problem[c1id].'">'.$this->lang('edit_page',Array($problem[c1name])).'</a>';
            $alert[links][] = '<a href="/admin/editcontent.php?sp_='.$_GET[sp_].'&content_id='.$problem[c2id].'">'.$this->lang('edit_page',Array($problem[c2name])).'</a>';
            $alerts[] = $alert;
        }
        
        // Pages with duplicate description
	    $query = 'SELECT p1.content_id AS c1id, p2.content_id AS c2id FROM '.cms_db_prefix().'content_props p1 INNER JOIN '.cms_db_prefix().'content_props p2 ON (p1.prop_name = p2.prop_name AND p1.prop_name = "'.str_replace(' ','_',$this->getPreference('description_block','')).'" AND p1.content_id < p2.content_id AND p1.content <> "" AND p2.content <> "") WHERE p1.content = p2.content LIMIT 0,21';
        $result =& $db->Execute($query);                       
        while ($problem = $result->fetchRow()) {
        	$query = 'SELECT content_id, content_name FROM '.cms_db_prefix().'content WHERE content_id = '.$problem[c1id].' OR content_id = '.$problem[c2id];
        	$result1 =& $db->Execute($query);
        	$first = $result1->fetchRow();
        	$second = $result1->fetchRow();            
            $alert = Array();
            $alert[group] = 'descriptions';
            $alert[message] = $this->lang('duplicate_descriptions',Array($first[content_name],$second[content_name]));
            $alert[links][] = '<a href="/admin/editcontent.php?sp_='.$_GET[sp_].'&content_id='.$first[content_id].'">'.$this->lang('edit_page',Array($first[content_name])).'</a>';
            $alert[links][] = '<a href="/admin/editcontent.php?sp_='.$_GET[sp_].'&content_id='.$second[content_id].'">'.$this->lang('edit_page',Array($second[content_name])).'</a>';
            $alerts[] = $alert;
        }
        // No author provided
        if ($this->getPreference('meta_publisher','') == '') {
        	$alert = Array();
        	$alert[group] = 'settings';
            $alert[message] = $this->lang('provide_an_author');
            $alert[links][] = $this->lang('visit_settings');
            $alerts[] = $alert;
        }
        return $alerts;		
	}
	
	function getNoticeAlerts() {
		$alerts = Array();
		// No standard meta
        if ($this->getPreference('meta_standard','false') != 'true') {
        	$alert = Array();
        	$alert[message] = $this->lang('use_standard_meta');
        	$alert[links][] = $this->lang('visit_settings');        	
            $alerts[] = $alert;
        }
        // Submit a sitemap
        if ($this->getPreference('create_sitemap','true') != 'true') {
        	$alert = Array();
            $alert[message] = $this->lang('create_a_sitemap');
            $alert[links][] = $this->lang('visit_settings');
            $alerts[] = $alert;
        }elseif($this->getPreference('push_sitemap','true') != 'true') {
          // Automatically submit the sitemap
            $alert = Array();
            $alert[message] = $this->lang('automatically_upload_sitemap');
            $alert[links][] = $this->lang('visit_settings');
            $alerts[] = $alert;	
        }        
        // Create a robots.txt file
        if ($this->getPreference('create_robots','true') != 'true') {
            $alert = Array();
            $alert[message] = $this->lang('create_robots');
            $alert[links][] = $this->lang('visit_settings');
            $alerts[] = $alert;
        }
        // Set a default image
        return $alerts;
	}
	
function get_keywords($source, $minlength = 6) {
    $source = preg_replace('/\{[^\}]+\}/isU', '', utf8_decode($source));
    $source = str_replace("\n"," ",strip_tags($source));
    $source = str_replace('-',' ',$source);
    $source = str_replace('.',' ',$source);
    $source = str_replace(',',' ',$source);
    $source = str_replace('!',' ',$source);
    $source = str_replace('?',' ',$source);
    $source = str_replace(':',' ',$source);
    $source = str_replace('  ',' ',$source);
    $keywords = explode(' ',$source);
    foreach ($keywords as $key=>$value) {
        if (strlen($value) < $minlength) {
            unset($keywords[$key]);
        }else{
        	$keywords[$key] = trim($value);
        }
    }
    return $keywords;    
}

function get_headlines($file){
      $h1tags = preg_match_all("/(<h1.*>)(\w.*)(<\/h1>)/isxmU",$file,$patterns);           
      $content = "";
      foreach($patterns[2] as $tag) {
      	$content .= " ".$tag;
      }
      $h2tags = preg_match_all("/(<h2.*>)(\w.*)(<\/h2>)/isxmU",$file,$patterns);           
      foreach($patterns[2] as $tag) {
      	$content .= " ".$tag;
      }
      $h3tags = preg_match_all("/(<h3.*>)(\w.*)(<\/h3>)/isxmU",$file,$patterns);           
      foreach($patterns[2] as $tag) {
      	$content .= " ".$tag;
      }
      $h4tags = preg_match_all("/(<h4.*>)(\w.*)(<\/h4>)/isxmU",$file,$patterns);           
      foreach($patterns[2] as $tag) {
      	$content .= " ".$tag;
      }
      $h5tags = preg_match_all("/(<h5.*>)(\w.*)(<\/h5>)/isxmU",$file,$patterns);           
      foreach($patterns[2] as $tag) {
      	$content .= " ".$tag;
      }
      $h6tags = preg_match_all("/(<h6.*>)(\w.*)(<\/h6>)/isxmU",$file,$patterns);           
      foreach($patterns[2] as $tag) {
      	$content .= " ".$tag;
      }
      return $content;           
    }

function getKeywordSuggestions($content_id) {
	global $gCms;
	$hm = $gCms->GetHierarchyManager();
    $curnode =& $hm->getNodeById($content_id);
    $curcontent =& $curnode->GetContent();
    $description_id = str_replace(' ','_',$this->getPreference('description_block',''));	    
    
    $db =&$gCms->db;
    $query = "SELECT * FROM ".cms_db_prefix()."content_props WHERE content_id = $content_id AND prop_name = 'content_en'";
    $result = $db->Execute($query);
    $content = $result->fetchRow();
    
    $query = "SELECT * FROM ".cms_db_prefix()."content_props WHERE content_id = $content_id AND prop_name = '$description_id'";
    $result = $db->Execute($query);
    $description = $result->fetchRow();
    
	/* Generate keywords from page title, description and content */
	$title_keywords = $this->get_keywords($curcontent->mName, $this->getPreference('keyword_minlength','6'));
	$description_keywords = $this->get_keywords($description['content'], $this->getPreference('keyword_minlength','6'));			
    $headline_keywords = $this->get_keywords($this->get_headlines($content['content']), $this->getPreference('keyword_minlength','6'));    
	$content_keywords = $this->get_keywords($content['content'], $this->getPreference('keyword_minlength','6'));
	
	$other_keywords = Array();
	
	foreach($title_keywords as $keyword) {
	    $other_keywords[$keyword] = $this->getPreference('keyword_title_weight','6');
	}
	foreach($description_keywords as $keyword) {
	    $other_keywords[$keyword] += $this->getPreference('keyword_description_weight','4');
	}
	foreach($headline_keywords as $keyword) {
	    $other_keywords[$keyword] += $this->getPreference('keyword_headline_weight','2');
	}	
	foreach($content_keywords as $keyword) {
	    $other_keywords[$keyword] += $this->getPreference('keyword_content_weight','1');
	}
	
	arsort($other_keywords);
	
	$exclude_list = explode(' ',strtoupper(utf8_decode($this->getPreference('keyword_exclude',''))));		
	
	foreach ($other_keywords as $key=>$value) {
	    if ($value < $this->getPreference('keyword_minimum_weight','7')) {
	        unset($other_keywords[$key]);
	    }
	    if (in_array(strtoupper($key),$exclude_list)) {
	    	unset($other_keywords[$key]);
	    }
	}
	return $other_keywords;	
}

function createRobotsTXT() {	
	global $gCms;		
	$fp = @fopen($gCms->config[root_path].'/robots.txt','w');
	// Create robots.txt
	if ($this->getPreference('create_sitemap','true') == 'true') {
		@fwrite($fp, "Sitemap: ".$gCms->config[root_url]."/sitemap.xml\n\n");
	}
	@fwrite($fp, "User-agent: *\n"); 
    @fwrite($fp, "Disallow: /admin/\n");
	@fwrite($fp, "Disallow: /contrib/\n"); 
	@fwrite($fp, "Disallow: /doc/\n");
	@fwrite($fp, "Disallow: /lib/\n");
	@fwrite($fp, "Disallow: /modules/\n"); 
	@fwrite($fp, "Disallow: /plugins/\n");
	@fwrite($fp, "Disallow: /scripts/\n");
	@fwrite($fp, "Disallow: /tmp/\n");
	
	$hm =& $gCms->getHierarchyManager();
	$db =& $gCms->db;
	$query = "SELECT * FROM ".cms_db_prefix()."module_seotools WHERE indexable = 0";
	$result = $db->Execute($query);
	while ($page = $result->fetchRow()) {
		$curnode =& $hm->getNodeById($page[content_id]);
        $curcontent =& $curnode->GetContent();
        $url = $curcontent->GetURL();
        @fwrite($fp, "Disallow: ".str_replace($gCms->config[root_url], '', $url)."\n");		
	}
	
	@fclose($fp);
}

function createSitemap($push = false) {
	global $gCms;
    $fp = @fopen($gCms->config[root_path].'/sitemap.xml','w');
        // Create sitemap

    fwrite($fp, "<?xml version='1.0' encoding='UTF-8'?>\n");
    fwrite($fp, "<urlset xmlns='http://www.sitemaps.org/schemas/sitemap/0.9'>\n\n");
    
    $db = $gCms->db;
    $hm =& $gCms->getHierarchyManager();
    
    $query = 'SELECT * FROM '.cms_db_prefix().'content WHERE active = 1 ORDER BY hierarchy ASC';
    $result =& $db->Execute($query);
    
    while ($page = $result->fetchRow()) {    	          	
      $curnode =& $hm->getNodeById($page[content_id]);
      if (!is_object($curnode)) {
      	continue;
      }
      $curcontent =& $curnode->GetContent();
      $url = $curcontent->GetURL();      
      
      $priority = 80;
      for ($i = 0; $i < substr_count($page[hierarchy],'.'); $i++) {      
        $priority  = $priority / 2;
      }
      if ($page[default_content] == 1) {
        $priority = 100;
      }
      
      $query = 'SELECT * FROM '.cms_db_prefix().'module_seotools WHERE content_id = '.$page[content_id];
      $result2 =& $db->Execute($query);
      $info = $result2->fetchRow();
      if (($info[priority] != 0) && ($info[priority] != "")) {
      	$priority = $info[priority];
      }
      if (($info[indexable] == "") || ($info[indexable] == 1)) {      
        fwrite($fp, "<url>\n");
        fwrite($fp, "<loc>".$url."</loc>\n");
        fwrite($fp, "<lastmod>".date("Y-m-d", strtotime($page[modified_date]))."</lastmod>\n");
        fwrite($fp, "<changefreq>always</changefreq>\n");
        fwrite($fp, "<priority>".number_format($priority / 100, 1)."</priority>\n");
        fwrite($fp, "</url>\n\n");
      }
    }
    fwrite($fp, "</urlset>");            
    fclose($fp);
    if ($push) {
    	// Push sitemap to google
    	$fp = fopen("http://www.google.com/webmasters/tools/ping?sitemap=".urlencode($gCms->config[root_url]."/sitemap.xml"),"r");
        fclose($fp);
    }
}

}

?>
