<?php

$sent_stats_query = 'select j.jobid as job_id, m.messageid as message_id, m.subject, j.started as date_started, j.finished as date_ended from '.cms_db_prefix().'module_nms_jobs j inner join '.cms_db_prefix().'module_nms_job_parts jp ON jp.jobid = j.jobid inner join '.cms_db_prefix().'module_nms_messages m ON m.messageid = jp.messageid order by j.jobid asc';
$messages = $db->GetAll($sent_stats_query);

for ($i = 0; $i < count($messages); $i++)
{
	$messages[$i]['unique_views'] = '-';
	$messages[$i]['total_views'] = '-';
	$messages[$i]['total_clicks'] = '-';
}

$view_stats_query = 'select job_id, message_id, count(distinct user_id) as unique_views, count(*) as total_views from '.cms_db_prefix().'module_nmstrack_views group by job_id';
$dbresult = $db->Execute($view_stats_query);
while ($dbresult && $row = $dbresult->FetchRow())
{
	for ($i = 0; $i < count($messages); $i++)
	{
		if ($messages[$i]['job_id'] == $row['job_id'])
		{
			$messages[$i]['unique_views'] = $row['unique_views'];
			$messages[$i]['total_views'] = $row['total_views'];
			break;
		}
	}
}

$click_stats_query = 'select job_id, message_id, count(*) as total_clicks from '.cms_db_prefix().'module_nmstrack_clicks group by job_id';
$dbresult = $db->Execute($click_stats_query);
while ($dbresult && $row = $dbresult->FetchRow())
{
	for ($i = 0; $i < count($messages); $i++)
	{
		if ($messages[$i]['job_id'] == $row['job_id'])
		{
			$messages[$i]['total_clicks'] = $row['total_clicks'];
			break;
		}
	}
}

for ($i = 0; $i < count($messages); $i++)
{
	$messages[$i]['view_link'] = '';
	$messages[$i]['click_link'] = '';
	$messages[$i]['click_by_users_link'] = '';
	$messages[$i]['total_user_count'] = $db->GetOne("select count(distinct userid) from ".cms_db_prefix()."module_nms_listuser lu inner join ".cms_db_prefix()."module_nms_job_parts jp ON jp.listid = lu.listid where jp.jobid = ?", array($messages[$i]['job_id']));
	if ($messages[$i]['total_views'] != '-')
	{
		$messages[$i]['view_link'] = $this->CreateLink($id, 'view_stats', $returnid, $this->Lang('view_stats'), array('job_id' => $messages[$i]['job_id']));
		$messages[$i]['click_link'] = $this->CreateLink($id, 'click_stats', $returnid, $this->Lang('click_stats'), array('job_id' => $messages[$i]['job_id']));
		$messages[$i]['click_by_users_link'] = $this->CreateLink($id, 'user_click_stats', $returnid, $this->Lang('click_by_users_stats'), array('job_id' => $messages[$i]['job_id']));
	}
}

$smarty->assign('messages', $messages);

echo $this->ProcessTemplate('admin_statistics_tab.tpl');

?>