<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Newsletter Made Simple (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide a flexible
#  mailing list solution.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

$cgextensions = cms_join_path($gCms->config['root_path'],'modules',
	'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
	echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
	return;
}
require_once($cgextensions);

class NMSTrack extends CGExtensions
{

	/*---------------------------------------------------------
	Module Constructor
	---------------------------------------------------------*/
	function __construct()
	{
		parent::__construct();
	}


	/*---------------------------------------------------------
	Return the module name
	---------------------------------------------------------*/
	function GetName()
	{
		return 'NMSTrack';
	}


	/*---------------------------------------------------------
	Return an array of the module dependencies.
	---------------------------------------------------------*/
	function GetDependencies()
	{
		return array( 'NMS' => '2.2.3',
			'CGExtensions' => '1.15');
	}


	/*---------------------------------------------------------
	GetEventDescription( $name )
	---------------------------------------------------------*/
	function GetEventDescription( $name )
	{
		return $this->Lang('info_event_'.$name );
	}


	/*---------------------------------------------------------
	GetEventHelp( $eventname )
	---------------------------------------------------------*/
	function GetEventHelp ( $eventname )
	{
		return $this->Lang ('help_'.$eventname);
	}


	function AllowAutoInstall()
	{
		return FALSE;
	}


	function AllowAutoUpgrade()
	{
		return FALSE;
	}


	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}


	function GetVersion()
	{
		return '1.0';
	}


	function GetHelp()
	{
		return $this->Lang('help');
	}


	function GetAuthor()
	{
		return 'Ted Kulp';
	}


	function GetAuthorEmail()
	{
		return 'ted@cmsmadesimple.org';
	}


	function GetChangeLog()
	{
		return $this->ProcessTemplate('changelog.tpl');
	}


	function IsPluginModule()
	{
		return true;
	}


	function HasAdmin()
	{
		return true;
	}


	function VisibleToAdminUser()
	{
		$x = 
			$this->CheckPermission('Manage NMS Users') ||
			$this->CheckPermission('Manage NMS Jobs') ||
			$this->CheckPermission('Manage NMS Lists') ||
			$this->CheckPermission('Manage NMS Messages') ||
			$this->CheckPermission('Manage NMS Preferences') ||
			$this->CheckPermission('Modify Templates') ||
			$this->CheckPermission('Modify Site Preferences');

		return $x;
	}


	function SetParameters()
	{
	}


	function GetAdminSection()
	{
		return 'extensions';
	}


	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}


	function MinimumCMSVersion()
	{
		return "1.5.2";
	}


	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}


	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}


	function HasCapability($capability, $params = array())
	{
		return ($capability == 'nms_vars');
	}
	
	
	function GetExtraNMSParamHelp()
	{
		return '<em>{$track_img}</em> - Inserts an empty .gif for tracking the times the item is opened<br/>
<em>{$link_url}</em> - Click tracking url.  Add your actual url directly after the smarty tag e.g. {$link_url}http://exmaple.com<br/>';
	}
	
	
	function SetSmartyVars($id, $job_id, $message_id, $email_address, &$smarty, $type = 'send')
	{
		if ($type == 'send')
		{
			global $gCms;
			$db = $gCms->GetDb();
			$page_id = $db->GetOne("SELECT pageid FROM " . cms_db_prefix() . "module_nms_messages WHERE messageid = ?", array($message_id));
			$user_id = $db->GetOne("SELECT userid FROM " . cms_db_prefix() . "module_nms_users WHERE email = ?", array($email_address));
		
			$smarty->assign('track_img', '<img src="'.$this->CreateLink($id, 'msg_opened', $page_id, '', array('message_id' => $message_id, 'user_id' => $user_id, 'job_id' => $job_id), '', true) . '" />');
			$smarty->assign('link_url', $this->CreateLink($id, 'link_click', $page_id, '', array('message_id' => $message_id, 'user_id' => $user_id, 'job_id' => $job_id), '', true) . '&amp;cntnt01url=');
		}
	}


} /* class */



// EOF
?>
