<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : method.install.php
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

if (!isset($gCms)) exit;

$db =& $this->GetDb();

$taboptarray = array('mysql' => 'TYPE=MyISAM');
$dict = NewDataDictionary($db);

//create tables
// archive
$flds = "id I KEY, sentby_id I, recipient_groups X, send_date " . CMS_ADODB_DT . ",
	subject C(128), mailbody X, last_userid I, processed_users I, recipients I";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_feumailer_archive", 
															$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_feumailer_archive_seq");

// temp
$flds = "id I KEY, sentby_id I, recipient_groups X, 
	send_date " . CMS_ADODB_DT . ", subject C(128), mailbody X, last_userid I, 
	processed_users I, recipients I, task C(8), archive_id I, save_message I";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_feumailer_tmp", $flds,
																	$taboptarray);

$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_feumailer_tmp_seq");

// logs
$flds = "id I KEY, archive_id I, tmp_id I, sentby_id I, recipient_id I, recipient_groups X, 
				send_date " . CMS_ADODB_DT . ", errorcode I, subject C(128),tmp_errorcode I, recieved I";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_feumailer_logs", 
															$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_feumailer_logs_seq");

// selected users
$flds = "id I KEY, userid I, username X, tmp_id I, usercount I, errorcode I";
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_feumailer_users", 
															$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_feumailer_users_seq");

// create permission
$this->CreatePermission('Use FEUMailer', 'Use FEUMailer');

//preferences
$this->SetPreference("autosave", true);
$this->SetPreference("autoclear_archivemails",true);
$this->SetPreference("autoclear_value", 3);
$this->SetPreference("autoclear_time", 'month');
$this->SetPreference("autoclear_tmpmails", true);
$this->SetPreference("is_html", false);
$this->SetPreference("maxmails", 50);
$this->SetPreference("save_logs", true);
$this->SetPreference("save_errorlogs_only", true);
$this->SetPreference("autoclear_logs", false);
$this->SetPreference("default_groups", '');
$this->SetPreference("request_delay", '');
$this->SetPreference("random_delay", false);
$this->SetPreference("limit", 100);
$this->SetPreference("sortorder", "ASC");
$this->SetPreference("sortby", "L.id");
$this->SetPreference("errorsonly", false);

?>