<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------------
#
# Module : FrontendUser Mailer (c) 2008-2010 by Georg Busch (georg.busch@gmx.net)
#          An addon module for CMS Made Simple to provide backend users ability 
#          to easily send an email to all frontend users or just specific front-
#          end usergroups within a CMS Made Simple powered website.
# Version: 0.9.3
# File   : de_DE.php (german language file)
#
#-------------------------------------------------------------------------------
#
# CMS - CMS Made Simple is (c) 2004-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
# See the GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------------
#END_LICENSE

// general stuff
$lang['friendlyname'] = 'FrontendUsers Mailer Modul';
$lang['postinstall'] = 'Installation des FrontendUsers Mailer Modul beendet. <br />Stellen Sie sicher, dass Benutzer, die Nachrichten an Benutzer des FrontendUsers Moduls senden d&uuml;rfen, die Berechtigung "Use FEUMailer" haben.';
$lang['postuninstall'] = 'FrontendUsers Mailer Modul deinstalliert.';
$lang['really_uninstall'] = 'Sind Sie sicher, dass Sie das FrontendUsers Mailer Modul deinstallieren wollen?\\nDabei werden alle gespeicherten Nachrichten ebenfalls geloescht.';
$lang['uninstalled'] = 'Modul deinstalliert.';
$lang['installed'] = 'Modul Version %s installiert.';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['moddescription'] = 'Dieses Modul bietet Benutzern des Backends eine einfache M&ouml;glichkeit Emails an Benutzer des FrontendUsers Moduls zu senden.';
$lang['changelog'] = '<br />
<ul>
	<li>
		<p><strong>Version 0.9.2.BETA (May 2009):</strong></p>
		<ul>
			<li><p>einige kleine Fehler behoben</p></li>
			<li><p>Alle Datenbankabfragen in FEUMailer.module.php als separate Funktionen verschoben.</p></li>
		</ul>
	</li>
	<li>
		<p><strong>Version 0.9.1 (April 2009):</strong></p>
		<ul>
			<li><p>einige kleine Fehler behoben</p></li>
		</ul>
	</li>
	<li>
		<p><strong>Version 0.9 (M&auml;rz 2009):</strong></p>
		<ul>
			<li><p>Kompatibilit&auml;t mit CMSms 1.5.x hergestellt</p></li>
			<li><p>Moduleigenes Icon hinzugef&uuml;gt</p></li>
			<li><p>Modul-Icons vergr&ouml;&szlig;ert</p></li>
			<li>
				<p>
					Funktion zum Speichern von Log-Daten gesendeter Mails eingef&uuml;gt.<br />
					&Uuml;ber diese Funktion k&ouml;nnen Emails an Benutzer, die zum Zeitpunkt des Versendens keine g&uuml;ltige Emailaddresse angegeben hatten, erneut versendet werden.
				</p>
			</li>
			<li><p>Gespeicherte Mails zeigen nun Anzahl der Empf&auml;nger, bearbeiteter Benutzer und Gesamtanzahl von Benutzern der ausgew&auml;hlten Gruppen an</p></li>
			<li><p>Best&auml;tigungsmeldungen vor dem tats&auml;chlichen Senden einer Nachricht eingef&uuml;gt<br />(Nachricht gibt Gesamtanzahl von Benutzern der ausgew&auml;hlten Gruppen, bereits bearbeitete Benutzer, Empf&auml;nger und noch zu bearbeitende Benutzer an)</p></li>
			<li><p>Funktion zum erneuten Versenden von tempor&auml;ren Emails an alle Benutzer der ausgew&auml;hlten Gruppen entfernt</p></li>
			<li><p>Funktion zum Bearbeiten von tempor&auml;ren Emails entfernt<br />(laufende Jobs k&ouml;nnen somit nicht mehr ge&auml;ndert, sondern nur noch fortgesetzt werden)</p></li>
			<li><p>Behebung verschiedener kleiner Fehler</p></li>
		</ul>
	</li>
	<li><p><strong>Version 0.8 (Juli 2008)</strong><p></li>
<ul>';
$lang['help'] = '<h3>Was macht dieses Modul?</h3>
<p>Dies ist ein einfaches "Email Modul".<br />
Es bietet Benutzern des Backends die M&ouml;glchkeit Emails an verschiedene Benutzergruppen des FrontendUsers Moduls zu senden.<br />
In den Emails kann Smarty-Syntax verwenden werden, um z.B. Benutzereigenschaften oder Links etc. einzuf&uuml;gen.<br />
Gesendete Nachrichten k&ouml;nnen in der Datenbank gespeichert werden.<br />
<br />
Zu sendende Nachrichten werden in der Datenbank tempor&auml;r zwischengespeichert und w&auml;hrend des Sendens st&auml;ndig mit der ID des letzten bearbeiteten Benutzers aktualisiert.<br />
Sollte es w&auml;hrend des Sendevorgangs zu Unterbrechungen kommen, kann das Modul den Sendevorgang somit vom letzten bearbeiteten Benutzer an fortsetzen.
<br /><br />
Um eine Zeit&uuml;berschreitung seitens des Servers zu vermeiden, werden die Emails mit Hilfe von AJAX in einzelnen "Jobs" gesendet.
<br />
<h3>Wie wird es eingesetzt?</h3>
<p>Dieses Modul bietet keine Funktionen f&uuml;r das Frontend.</p>
<p>Nach der Installation wird im Backend dem Men&uuml;punkt "Benutzerverwaltung" ein weiterer Punkt "FrontendUsers Mailer Modul" hinzugef&uuml;gt.<br />
Um eine Nachricht zu senden, w&auml;hlen Sie dort einfach den Link "Neue Nachricht senden".<br />
W&auml;hen Sie hier die gew&uuml;nschten Gruppen des FrontendUsers Moduls aus, denen Sie eine Nachricht senden m&ouml;chten.<br />
Geben Sie einen Betreff ein (optional).<br />
Schreiben Sie eine Nachricht.<br />
W&auml;hlen Sie "Absenden" um die Nachricht zu senden.<br /><br />
Das Modul sendet nun mit Hilfe des CMSmailer Moduls eine Email an alle Benutzer der ausgew&auml;hlten Gruppen.
</p>
<p><strong>Smarty-Syntax:</strong><br />
Sie k&ouml;nnen allgemeinen Smarty-Syntax in einer Email verwenden.<br />
Zus&auml;tzliche Smarty-Variablen sind:</p>
<ul>
<li><strong>{$username}: </strong>Gibt den Benutzernamen des Benutzers aus, dem die Nachricht gerade gesendet wird.</li>
<li><strong>{$userprops}: </strong>Ist ein Array(), das alle Benutzereigenschaften des Benutzers enth&auml;lt, dem die Nachricht gerade gesendet wird.</li>
</ul>
<br />
Mit Hilfe einer {foreach}-Schleife kann man alle Benutzereigenschaften ausgeben lassen.<br /><br />
Beispiel:<br />
--------------------------------------------------------------------------------
<br /><br />
<pre>
Hallo {$username},

Sind diese Angaben auf dem neuesten Stand?

{foreach from=$userprops item=prop}
{$prop.prompt}: {$prop.data}&lt;br /&gt;
{/foreach}

Falls nicht, aktualisieren Sie sie bitte.

Mfg, Ihr Admin.
</pre>
<br />
--------------------------------------------------------------------------------
<br />
<br />
{$prop.data} enth&auml;lt die Daten dieses Feldes.<br />
{$prop.prompt} enth&auml;lt die Eingabeaufforderung f&uuml;r dieses Feld.
<br /><br />
Einzelne Benutzereigenschaften k&ouml;nnen auch direkt mit Hilfe des Punktsyntax ausgegeben werden:
<br /><br />
Bespiel:<br />
--------------------------------------------------------------------------------
<br /><br />
<pre>
Hallo {$userprops.vorname.data},

...
</pre>
<br />
--------------------------------------------------------------------------------
<br /><br />
{$userprops.FELDNAME.data} enth&auml;lt die Daten dieses Feldes.<br />
{$userprops.FELDNAME.prompt} enth&auml;lt die Eingabeaufforderung f&uuml;r dieses Feld.
<br />
</p>
<h3>Einstellungen</h3>
<p>Im Backend k&ouml;nnen folgende Einstellungen vorgenommen werden:</p>
<ul>
	<li>
		<strong>Gesendete Nachrichten automatisch speichern:</strong>
		<ul>
			<li>
				Verwenden Sie diese Option, um gesendete Nachrichten im Archiv zu speichern.<br />
				<br />
				Voreinstellung ist "aktiviert".
			</li>
		</ul>
	</li>
	<br >
	<li><strong>Log-Daten speichern:</strong>
		<ul>
			<li>
				Verwenden Sie diese Option um Log-Daten zu gesendeten Nachrichten zu speichern.<br /><br />
				<em>Hinweis: Die Anzahl von Log-Daten h&auml;ngt von der Anzahl der Benutzer ab.<br />
				Sollten Sie Performance-Problemen bei einer gro&szlig;en Anzahl von Benutzern feststellen, deaktivieren Sie diese Option.<br />
				Wenn diese Option deaktiviert ist, geht leider automatisch auch die Funktion zum erneuten Versenden einer Nachricht an Benutzer, die zum Zeitpunkt des vorhergehenden Sendevorgangs keine g&uuml;ltige Emailaddresse angegeben hatten, verloren.</em>
				<br /><br />
				Voreinstellung ist "aktiviert".
			</li>
			<br />
			<li><strong>Nur Fehler speichern:</strong>
				<ul>
					<li>
						Mit dieser Option werden nur Log-Daten gespeichert, wenn eine Email nicht an einen Benutzer gesendet werden konnte.<br />
						Das kann z.B. dann der Fall sein, wenn ein Benutzer keine g&uuml;ltige Emailaddresse angegeben hat.<br />
						<br />
						Voreinstellung ist "aktiviert".
					</li>
				</ul>
			</li>
		</ul>
	</li>
	<br />
	<li><strong>Alte Nachrichten automatisch l&ouml;schen:</strong>
		<ul>
			<li>
				Mit dieser Option werden &auml;ltere Nachrichten aus dem Archiv automatisch gel&ouml;scht.
				<br /><br />
				Voreinstellung ist "aktiviert".<br />
				<br />
				W&auml;hlen Sie im Listenauswahlfeld die Zeitdauer aus nach der alte Nachrichten gel&ouml;scht werden.<br /><br />
				Voreinstellung ist 3 Monate.
			</li>
		</ul>
	</li>
	<br />
	<li><strong>Standard Gruppe(n):</strong>
		<ul>
			<li>
				W&auml;hlen Sie hier ein oder mehrere Gruppe(n) aus, die beim Senden einer neuen Nachricht automatisch ausgew&auml;hlt sind.<br />
				<br />
				Voreinstellung ist keine.
			</li>
		</ul>
	</li>
	<br />
	<li><strong>Nachricht als HTML text senden:</strong>
		<ul>
			<li>
				Wenn Sie diese Option w&auml;hlen, kann zum Schreiben einer Nachricht der WYSIWYG-Editor verwendet werden.<br />
				<br />
				Voreinstellung ist "deaktiviert".
			</li>
		</ul>
	</li>
	<br />
	<li><strong>Max. Anzahl von Emails pro Job:</strong>
		<ul>
			<li>
				Um eine Zeit&uuml;berschreitung seitens des Servers zu vermeiden, werden die Emails mit Hilfe von AJAX in einzelnen "Jobs" gesendet.<br />
				Geben Sie hier die Anzahl von Emails an, die pro Job gesendet werden sollen.<br />
				<br />
				Voreinstellung ist "50"
			</li>
		</ul>
	</li>
	<br />
	<li><strong>AJAX Anfrage-Verz&ouml;gerung:</strong>
		<ul>
			<li>
				Wenn Sie eine gro&szlig;e Anzahl von Benutzern und eine kleine Anzahl von Emails pro Job haben, f&uuml;hrt das dazu, dass der Browser innerhalb sehr kurzer Zeitast&auml;nde eine gro&szlig;e Anzahl von identischen Anfragen an den Server sendet.<br />
				Einige Sicherheitsprogramme k&ouml;nnten dies m&ouml;glicherweise als Angriffsversuch deuten und die Anfragen abbrechen oder sogar Ihre IP-Adresse blockieren.<br />
				<br />
				Um dies zu vermeiden k&ouml;nnen Sie eine Verz&ouml;gerungsdauer (in Millisekunden) angeben, die das Javascript warten, bevor eine neue Anfrage an den Server gesendet wird.<br />
				<br />
				Voreinstellung ist "keine Verz&ouml;gerung".
			</li>
		</ul>
	</li>
</ul>
<h3>Support</h3>
<p>Dieses Modul bietet keine kommerzielle Unterst&uuml;tzung.</p>
<ul>
	<li>Project Homepage: <a href="http://dev.cmsmadesimple.org/projects/feumailer/">http://dev.cmsmadesimple.org/projects/feumailer/</a></li>
	<li>Forum: <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
</ul>
<br />
<p>Bitte melden Sie Fehler oder Verbesserungsvorschl&auml;ge auf der Project Homepage.</p>
<h3>Bekannte Probleme:</h3>
	
	<p>Wenn der Benutzername als Emailaddresse gilt, wird nur diese Addresse verwendet.</p>
	<p>Anderenfalls sucht das FrontendUsers Mailer Modul ausschlie&szlig;lich nach einer Benutzereigenschaft vom <strong>Typ "email"</strong>.</p>
	<p>Wenn der Benutzer mehrere Emailaddressen angegeben hat, wird nur die erste gefundene Addresse verwendet.</p>
	<p>
		Wenn Bilder oder andere Medien mit dem WYSIWYG-Editor eingef&uuml;gt werden, werden diese nicht an die Email angeh&auml;ngt, sondern verweisen auf das Medium auf dem Server.<br />
		Diese Verweise werden meist in Form von relativen Pfadangaben eingef&uuml;gt (z.B. &lt;img src="/uploads/images/a_tiny_image.jpg" /&gt;).<br />
		F&uuml;r eine korrekte Darstellung m&uuml;ssen solche Verweise in absolute Verweise ge&auml;ndert werden <br />(z.B. &lt;img src="http://www.ihreDomain/uploads/images/a_tiny_image.jpg" /&gt;).
	</p>
	<p>
		Einige Smarty-Tags, Plugins oder Module funktoinieren nicht korrekt, da sie unter Umst&auml;nden Daten aus der Serveranfrage in der Adressleiste des Browser ben&ouml;tigen.<br />
		Diese Daten existieren nur dann, wenn die Seite vom Frontend aus aufgerufen wird.<br />
		Da die Email aber vom Backend aus verarbeitet wird, fehlen derartige Daten.<br />
		Solche Fehler lassen sich leider nicht bzw. nur mit einer Modifikation der betreffenden Funktionen beheben.
	</p>
<h3>Copyright und Lizenz</h3>
<p>Copyright &copy; 2008, Georg Busch (NaN) <a href="mailto:georg.busch@gmx.net">&lt;georg.busch@gmx.net&gt;</a>. Alle Rechte vorbehalten.</p>
<p>Dieses Modul wurde unter der <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a> ver&ouml;ffentlicht. Sie m&uuml;ssen dieser Lizenz zustimmen, bevor Sie das Modul verwenden.</p>
<p>
	Laut den Lizenzbedingungen der GPL wird diese Software so ver&ouml;ffentlicht wie sie ist.<br />
	Sie erhebt keinerlei Anspruch auf einwandfreie Funktion.<br />
	Das Modul wurde erstellt, in der Hoffnung n&uuml;tzlich zu sein.<br />
	Es besteht keinerlei Garantie auf einen einwandfreien Nutzen.<br />
	Bitte lesen Sie die Nutzungsbedingungen f&uuml;r ausf&uuml;hrliche Informationen.
</p>
';

// Error messages
$lang['error'] = 'Fehler!';
$lang['error_upgrade'] = "F&uuml;r diese Version ist leider kein Upgrade verf&uuml;gbar. <br />Sie m&uuml;ssen das Modul neu installieren.";
$lang['error_permissions'] = 'Zugriff verweigert. Pr&uuml;fen Sie Ihre Berechtigungen.';
$lang['error_feusers'] = 'Das FrontendUsers Modul ist nicht installiert. Um das FrontendUsers Mailer Modul verwenden zu k&ouml;nnen muss das FrontendUsers Modul installiert sein.';
$lang['error_cmsmailer'] = 'Das CMS Mailer Modul ist nicht installiert. Um das FrontendUsers Mailer Modul verwenden zu k&ouml;nnen muss das CMS Mailer Modul installiert sein.';
$lang['error_tmpmails'] = 'Es sind tempor&auml;re Emails in der Datenbank.<br />Dies kann passieren, wenn ein Sendevorgang abgebrochen wurde.<br />Sie k&ouml;nnen versuchen den Sendevorgang mit Hilfe des Links "Sendevorgang fortsetzen" im Tab "Tempor&auml;re Emails" zu beenden.';
$lang['error_groups'] = 'Keine Gruppen des FrontendUsers Moduls gefunden.<br />Pr&uuml;fen Sie, ob im FrontendUsers Modul mindestens eine Benutzergruppe angelegt wurde.';
$lang['error_selectedgroups'] = 'Bitte waehlen Sie mindestens eine Benutzergruppe aus.';
$lang['error_mailbody'] = 'Bitte geben Sie einen Text fuer Ihre Nachricht ein.';
$lang['error_request_status'] = "Die AJAX Anfrage wurde erfolgreich gesendet aber es sind Fehler aufgetreten. Request Status:";
$lang['error_xmlhttp_instance'] = "Kann keine XMLHttp Instanz erzeugen!";
$lang['error_selectedarchivemails'] = 'Keine Nachrichten ausgew&auml;hlt.<br />Keine Nachrichten gel&ouml;scht.';
$lang['error_selectedtmpmails'] = 'Keine Nachrichten ausgew&auml;hlt.<br />Keine Nachrichten gel&ouml;scht.';
$lang['error_insufficientparams'] = 'Unzureichende Parameter.<br />Falscher oder fehlender Wert f&uuml;r Parameter %s in modules/FEUMailer/action.%s.php.';
$lang['error_insufficientparams_ajax'] = 'Vorgang abgebrochen. Unzureichende Parameter.<br />Falscher oder fehlender Wert f&uuml;r Parameter %s in modules/FEUMailer/action.%s.php.';
$lang['error_nousersfound'] = 'Keine Benutzer gefunden.';
$lang['error_ajax'] = "Es ist ein Fehler aufgetreten.\\nDie Antwort des Servers konnte nicht interpretiert werden.\\nVorgang abgebrochen.\\nBitte versuchen Sie es sp&auml;ter nocheinmal.\\n\\nServer-Antwort:\\n\\n";

// db errors
$lang['error_db_deletemail'] = 'Nachricht(en) nicht gel&ouml;scht.<br />Die Datenbankanfrage konnte nicht ausgef&uuml;hrt werden:<br />%s';
$lang['error_db_savemail'] = 'Nachricht konnte nicht gespeichert werden.<br />Die Datenbankanfrage konnte nicht ausgef&uuml;hrt werden:<br />%s';
$lang['error_db_savemail_ajax'] = 'Nachricht konnte nicht gespeichert werden.';
$lang['error_db_get_tmpmail'] = 'Keine tempor&auml;re Nachricht mit der ID %s gefunden.<br />Die Datenbankanfrage konnte nicht ausgef&uuml;hrt werden oder lieferte ein leeres Resultat:<br />Query:<br />%s';
$lang['error_db_get_tmpmail_ajax'] = 'Vorgang abgebrochen. Keine tempor&auml;re Nachricht mit der ID %s gefunden.';
$lang['error_db_get_archivemail'] = 'Keine tempor&auml;re Nachricht mit der ID %s gefunden.<br />Die Datenbankanfrage konnte nicht ausgef&uuml;hrt werden oder lieferte ein leeres Resultat.<br />Query:<br />%s';
$lang['error_db_create_tmpmail'] = "Vorgang abgebrochen. Konnte tempor&auml;re Nachricht nicht erstellen.<br />Die Datenbankanfrage konnte nicht ausgef&uuml;hrt werden:<br />%s";
$lang['error_db_autoclearlog'] = 'Log-Daten gel&ouml;schter Nachricht(en) konnte(n) nicht gel&ouml;scht werden.<br />Die Datenbankanfrage konnte nicht ausgef&uuml;hrt werden:<br />%s';
$lang['error_db_update_tmpmail'] = 'Vorgang abgebrochen.<br />Konnte tempor&auml;re Nachricht nicht aktualisieren.<br />Die Datenbankanfrage konnte nicht ausgef&uuml;hrt werden:<br />%s';
$lang['error_db_update_tmpmail_ajax'] = 'Vorgang abgebrochen. Konnte tempor&auml;re Nachricht nicht aktualisieren.';

$lang['error_db_create_log'] = 'Log-Eintrag konnte nicht erstellt werden.';
$lang['error_db_update_archive'] = 'Nachricht konnte nicht aktualisiert werden. Das kann zur Anzeige einer falschen Anzahl von Emp&auml;ngern und/oder bearbeiteten Benutzern f&uuml;hren.';
$lang['error_db_delete_tmp'] = 'Tempor&auml;re Nachricht konnte nicht gel&ouml;scht werden. Sie m&uuml;ssen die tempor&auml;re Nachricht manuell l&ouml;schen.';
$lang['error_db_update_log'] = 'Log-Daten konnten nicht aktualisert werden. Dies kann zur falschen Anzeige des Sendestatus f&uuml;hren.';

// module stuff
$lang['adminpanel'] = 'Modul-Administration';
$lang['sendmail'] = 'Sende Nachricht...';
$lang['emailaddress'] = 'Email-Adresse';
$lang['nomails'] = 'Keine Nachrichten gefunden.';
$lang['notempmails'] = 'Keine tempor&auml;ren Nachrichten gefunden.';
$lang['archive'] = 'Archivierte Nachrichten';
$lang['newmail'] = 'Eine neue Nachricht senden';
$lang['temp'] = 'Tempor&auml;re Nachrichten';
$lang['pref'] = 'Einstellungen';
$lang['prefs_updated'] = 'Einstellungen aktualisiert.';
$lang['users'] = 'Benutzer';
$lang['request_delay'] = 'AJAX Anfrage-Verz&ouml;gerung';
$lang['groups'] = 'Benutzergruppen';
$lang['subject'] = 'Betreff';
$lang['date'] = 'Sendedatum';
$lang['recipients'] = 'Empf&auml;nger';
$lang['read'] = 'Lesen';
$lang['readmail'] = 'Nachricht lesen';
$lang['edit'] = 'Bearbeiten';
$lang['resend'] = 'Erneut senden';
$lang['delete'] = 'L&ouml;schen';
$lang['save_logs'] = 'Log-Daten speichern';
$lang['save_errorlogs_only'] = 'Nur Fehler speichern';
$lang['logid'] = 'Log ID';
$lang['status'] = 'Status';
$lang['recieved'] = 'Gelesen';
$lang['noemailaddressfound'] = 'Keine Email-Adresse gefunden';
$lang['invalidemailaddress'] = 'Ung&uuml;ltige Email-Adresse';
$lang['filter'] = 'Filter';
$lang['asc'] = 'aufsteigend';
$lang['desc'] = 'absteigend';
$lang['sortby'] = 'Sortiere nach';
$lang['sort'] = 'sort';
$lang['limit'] =  'Begrenzung';
$lang['errorsonly'] = 'Zeige nur Fehler';
$lang['savedefault'] = 'Filter speichern';
$lang['send_order'] = 'Sendereihenfolge';
$lang['sortorder'] = 'Sort order';
$lang['send_date'] = 'Sendedatum';
$lang['username'] = 'Benutzername';
$lang['nolimit'] = 'keine Begrenzung';
$lang['pages'] = 'Seiten';
$lang['autosave'] = 'Gesendete Nachrichten automatisch speichern';
$lang['autoclear_archivemails'] = 'Alte Nachrichten automatisch l&ouml;schen';
$lang['autoclear_action'] = 'L&ouml;sche Nachrichten, die &auml;lter sind als';
$lang['seconds'] = 'Sekunde(n)';
$lang['minutes'] = 'Minute(n)';
$lang['hours'] = 'Stunde(n)';
$lang['days'] = 'Tag(e)';
$lang['weeks'] = 'Woche(n)';
$lang['months'] = 'Monat(e)';
$lang['years'] = 'Jahr(e)';
$lang['autoclear_tmpmails'] = 'einschlie&szlig;liech tempor&auml;rer Nachrichten ';
$lang['default_groups'] = 'Standard Empf&auml;nger-Gruppen';
$lang['is_html'] = 'Nachricht als HTML-Text Senden';
$lang['submit'] = 'Absenden';
$lang['cancel'] = 'Abbrechen';
$lang['message'] = 'Nachricht';
$lang['save'] = 'Gesendete Nachricht speichern';
$lang['maxmails'] = 'Max. Anzahl von Emails pro Job';

$lang['nosubject'] = 'Kein Betreff';
$lang['logs'] = 'Log-Daten';
$lang['tmpmaildeleted'] = 'Tempor&auml;re Nachricht(en) gel&ouml;scht';
$lang['archivemaildeleted'] = 'Nachricht(en) gel&ouml;scht';

$lang['task_finished'] = 'Dieser Sendevorgang ist bereits beendet.';
$lang['task_open'] = 'Dieser Sendevorgang ist nocht nicht beendet!';
$lang['mails_sent'] = 'Sendevorgang efolgreich beendet';
$lang['ok'] = 'Ok';
$lang['back'] = 'Zur&uuml;ck';
$lang['of'] = 'von';
$lang['wait'] = 'Bitte warten...';
$lang['sending'] = 'Sende Nachricht';
$lang['deleteselected'] = 'Ausgew&auml;hlte Nachricht(en) l&ouml;schen';
$lang['deleteselectedlog'] = 'Ausgew&auml;hlte Log-Daten l&ouml;schen';

$lang['totallogs'] = 'Eintr&auml;ge insgesamt';
$lang['errorlogs'] = 'Fehler';

$lang['log_deleted'] = 'Log-Eintrag/Eintr&auml;ge gel&ouml;scht.';
$lang['autoclear_logs'] = 'Log-Daten automatisch l&ouml;schen, wenn zugeh&ouml;rige Nachrichten gel&ouml;scht werden.';
$lang['view_logs'] = 'Log-Daten ansehen';
$lang['view'] = 'Details';
$lang['nologs'] = 'Keine Log-Daten gefunden';
$lang['processedusers'] = 'Bearbeitete Benutzer';
$lang['totalusers'] = 'Benutzer insgesamt';
$lang['remaining'] = 'Verbleibende Benutzer';
$lang['sentby'] = 'Gesendet von';
$lang['resend_all'] = 'Nachricht erneut an alle Benutzer senden';
$lang['continue_archive'] = 'Nachricht nur an neue Benutzer senden';
$lang['continue_tmp'] = 'Fortsetzen (vom letzten bearbeiteten Benutzer)';
$lang['resend_errors'] = 'Nur an Fehler erneut senden';
$lang['resend_user'] = 'Erneut an diesen Benutzer senden';
$lang['resend_selected'] = 'Erneut an ausgew&auml;hlte Benutzer senden';
$lang['random_delay'] = 'Zufallswert f&uuml;r die Verz&ouml;gerung verwenden.';

// confirm messages
$lang['groups_changed'] = 'Sie haben die Empfaenger-Guppen geaendert.\\nWollen Sie fortfahren?';
$lang['deleteconfirm'] = 'Wollen Sie die ausgewaehlten Nachrichten wirklich loeschen?';
$lang['deletearchiveconfirm'] = 'Wollen Sie diese Nachricht wirklich loeschen?';
$lang['deletetempconfirm'] = 'Wollen Sie diese temporaere Nachricht wirklich loeschen?';
$lang['deletelogconfirm'] = 'Wollen Sie die ausgewaehlten Log-Daten wirklich loeschen?';

$lang['submitconfirm'] = "Moechten Sie diese Nachricht wirklich an alle Benutzer der ausgewaehlten Gruppe(n) senden?";
$lang['resendselectedconfirm'] = 'Moechten Sie diese Nachricht wirklich NOCHEINMAL an alle ausgewaehlten Benutzer senden?';
$lang['resendallarchiveconfirm'] = "Moechten Sie diese Nachricht wirklich NOCHEINMAL an alle Benutzer der ausgewaehlten Gruppe(n) senden?";
$lang['resendnewarchiveconfirm'] = "Moechten Sie diese Nachricht wirklich an alle NEUEN Benutzer der ausgewaehlten Gruppe(n) senden?\\n(fortsetzen vom letzten bearbeiteten Benutzer)";
$lang['resenderrorarchiveconfirm'] = "Moechten Sie diese Nachricht wirklich an alle Benutzer der ausgewaehlten Gruppe(n) senden, die beim letzten Sendevorgang keine oder eine ungueltige Email-Adresse hatten?";
$lang['resenduserconfirm_1'] = 'Moechten Sie diese Nachricht wirklich NOCHEINMAL an diesen Benutzer senden?\\nBenutzername/Email: %s';
$lang['resenduserconfirm_2'] = 'Moechten Sie diese Nachricht wirklich NOCHEINMAL an diesen Benutzer senden?\\nBenutzername: %s\\nEmail: %s';

$lang['submitconfirm_full'] = "Moechten Sie diese Nachricht wirklich an alle Benutzer der ausgewaehlten Gruppe(n) senden?\\n\\nGruppen:\\n%s\\n\\nBenutzer:\\n%s";
$lang['resendalltmpconfirm_full'] = "Moechten Sie diese Nachricht wirklich NOCHEINMAL an alle Benutzer der ausgewaehlten Gruppe(n) senden?\\n\\nGruppen:\\n%s\\n\\nBenutzer:\\n%s";
$lang['resendnewtmpconfirm_full'] = "Moechten Sie diese temporaere Nachricht wirklich an alle Benutzer der ausgewaehlten Gruppe(n) senden? (fortsetzen vom letzten bearbeiteten Benutzer)\\n\\nGruppen:\\n%s\\n\\nBenutzer insgesamt:\\n%s\\n\\nBearbeitete Benutzer: %s\\n\\nEmpfaenger: %s\\n\\nVerbleibende Benutzer:\\n%s";
$lang['resendallarchiveconfirm_full'] = "Moechten Sie diese Nachricht wirklich NOCHEINMAL an alle Benutzer der ausgewaehlten Gruppe(n) senden?\\n\\nGruppen:\\n%s\\n\\nBenutzer:\\n%s";
$lang['resendnewarchiveconfirm_full'] = "Moechten Sie diese Nachricht wirklich an alle NEUEN Benutzer der ausgewaehlten Gruppe(n) senden?\\n(fortsetzen vom letzten bearbeiteten Benutzer)\\n\\nGruppen:\\n%s\\n\\nBenutzer insgesamt:\\n%s\\n\\nBearbeitete Benutzer:\\n%s\\n\\nEmpfaenger:\\n%s\\n\\nVerbleibende Benutzer:\\n%s";
$lang['resenderrorarchiveconfirm_full'] = "Moechten Sie diese Nachricht wirklich an alle Benutzer der ausgewaehlten Gruppe(n) senden, die beim letzten Sendevorgang keine oder eine ungueltige Email-Adresse hatten?\\n\\nGruppen:\\n%s\\n\\nBenutzer insgesamt:\\n%s\\n\\nBearbeitete Benutzer:\\n%s\\n\\nEmpfaenger:\\n%s\\n\\nVerbleibende Benutzer:\\n%s";

?>
